/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexingThread;
import org.opencms.search.CmsVfsIndexer;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;

public class CmsIndexingThreadManager {
    private static final Log LOG = CmsLog.getLog(CmsIndexingThreadManager.class);
    private int m_abandonedCounter;
    private long m_lastLogErrorTime;
    private long m_lastLogWarnTime;
    private int m_maxModificationsBeforeCommit;
    private int m_returnedCounter;
    private int m_startedCounter;
    private long m_timeout;

    public CmsIndexingThreadManager(long timeout, int maxModificationsBeforeCommit) {
        this.m_timeout = timeout;
        this.m_maxModificationsBeforeCommit = maxModificationsBeforeCommit;
    }

    public void createIndexingThread(CmsVfsIndexer indexer, I_CmsIndexWriter writer, CmsResource res) {
        block11: {
            I_CmsSearchDocument doc;
            I_CmsReport report = indexer.getReport();
            ++this.m_startedCounter;
            CmsIndexingThread thread = new CmsIndexingThread(indexer.getCms(), res, indexer.getIndex(), this.m_startedCounter, report);
            thread.setPriority(1);
            thread.start();
            try {
                thread.join(this.m_timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (thread.isAlive()) {
                ++this.m_abandonedCounter;
                thread.interrupt();
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_INDEXING_TIMEOUT_1", res.getRootPath()));
                }
                if (report != null) {
                    report.println();
                    report.print(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 1);
                    report.println(Messages.get().container("RPT_SEARCH_INDEXING_TIMEOUT_1", res.getRootPath()), 1);
                }
            } else {
                ++this.m_returnedCounter;
            }
            if ((doc = thread.getResult()) != null) {
                indexer.updateResource(writer, res.getRootPath(), doc);
            } else {
                indexer.deleteResource(writer, new CmsPublishedResource(res));
            }
            if (this.m_startedCounter % this.m_maxModificationsBeforeCommit == 0) {
                try {
                    writer.commit();
                }
                catch (IOException e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_COMMIT_2", indexer.getIndex().getName(), indexer.getIndex().getPath()), (Throwable)e);
                }
            }
        }
    }

    public boolean isRunning() {
        boolean result;
        if (this.m_lastLogErrorTime <= 0L) {
            this.m_lastLogWarnTime = this.m_lastLogErrorTime = System.currentTimeMillis();
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.m_lastLogWarnTime > 30000L) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_WAITING_ABANDONED_THREADS_2", new Integer(this.m_abandonedCounter), new Integer(this.m_startedCounter - this.m_returnedCounter)));
                }
                this.m_lastLogWarnTime = currentTime;
            }
            if (currentTime - this.m_lastLogErrorTime > 600000L) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WAITING_ABANDONED_THREADS_2", new Integer(this.m_abandonedCounter), new Integer(this.m_startedCounter - this.m_returnedCounter)));
                this.m_lastLogErrorTime = currentTime;
            }
        }
        boolean bl = result = this.m_returnedCounter + this.m_abandonedCounter < this.m_startedCounter;
        if (result && LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_THREADS_FINISHED_0"));
        }
        return result;
    }

    public void reportStatistics(I_CmsReport report) {
        if (report != null) {
            CmsMessageContainer message = Messages.get().container("RPT_SEARCH_INDEXING_STATS_4", new Object[]{new Integer(this.m_startedCounter), new Integer(this.m_returnedCounter), new Integer(this.m_abandonedCounter), report.formatRuntime()});
            report.println(message);
            if (!(report instanceof CmsLogReport) && LOG.isInfoEnabled()) {
                LOG.info((Object)message.key());
            }
        }
    }
}

