/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.I_CmsMemoryMonitorable;
import org.opencms.util.CmsStringUtil;

public class CmsSearchResult
implements I_CmsMemoryMonitorable,
Comparable<CmsSearchResult> {
    protected Date m_dateCreated;
    protected Date m_dateLastModified;
    protected String m_documentType;
    protected String m_excerpt;
    protected Map<String, String> m_fields;
    protected String m_path;
    protected int m_score;
    private int m_memorySize;

    public CmsSearchResult(int score, Document doc, String excerpt) {
        this.m_score = score;
        this.m_excerpt = excerpt;
        this.m_fields = new HashMap<String, String>();
        for (IndexableField field : doc.getFields()) {
            String name = field.name();
            String value = field.stringValue();
            if (!CmsStringUtil.isNotEmpty(value) || "path".equals(name) || "created".equals(name) || "lastmodified".equals(name)) continue;
            this.m_fields.put(name, value);
        }
        IndexableField f = doc.getField("path");
        this.m_path = f != null ? f.stringValue() : null;
        f = doc.getField("created");
        if (f != null) {
            try {
                this.m_dateCreated = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                this.m_dateCreated = null;
            }
        } else {
            this.m_dateCreated = null;
        }
        if ((f = doc.getField("lastmodified")) != null) {
            try {
                this.m_dateLastModified = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                this.m_dateLastModified = null;
            }
        } else {
            this.m_dateLastModified = null;
        }
        this.m_documentType = (f = doc.getField("type")) != null ? f.stringValue() : null;
    }

    protected CmsSearchResult() {
    }

    @Override
    public int compareTo(CmsSearchResult obj) {
        if (obj == this) {
            return 0;
        }
        return obj.m_score - this.m_score;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchResult) {
            CmsSearchResult other = (CmsSearchResult)obj;
            return this.m_documentType.equals(other.m_documentType) && this.m_path.equals(other.m_path);
        }
        return false;
    }

    public Date getDateCreated() {
        if (this.m_dateCreated != null) {
            return (Date)this.m_dateCreated.clone();
        }
        return null;
    }

    public Date getDateLastModified() {
        if (this.m_dateLastModified != null) {
            return (Date)this.m_dateLastModified.clone();
        }
        return null;
    }

    @Deprecated
    public String getDescription() {
        return this.getField("description");
    }

    public String getDocumentType() {
        return this.m_documentType;
    }

    public String getExcerpt() {
        return this.m_excerpt;
    }

    public String getField(String fieldName) {
        return this.m_fields.get(fieldName);
    }

    @Deprecated
    public String getKeywords() {
        return this.getField("keywords");
    }

    @Override
    public int getMemorySize() {
        if (this.m_memorySize == 0) {
            int result = 8;
            if (this.m_dateCreated != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_dateCreated);
            }
            if (this.m_dateLastModified != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_dateLastModified);
            }
            if (this.m_path != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_path);
            }
            if (this.m_fields != null) {
                for (Map.Entry<String, String> entry : this.m_fields.entrySet()) {
                    result += CmsMemoryMonitor.getMemorySize(entry.getKey());
                    result += CmsMemoryMonitor.getMemorySize(entry.getValue());
                }
            }
            if (this.m_excerpt != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_excerpt);
            }
            this.m_memorySize = result;
        }
        return this.m_memorySize;
    }

    public String getPath() {
        return this.m_path;
    }

    public int getScore() {
        return this.m_score;
    }

    @Deprecated
    public String getTitle() {
        return this.getField("title-key");
    }

    public int hashCode() {
        return this.m_documentType.hashCode() * 1109 + this.m_path.hashCode();
    }
}

