/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.uninverting.UninvertingReader;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

public class CmsSearchField
implements Serializable {
    public static final String FIELD_CATEGORY = "category";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_BLOB = "contentblob";
    public static final String FIELD_CONTENT_LOCALES = "con_locales";
    public static final String FIELD_DATE_CONTENT = "contentdate";
    public static final String FIELD_DATE_CREATED = "created";
    public static final String FIELD_DATE_CREATED_LOOKUP = "created_lookup";
    public static final String FIELD_DATE_EXPIRED = "expired";
    public static final String FIELD_DATE_LASTMODIFIED = "lastmodified";
    public static final String FIELD_DATE_LASTMODIFIED_LOOKUP = "lastmodified_lookup";
    public static final String FIELD_DATE_LOOKUP_SUFFIX = "_lookup";
    public static final String FIELD_DATE_RELEASED = "released";
    public static final String FIELD_DEPENDENCY_TYPE = "dependencyType";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_DYNAMIC_EXACT = "_exact";
    public static final String FIELD_DYNAMIC_PROPERTIES = "_prop";
    public static final String FIELD_DYNAMIC_PROPERTIES_DIRECT = "_dprop";
    public static final String FIELD_EXCERPT = "_excerpt";
    public static final String FIELD_FILENAME = "filename";
    public static final String FIELD_ID = "id";
    public static final String FIELD_KEYWORDS = "keywords";
    public static final String FIELD_LINK = "link";
    public static final String FIELD_META = "meta";
    public static final String FIELD_MIMETYPE = "mimetype";
    public static final String FIELD_PARENT_FOLDERS = "parent-folders";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_PREFIX_DEPENDENCY = "dep_";
    public static final String FIELD_PREFIX_DYNAMIC = "*_";
    public static final String FIELD_PREFIX_TEXT = "text_";
    public static final String FIELD_POSTFIX_STRING = "_s";
    public static final String FIELD_POSTFIX_DATE = "_dt";
    public static final String FIELD_POSTFIX_DATES = "_dts";
    public static final String FIELD_POSTFIX_DATE_RANGE = "_dr";
    public static final String FIELD_POSTFIX_DATE_RANGES = "_drs";
    public static final String FIELD_POSTFIX_INT = "_i";
    public static final String FIELD_POSTFIX_LOC = "_loc";
    public static final String FIELD_POSTFIX_SORT = "_sort";
    public static final String FIELD_PRIORITY = "priority";
    public static final String FIELD_RESOURCE_LOCALES = "res_locales";
    public static final String FIELD_SCORE = "score";
    public static final String FIELD_SEARCH_EXCLUDE = "search_exclude";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_SORT_TITLE = "sort-title";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_SUFFIX = "suffix";
    public static final String FIELD_TEXT = "text";
    public static final String FIELD_TITLE = "title-key";
    public static final String FIELD_TITLE_UNSTORED = "title";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_PATH_HIERARCHY = "path_hierarchy";
    public static final String FIELD_CONTAINER_TYPES = "container_types";
    public static final String FIELD_CATEGORY_EXACT = "category_exact";
    public static final String FIELD_ADDITIONAL_INFO = "additional_info";
    public static final String FIELD_PLACE = "place";
    public static final String FIELD_SPELL = "spell";
    public static final String FIELD_TEXT_EN = "text_en";
    public static final String FIELD_TEXT_DE = "text_de";
    public static final String FIELD_TEXT_EL = "text_el";
    public static final String FIELD_TEXT_ES = "text_es";
    public static final String FIELD_TEXT_FR = "text_fr";
    public static final String FIELD_TEXT_HU = "text_hu";
    public static final String FIELD_TEXT_IT = "text_it";
    public static final String FIELD_SEARCH_CHANNEL = "search_channel";
    public static final String FIELD_DISPTITLE = "disptitle";
    public static final String FIELD_DISPORDER = "disporder";
    public static final String FIELD_GEOCOORDS = "geocoords_loc";
    public static final String FIELD_INSTANCEDATE = "instancedate";
    public static final String FIELD_INSTANCEDATE_END = "instancedateend";
    public static final String FIELD_INSTANCEDATE_CURRENT_TILL = "instancedatecurrenttill";
    public static final String FIELD_INSTANCEDATE_RANGE = "instancedaterange";
    public static final String FIELD_SERIESDATES = "seriesdates_dts";
    public static final String FIELD_SERIESDATES_END = "seriesdatesend_dts";
    public static final String FIELD_SERIESDATES_CURRENT_TILL = "seriesdatescurrenttill_dts";
    public static final String FIELD_SERIESDATES_TYPE = "seriesdatestype_s";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_USER_CREATED = "userCreated";
    public static final String FIELD_USER_LAST_MODIFIED = "userLastModified";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_SOLR_ID = "solr_id";
    private static final long serialVersionUID = 3185631015824549119L;
    private String m_defaultValue;
    private boolean m_excerpt;
    private boolean m_indexed;
    private List<I_CmsSearchFieldMapping> m_mappings = new ArrayList<I_CmsSearchFieldMapping>();
    private String m_name;
    private boolean m_stored;

    public CmsSearchField() {
    }

    public CmsSearchField(String name, String defaultValue) {
        this();
        this.m_name = name;
        this.m_defaultValue = defaultValue;
    }

    public static void addUninvertingMappings(Map<String, UninvertingReader.Type> uninvertingMap) {
        uninvertingMap.put(FIELD_CATEGORY, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_CONTENT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_CONTENT_BLOB, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_CONTENT_LOCALES, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_CONTENT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_CREATED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_CREATED_LOOKUP, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_EXPIRED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_LASTMODIFIED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_LASTMODIFIED_LOOKUP, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_LOOKUP_SUFFIX, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DATE_RELEASED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DEPENDENCY_TYPE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DESCRIPTION, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DYNAMIC_EXACT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_DYNAMIC_PROPERTIES, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_EXCERPT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_FILENAME, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_ID, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_KEYWORDS, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_LINK, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_META, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_MIMETYPE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PARENT_FOLDERS, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PATH, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PREFIX_DEPENDENCY, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PREFIX_DYNAMIC, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PREFIX_TEXT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_PRIORITY, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_RESOURCE_LOCALES, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_SCORE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_SEARCH_EXCLUDE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_SIZE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_SORT_TITLE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_STATE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_SUFFIX, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_TEXT, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_TITLE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_TITLE_UNSTORED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_TYPE, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_USER_CREATED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_USER_LAST_MODIFIED, UninvertingReader.Type.SORTED);
        uninvertingMap.put(FIELD_VERSION, UninvertingReader.Type.SORTED);
    }

    public void addMapping(I_CmsSearchFieldMapping mapping) {
        this.m_mappings.add(mapping);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CmsSearchField) {
            return CmsStringUtil.isEqual(this.m_name, ((CmsSearchField)obj).getName());
        }
        return false;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getIndexed() {
        return null;
    }

    public List<I_CmsSearchFieldMapping> getMappings() {
        return this.m_mappings;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name == null ? 41 : this.m_name.hashCode();
    }

    public boolean isIndexed() {
        return this.m_indexed;
    }

    public boolean isInExcerpt() {
        return this.m_excerpt;
    }

    public boolean isStored() {
        return this.m_stored;
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    public void setIndexed(boolean indexed) {
        this.m_indexed = indexed;
    }

    public void setInExcerpt(boolean excerpt) {
        this.m_excerpt = excerpt;
    }

    public void setName(String fieldName) {
        this.m_name = fieldName;
    }

    public void setStored(boolean stored) {
        this.m_stored = stored;
    }

    public String toString() {
        return this.getName();
    }
}

