/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.opencms.db.CmsPublishedResource;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.I_CmsSolrIndexWriter;
import org.opencms.search.solr.Messages;

public class CmsSolrIndexWriter
implements I_CmsSolrIndexWriter {
    protected static final Log LOG = CmsLog.getLog(CmsSolrIndexWriter.class);
    private int m_commitMs = new Long(OpenCms.getSearchManager().getSolrServerConfiguration().getSolrCommitMs()).intValue();
    private CmsSolrIndex m_index;
    private SolrClient m_server;

    public CmsSolrIndexWriter(SolrClient client) {
        this(client, null);
    }

    public CmsSolrIndexWriter(SolrClient client, CmsSolrIndex index) {
        this.m_index = index;
        this.m_server = client;
        if (this.m_index != null) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_CREATE_2", this.m_index.getName(), this.m_index.getPath()));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_COMMIT_2", this.m_index.getName(), this.m_index.getPath()));
                this.m_server.commit(this.m_index.getCoreName());
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void deleteAllDocuments() throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DELETE_ALL_2", this.m_index.getName(), this.m_index.getPath()));
                this.m_server.deleteByQuery(this.m_index.getCoreName(), "*:*", this.m_commitMs);
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void deleteDocument(CmsPublishedResource resource) throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DOC_DELETE_3", resource.getRootPath(), this.m_index.getName(), this.m_index.getPath()));
                this.m_server.deleteByQuery(this.m_index.getCoreName(), "id:" + resource.getStructureId().toString(), this.m_commitMs);
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
            catch (SolrException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void optimize() {
    }

    public void updateDocument(I_CmsSearchDocument searchDocument) throws IOException {
        SolrInputDocument inputDoc = (SolrInputDocument)searchDocument.getDocument();
        try {
            this.m_server.add(this.m_index.getCoreName(), inputDoc, this.m_commitMs);
        }
        catch (SolrServerException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateDocument(String rootPath, I_CmsSearchDocument document) throws IOException {
        if (this.m_server != null && this.m_index != null && document.getDocument() != null) {
            try {
                this.m_server.deleteByQuery(this.m_index.getCoreName(), "path:\"" + rootPath + "\"", this.m_commitMs);
            }
            catch (Exception e1) {
                LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
            }
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DOC_UPDATE_3", rootPath, this.m_index.getName(), this.m_index.getPath()));
                this.addDocumentInstances(document);
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    private void addDocumentInstances(I_CmsSearchDocument document) throws SolrServerException, IOException {
        List<String> serialDates = document.getMultivaluedFieldAsStringList("seriesdates_dts");
        SolrInputDocument inputDoc = (SolrInputDocument)document.getDocument();
        String id = inputDoc.getFieldValue("id").toString();
        if (null != serialDates) {
            List<String> serialDatesEnd = document.getMultivaluedFieldAsStringList("seriesdatesend_dts");
            List<String> serialDatesCurrentTill = document.getMultivaluedFieldAsStringList("seriesdatescurrenttill_dts");
            for (int i = 0; i < serialDates.size(); ++i) {
                String endDate;
                String date = serialDates.get(i);
                String endDateRange = endDate = serialDatesEnd.get(i);
                if (!date.equals(endDate)) {
                    try {
                        Date parsed = CmsSearchUtil.parseDate(endDate);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(parsed);
                        calendar.add(13, -1);
                        endDateRange = CmsSearchUtil.getDateAsIso8601(calendar.getTime());
                    }
                    catch (ParseException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                String dateRange = "[" + date + " TO " + endDateRange + "]";
                String currentTillDate = serialDatesCurrentTill.get(i);
                inputDoc.setField("instancedate_dt", (Object)date);
                inputDoc.setField("instancedateend_dt", (Object)endDate);
                inputDoc.setField("instancedaterange_dr", (Object)dateRange);
                inputDoc.setField("instancedatecurrenttill_dt", (Object)currentTillDate);
                for (String locale : document.getMultivaluedFieldAsStringList("con_locales")) {
                    inputDoc.setField("instancedate_" + locale + "_dt", (Object)date);
                    inputDoc.setField("instancedateend_" + locale + "_dt", (Object)endDate);
                    inputDoc.setField("instancedaterange_" + locale + "_dr", (Object)dateRange);
                    inputDoc.setField("instancedatecurrenttill_" + locale + "_dt", (Object)currentTillDate);
                }
                String newId = id + String.format("-%04d", i + 1);
                inputDoc.setField("solr_id", (Object)newId);
                inputDoc.removeField("seriesdatesend_dts");
                inputDoc.removeField("seriesdatescurrenttill_dts");
                this.m_server.add(this.m_index.getCoreName(), inputDoc, this.m_commitMs);
            }
        } else {
            inputDoc.setField("solr_id", (Object)id);
            this.m_server.add(this.m_index.getCoreName(), inputDoc, this.m_commitMs);
        }
    }
}

