/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr.updateprocessors;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class CmsSolrCopyModifiedUpateProcessor
extends UpdateRequestProcessor {
    private final String m_source;
    private final String m_target;
    private final Pattern m_regex;
    private final String m_replacement;

    public CmsSolrCopyModifiedUpateProcessor(@Nonnull String source, @Nonnull String target, @Nonnull Pattern regex, @Nonnull String replacement, UpdateRequestProcessor nextProcessor) {
        super(nextProcessor);
        this.m_source = source;
        this.m_target = target;
        this.m_regex = regex;
        this.m_replacement = replacement;
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument doc = cmd.getSolrInputDocument();
        String v = (String)doc.getFieldValue(this.m_source);
        if (v != null) {
            String v1 = this.m_regex.matcher(v).replaceAll(this.m_replacement);
            doc.addField(this.m_target, (Object)v1);
        }
        super.processAdd(cmd);
    }
}

