/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import com.alkacon.simapi.CmykJpegReader.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsSitesConfiguration;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsAlternativeSiteRootMapping;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.site.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPath;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsSiteManagerImpl
implements I_CmsEventListener {
    public static final String DEFAULT_SHARED_FOLDER = "shared";
    public static final String PATH_SYSTEM_SHARED_FOLDER = "/system/shared/";
    public static final String SHARED_FOLDER_TITLE = "%SHARED_FOLDER%";
    public static final String WEB_SERVER_CONFIG_CONFIGTEMPLATE = "configtemplate";
    public static final String WEB_SERVER_CONFIG_FILENAMEPREFIX = "filenameprefix";
    public static final String WEB_SERVER_CONFIG_LOGGINGDIR = "loggingdir";
    public static final String WEB_SERVER_CONFIG_SECURETEMPLATE = "securetemplate";
    public static final String WEB_SERVER_CONFIG_TARGETPATH = "targetpath";
    public static final String WEB_SERVER_CONFIG_WEBSERVERSCRIPT = "webserverscript";
    private static final Log LOG = CmsLog.getLog(CmsSiteManagerImpl.class);
    private static final String SITES_FOLDER = "/sites/";
    private static final int SITES_FOLDER_POS = "/sites/".length() + 1;
    private List<String> m_additionalSiteRoots;
    private volatile AlternativeSiteData m_alternativeSiteData = new AlternativeSiteData(new ArrayList<CmsSite>());
    private Map<String, String> m_apacheConfig;
    private CmsObject m_clone;
    private CmsSite m_defaultSite;
    private String m_defaultUri;
    private boolean m_frozen;
    private boolean m_isListenerSet;
    private boolean m_oldStyleSecureServer = true;
    private List<CmsSite> m_onlyOfflineSites;
    private String m_sharedFolder;
    private List<CmsSiteMatcher> m_siteMatchers;
    private Map<CmsSiteMatcher, CmsSite> m_siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>();
    private Map<String, CmsSite> m_siteRootSites = new HashMap<String, CmsSite>();
    private Map<CmsUUID, CmsSite> m_siteUUIDs;
    private List<CmsSiteMatcher> m_workplaceMatchers;
    private Map<String, CmsSSLMode> m_workplaceServers;

    public CmsSiteManagerImpl() {
        this.m_additionalSiteRoots = new ArrayList<String>();
        this.m_workplaceServers = new LinkedHashMap<String, CmsSSLMode>();
        this.m_workplaceMatchers = new ArrayList<CmsSiteMatcher>();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SITE_CONFIG_0"));
        }
    }

    public static CmsSiteMatcher createAliasSiteMatcher(String alias, String redirect, String offset) {
        long timeOffset = 0L;
        try {
            timeOffset = Long.parseLong(offset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CmsSiteMatcher siteMatcher = new CmsSiteMatcher(alias, timeOffset);
        boolean redirectVal = new Boolean(redirect);
        siteMatcher.setRedirect(redirectVal);
        return siteMatcher;
    }

    private static String getHost(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void addSite(CmsObject cms, CmsSite site) throws CmsException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        this.validateSiteRoot(site.getSiteRoot());
        this.m_frozen = false;
        String secureUrl = null;
        if (site.hasSecureServer()) {
            secureUrl = site.getSecureUrl();
        }
        this.addSite(site.getUrl(), site.getSiteRoot(), site.getTitle(), Float.toString(site.getPosition()), site.getErrorPage(), Boolean.toString(site.isWebserver()), site.getSSLMode().getXMLValue(), secureUrl, Boolean.toString(site.isExclusiveUrl()), Boolean.toString(site.isExclusiveError()), Boolean.toString(site.usesPermanentRedirects()), Boolean.toString(site.isSubsiteSelectionEnabled()), site.getParameters(), site.getAliases(), site.getAlternativeSiteRootMapping());
        this.initialize(cms);
        OpenCms.writeConfiguration(CmsSitesConfiguration.class);
    }

    public void addSite(String server, String uri, String title, String position, String errorPage, String webserver, String sslMode, String secureServer, String exclusive, String error, String usePermanentRedirects, String subsiteSelection, SortedMap<String, String> params, List<CmsSiteMatcher> aliases, Optional<CmsAlternativeSiteRootMapping> alternativeSiteRootMapping) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        if (this.getSiteRoots().contains(uri)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SITE_ALREADY_CONFIGURED_1", uri));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(server)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_EMPTY_SERVER_URL_0"));
        }
        this.validateSiteRoot(uri);
        CmsSiteMatcher matcher = new CmsSiteMatcher(server);
        CmsSite site = new CmsSite(uri, matcher);
        site.setTitle(title);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(position)) {
            float pos = Float.MAX_VALUE;
            try {
                pos = Float.parseFloat(position);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            site.setPosition(pos);
        }
        site.setErrorPage(errorPage);
        site.setWebserver(Boolean.valueOf(webserver));
        site.setSSLMode(CmsSSLMode.getModeFromXML(sslMode));
        if (CmsStringUtil.isNotEmpty(secureServer)) {
            matcher = new CmsSiteMatcher(secureServer);
            site.setSecureServer(matcher);
            site.setExclusiveUrl(Boolean.valueOf(exclusive));
            site.setExclusiveError(Boolean.valueOf(error));
            site.setUsePermanentRedirects(Boolean.valueOf(usePermanentRedirects));
        }
        site.setSubsiteSelectionEnabled(Boolean.parseBoolean(subsiteSelection));
        site.setAliases(aliases);
        boolean valid = true;
        ArrayList<CmsSiteMatcher> toAdd = new ArrayList<CmsSiteMatcher>();
        for (CmsSiteMatcher matcherToAdd : site.getAllMatchers()) {
            valid = valid & this.isServerValid(matcherToAdd) & !toAdd.contains(matcherToAdd);
            toAdd.add(matcherToAdd);
        }
        if (!valid) {
            throw new CmsConfigurationException(Messages.get().container("ERR_DUPLICATE_SERVER_NAME_1", matcher.getUrl()));
        }
        for (CmsSiteMatcher matcherToAdd : site.getAllMatchers()) {
            this.addServer(matcherToAdd, site);
        }
        site.setParameters(params);
        site.setAlternativeSiteRootMapping(alternativeSiteRootMapping);
        this.m_siteRootSites = new HashMap<String, CmsSite>(this.m_siteRootSites);
        this.m_siteRootSites.put(site.getSiteRoot(), site);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SITE_ROOT_ADDED_1", site.toString()));
        }
    }

    public void addSiteInternally(String server, String uri, String title, String position, String errorPage, String webserver, String sslMode, String secureServer, String exclusive, String error, String usePermanentRedirects, String subsiteSelection, SortedMap<String, String> params, List<CmsSiteMatcher> aliases, Optional<CmsAlternativeSiteRootMapping> alternativeSiteRoot) throws CmsConfigurationException {
        try {
            this.addSite(server, uri, title, position, errorPage, webserver, sslMode, secureServer, exclusive, error, usePermanentRedirects, subsiteSelection, params, aliases, alternativeSiteRoot);
        }
        catch (CmsConfigurationException e) {
            LOG.error((Object)"Error reading definitions. Trying to read without aliases.", (Throwable)e);
            this.addSite(server, uri, title, position, errorPage, webserver, sslMode, secureServer, exclusive, error, usePermanentRedirects, subsiteSelection, params, new ArrayList<CmsSiteMatcher>(), alternativeSiteRoot);
        }
    }

    public void addWorkplaceServer(String workplaceServer, String sslmode) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        if (!this.m_workplaceServers.containsKey(workplaceServer)) {
            this.m_workplaceServers.put(workplaceServer, CmsSSLMode.getModeFromXML(sslmode));
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        try {
            CmsProject project = this.getOfflineProject();
            this.m_clone.getRequestContext().setCurrentProject(project);
            List<CmsPublishedResource> res = null;
            ArrayList<CmsPublishedResource> foundSites = new ArrayList<CmsPublishedResource>();
            res = this.m_clone.readPublishedResources(new CmsUUID((String)event.getData().get("publishHistoryId")));
            if (res != null) {
                for (CmsPublishedResource r : res) {
                    if (foundSites.contains(r) || !this.m_siteUUIDs.containsKey(r.getStructureId())) continue;
                    foundSites.add(r);
                }
            }
            project = this.m_clone.readProject(CmsProject.ONLINE_PROJECT_ID);
            this.m_clone.getRequestContext().setCurrentProject(project);
            HashMap<CmsSite, CmsSite> updateMap = new HashMap<CmsSite, CmsSite>();
            for (CmsPublishedResource r : foundSites) {
                CmsResource siteRoot;
                if (!this.m_clone.existsResource(r.getStructureId()) || !(!this.m_siteRootSites.containsKey(CmsFileUtil.removeTrailingSeparator((siteRoot = this.m_clone.readResource(r.getStructureId())).getRootPath())) | this.m_onlyOfflineSites.contains(this.m_siteUUIDs.get(r.getStructureId())))) continue;
                CmsSite oldSite = this.m_siteUUIDs.get(siteRoot.getStructureId());
                CmsSite newSite = oldSite.clone();
                newSite.setSiteRoot(siteRoot.getRootPath());
                updateMap.put(oldSite, newSite);
            }
            for (CmsSite site : updateMap.keySet()) {
                this.updateSite(this.m_clone, site, (CmsSite)updateMap.get(site));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to handle publish event", (Throwable)e);
        }
    }

    public List<CmsSite> getAvailableCorruptedSites(CmsObject cms, boolean workplaceMode) {
        ArrayList<CmsSite> res = new ArrayList<CmsSite>();
        List<CmsSite> visSites = this.getAvailableSites(cms, workplaceMode);
        Map<CmsSiteMatcher, CmsSite> allsites = this.getSites();
        for (CmsSiteMatcher matcher : allsites.keySet()) {
            CmsSite site = allsites.get(matcher);
            if (!(!visSites.contains(site) & !res.contains(site))) continue;
            res.add(site);
        }
        return res;
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode) {
        return this.getAvailableSites(cms, workplaceMode, cms.getRequestContext().getOuFqn());
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, boolean showShared, String ouFqn) {
        return this.getAvailableSites(cms, workplaceMode, showShared, ouFqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, boolean showShared, String ouFqn, CmsSSLMode filterMode) {
        String folder;
        ArrayList<String> siteroots = new ArrayList<String>(this.m_siteMatcherSites.size() + 1);
        HashMap<String, CmsSiteMatcher> siteServers = new HashMap<String, CmsSiteMatcher>(this.m_siteMatcherSites.size() + 1);
        ArrayList<CmsSite> result = new ArrayList<CmsSite>(this.m_siteMatcherSites.size() + 1);
        for (CmsSite mainSite : this.m_siteMatcherSites.values()) {
            ArrayList<CmsSite> sitesToProcess = new ArrayList<CmsSite>();
            sitesToProcess.add(mainSite);
            CmsSite extensionFolderSite = mainSite.createAlternativeSiteRootSite();
            if (extensionFolderSite != null) {
                sitesToProcess.add(extensionFolderSite);
            }
            for (CmsSite cmsSite : sitesToProcess) {
                String folder2 = CmsFileUtil.addTrailingSeparator(cmsSite.getSiteRoot());
                if (siteroots.contains(folder2)) continue;
                siteroots.add(folder2);
                siteServers.put(folder2, cmsSite.getSiteMatcher());
            }
        }
        if (workplaceMode && this.m_defaultSite != null && !siteroots.contains(folder = CmsFileUtil.addTrailingSeparator(this.m_defaultSite.getSiteRoot()))) {
            siteroots.add(folder);
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("/");
            if (workplaceMode && OpenCms.getRoleManager().hasRole(cms, CmsRole.VFS_MANAGER)) {
                if (!siteroots.contains("/")) {
                    siteroots.add("/");
                }
                if (!siteroots.contains(CmsFileUtil.addTrailingSeparator(storedSiteRoot))) {
                    siteroots.add(CmsFileUtil.addTrailingSeparator(storedSiteRoot));
                }
            }
            String shared = OpenCms.getSiteManager().getSharedFolder();
            if (showShared && shared != null && !siteroots.contains(shared)) {
                siteroots.add(shared);
            }
            boolean allCompatible = OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN) && (ouFqn.isEmpty() || ouFqn.equals("/"));
            List<Object> resources = Collections.emptyList();
            if (!allCompatible) {
                try {
                    resources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(cms, ouFqn);
                }
                catch (CmsException e) {
                    List<CmsSite> list = Collections.emptyList();
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    return list;
                }
            }
            Collections.sort(siteroots);
            for (String string : siteroots) {
                boolean compatible = allCompatible;
                if (!compatible) {
                    for (CmsResource cmsResource : resources) {
                        if (!cmsResource.getRootPath().startsWith(string) && !string.startsWith(cmsResource.getRootPath())) continue;
                        compatible = true;
                        break;
                    }
                }
                if (!compatible) continue;
                try {
                    CmsResource res = cms.readResource(string);
                    if (workplaceMode && !cms.hasPermissions(res, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ONLY_VISIBLE)) continue;
                    CmsSite cmsSite = this.getSiteForSiteRoot(CmsFileUtil.removeTrailingSeparator(string));
                    String title = null;
                    if (cmsSite != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(cmsSite.getTitle())) {
                        title = cmsSite.getTitle();
                    }
                    if (title == null) {
                        title = this.getSiteTitle(cms, res);
                    }
                    String position = null;
                    if (cmsSite != null && cmsSite.getPosition() != Float.MAX_VALUE) {
                        position = Float.toString(cmsSite.getPosition());
                    }
                    if (position == null) {
                        position = cms.readPropertyObject(res, "NavPos", false).getValue();
                    }
                    if (cmsSite != null) {
                        float pos = Float.MAX_VALUE;
                        try {
                            pos = Float.parseFloat(position);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        CmsSite clone = cmsSite.clone();
                        clone.setPosition(pos);
                        clone.setTitle(title);
                        if (filterMode == null) {
                            result.add(clone);
                            continue;
                        }
                        if (!filterMode.equals((Object)clone.getSSLMode())) continue;
                        result.add(clone);
                        continue;
                    }
                    result.add(new CmsSite(string, res.getStructureId(), title, (CmsSiteMatcher)siteServers.get(string), position));
                }
                catch (CmsException cmsException) {}
            }
            Collections.sort(result, new Comparator<CmsSite>(){

                @Override
                public int compare(CmsSite o1, CmsSite o2) {
                    if (CmsSiteManagerImpl.this.isSharedFolder(o1.getSiteRoot())) {
                        return 1;
                    }
                    if (CmsSiteManagerImpl.this.isSharedFolder(o2.getSiteRoot())) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_SITE_PROP_FAILED_0"), t);
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
        return result;
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, CmsSSLMode filterMode) {
        return this.getAvailableSites(cms, workplaceMode, workplaceMode, cms.getRequestContext().getOuFqn(), filterMode);
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, String ouFqn) {
        return this.getAvailableSites(cms, workplaceMode, workplaceMode, ouFqn);
    }

    public CmsSite getCurrentSite(CmsObject cms) {
        CmsSite site = this.getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
        return site == null ? this.m_defaultSite : site;
    }

    public CmsSite getDefaultSite() {
        return this.m_defaultSite;
    }

    public String getDefaultUri() {
        return this.m_defaultUri;
    }

    public String getSharedFolder() {
        return this.m_sharedFolder;
    }

    public CmsSite getSite(String rootPath, String fallbackSiteRoot) {
        CmsSite result = this.getSiteForRootPath(rootPath);
        if (result == null && (result = this.getSiteForSiteRoot(fallbackSiteRoot)) == null) {
            result = this.getDefaultSite();
        }
        return result;
    }

    public com.google.common.base.Optional<CmsSite> getSiteForDefaultUri() {
        String defaultUri = this.getDefaultUri();
        CmsSite candidate = this.m_siteRootSites.get(CmsFileUtil.removeTrailingSeparator(defaultUri));
        return com.google.common.base.Optional.fromNullable((Object)candidate);
    }

    public CmsSite getSiteForRootPath(String rootPath) {
        CmsSite result;
        if (rootPath.length() > 0 && !rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((result = this.lookupSitesFolder(rootPath)) != null) {
            return result;
        }
        String siteRoot = this.lookupAdditionalSite(rootPath);
        if (siteRoot != null) {
            return this.getSiteForSiteRoot(siteRoot);
        }
        return this.m_alternativeSiteData.getSiteForRootPath(rootPath);
    }

    public CmsSite getSiteForSiteRoot(String siteRoot) {
        if (siteRoot == null) {
            return null;
        }
        CmsSite result = this.m_siteRootSites.get(siteRoot);
        if (result != null) {
            return result;
        }
        return this.m_alternativeSiteData.getSiteForSiteRoot(siteRoot);
    }

    public String getSiteRoot(String rootPath) {
        CmsSite site;
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((site = this.lookupSitesFolder(rootPath)) != null) {
            return site.getSiteRoot();
        }
        String result = this.lookupAdditionalSite(rootPath);
        if (result != null) {
            return result;
        }
        CmsSite extSite = this.m_alternativeSiteData.getSiteForRootPath(rootPath);
        if (extSite != null) {
            result = extSite.getSiteRoot();
        }
        return result;
    }

    public Set<String> getSiteRoots() {
        return Sets.union(this.m_siteRootSites.keySet(), this.m_alternativeSiteData.getSiteRoots());
    }

    public Map<CmsSiteMatcher, CmsSite> getSites() {
        return this.m_siteMatcherSites;
    }

    public String getSiteTitle(CmsObject cms, CmsResource resource) throws CmsException {
        String title = cms.readPropertyObject(resource, "Title", false).getValue();
        if (title == null) {
            title = resource.getRootPath();
        }
        if (resource.getRootPath().equals(this.getSharedFolder())) {
            title = SHARED_FOLDER_TITLE;
        }
        return title;
    }

    public CmsSSLMode getSSLModeForWorkplaceServer(String server) {
        if (server == null) {
            return CmsSSLMode.NO;
        }
        if (!this.m_workplaceServers.containsKey(server)) {
            return CmsSSLMode.NO;
        }
        return this.m_workplaceServers.get(server);
    }

    public Map<String, String> getWebServerConfig() {
        return this.m_apacheConfig;
    }

    public String getWorkplaceServer() {
        return this.m_workplaceServers.keySet().isEmpty() ? null : this.m_workplaceServers.keySet().iterator().next();
    }

    public String getWorkplaceServer(CmsObject cms) {
        String reqHost;
        if (this.m_workplaceServers.keySet().isEmpty()) {
            return null;
        }
        CmsSiteMatcher requestMatcher = cms.getRequestContext().getRequestMatcher();
        if (requestMatcher != null && (reqHost = CmsSiteManagerImpl.getHost(requestMatcher.toString())) != null) {
            for (String wpServer : this.m_workplaceServers.keySet()) {
                String wpHost = CmsSiteManagerImpl.getHost(wpServer);
                if (!reqHost.equals(wpHost)) continue;
                return wpServer;
            }
        }
        return this.m_workplaceServers.keySet().iterator().next();
    }

    public List<String> getWorkplaceServers() {
        return Collections.unmodifiableList(new ArrayList<String>(this.m_workplaceServers.keySet()));
    }

    public List<String> getWorkplaceServers(CmsSSLMode filterMode) {
        if (filterMode == null) {
            return this.getWorkplaceServers();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String server : this.m_workplaceServers.keySet()) {
            if (!this.m_workplaceServers.get(server).equals((Object)filterMode)) continue;
            ret.add(server);
        }
        return ret;
    }

    public Map<String, CmsSSLMode> getWorkplaceServersMap() {
        return Collections.unmodifiableMap(this.m_workplaceServers);
    }

    public CmsSiteMatcher getWorkplaceSiteMatcher() {
        return this.m_workplaceMatchers.isEmpty() ? null : this.m_workplaceMatchers.get(0);
    }

    public void initialize(CmsObject cms) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_SITE_ROOTS_CONFIGURED_1", new Integer(this.m_siteMatcherSites.size() + (this.m_defaultUri != null ? 1 : 0))));
        }
        try {
            block17: {
                this.m_clone = OpenCms.initCmsObject(cms);
                this.m_clone.getRequestContext().setSiteRoot("");
                this.m_clone.getRequestContext().setCurrentProject(this.m_clone.readProject("Online"));
                CmsObject cms_offline = OpenCms.initCmsObject(this.m_clone);
                CmsProject tempProject = cms_offline.createProject("tempProjectSites", "", "/Users", "/Users", CmsProject.PROJECT_TYPE_TEMPORARY);
                cms_offline.getRequestContext().setCurrentProject(tempProject);
                this.m_siteUUIDs = new HashMap<CmsUUID, CmsSite>();
                this.m_onlyOfflineSites = new ArrayList<CmsSite>();
                for (CmsSite site : this.m_siteMatcherSites.values()) {
                    this.checkUUIDOfSiteRoot(site, this.m_clone, cms_offline);
                    try {
                        String title;
                        CmsResource siteRes = this.m_clone.readResource(site.getSiteRoot());
                        site.setSiteRootUUID(siteRes.getStructureId());
                        this.m_siteUUIDs.put(siteRes.getStructureId(), site);
                        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(site.getTitle()) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(title = this.m_clone.readPropertyObject(siteRes, "Title", false).getValue())) continue;
                        site.setTitle(title);
                    }
                    catch (Throwable t) {
                        if (!CmsLog.INIT.isWarnEnabled()) continue;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_1", site));
                    }
                }
                cms_offline.deleteProject(tempProject.getUuid());
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_defaultUri)) {
                    this.m_defaultSite = null;
                } else {
                    this.m_defaultSite = new CmsSite(this.m_defaultUri, CmsSiteMatcher.DEFAULT_MATCHER);
                    try {
                        this.m_clone.readResource(this.m_defaultSite.getSiteRoot());
                    }
                    catch (Throwable t) {
                        if (!CmsLog.INIT.isWarnEnabled()) break block17;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_DEFAULT_SITE_1", this.m_defaultSite));
                    }
                }
            }
            if (this.m_defaultSite == null) {
                this.m_defaultSite = new CmsSite("/", CmsSiteMatcher.DEFAULT_MATCHER);
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                if (this.m_defaultSite != null) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_1", this.m_defaultSite));
                } else {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_0"));
                }
            }
            this.initWorkplaceMatchers();
            this.setSiteMatcherSites(this.m_siteMatcherSites);
            for (String root : this.m_siteRootSites.keySet()) {
                if (root.startsWith(SITES_FOLDER) && root.split("/").length < 4) continue;
                this.m_additionalSiteRoots.add(root);
            }
            this.initExtensionSites();
            if (this.m_sharedFolder == null) {
                this.m_sharedFolder = DEFAULT_SHARED_FOLDER;
            }
            this.m_frozen = true;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (!this.m_isListenerSet) {
            OpenCms.addCmsEventListener(this, new int[]{2});
            this.m_isListenerSet = true;
        }
    }

    public boolean isConfigurableWebServer() {
        return this.m_apacheConfig != null;
    }

    public boolean isMatching(CmsSiteMatcher matcher) {
        boolean result;
        boolean bl = result = this.m_siteMatcherSites.get(matcher) != null;
        if (!result) {
            result = this.isWorkplaceRequest(matcher);
        }
        return result;
    }

    public boolean isMatchingCurrentSite(CmsObject cms, CmsSiteMatcher matcher) {
        return this.m_siteMatcherSites.get(matcher) == this.getCurrentSite(cms);
    }

    public boolean isOldStyleSecureServerAllowed() {
        return this.m_oldStyleSecureServer;
    }

    public boolean isOnlyOfflineSite(CmsSite site) {
        return this.m_onlyOfflineSites.contains(site);
    }

    public boolean isSharedFolder(String name) {
        return this.m_sharedFolder != null && this.m_sharedFolder.equals(CmsStringUtil.joinPaths("/", name, "/"));
    }

    public boolean isSiteRoot(String rootPath) {
        String siteRoot = this.getSiteRoot(rootPath);
        rootPath = CmsStringUtil.joinPaths(rootPath, "/");
        return rootPath.equals(siteRoot);
    }

    public boolean isSiteUnderSite(CmsSite site) {
        return this.isSiteUnderSite(site.getSiteRoot());
    }

    public boolean isSiteUnderSite(String siteRootPath) {
        for (String siteRoot : this.getSiteRoots()) {
            if (!(siteRootPath.length() > siteRoot.length() & siteRootPath.startsWith(CmsFileUtil.addTrailingSeparator(siteRoot)))) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkplaceRequest(CmsSiteMatcher matcher) {
        return this.m_workplaceMatchers.contains(matcher);
    }

    public boolean isWorkplaceRequest(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        return this.isWorkplaceRequest(this.getRequestMatcher(req));
    }

    public CmsSite matchRequest(HttpServletRequest req) {
        CmsSite alternativeSite;
        CmsSite site;
        HttpSession session;
        CmsSiteMatcher matcher = this.getRequestMatcher(req);
        if (matcher.getTimeOffset() != 0L && (session = req.getSession()) != null) {
            session.setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(System.currentTimeMillis() + matcher.getTimeOffset()));
        }
        if ((site = this.matchSite(matcher)).matchAlternativeSiteRoot(OpenCmsCore.getPathInfo(req)) && (alternativeSite = site.createAlternativeSiteRootSite()) != null) {
            LOG.debug((Object)(req.getRequestURL().toString() + ": Matched extension folder rule, changing site root from " + site.getSiteRoot() + " to " + alternativeSite.getSiteRoot()));
            site = alternativeSite;
        }
        if (LOG.isDebugEnabled()) {
            String requestServer = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MATCHING_REQUEST_TO_SITE_2", requestServer, site.toString()));
        }
        return site;
    }

    public CmsSite matchSite(CmsSiteMatcher matcher) {
        CmsSite site = this.m_siteMatcherSites.get(matcher);
        if (site == null) {
            site = this.m_defaultSite;
        }
        return site;
    }

    public void removeSite(CmsObject cms, CmsSite site) throws CmsException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        this.m_frozen = false;
        HashMap<CmsSiteMatcher, CmsSite> siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>();
        List<CmsSiteMatcher> matchersForSite = site.getAllMatchers();
        for (Map.Entry<CmsSiteMatcher, CmsSite> entry : this.m_siteMatcherSites.entrySet()) {
            if (matchersForSite.contains(entry.getKey())) continue;
            siteMatcherSites.put(entry.getKey(), entry.getValue());
        }
        this.setSiteMatcherSites(siteMatcherSites);
        HashMap<String, CmsSite> siteRootSites = new HashMap<String, CmsSite>(this.m_siteRootSites);
        siteRootSites.remove(site.getSiteRoot());
        this.m_siteRootSites = Collections.unmodifiableMap(siteRootSites);
        this.initialize(cms);
        OpenCms.writeConfiguration(CmsSitesConfiguration.class);
    }

    public void setDefaultUri(String defaultUri) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_defaultUri = defaultUri;
    }

    public void setOldStyleSecureServerAllowed(String value) {
        this.m_oldStyleSecureServer = Boolean.parseBoolean(StringUtil.toLowerCase((String)value));
    }

    public void setSharedFolder(String sharedFolder) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_sharedFolder = CmsStringUtil.joinPaths("/", sharedFolder, "/");
    }

    public void setWebServerScripting(String webserverscript, String targetpath, String configtemplate, String securetemplate, String filenameprefix, String loggingdir) {
        this.m_apacheConfig = new HashMap<String, String>();
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_WEBSERVERSCRIPT, webserverscript);
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_TARGETPATH, targetpath);
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_CONFIGTEMPLATE, configtemplate);
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_SECURETEMPLATE, securetemplate);
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_FILENAMEPREFIX, filenameprefix);
        this.m_apacheConfig.put(WEB_SERVER_CONFIG_LOGGINGDIR, loggingdir);
    }

    public boolean startsWithShared(String path) {
        return this.m_sharedFolder != null && CmsFileUtil.addTrailingSeparator(path).startsWith(this.m_sharedFolder);
    }

    public void updateGeneralSettings(CmsObject cms, String defaultUri, List<String> workplaceServersList, String sharedFolder) throws CmsException {
        LinkedHashMap<String, CmsSSLMode> workplaceServers = new LinkedHashMap<String, CmsSSLMode>();
        for (String server : workplaceServersList) {
            if (this.m_workplaceServers.containsKey(server)) {
                workplaceServers.put(server, this.m_workplaceServers.get(server));
                continue;
            }
            workplaceServers.put(server, CmsSSLMode.NO);
        }
        this.updateGeneralSettings(cms, defaultUri, workplaceServers, sharedFolder);
    }

    public void updateGeneralSettings(CmsObject cms, String defaulrUri, Map<String, CmsSSLMode> workplaceServers, String sharedFolder) throws CmsException {
        CmsObject clone = OpenCms.initCmsObject(cms);
        clone.getRequestContext().setSiteRoot("");
        if (sharedFolder == null || sharedFolder.equals("") || sharedFolder.equals("/") || !sharedFolder.startsWith("/") || !sharedFolder.endsWith("/") || sharedFolder.startsWith(SITES_FOLDER)) {
            throw new CmsException(Messages.get().container("ERR_INVALID_PATH_FOR_SHARED_FOLDER_1", sharedFolder));
        }
        this.m_frozen = false;
        this.setDefaultUri(clone.readResource(defaulrUri).getRootPath());
        this.setSharedFolder(clone.readResource(sharedFolder).getRootPath());
        this.m_workplaceServers = workplaceServers;
        this.initialize(cms);
        this.m_frozen = true;
    }

    public void updateSite(CmsObject cms, CmsSite oldSite, CmsSite newSite) throws CmsException {
        if (oldSite != null) {
            this.removeSite(cms, oldSite);
        }
        if (newSite != null) {
            this.addSite(cms, newSite);
        }
    }

    public boolean usesSecureSite(HttpServletRequest req) {
        CmsSite site = this.matchRequest(req);
        if (site == null) {
            return false;
        }
        CmsSiteMatcher secureMatcher = site.getSecureServerMatcher();
        boolean result = false;
        if (secureMatcher != null) {
            result = secureMatcher.equals(this.getRequestMatcher(req));
        }
        return result;
    }

    public void validateSiteRoot(String siteRoot) {
        if (!this.isValidSiteRoot(siteRoot)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_INVALID_SITE_ROOT_1", siteRoot));
        }
    }

    private void addServer(CmsSiteMatcher matcher, CmsSite site) {
        HashMap<CmsSiteMatcher, CmsSite> siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>(this.m_siteMatcherSites);
        siteMatcherSites.put(matcher, site);
        this.setSiteMatcherSites(siteMatcherSites);
    }

    private void checkUUIDOfSiteRoot(CmsSite site, CmsObject clone, CmsObject cms_offline) {
        CmsUUID id = null;
        try {
            id = clone.readResource(site.getSiteRoot()).getStructureId();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (id == null) {
            try {
                id = cms_offline.readResource(site.getSiteRoot()).getStructureId();
                this.m_onlyOfflineSites.add(site);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        if (id != null) {
            site.setSiteRootUUID(id);
            this.m_siteUUIDs.put(id, site);
        }
    }

    private CmsProject getOfflineProject() {
        try {
            return this.m_clone.readProject("Offline");
        }
        catch (CmsException e) {
            try {
                for (CmsProject p : OpenCms.getOrgUnitManager().getAllAccessibleProjects(this.m_clone, "/", true)) {
                    if (p.isOnlineProject()) continue;
                    return p;
                }
            }
            catch (CmsException e1) {
                LOG.error((Object)"Unable to get ptoject", (Throwable)e);
            }
            return null;
        }
    }

    private CmsSiteMatcher getRequestMatcher(HttpServletRequest req) {
        CmsSiteMatcher matcher = new CmsSiteMatcher(req.getScheme(), req.getServerName(), req.getServerPort());
        int index = this.m_siteMatchers.indexOf(matcher);
        if (index < 0) {
            return matcher;
        }
        return this.m_siteMatchers.get(index);
    }

    private void initExtensionSites() {
        this.m_alternativeSiteData = new AlternativeSiteData(this.m_siteMatcherSites.values());
    }

    private void initWorkplaceMatchers() {
        ArrayList matchers = new ArrayList();
        if (!this.m_workplaceServers.isEmpty()) {
            HashMap matchersByUrl = Maps.newHashMap();
            for (String server : this.m_workplaceServers.keySet()) {
                CmsSSLMode mode = this.m_workplaceServers.get(server);
                CmsSiteMatcher matcher = new CmsSiteMatcher(server);
                if (mode == CmsSSLMode.LETS_ENCRYPT || mode == CmsSSLMode.MANUAL_EP_TERMINATION) {
                    CmsSiteMatcher httpMatcher = matcher.forDifferentScheme("http");
                    CmsSiteMatcher httpsMatcher = matcher.forDifferentScheme("https");
                    for (CmsSiteMatcher current : new CmsSiteMatcher[]{httpMatcher, httpsMatcher}) {
                        matchersByUrl.put(current.getUrl(), current);
                        if (!CmsLog.INIT.isInfoEnabled()) continue;
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_1", matcher));
                    }
                    continue;
                }
                matchersByUrl.put(matcher.getUrl(), matcher);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_1", matcher));
            }
            matchers = Lists.newArrayList(matchersByUrl.values());
        } else if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_0"));
        }
        this.m_workplaceMatchers = matchers;
    }

    private boolean isServerValid(CmsSiteMatcher matcher) {
        return !this.m_siteMatcherSites.containsKey(matcher);
    }

    private boolean isValidSiteRoot(String uri) {
        return !"".equals(uri) && !"/".equals(uri);
    }

    private String lookupAdditionalSite(String rootPath) {
        int size = this.m_additionalSiteRoots.size();
        for (int i = 0; i < size; ++i) {
            String siteRoot = this.m_additionalSiteRoots.get(i);
            if (!rootPath.startsWith(siteRoot + "/")) continue;
            return siteRoot;
        }
        return null;
    }

    private CmsSite lookupSitesFolder(String rootPath) {
        int pos = rootPath.indexOf(47, SITES_FOLDER_POS);
        if (pos > 0) {
            return this.m_siteRootSites.get(rootPath.substring(0, pos));
        }
        return null;
    }

    private void setSiteMatcherSites(Map<CmsSiteMatcher, CmsSite> siteMatcherSites) {
        this.m_siteMatcherSites = Collections.unmodifiableMap(siteMatcherSites);
        this.m_siteMatchers = Collections.unmodifiableList(new ArrayList<CmsSiteMatcher>(this.m_siteMatcherSites.keySet()));
    }

    private static class AlternativeSiteData {
        private Map<CmsPath, CmsSite> m_alternativeSites = new HashMap<CmsPath, CmsSite>();
        private Set<String> m_siteRoots = new HashSet<String>();

        public AlternativeSiteData(Collection<CmsSite> normalSites) {
            for (CmsSite site : normalSites) {
                if (!site.getAlternativeSiteRootMapping().isPresent()) continue;
                CmsSite extensionSite = site.createAlternativeSiteRootSite();
                CmsPath key = new CmsPath(extensionSite.getSiteRoot());
                this.m_alternativeSites.put(key, extensionSite);
                this.m_siteRoots.add(key.asString());
            }
        }

        public CmsSite getSiteForRootPath(String path) {
            for (Map.Entry<CmsPath, CmsSite> entry : this.m_alternativeSites.entrySet()) {
                CmsPath key = entry.getKey();
                if (!key.isPrefixOfStr(path)) continue;
                return entry.getValue();
            }
            return null;
        }

        public CmsSite getSiteForSiteRoot(String path) {
            CmsPath key = new CmsPath(path);
            CmsSite result = this.m_alternativeSites.get(key);
            return result;
        }

        public Set<String> getSiteRoots() {
            return Collections.unmodifiableSet(this.m_siteRoots);
        }
    }
}

