/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.xmlsitemap.CmsXmlSitemapGenerator;
import org.opencms.site.xmlsitemap.CmsXmlSitemapUrlBean;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPathMap;
import org.opencms.util.CmsStringUtil;

public class CmsDetailPageDuplicateEliminatingSitemapGenerator
extends CmsXmlSitemapGenerator {
    private static final Log LOG = CmsLog.getLog(CmsDetailPageDuplicateEliminatingSitemapGenerator.class);
    protected List<CmsADEConfigData.DetailInfo> m_detailInfos = new ArrayList<CmsADEConfigData.DetailInfo>();
    private Multimap<String, CmsADEConfigData.DetailInfo> m_detailInfosByPage;
    private HashMap<String, CmsPathMap<CmsResource>> m_pathMapsByType = Maps.newHashMap();

    public CmsDetailPageDuplicateEliminatingSitemapGenerator(String sitemapPath) throws CmsException {
        super(sitemapPath);
        List<CmsADEConfigData.DetailInfo> rawDetailInfo = OpenCms.getADEManager().getDetailInfo(this.m_guestCms);
        ArrayList filteredDetailInfo = Lists.newArrayList();
        for (CmsADEConfigData.DetailInfo item : rawDetailInfo) {
            String path = item.getFolderPath();
            if (OpenCms.getSiteManager().startsWithShared(path) || CmsStringUtil.isPrefixPath(this.m_siteRoot, path)) {
                filteredDetailInfo.add(item);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Filtered detail info: " + item));
        }
        this.m_detailInfos = filteredDetailInfo;
    }

    @Override
    public List<CmsXmlSitemapUrlBean> generateSitemapBeans() throws CmsException {
        List<CmsXmlSitemapUrlBean> parentResult = super.generateSitemapBeans();
        ArrayList result = Lists.newArrayList();
        ArrayListMultimap detailPageBeans = ArrayListMultimap.create();
        for (CmsXmlSitemapUrlBean urlBean : parentResult) {
            if (urlBean.getDetailPageResource() == null) {
                result.add(urlBean);
                continue;
            }
            String localeKey = urlBean.getOriginalResource().getStructureId() + "_" + urlBean.getLocale();
            detailPageBeans.put((Object)localeKey, (Object)urlBean);
        }
        Comparator<CmsXmlSitemapUrlBean> pathComparator = new Comparator<CmsXmlSitemapUrlBean>(){

            @Override
            public int compare(CmsXmlSitemapUrlBean urlbean1, CmsXmlSitemapUrlBean urlbean2) {
                String subsite2;
                String subsite1 = urlbean1.getSubsite();
                if (subsite1 == null) {
                    subsite1 = "";
                }
                if ((subsite2 = urlbean2.getSubsite()) == null) {
                    subsite2 = "";
                }
                return subsite1.compareTo(subsite2);
            }
        };
        for (String key : detailPageBeans.keySet()) {
            result.add(Collections.max(detailPageBeans.get((Object)key), pathComparator));
        }
        return result;
    }

    @Override
    protected void addDetailLinks(CmsResource containerPage, Locale locale) throws CmsException {
        Collection<CmsADEConfigData.DetailInfo> detailInfos = this.getDetailInfosForPage(containerPage);
        for (CmsADEConfigData.DetailInfo info : detailInfos) {
            List<CmsResource> contents = this.getContents(info.getFolderPath(), info.getType());
            for (CmsResource detailRes : contents) {
                if (!OpenCms.getADEManager().getDetailPageHandler().isValidDetailPage(this.m_guestCms, containerPage, detailRes)) continue;
                List<CmsProperty> detailProps = this.m_guestCms.readPropertyObjects(detailRes, true);
                String detailLink = this.getDetailLink(containerPage, detailRes, locale);
                detailLink = CmsFileUtil.removeTrailingSeparator(detailLink);
                CmsXmlSitemapUrlBean detailUrlBean = new CmsXmlSitemapUrlBean(this.replaceServerUri(detailLink), detailRes.getDateLastModified(), CmsDetailPageDuplicateEliminatingSitemapGenerator.getChangeFrequency(detailProps), CmsDetailPageDuplicateEliminatingSitemapGenerator.getPriority(detailProps));
                detailUrlBean.setLocale(locale);
                detailUrlBean.setOriginalResource(detailRes);
                detailUrlBean.setDetailPageResource(containerPage);
                detailUrlBean.setSubsite(info.getBasePath());
                this.addResult(detailUrlBean, 2);
            }
        }
    }

    private List<CmsResource> getContents(String folderPath, String type) throws CmsException {
        CmsPathMap<CmsResource> pathMap = this.getPathMapForType(type);
        return pathMap.getChildValues(folderPath);
    }

    private Collection<CmsADEConfigData.DetailInfo> getDetailInfosForPage(CmsResource containerPage) {
        if (this.m_detailInfosByPage == null) {
            this.m_detailInfosByPage = ArrayListMultimap.create();
            for (CmsADEConfigData.DetailInfo detailInfo : this.m_detailInfos) {
                this.m_detailInfosByPage.put((Object)detailInfo.getDetailPageInfo().getUri(), (Object)detailInfo);
            }
        }
        String folderPath = CmsResource.getParentFolder(containerPage.getRootPath());
        Collection result = this.m_detailInfosByPage.get((Object)containerPage.getRootPath());
        if (result.isEmpty()) {
            result = this.m_detailInfosByPage.get((Object)folderPath);
        }
        return result;
    }

    private CmsPathMap<CmsResource> getPathMapForType(String typeName) throws CmsException {
        if (!this.m_pathMapsByType.containsKey(typeName)) {
            CmsPathMap<CmsResource> pathMap = this.readPathMapForType(OpenCms.getResourceManager().getResourceType(typeName));
            this.m_pathMapsByType.put(typeName, pathMap);
        }
        return this.m_pathMapsByType.get(typeName);
    }

    private CmsPathMap<CmsResource> readPathMapForType(I_CmsResourceType type) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addRequireType(type);
        try {
            List<CmsResource> siteFiles = this.m_guestCms.readResources(this.m_siteRoot, filter, true);
            result.addAll(siteFiles);
        }
        catch (CmsException e) {
            LOG.error((Object)("XML sitemap generator error: " + e.getLocalizedMessage()), (Throwable)e);
        }
        String shared = CmsFileUtil.removeTrailingSeparator(OpenCms.getSiteManager().getSharedFolder());
        if (shared != null) {
            try {
                List<CmsResource> sharedFiles = this.m_guestCms.readResources(shared, filter, true);
                result.addAll(sharedFiles);
            }
            catch (CmsException e) {
                LOG.error((Object)("XML sitemap generator error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        CmsPathMap<CmsResource> resultMap = new CmsPathMap<CmsResource>();
        for (CmsResource resource : result) {
            resultMap.add(resource.getRootPath(), resource);
        }
        return resultMap;
    }
}

