/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.xmlsitemap.CmsPathIncludeExcludeSet;
import org.opencms.site.xmlsitemap.CmsXmlSeoConfiguration;
import org.opencms.site.xmlsitemap.CmsXmlSitemapCache;
import org.opencms.site.xmlsitemap.CmsXmlSitemapGenerator;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsXmlSitemapActionElement
extends CmsJspActionElement {
    private static final Log LOG = CmsLog.getLog(CmsXmlSitemapActionElement.class);
    private static final String PARAM_DEFAULT_SITEMAP_GENERATOR = "sitemap.generator";
    protected CmsXmlSeoConfiguration m_configuration;

    public CmsXmlSitemapActionElement(PageContext pageContext, HttpServletRequest request, HttpServletResponse response) {
        super(pageContext, request, response);
    }

    public static CmsXmlSitemapGenerator createSitemapGenerator(String className, String folderRootPath) throws CmsException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(className)) {
            className = (String)OpenCms.getRuntimeProperty(PARAM_DEFAULT_SITEMAP_GENERATOR);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(className)) {
            className = CmsXmlSitemapGenerator.class.getName();
        }
        try {
            Class<CmsXmlSitemapGenerator> generatorClass = Class.forName(className).asSubclass(CmsXmlSitemapGenerator.class);
            Constructor<CmsXmlSitemapGenerator> constructor = generatorClass.getConstructor(String.class);
            CmsXmlSitemapGenerator generator = constructor.newInstance(folderRootPath);
            return generator;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create configured sitemap generator " + className + ", using the default class instead"), (Throwable)e);
            return new CmsXmlSitemapGenerator(folderRootPath);
        }
    }

    public static CmsXmlSitemapGenerator prepareSitemapGenerator(CmsResource seoFileRes, CmsXmlSeoConfiguration config) throws CmsException {
        if (config.getMode().equals(CmsXmlSeoConfiguration.MODE_XML_SITEMAP)) {
            String baseFolderRootPath = CmsFileUtil.removeTrailingSeparator(CmsResource.getParentFolder(seoFileRes.getRootPath()));
            CmsXmlSitemapGenerator xmlSitemapGenerator = CmsXmlSitemapActionElement.createSitemapGenerator(config.getSitemapGeneratorClassName(), baseFolderRootPath);
            xmlSitemapGenerator.setComputeContainerPageDates(config.shouldComputeContainerPageModificationDates());
            CmsPathIncludeExcludeSet inexcludeSet = xmlSitemapGenerator.getIncludeExcludeSet();
            for (String include : config.getIncludes()) {
                inexcludeSet.addInclude(include);
            }
            for (String exclude : config.getExcludes()) {
                inexcludeSet.addExclude(exclude);
            }
            xmlSitemapGenerator.setServerUrl(config.getServerUrl());
            return xmlSitemapGenerator;
        }
        return null;
    }

    public void run() throws Exception {
        CmsObject cms = this.getCmsObject();
        String seoFilePath = cms.getRequestContext().getUri();
        CmsResource seoFile = cms.readResource(seoFilePath);
        this.m_configuration = new CmsXmlSeoConfiguration();
        this.m_configuration.load(cms, seoFile);
        String mode = this.m_configuration.getMode();
        if (mode.equals(CmsXmlSeoConfiguration.MODE_ROBOTS_TXT)) {
            this.showRobotsTxt();
        } else {
            boolean updateCache = Boolean.parseBoolean(this.getRequest().getParameter("updateCache"));
            String value = "";
            if (updateCache && this.m_configuration.usesCache()) {
                CmsXmlSitemapGenerator generator = CmsXmlSitemapActionElement.prepareSitemapGenerator(seoFile, this.m_configuration);
                value = generator.renderSitemap();
                CmsXmlSitemapCache.INSTANCE.put(seoFile.getRootPath(), value);
            } else if (!updateCache && this.m_configuration.usesCache()) {
                String cachedValue = CmsXmlSitemapCache.INSTANCE.get(seoFile.getRootPath());
                if (cachedValue != null) {
                    value = cachedValue;
                } else {
                    CmsXmlSitemapGenerator generator = CmsXmlSitemapActionElement.prepareSitemapGenerator(seoFile, this.m_configuration);
                    value = generator.renderSitemap();
                    CmsXmlSitemapCache.INSTANCE.put(seoFile.getRootPath(), value);
                }
            } else if (!updateCache && !this.m_configuration.usesCache()) {
                CmsXmlSitemapGenerator generator = CmsXmlSitemapActionElement.prepareSitemapGenerator(seoFile, this.m_configuration);
                value = generator.renderSitemap();
            } else if (!updateCache || !this.m_configuration.usesCache()) {
                // empty if block
            }
            this.getResponse().getWriter().print(value);
        }
    }

    private void showRobotsTxt() throws Exception {
        CmsObject cms = this.getCmsObject();
        StringBuffer buffer = new StringBuffer();
        I_CmsResourceType seoFileType = OpenCms.getResourceManager().getResourceType("seo_file");
        List<CmsResource> seoFiles = cms.readResources("/", CmsResourceFilter.DEFAULT_FILES.addRequireVisible().addRequireType(seoFileType));
        for (CmsResource seoFile : seoFiles) {
            try {
                if (seoFile.getName().contains("test")) continue;
                CmsXmlSeoConfiguration seoFileConfig = new CmsXmlSeoConfiguration();
                seoFileConfig.load(cms, seoFile);
                if (!seoFileConfig.isXmlSitemapMode()) continue;
                buffer.append("Sitemap: " + CmsXmlSitemapGenerator.replaceServerUri(OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(seoFile)), this.m_configuration.getServerUrl()));
                buffer.append("\n");
            }
            catch (CmsException e) {
                LOG.error((Object)("Error while generating robots.txt : " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        buffer.append("\n");
        buffer.append(this.m_configuration.getRobotsTxtText());
        buffer.append("\n");
        this.getResponse().getWriter().print(buffer.toString());
    }
}

