/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.staticexport.A_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsUUID;

public abstract class A_CmsOnDemandStaticExportHandler
extends A_CmsStaticExportHandler {
    private static final Log LOG = CmsLog.getLog(A_CmsOnDemandStaticExportHandler.class);

    @Override
    public void performEventPublishProject(CmsUUID publishHistoryId, I_CmsReport report) {
        int count = 0;
        while (count < 60 && this.isBusy()) {
            ++count;
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_WAITING_STATIC_EXPORT_3", this.getClass().getName(), new Integer(count), new Integer(60)));
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                count = 60;
            }
        }
        if (this.isBusy()) {
            Object[] arguments = new Object[]{publishHistoryId, new Integer(60)};
            LOG.error((Object)Messages.get().getBundle().key("LOG_SCRUBBING_FOLDER_FAILED_2", arguments));
            return;
        }
        final CmsUUID id = publishHistoryId;
        if (OpenCms.getRunLevel() >= 1) {
            this.m_busy = true;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        A_CmsOnDemandStaticExportHandler.this.scrubExportFolders(id);
                    }
                    finally {
                        A_CmsOnDemandStaticExportHandler.this.m_busy = false;
                    }
                }
            }, Messages.get().getBundle().key("GUI_THREAD_NAME_SCRUB_EXPORT_FOLDERS_1", String.valueOf(id)));
            t.start();
        }
    }
}

