/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ugc.CmsUgcDataItem;
import org.opencms.ugc.I_CmsFormDataHandler;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsUgcUploadHelper {
    private static final Log LOG = CmsLog.getLog(CmsUgcUploadHelper.class);
    private ConcurrentHashMap<String, List<FileItem>> m_storedFormData = new ConcurrentHashMap();

    public void consumeFormData(String formDataId, I_CmsFormDataHandler handler) throws Exception {
        List<FileItem> items = this.m_storedFormData.get(formDataId);
        if (items != null) {
            HashMap itemMap = Maps.newHashMap();
            LOG.debug((Object)(formDataId + ": Processing file items"));
            for (FileItem item : items) {
                LOG.debug((Object)(formDataId + ": " + item.toString()));
                if (!item.isFormField() && CmsStringUtil.isEmptyOrWhitespaceOnly(item.getName())) {
                    LOG.debug((Object)(formDataId + ": skipping previous file field because it is empty"));
                    continue;
                }
                itemMap.put(item.getFieldName(), new CmsUgcDataItem(item));
            }
            Exception storedException = null;
            try {
                handler.handleFormData(itemMap);
            }
            catch (Exception e) {
                storedException = e;
            }
            for (FileItem item : items) {
                item.delete();
            }
            this.m_storedFormData.remove(formDataId);
            if (storedException != null) {
                throw storedException;
            }
        }
    }

    void processFormSubmitRequest(HttpServletRequest request) {
        String formDataId = this.getFormDataId(request);
        List<FileItem> items = CmsRequestUtil.readMultipartFileItems(request);
        this.m_storedFormData.put(formDataId, items);
    }

    private String getFormDataId(HttpServletRequest request) {
        String result = request.getParameter("formDataId");
        return result;
    }
}

