/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsLockedResourcesList;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.util.CmsUUID;

public abstract class A_CmsWorkplaceAction
implements I_CmsWorkplaceAction {
    private static final Log LOG = CmsLog.getLog(A_CmsWorkplaceAction.class);

    public String getDialogTitle() {
        return OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()).key(this.getDialogTitleKey());
    }

    protected String getDialogTitleKey() {
        return this.getTitleKey();
    }

    @Override
    public String getTitle(Locale locale) {
        return OpenCms.getWorkplaceManager().getMessages(locale).key(this.getTitleKey());
    }

    protected abstract String getTitleKey();

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        return this.getVisibility(context.getCms(), context.getResources());
    }

    protected boolean hasBlockingLocks(final I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        List<CmsResource> resources = context.getResources();
        ArrayList blocked = Lists.newArrayList();
        for (CmsResource resource : resources) {
            try {
                blocked.addAll(cms.getBlockingLockedResources(resource));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (blocked.isEmpty()) {
            return false;
        }
        CmsLockedResourcesList dialog = new CmsLockedResourcesList(cms, blocked, CmsVaadinUtils.getMessageText("GUI_CANT_PERFORM_OPERATION_BECAUSE_OF_LOCKED_RESOURCES_0", new Object[0]), new Runnable(){

            @Override
            public void run() {
                List<CmsUUID> noStructureIds = Collections.emptyList();
                context.finish(noStructureIds);
            }
        }, null);
        context.start(CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_LOCKS_0", new Object[0]), (Component)dialog);
        return true;
    }

    @Override
    public boolean isActive(I_CmsDialogContext context) {
        return this.getVisibility(context).isActive();
    }

    protected void openDialog(CmsBasicDialog dialog, I_CmsDialogContext context) {
        context.start(this.getDialogTitle(), (Component)dialog);
    }

    protected void openDialog(CmsBasicDialog dialog, I_CmsDialogContext context, CmsBasicDialog.DialogWidth dialogWidth) {
        context.start(this.getDialogTitle(), (Component)dialog, dialogWidth);
    }
}

