/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsGalleryDialogAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public class CmsGalleryDialogAction
extends A_CmsGalleryDialogAction {
    public static final String ACTION_ID = "gallery";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.VISIBLE;
    private static final String[] GALLERY_TYPES = new String[]{"imagegallery", "downloadgallery", "linkgallery"};

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        CmsResource gallery = this.getGallery(context);
        try {
            CmsGwtDialogExtension dialogExtension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList updatedIds = Lists.newArrayList();
                    for (String item : updatedItems) {
                        updatedIds.add(new CmsUUID(item));
                    }
                    context.finish(updatedIds);
                }
            });
            dialogExtension.openGalleryDialog(gallery);
        }
        catch (Exception e) {
            context.error(e);
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    protected String[] getSupportedGalleryTypes() {
        return GALLERY_TYPES;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_OPENGALLERY_0";
    }
}

