/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.ui.apps.CmsAppCategory;
import org.opencms.ui.apps.CmsWorkplaceAppManager;
import org.opencms.ui.apps.I_CmsAppCategory;
import org.opencms.ui.apps.I_CmsHasOrder;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public class CmsAppCategoryNode
implements I_CmsHasOrder {
    private I_CmsAppCategory m_data;
    private List<CmsAppCategoryNode> m_children = Lists.newArrayList();
    private List<I_CmsWorkplaceAppConfiguration> m_appConfigurations = Lists.newArrayList();
    private int m_appCount;

    public CmsAppCategoryNode(I_CmsAppCategory appCategory) {
        this.m_data = appCategory;
    }

    CmsAppCategoryNode() {
        this.m_data = new CmsAppCategory(null, null, 0, 0);
    }

    public void addAppConfiguration(I_CmsWorkplaceAppConfiguration appConfig) {
        this.m_appConfigurations.add(appConfig);
    }

    public void addChild(CmsAppCategoryNode node) {
        this.m_children.add(node);
    }

    public List<I_CmsWorkplaceAppConfiguration> getAppConfigurations() {
        return this.m_appConfigurations;
    }

    public I_CmsAppCategory getCategory() {
        return this.m_data;
    }

    public List<CmsAppCategoryNode> getChildren() {
        return this.m_children;
    }

    @Override
    public int getOrder() {
        return this.getCategory().getOrder();
    }

    public void removeApplessSubtrees() {
        this.internalRemoveApplessSubtrees(true);
    }

    public void sort() {
        Collections.sort(this.m_appConfigurations, new CmsWorkplaceAppManager.ConfigurationComparator());
        Collections.sort(this.m_children, new CmsWorkplaceAppManager.ConfigurationComparator());
    }

    public void sortRecursively() {
        this.sort();
        for (CmsAppCategoryNode child : this.m_children) {
            child.sortRecursively();
        }
    }

    private void computeAppCount() {
        this.m_appCount = this.m_appConfigurations.size();
        for (CmsAppCategoryNode child : this.m_children) {
            child.computeAppCount();
            this.m_appCount += child.m_appCount;
        }
    }

    private void internalRemoveApplessSubtrees(boolean isRoot) {
        if (isRoot) {
            this.computeAppCount();
        }
        Iterator<CmsAppCategoryNode> iter = this.m_children.iterator();
        while (iter.hasNext()) {
            CmsAppCategoryNode child = iter.next();
            if (child.m_appCount == 0) {
                iter.remove();
                continue;
            }
            child.internalRemoveApplessSubtrees(false);
        }
    }
}

