/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vaadin.event.Action;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutAction;
import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.event.dd.acceptcriteria.ServerSideCriterion;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.Tree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.CmsCopyDialogAction;
import org.opencms.ui.actions.CmsPropertiesDialogAction;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsExplorerDialogContext;
import org.opencms.ui.apps.CmsFileExplorerSettings;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.A_CmsFocusShortcutListener;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.components.CmsUploadButton;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.components.extensions.CmsUploadAreaExtension;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.ui.dialogs.CmsCopyMoveDialog;
import org.opencms.ui.dialogs.CmsDeleteDialog;
import org.opencms.ui.dialogs.CmsNewDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsFileExplorer
implements I_CmsWorkplaceApp,
I_CmsCachableApp,
ViewChangeListener,
I_CmsWindowCloseListener,
I_CmsHasShortcutActions,
I_CmsContextProvider,
CmsFileTable.I_FolderSelectHandler {
    public static final String ATTR_KEY = "CmsFileExplorer";
    public static final Collection<CmsResourceTableProperty> INLINE_EDIT_PROPERTIES = Arrays.asList(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, CmsResourceTableProperty.PROPERTY_TITLE, CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, CmsResourceTableProperty.PROPERTY_COPYRIGHT, CmsResourceTableProperty.PROPERTY_CACHE);
    public static final int LAYOUT_SPLIT_POSITION = 399;
    public static final String OPENED_PATHS = "explorer-opened-paths";
    public static final String SITE_CAPTION = "site_caption";
    public static final String SITE_ROOT = "site_root";
    public static final int UPDATE_FOLDER_THRESHOLD = 200;
    static final Log LOG = CmsLog.getLog(CmsFileExplorer.class);
    private static final Action ACTION_DELETE = new ShortcutAction("Del", 46, null);
    private static final Action ACTION_FOLDER_UP = new ShortcutAction("Alt+ArrowUp", 38, new int[]{18});
    private static final Action ACTION_PROPERTIES = new ShortcutAction("Alt+Enter", 13, new int[]{18});
    private static final Action ACTION_RENAME = new ShortcutAction("F2", 113, null);
    private static final Action ACTION_SELECT_ALL = new ShortcutAction("Ctrl+A", 65, new int[]{17});
    private static final Action ACTION_SELECT_ALL_CMD = new ShortcutAction("CMD+A", 65, new int[]{91});
    private static final Action ACTION_SWITCH_ONLINE = new ShortcutAction("Ctrl+O", 79, new int[]{17});
    private static final Action ACTION_SWITCH_ONLINE_CMD = new ShortcutAction("CMD+O", 79, new int[]{91});
    private static final CmsResourceFilter FILES_N_FOLDERS = CmsResourceFilter.ONLY_VISIBLE;
    private static final CmsResourceFilter FOLDERS = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFolder();
    private static final long serialVersionUID = 1L;
    protected I_CmsAppUIContext m_appContext;
    protected String m_savedExplorerState = "";
    CmsFileTable m_fileTable;
    TextField m_infoPath;
    Map<Action, Runnable> m_shortcutActions = new HashMap<Action, Runnable>();
    private Button.ClickListener m_crumbListener;
    private CssLayout m_crumbs;
    private CmsUUID m_currentFolder;
    private String m_currentState;
    private TreeExpandListener m_expandListener;
    private Tree m_fileTree;
    private int m_firstVisibleTableItemIndex;
    private List<CmsResource> m_lastDialogContextResources;
    private CmsQuickLaunchLocationCache m_locationCache;
    private Button m_newButton;
    private Button m_publishButton;
    private com.vaadin.v7.ui.TextField m_searchField;
    private CmsUUID m_selectTreeFolder;
    private ComboBox m_siteSelector;
    private HierarchicalContainer m_treeContainer;
    private CmsUploadAreaExtension m_uploadArea;
    private CmsUploadButton m_uploadButton;
    private Button m_specialUploadButton;
    private String m_uploadAction;
    private CmsResource m_uploadFolder;

    public CmsFileExplorer() {
        this.m_shortcutActions.put(ACTION_DELETE, new Runnable(){

            @Override
            public void run() {
                if (!CmsFileExplorer.this.m_fileTable.getSelectedIds().isEmpty()) {
                    CmsExplorerDialogContext context1 = CmsFileExplorer.this.getDialogContext();
                    context1.start("Delete", (Component)new CmsDeleteDialog(context1));
                }
            }
        });
        this.m_shortcutActions.put(ACTION_FOLDER_UP, new Runnable(){

            @Override
            public void run() {
                CmsFileExplorer.this.showParentFolder();
            }
        });
        this.m_shortcutActions.put(ACTION_PROPERTIES, new Runnable(){

            @Override
            public void run() {
                CmsPropertiesDialogAction propAction = new CmsPropertiesDialogAction();
                CmsExplorerDialogContext context = CmsFileExplorer.this.getDialogContext();
                if (propAction.getVisibility(context).isActive()) {
                    propAction.executeAction(context);
                }
            }
        });
        this.m_shortcutActions.put(ACTION_RENAME, new Runnable(){

            @Override
            public void run() {
                CmsExplorerDialogContext context = CmsFileExplorer.this.getDialogContext();
                if (context.isPropertyEditable(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME)) {
                    context.editProperty(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME);
                }
            }
        });
        Runnable selectAll = new Runnable(){

            @Override
            public void run() {
                CmsFileExplorer.this.m_fileTable.selectAll();
            }
        };
        this.m_shortcutActions.put(ACTION_SELECT_ALL, selectAll);
        this.m_shortcutActions.put(ACTION_SELECT_ALL_CMD, selectAll);
        Runnable switchOnline = new Runnable(){

            @Override
            public void run() {
                CmsFileExplorer.this.toggleOnlineOffline();
            }
        };
        this.m_shortcutActions.put(ACTION_SWITCH_ONLINE, switchOnline);
        this.m_shortcutActions.put(ACTION_SWITCH_ONLINE_CMD, switchOnline);
        this.m_fileTable = new CmsFileTable(this);
        this.m_fileTable.setSizeFull();
        this.m_fileTable.setMenuBuilder(new CmsResourceContextMenuBuilder());
        this.m_fileTable.setFolderSelectHandler(this);
        this.m_uploadArea = new CmsUploadAreaExtension((AbstractComponent)this.m_fileTable);
        this.m_uploadArea.addUploadListener(new CmsUploadButton.I_UploadListener(){

            @Override
            public void onUploadFinished(List<String> uploadedFiles) {
                CmsFileExplorer.this.updateAll(true);
            }
        });
        this.m_treeContainer = new HierarchicalContainer();
        this.addTreeContainerProperties(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, CmsResourceTableProperty.PROPERTY_STATE, CmsResourceTableProperty.PROPERTY_TREE_CAPTION, CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT, CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED, CmsResourceTableProperty.PROPERTY_DISABLED);
        this.m_fileTree = new Tree();
        this.m_fileTree.addStyleName("o-simple-drag");
        this.m_fileTree.addStyleName("o-full-width-padding");
        this.m_fileTree.setWidth("100%");
        this.m_fileTree.setContainerDataSource((Container)this.m_treeContainer);
        this.m_fileTree.setItemCaptionPropertyId((Object)CmsResourceTableProperty.PROPERTY_TREE_CAPTION);
        this.m_fileTree.setHtmlContentAllowed(true);
        this.m_expandListener = new TreeExpandListener();
        this.m_fileTree.addExpandListener((Tree.ExpandListener)this.m_expandListener);
        this.m_fileTree.addCollapseListener(new Tree.CollapseListener(){
            private static final long serialVersionUID = 1L;

            public void nodeCollapse(Tree.CollapseEvent event) {
                CmsFileExplorer.this.selectTreeItem((CmsUUID)event.getItemId());
                CmsFileExplorer.this.clearTreeLevel((CmsUUID)event.getItemId());
            }
        });
        this.m_fileTree.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsFileExplorer.this.handleFileTreeClick(event);
            }
        });
        this.m_fileTree.setItemStyleGenerator(new Tree.ItemStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Tree source, Object itemId) {
                return CmsFileTable.getStateStyle(source.getContainerDataSource().getItem(itemId));
            }
        });
        this.m_fileTree.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsFileExplorer.this.handleFileTreeValueChange();
            }
        });
        this.m_fileTree.setNullSelectionAllowed(false);
        ExplorerDropHandler handler = new ExplorerDropHandler();
        this.m_fileTable.setDropHandler(handler);
        this.m_fileTable.setDragMode(Table.TableDragMode.MULTIROW);
        this.m_fileTree.setDropHandler((DropHandler)handler);
        this.m_fileTree.setDragMode(Tree.TreeDragMode.NONE);
        this.m_siteSelector = this.createSiteSelect(A_CmsUI.getCmsObject());
        this.m_infoPath = new TextField();
        A_CmsFocusShortcutListener shortcutListener = new A_CmsFocusShortcutListener("Open path", 13, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void blur(FieldEvents.BlurEvent event) {
                super.blur(event);
                CmsFileExplorer.this.showCrumbs(true);
            }

            @Override
            public void focus(FieldEvents.FocusEvent event) {
                super.focus(event);
                CmsFileExplorer.this.showCrumbs(false);
            }

            public void handleAction(Object sender, Object target) {
                CmsFileExplorer.this.openPath(CmsFileExplorer.this.m_infoPath.getValue());
            }
        };
        shortcutListener.installOn(this.m_infoPath);
        this.m_crumbs = new CssLayout();
        this.m_crumbs.setPrimaryStyleName("o-crumbs");
        this.m_crumbListener = new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsFileExplorer.this.openPath((String)event.getButton().getData());
            }
        };
        this.m_searchField = new com.vaadin.v7.ui.TextField();
        this.m_searchField.setIcon((Resource)FontOpenCms.FILTER);
        this.m_searchField.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_searchField.addStyleName("inline-icon");
        this.m_searchField.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsFileExplorer.this.filterTable(event.getText());
            }
        });
        this.m_locationCache = CmsQuickLaunchLocationCache.getLocationCache(CmsAppWorkplaceUi.get().getHttpSession());
        String startSite = CmsWorkplace.getStartSiteRoot(A_CmsUI.getCmsObject(), CmsAppWorkplaceUi.get().getWorkplaceSettings());
        while (startSite.endsWith("/")) {
            startSite = startSite.substring(0, startSite.length() - 1);
        }
        if (this.m_locationCache.getFileExplorerLocation(startSite) == null) {
            String startFolder = CmsAppWorkplaceUi.get().getWorkplaceSettings().getUserSettings().getStartFolder();
            this.m_locationCache.setFileExplorerLocation(startSite, startFolder);
        }
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.m_fileTable.setFirstVisibleItemIndex(this.m_firstVisibleTableItemIndex);
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.m_firstVisibleTableItemIndex = this.m_fileTable.getFirstVisibleItemIndex();
        OpenCms.getWorkplaceAppManager().storeAppSettings(A_CmsUI.getCmsObject(), CmsFileExplorerSettings.class, this.m_fileTable.getTableSettings());
        return true;
    }

    public void changeSite(String siteRoot, String path) {
        this.changeSite(siteRoot, path, false);
    }

    public void changeSite(String siteRoot, String path, boolean force) {
        CmsObject cms = A_CmsUI.getCmsObject();
        String currentSiteRoot = cms.getRequestContext().getSiteRoot();
        if (force || !currentSiteRoot.equals(siteRoot) || path != null) {
            CmsAppWorkplaceUi.get().changeSite(siteRoot);
            if (path == null) {
                path = this.m_locationCache.getFileExplorerLocation(siteRoot);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(siteRoot) && (path == null || !path.startsWith("/system")) && (path = this.m_locationCache.getFileExplorerLocation(currentSiteRoot)) != null) {
                    path = CmsStringUtil.joinPaths(currentSiteRoot, path);
                }
            }
            this.openPath(path, true);
            Container container = this.m_siteSelector.getContainerDataSource();
            CmsExtendedSiteSelector.SiteSelectorOption optionToSelect = null;
            for (Object id : container.getItemIds()) {
                CmsExtendedSiteSelector.SiteSelectorOption option = (CmsExtendedSiteSelector.SiteSelectorOption)id;
                if (option == null || !CmsStringUtil.comparePaths(option.getSite(), siteRoot)) continue;
                optionToSelect = option;
                break;
            }
            this.m_siteSelector.select(optionToSelect);
        }
    }

    public void clearSelection() {
        this.m_fileTable.clearSelection();
    }

    public List<CmsUUID> getAllIds() {
        return this.m_fileTable.getAllIds();
    }

    public CmsUUID getCurrentFolder() {
        return this.m_currentFolder;
    }

    @Override
    public CmsExplorerDialogContext getDialogContext() {
        List<CmsResource> resources = this.m_fileTable.getSelectedResources();
        this.m_lastDialogContextResources = resources;
        CmsExplorerDialogContext context = new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.fileTable, this.m_fileTable, this, resources);
        context.setEditableProperties(INLINE_EDIT_PROPERTIES);
        return context;
    }

    @Override
    public Map<Action, Runnable> getShortcutActions() {
        return this.m_shortcutActions;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        this.m_appContext = context;
        this.m_appContext.setAttribute(ATTR_KEY, this);
        this.m_appContext.setMenuDialogContext(new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.appToolbar, this.m_fileTable, this, null));
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setSizeFull();
        sp.setFirstComponent((Component)this.m_fileTree);
        try {
            CmsFileExplorerSettings settings = OpenCms.getWorkplaceAppManager().getAppSettings(A_CmsUI.getCmsObject(), CmsFileExplorerSettings.class);
            this.m_fileTable.setTableState(settings);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading file explorer settings from user.", (Throwable)e);
        }
        sp.setSecondComponent((Component)this.m_fileTable);
        sp.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        context.setAppContent((Component)sp);
        context.showInfoArea(true);
        HorizontalLayout inf = new HorizontalLayout();
        inf.setSizeFull();
        inf.setSpacing(true);
        inf.setMargin(true);
        this.m_siteSelector.setWidth("379px");
        inf.addComponent((Component)this.m_siteSelector);
        CssLayout crumbWrapper = new CssLayout();
        crumbWrapper.setSizeFull();
        crumbWrapper.setPrimaryStyleName("o-crumb-wrapper");
        crumbWrapper.addComponent((Component)this.m_crumbs);
        this.m_infoPath.setWidth("100%");
        crumbWrapper.addComponent((Component)this.m_infoPath);
        inf.addComponent((Component)crumbWrapper);
        inf.setExpandRatio((Component)crumbWrapper, 1.0f);
        this.m_searchField.setWidth("200px");
        inf.addComponent((Component)this.m_searchField);
        context.setAppInfo((Component)inf);
        this.initToolbarButtons(context);
        this.m_fileTable.updateColumnWidths(A_CmsUI.get().getPage().getBrowserWindowWidth() - 399);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public void onFolderSelect(CmsUUID itemId) {
        this.expandCurrentFolder();
        if (this.m_fileTree.getItem((Object)itemId) != null) {
            this.m_fileTree.select((Object)itemId);
        }
        try {
            this.readFolder(itemId);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_READ_RESOURCE_1", itemId), e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void onRestoreFromCache() {
        if (this.m_lastDialogContextResources != null) {
            ArrayList updateIds = Lists.newArrayList();
            for (CmsResource resource : this.m_lastDialogContextResources) {
                updateIds.add(resource.getStructureId());
            }
            this.update(updateIds);
        }
    }

    public void onSiteOrProjectChange(CmsProject project, String siteRoot) {
        if (siteRoot != null && !siteRoot.equals(this.getSiteRootFromState())) {
            this.changeSite(siteRoot, null, true);
        } else if (project != null && !project.getUuid().equals(this.getProjectIdFromState())) {
            this.openPath(this.getPathFromState(), true);
        }
        this.m_appContext.updateOnChange();
        this.setToolbarButtonsEnabled(!CmsAppWorkplaceUi.isOnlineProject());
    }

    @Override
    public void onStateChange(String state) {
        state = this.normalizeState(state);
        if (this.m_currentState == null || !this.m_currentState.equals(state)) {
            this.m_currentState = state;
            CmsObject cms = A_CmsUI.getCmsObject();
            String siteRoot = this.getSiteRootFromState();
            String path = this.getPathFromState();
            CmsUUID projectId = this.getProjectIdFromState();
            if (projectId != null && !cms.getRequestContext().getCurrentProject().getUuid().equals(projectId)) {
                try {
                    CmsProject project = cms.readProject(projectId);
                    cms.getRequestContext().setCurrentProject(project);
                    CmsAppWorkplaceUi.get().getWorkplaceSettings().setProject(project.getUuid());
                }
                catch (CmsException e) {
                    LOG.warn((Object)"Error reading project from history state", (Throwable)e);
                }
                this.changeSite(siteRoot, path, true);
            } else if (siteRoot != null && !CmsStringUtil.comparePaths(siteRoot, cms.getRequestContext().getSiteRoot())) {
                String saveState = this.m_currentState;
                this.changeSite(siteRoot, path);
                if (!this.getSelectionFromState(saveState).isEmpty()) {
                    this.m_fileTable.setValue(Collections.singleton(this.getSelectionFromState(saveState)));
                }
            } else {
                String saveState = this.m_currentState;
                this.openPath(path, true);
                if (!this.getSelectionFromState(saveState).isEmpty()) {
                    this.m_fileTable.setValue(Collections.singleton(this.getSelectionFromState(saveState)));
                }
            }
        }
    }

    @Override
    public void onWindowClose() {
        OpenCms.getWorkplaceAppManager().storeAppSettings(A_CmsUI.getCmsObject(), CmsFileExplorerSettings.class, this.m_fileTable.getTableSettings());
    }

    public void populateFileTable(String sitePath) {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_searchField.clear();
        this.m_firstVisibleTableItemIndex = 0;
        try {
            List<CmsResource> folderResources = cms.readResources(sitePath, FILES_N_FOLDERS, false);
            this.m_fileTable.fillTable(cms, folderResources);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void update(Collection<CmsUUID> ids) {
        try {
            CmsResource currentFolderRes = A_CmsUI.getCmsObject().readResource(this.m_currentFolder, CmsResourceFilter.ALL);
            boolean updateFolder = this.m_fileTable.getItemCount() < 200;
            HashSet<CmsUUID> removeIds = new HashSet<CmsUUID>();
            for (CmsUUID id : ids) {
                boolean remove = false;
                try {
                    CmsResource resource = A_CmsUI.getCmsObject().readResource(id, CmsResourceFilter.ALL);
                    remove = !CmsResource.getParentFolder(resource.getRootPath()).equals(currentFolderRes.getRootPath());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    remove = true;
                    LOG.debug((Object)("Could not read update resource " + id), (Throwable)e);
                }
                if (!remove) continue;
                removeIds.add(id);
            }
            for (CmsUUID id : ids) {
                this.updateTree(id);
            }
            if (updateFolder) {
                this.updateCurrentFolder(removeIds);
            } else {
                this.m_fileTable.update(removeIds, true);
                HashSet<CmsUUID> updateIds = new HashSet<CmsUUID>(ids);
                ids.removeAll(removeIds);
                this.m_fileTable.update(updateIds, false);
            }
            this.m_fileTable.updateSorting();
            this.m_fileTable.clearSelection();
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_searchField.getValue())) {
            this.filterTable((String)this.m_searchField.getValue());
        }
    }

    public void updateAll(boolean clearFilter) {
        try {
            this.readFolder(this.m_currentFolder, clearFilter);
            HashSet ids = Sets.newHashSet();
            ids.addAll(this.m_fileTree.getItemIds());
            for (Object id : ids) {
                this.updateTree((CmsUUID)id);
            }
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_READ_RESOURCE_1", this.m_currentFolder), e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateResourceInTree(CmsObject cms, CmsUUID id) {
        try {
            CmsResource resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
            if (resource.isFile()) {
                return;
            }
            if (!resource.getRootPath().startsWith(cms.getRequestContext().getSiteRoot())) {
                this.m_treeContainer.removeItemRecursively((Object)id);
                return;
            }
            CmsResource parent = cms.readParentFolder(id);
            CmsUUID parentId = null;
            if (parent != null) {
                parentId = parent.getStructureId();
            } else {
                LOG.debug((Object)("Parent for resource '" + resource.getRootPath() + "' is null"));
            }
            Item resourceItem = this.m_treeContainer.getItem((Object)id);
            if (resourceItem != null) {
                String resName = parentId == null ? resource.getRootPath() : resource.getName();
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).setValue((Object)resName);
                CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
                String iconHTML = CmsResourceIcon.getTreeCaptionHTML(resName, resUtil, null, false);
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TREE_CAPTION).setValue((Object)iconHTML);
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).setValue((Object)resource.getState());
                if (parentId != null) {
                    this.m_treeContainer.setParent((Object)resource.getStructureId(), (Object)parentId);
                }
            } else {
                this.addTreeItem(cms, resource, parentId, false, this.m_treeContainer);
            }
            this.m_fileTree.markAsDirty();
        }
        catch (CmsVfsResourceNotFoundException e) {
            this.m_treeContainer.removeItemRecursively((Object)id);
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateTree(CmsUUID id) {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.updateResourceInTree(cms, id);
    }

    protected void clearTreeLevel(CmsUUID parentId) {
        Collection children = this.m_treeContainer.getChildren((Object)parentId);
        if (children != null) {
            ArrayList childIds = new ArrayList(this.m_treeContainer.getChildren((Object)parentId));
            for (Object childId : childIds) {
                this.m_treeContainer.removeItemRecursively(childId);
            }
        }
    }

    protected void readFolder(CmsUUID folderId) throws CmsException {
        this.readFolder(folderId, true);
    }

    protected void readFolder(CmsUUID folderId, boolean clearFilter) throws CmsException {
        CmsObject cms = A_CmsUI.getCmsObject();
        if (clearFilter) {
            this.m_searchField.clear();
        }
        CmsResource folder = cms.readResource(folderId, FOLDERS);
        this.m_currentFolder = folderId;
        String folderPath = cms.getSitePath(folder);
        if (OpenCms.getSiteManager().isSharedFolder(cms.getRequestContext().getSiteRoot())) {
            folderPath = folderPath.substring(cms.getRequestContext().getSiteRoot().length());
        }
        this.setPathInfo(folderPath);
        List<CmsResource> childResources = cms.readResources(folder, FILES_N_FOLDERS, false);
        this.m_fileTable.fillTable(cms, childResources, clearFilter);
        boolean hasFolderChild = false;
        for (CmsResource child : childResources) {
            if (!child.isFolder()) continue;
            hasFolderChild = true;
            break;
        }
        this.m_treeContainer.setChildrenAllowed((Object)folderId, hasFolderChild);
        String sitePath = folder.getRootPath().equals(cms.getRequestContext().getSiteRoot() + "/") ? "" : folderPath;
        String state = new StateBean(cms.getRequestContext().getSiteRoot(), sitePath, cms.getRequestContext().getCurrentProject().getUuid().toString()).asString();
        if (LOG.isDebugEnabled()) {
            String p = RandomStringUtils.randomAlphanumeric((int)5) + " readFolder ";
            LOG.debug((Object)(p + "siteRoot = " + cms.getRequestContext().getSiteRoot()));
            LOG.debug((Object)(p + "folder = " + folder.getRootPath()));
            LOG.debug((Object)(p + "folderPath = " + folderPath));
            LOG.debug((Object)(p + "sitePath = " + sitePath));
            LOG.debug((Object)(p + "state = " + state));
            LOG.debug((Object)(p + "m_currentState = " + this.m_currentState));
            LOG.debug((Object)(p + "m_currentState.asString = " + StateBean.parse(this.m_currentState).asString()));
        }
        if (this.m_currentState == null || !state.equals(StateBean.parse(this.m_currentState).asString())) {
            this.m_currentState = state;
            CmsAppWorkplaceUi.get().changeCurrentAppState(this.m_currentState);
        }
        this.m_locationCache.setFileExplorerLocation(cms.getRequestContext().getSiteRoot(), sitePath);
        this.updateUploadButton(folder);
        if (!this.m_fileTree.isExpanded((Object)folderId)) {
            this.expandCurrentFolder();
        }
        if (!this.m_fileTree.isSelected((Object)folderId)) {
            this.m_fileTree.select((Object)folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCurrentFolder(Collection<CmsUUID> removeIds) {
        this.m_fileTable.update(removeIds, true);
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            this.m_fileTable.saveFilters();
            this.m_fileTable.clearFilters();
            CmsResource folder = cms.readResource(this.m_currentFolder, FOLDERS);
            List<CmsResource> childResources = cms.readResources(cms.getSitePath(folder), FILES_N_FOLDERS, false);
            HashSet<CmsUUID> ids = new HashSet<CmsUUID>();
            for (CmsResource child : childResources) {
                ids.add(child.getStructureId());
            }
            this.m_fileTable.update(ids, false);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.m_fileTable.restoreFilters();
        }
    }

    void expandCurrentFolder() {
        if (this.m_currentFolder != null) {
            this.m_treeContainer.setChildrenAllowed((Object)this.m_currentFolder, true);
            this.m_fileTree.expandItem((Object)this.m_currentFolder);
        }
    }

    void filterTable(String search) {
        this.m_fileTable.filterTable(search);
    }

    void handleFileTreeClick(ItemClickEvent event) {
        Item resourceItem = this.m_treeContainer.getItem(event.getItemId());
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue() == null || !((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue()).booleanValue()) {
            try {
                this.readFolder((CmsUUID)event.getItemId());
            }
            catch (CmsException e) {
                CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_READ_RESOURCE_1", event.getItemId()), e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    void handleFileTreeValueChange() {
        Item resourceItem = this.m_treeContainer.getItem(this.m_fileTree.getValue());
        if (resourceItem != null) {
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue() != null && ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue()).booleanValue()) {
                this.m_fileTree.setValue((Object)this.m_selectTreeFolder);
            } else {
                this.m_selectTreeFolder = (CmsUUID)this.m_fileTree.getValue();
            }
        }
    }

    void onClickNew() {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsResource folderRes = cms.readResource(this.m_currentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsExplorerDialogContext newDialogContext = this.getDialogContext();
            CmsNewDialog newDialog = new CmsNewDialog(folderRes, newDialogContext);
            newDialogContext.start(CmsVaadinUtils.getMessageText("GUI_NEWRESOURCEDIALOG_TITLE_0", new Object[0]), (Component)newDialog);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    void openPath(String path) {
        this.openPath(path, false);
    }

    void openPath(String path, boolean initTree) {
        Collection rootItems;
        boolean existsPath;
        if (path == null) {
            String siteRoot = A_CmsUI.getCmsObject().getRequestContext().getSiteRoot();
            path = this.m_locationCache.getFileExplorerLocation(siteRoot);
            if (path == null) {
                path = "";
            } else if (OpenCms.getSiteManager().startsWithShared(path)) {
                path = path.substring(siteRoot.length());
            }
        }
        boolean bl = existsPath = CmsStringUtil.isNotEmptyOrWhitespaceOnly(path) && A_CmsUI.getCmsObject().existsResource(path, FILES_N_FOLDERS);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathItems = path.split("/");
        if (initTree) {
            try {
                this.initFolderTree(existsPath);
            }
            catch (CmsException e) {
                CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_OPEN_PATH_1", path), e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return;
            }
        }
        if ((rootItems = this.m_treeContainer.rootItemIds()).size() != 1) {
            throw new RuntimeException("Illeagal state, folder tree has " + rootItems.size() + " children");
        }
        CmsUUID folderId = (CmsUUID)rootItems.iterator().next();
        if (initTree) {
            if (existsPath) {
                this.m_expandListener.setOpenPathFragment(pathItems[0]);
            }
            this.m_fileTree.expandItem((Object)folderId);
            this.m_expandListener.setOpenPathFragment(null);
        }
        Collection children = this.m_treeContainer.getChildren((Object)folderId);
        for (int i = 0; i < pathItems.length; ++i) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(pathItems[i])) continue;
            CmsUUID level = null;
            if (children != null) {
                for (Object id : children) {
                    if (!this.m_treeContainer.getItem(id).getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).getValue().equals(pathItems[i])) continue;
                    level = (CmsUUID)id;
                    this.m_expandListener.setOpenPathFragment(existsPath && i < pathItems.length - 1 ? pathItems[i + 1] : null);
                    this.m_fileTree.expandItem((Object)level);
                    this.m_expandListener.setOpenPathFragment(null);
                    break;
                }
            }
            if (level == null || level.equals(folderId)) break;
            folderId = level;
            children = this.m_treeContainer.getChildren((Object)folderId);
        }
        try {
            this.readFolder(folderId);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_OPEN_PATH_1", path), e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return;
        }
    }

    void readTreeLevel(CmsUUID parentId, String openPathFragment) {
        CmsObject cms = A_CmsUI.getCmsObject();
        boolean openedFragment = false;
        try {
            CmsResource parent = cms.readResource(parentId, CmsResourceFilter.IGNORE_EXPIRATION);
            String folderPath = cms.getSitePath(parent);
            List<CmsResource> folderResources = cms.readResources(folderPath, FOLDERS, false);
            this.m_treeContainer.setChildrenAllowed((Object)parentId, !folderResources.isEmpty());
            for (CmsResource resource : folderResources) {
                this.addTreeItem(cms, resource, parentId, false, this.m_treeContainer);
                openedFragment = openedFragment || resource.getName().equals(openPathFragment);
            }
            if (!openedFragment && openPathFragment != null) {
                CmsResource resource = cms.readResource(CmsStringUtil.joinPaths(folderPath, openPathFragment), CmsResourceFilter.IGNORE_EXPIRATION);
                this.addTreeItem(cms, resource, parentId, true, this.m_treeContainer);
            }
            this.m_fileTree.markAsDirtyRecursive();
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    void selectTreeItem(CmsUUID itemId) {
        this.m_fileTree.select((Object)itemId);
    }

    void showCrumbs(boolean show) {
        if (show) {
            this.m_crumbs.removeStyleName("hidden");
            CmsAppWorkplaceUi.get().enableGlobalShortcuts();
        } else {
            this.m_crumbs.addStyleName("hidden");
            CmsAppWorkplaceUi.get().disableGlobalShortcuts();
        }
    }

    void showParentFolder() {
        Item resourceItem;
        CmsUUID parentId = (CmsUUID)this.m_treeContainer.getParent((Object)this.m_currentFolder);
        if (!(parentId == null || (resourceItem = this.m_treeContainer.getItem((Object)parentId)).getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue() != null && ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue()).booleanValue())) {
            try {
                this.readFolder(parentId);
                this.m_fileTree.select((Object)parentId);
            }
            catch (CmsException e) {
                CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_READ_RESOURCE_1", parentId), e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    void toggleOnlineOffline() {
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsProject targetProject = null;
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            targetProject = A_CmsUI.get().getLastOfflineProject();
            if (targetProject == null) {
                CmsUserSettings userSettings = new CmsUserSettings(cms);
                try {
                    CmsProject project = cms.readProject(userSettings.getStartProject());
                    if (!project.isOnlineProject() && OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, project.getOuFqn(), false).contains(project)) {
                        targetProject = project;
                    }
                }
                catch (CmsException e) {
                    LOG.debug((Object)"Error reading user start project.", (Throwable)e);
                }
                if (targetProject == null) {
                    List<CmsProject> availableProjects = CmsVaadinUtils.getAvailableProjects(cms);
                    for (CmsProject project : availableProjects) {
                        if (project.isOnlineProject()) continue;
                        targetProject = project;
                        break;
                    }
                }
            }
        } else {
            try {
                targetProject = cms.readProject(CmsProject.ONLINE_PROJECT_ID);
            }
            catch (CmsException e) {
                LOG.debug((Object)"Error reading online project.", (Throwable)e);
            }
        }
        if (targetProject != null) {
            A_CmsUI.get().changeProject(targetProject);
            this.onSiteOrProjectChange(targetProject, null);
            Notification.show((String)CmsVaadinUtils.getMessageText("GUI_SWITCHED_TO_PROJECT_1", targetProject.getName()));
        }
    }

    private void addTreeContainerProperties(CmsResourceTableProperty ... properties) {
        for (CmsResourceTableProperty property : properties) {
            this.m_treeContainer.addContainerProperty((Object)property, property.getColumnType(), property.getDefaultValue());
        }
    }

    private void addTreeItem(CmsObject cms, CmsResource resource, CmsUUID parentId, boolean disabled, HierarchicalContainer container) {
        CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
        Item resourceItem = container.getItem((Object)resource.getStructureId());
        if (resourceItem == null) {
            resourceItem = container.addItem((Object)resource.getStructureId());
        }
        String resName = parentId == null ? resource.getRootPath() : resource.getName();
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).setValue((Object)resName);
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).setValue((Object)resource.getState());
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT).setValue((Object)resUtil.isInsideProject());
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).setValue((Object)resUtil.isReleasedAndNotExpired());
        String iconHTML = CmsResourceIcon.getTreeCaptionHTML(resName, resUtil, null, false);
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TREE_CAPTION).setValue((Object)iconHTML);
        if (disabled) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).setValue((Object)Boolean.TRUE);
        }
        if (parentId != null) {
            container.setChildrenAllowed((Object)parentId, true);
            container.setParent((Object)resource.getStructureId(), (Object)parentId);
        }
    }

    private ComboBox createSiteSelect(CmsObject cms) {
        List<CmsExtendedSiteSelector.SiteSelectorOption> sites = CmsExtendedSiteSelector.getExplorerSiteSelectorOptions(cms, true);
        final BeanItemContainer container = new BeanItemContainer(CmsExtendedSiteSelector.SiteSelectorOption.class);
        for (CmsExtendedSiteSelector.SiteSelectorOption option : sites) {
            container.addItem((Object)option);
        }
        final ComboBox combo = new ComboBox(null, (Container)container);
        combo.setTextInputAllowed(true);
        combo.setNullSelectionAllowed(false);
        combo.setWidth("200px");
        combo.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        combo.setItemCaptionPropertyId((Object)"label");
        combo.select((Object)new CmsExtendedSiteSelector.SiteSelectorOption(cms.getRequestContext().getSiteRoot(), null, null));
        combo.setFilteringMode(FilteringMode.CONTAINS);
        combo.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;
            private boolean m_disabled;

            public void valueChange(Property.ValueChangeEvent event) {
                if (this.m_disabled) {
                    return;
                }
                CmsExtendedSiteSelector.SiteSelectorOption option = (CmsExtendedSiteSelector.SiteSelectorOption)event.getProperty().getValue();
                if (container.containsId((Object)option)) {
                    CmsFileExplorer.this.changeSite(option.getSite(), option.getPath());
                    CmsFileExplorer.this.m_appContext.updateOnChange();
                    container.removeAllContainerFilters();
                    if (option.getPath() != null) {
                        try {
                            this.m_disabled = true;
                            combo.select((Object)new CmsExtendedSiteSelector.SiteSelectorOption(option.getSite(), null, null));
                        }
                        finally {
                            this.m_disabled = false;
                        }
                    }
                }
            }
        });
        if (Page.getCurrent().getBrowserWindowHeight() > 650) {
            combo.setPageLength(20);
        }
        return combo;
    }

    private String getPathFromState() {
        return StateBean.parse(this.m_currentState).getFolder();
    }

    private CmsUUID getProjectIdFromState() {
        String projectIdStr = StateBean.parse(this.m_currentState).getProjectId();
        if (CmsUUID.isValidUUID(projectIdStr)) {
            return new CmsUUID(projectIdStr);
        }
        return null;
    }

    private String getSelectionFromState(String state) {
        return StateBean.parse(state).getSelectedResource();
    }

    private String getSiteRootFromState() {
        String siteRoot = StateBean.parse(this.m_currentState).getSiteRoot();
        return siteRoot;
    }

    private void initFolderTree(boolean showInvisible) throws CmsException {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_treeContainer.removeAllItems();
        try {
            CmsResource siteRoot = cms.readResource("/", FOLDERS);
            this.addTreeItem(cms, siteRoot, null, false, this.m_treeContainer);
        }
        catch (CmsException e) {
            if (showInvisible) {
                CmsResource siteRoot = cms.readResource("/", CmsResourceFilter.IGNORE_EXPIRATION);
                this.addTreeItem(cms, siteRoot, null, true, this.m_treeContainer);
            }
            throw e;
        }
    }

    private void initToolbarButtons(I_CmsAppUIContext context) {
        this.m_publishButton = context.addPublishButton(new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
                CmsFileExplorer.this.updateAll(false);
            }
        });
        this.m_newButton = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_NEW_RESOURCE_TITLE_0", new Object[0]));
        if (CmsAppWorkplaceUi.isOnlineProject()) {
            this.m_newButton.setEnabled(false);
            this.m_newButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
        }
        this.m_newButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsFileExplorer.this.onClickNew();
            }
        });
        context.addToolbarButton((Component)this.m_newButton);
        this.m_uploadButton = new CmsUploadButton((Resource)FontOpenCms.UPLOAD, "/");
        this.m_specialUploadButton = new Button((Resource)FontOpenCms.UPLOAD);
        this.m_uploadButton.addStyleName("borderless");
        this.m_uploadButton.addStyleName("o-toolbar-button");
        if (CmsAppWorkplaceUi.isOnlineProject()) {
            this.m_uploadButton.setEnabled(false);
            this.m_specialUploadButton.setEnabled(false);
            this.m_uploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
            this.m_specialUploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
        } else {
            this.m_uploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_UPLOAD_BUTTON_TITLE_0", new Object[0]));
            this.m_specialUploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_UPLOAD_BUTTON_TITLE_0", new Object[0]));
        }
        this.m_uploadButton.addUploadListener(new CmsUploadButton.I_UploadListener(){

            @Override
            public void onUploadFinished(List<String> uploadedFiles) {
                CmsFileExplorer.this.updateAll(true);
            }
        });
        this.m_specialUploadButton.addStyleName("borderless");
        this.m_specialUploadButton.addStyleName("o-toolbar-button");
        this.m_specialUploadButton.addClickListener((Button.ClickListener & Serializable)event -> {
            try {
                Class<?> actionClass = this.getClass().getClassLoader().loadClass(this.m_uploadAction);
                I_CmsWorkplaceAction action = (I_CmsWorkplaceAction)actionClass.newInstance();
                ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
                resources.add(this.m_uploadFolder);
                CmsExplorerDialogContext uploadContext = new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.fileTable, this.m_fileTable, this, resources);
                action.executeAction(uploadContext);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                CmsErrorDialog.showErrorDialog(e);
            }
        });
        context.addToolbarButton((Component)this.m_uploadButton);
        context.addToolbarButton((Component)this.m_specialUploadButton);
    }

    private String normalizeState(String state) {
        String result = "";
        if (state.contains("!!")) {
            result = state;
            while (result.startsWith("/")) {
                result = result.substring(1);
            }
        }
        return result;
    }

    private void setPathInfo(String path) {
        this.m_infoPath.setValue(path);
        this.m_crumbs.removeAllComponents();
        int i = path.indexOf("/");
        String openPath = "";
        while (i >= 0) {
            String fragment = path.substring(0, i + 1);
            openPath = openPath + fragment;
            path = path.substring(i + 1);
            i = path.indexOf("/");
            Button crumb = new Button(fragment, this.m_crumbListener);
            crumb.setData((Object)openPath);
            crumb.addStyleName("link");
            this.m_crumbs.addComponent((Component)crumb);
        }
    }

    private void setToolbarButtonsEnabled(boolean enabled) {
        this.m_publishButton.setEnabled(enabled);
        this.m_newButton.setEnabled(enabled);
        this.m_uploadButton.setEnabled(enabled);
        this.m_specialUploadButton.setEnabled(enabled);
        if (enabled) {
            this.m_publishButton.setDescription(CmsVaadinUtils.getMessageText("GUI_PUBLISH_BUTTON_TITLE_0", new Object[0]));
            this.m_newButton.setDescription(CmsVaadinUtils.getMessageText("GUI_NEW_RESOURCE_TITLE_0", new Object[0]));
            this.m_uploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_UPLOAD_BUTTON_TITLE_0", new Object[0]));
            this.m_specialUploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_UPLOAD_BUTTON_TITLE_0", new Object[0]));
        } else {
            this.m_publishButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
            this.m_newButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
            this.m_uploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
            this.m_specialUploadButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
        }
    }

    private void updateUploadButton(CmsResource folder) {
        String uploadAction = null;
        this.m_uploadFolder = folder;
        try {
            uploadAction = OpenCms.getResourceManager().getResourceType(folder).getConfiguration().get("gallery.upload.action");
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_uploadAction = uploadAction;
        if (uploadAction != null) {
            this.m_uploadButton.setVisible(false);
            this.m_specialUploadButton.setVisible(true);
            this.m_uploadArea.setTargetFolder(null);
        } else {
            this.m_uploadButton.setVisible(true);
            this.m_specialUploadButton.setVisible(false);
            this.m_uploadButton.setTargetFolder(folder.getRootPath());
            this.m_uploadArea.setTargetFolder(folder.getRootPath());
        }
    }

    static class StateBean {
        private String m_folder;
        private String m_projectId;
        private String m_selectedResource;
        private String m_siteRoot;

        public StateBean(String siteRoot, String folder, String projectId) {
            this.m_siteRoot = siteRoot;
            this.m_folder = folder;
            this.m_projectId = projectId;
            if ("".equals(this.m_siteRoot)) {
                this.m_siteRoot = "/";
            }
        }

        public static StateBean parse(String state) {
            List<String> fields = CmsStringUtil.splitAsList(state, "!!");
            if (fields.size() >= 3) {
                String projectId = fields.get(0);
                String siteRoot = fields.get(1);
                String folder = fields.get(2);
                StateBean ret = new StateBean(siteRoot, folder, projectId);
                if (fields.size() == 4) {
                    ret.setSelectedResource(fields.get(3));
                }
                return ret;
            }
            return new StateBean(null, null, null);
        }

        public String asString() {
            String result = this.m_projectId + "!!" + this.m_siteRoot + "!!" + this.m_folder + "!!";
            return result;
        }

        public String getFolder() {
            return this.m_folder;
        }

        public String getProjectId() {
            return this.m_projectId;
        }

        public String getSelectedResource() {
            return this.m_selectedResource == null ? "" : this.m_selectedResource;
        }

        public String getSiteRoot() {
            return this.m_siteRoot;
        }

        public void setSelectedResource(String resource) {
            this.m_selectedResource = resource;
        }
    }

    public class TreeExpandListener
    implements Tree.ExpandListener {
        private static final long serialVersionUID = 1L;
        private String m_openPathFragment;

        public void nodeExpand(Tree.ExpandEvent event) {
            CmsFileExplorer.this.selectTreeItem((CmsUUID)event.getItemId());
            CmsFileExplorer.this.readTreeLevel((CmsUUID)event.getItemId(), this.m_openPathFragment);
        }

        public void setOpenPathFragment(String openPathFragment) {
            this.m_openPathFragment = openPathFragment;
        }
    }

    public class ExplorerDropHandler
    implements DropHandler {
        private static final long serialVersionUID = 5392136127699472654L;
        final transient I_CmsWorkplaceAction m_copyMoveAction = new CmsCopyDialogAction();

        public void drop(DragAndDropEvent dragEvent) {
            try {
                CmsExplorerDialogContext context = this.getContext(dragEvent);
                if (this.m_copyMoveAction.isActive(context)) {
                    CmsCopyMoveDialog dialog = new CmsCopyMoveDialog(context, CmsCopyMoveDialog.DialogMode.copy_and_move);
                    dialog.setTargetFolder(this.getTargetId(dragEvent));
                    context.start(CmsVaadinUtils.getMessageText("GUI_DIALOGTITLE_COPYMOVE_0", new Object[0]), (Component)dialog);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Moving resource failed", (Throwable)e);
            }
        }

        public AcceptCriterion getAcceptCriterion() {
            return new ServerSideCriterion(){
                private static final long serialVersionUID = 1L;

                public boolean accept(DragAndDropEvent dragEvent) {
                    try {
                        if (!ExplorerDropHandler.this.m_copyMoveAction.isActive(ExplorerDropHandler.this.getContext(dragEvent))) {
                            return false;
                        }
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Drag an drop evaluation failed", (Throwable)e);
                        return false;
                    }
                    CmsUUID targetId = ExplorerDropHandler.this.getTargetId(dragEvent);
                    return ExplorerDropHandler.this.mayDrop(targetId);
                }
            };
        }

        protected CmsUUID getTargetId(DragAndDropEvent dragEvent) {
            CmsUUID targetId = null;
            if (dragEvent.getTargetDetails() instanceof AbstractSelect.AbstractSelectTargetDetails) {
                AbstractSelect.AbstractSelectTargetDetails target = (AbstractSelect.AbstractSelectTargetDetails)dragEvent.getTargetDetails();
                Object itemOverId = target.getItemIdOver();
                if (itemOverId instanceof CmsUUID) {
                    targetId = (CmsUUID)itemOverId;
                } else if (itemOverId instanceof String) {
                    targetId = CmsFileExplorer.this.m_fileTable.getUUIDFromItemID((String)itemOverId);
                }
            }
            try {
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsResource target = cms.readResource(targetId);
                if (target.isFile()) {
                    targetId = null;
                }
            }
            catch (CmsException e) {
                targetId = null;
                LOG.debug((Object)"Checking drop target failed, use current folder.", (Throwable)e);
            }
            if (targetId == null) {
                targetId = CmsFileExplorer.this.getCurrentFolder();
            }
            return targetId;
        }

        protected boolean mayDrop(CmsUUID targetId) {
            boolean result = false;
            try {
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsResource target = cms.readResource(targetId);
                result = cms.hasPermissions(target, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            catch (Exception e) {
                LOG.debug((Object)"Checking folder write permissions failed", (Throwable)e);
            }
            return result;
        }

        CmsExplorerDialogContext getContext(DragAndDropEvent dragEvent) throws CmsException {
            List<CmsResource> resources;
            if (dragEvent.getTransferable().getSourceComponent() instanceof Table && !CmsFileExplorer.this.m_fileTable.getSelectedResources().isEmpty()) {
                resources = CmsFileExplorer.this.m_fileTable.getSelectedResources();
            } else {
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsUUID sourceId = CmsFileExplorer.this.m_fileTable.getUUIDFromItemID((String)dragEvent.getTransferable().getData("itemId"));
                CmsResource source = cms.readResource(sourceId, CmsResourceFilter.IGNORE_EXPIRATION);
                resources = Collections.singletonList(source);
            }
            CmsExplorerDialogContext context = new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.fileTable, CmsFileExplorer.this.m_fileTable, CmsFileExplorer.this, resources);
            return context;
        }
    }
}

