/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.UI;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.ProgressBar;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opencms.cache.CmsLruCache;
import org.opencms.flex.CmsFlexCache;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryStatus;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.cacheadmin.CmsFlexCacheTable;
import org.opencms.ui.apps.cacheadmin.CmsFlushCache;
import org.opencms.ui.apps.cacheadmin.CmsImageCacheInput;
import org.opencms.ui.apps.cacheadmin.CmsImageCacheTable;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsCacheViewApp
extends A_CmsWorkplaceApp {
    private Mode m_mode;
    private TextField m_siteTableFilter;

    public CmsCacheViewApp(Mode mode) {
        this.m_mode = mode;
    }

    public static CmsInfoButton getJavaStatisticButton() {
        return CmsCacheViewApp.getJavaStatisticButton(OpenCms.getMemoryMonitor().getMemoryStatus());
    }

    public static CmsInfoButton getJavaStatisticButton(CmsMemoryStatus memory) {
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_JAVA_HEAP_MAX_0", new Object[0]), CmsFileUtil.formatFilesize(memory.getMaxMemory() * 0x100000L, A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_JAVA_HEAP_TOTAL_0", new Object[0]), CmsFileUtil.formatFilesize(memory.getTotalMemory() * 0x100000L, A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_JAVA_HEAP_USED_0", new Object[0]), CmsFileUtil.formatFilesize(memory.getUsedMemory() * 0x100000L, A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_JAVA_HEAP_FREE_0", new Object[0]), CmsFileUtil.formatFilesize(memory.getFreeMemory() * 0x100000L, A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        CmsInfoButton info = new CmsInfoButton(infoMap);
        VerticalLayout prog = new VerticalLayout();
        Label label = new Label();
        label.setContentMode(ContentMode.HTML);
        label.setValue("<p>" + CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_MEMORY_BLOCK_0", new Object[0]) + "</p>");
        prog.addComponent((Component)label);
        prog.addComponent((Component)CmsCacheViewApp.getProgressBar((float)memory.getUsage() / 100.0f));
        info.addAdditionalElement((Component)prog, 0);
        info.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEX_0", new Object[0]));
        info.setDescription(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEX_0", new Object[0]));
        return info;
    }

    public static ProgressBar getProgressBar(float value) {
        ProgressBar res = new ProgressBar(value);
        String style = "";
        if ((double)value > 0.75) {
            style = "o-nearlyfull";
        }
        if ((double)value > 0.9) {
            style = "o-full";
        }
        res.addStyleName(style);
        return res;
    }

    protected static CmsInfoButton getFlexStatisticButton() {
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        CmsFlexCache cache = OpenCms.getFlexCache();
        CmsLruCache entryLruCache = cache.getEntryLruCache();
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_STATS_KEYS_0", new Object[0]), String.valueOf(cache.keySize()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_STATS_VARIATIONS_0", new Object[0]), String.valueOf(cache.size()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_MEMORY_MAXSIZE_0", new Object[0]), CmsFileUtil.formatFilesize(entryLruCache.getMaxCacheCosts(), A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_MEMORY_CURSIZE_0", new Object[0]), CmsFileUtil.formatFilesize(entryLruCache.getObjectCosts(), A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        CmsInfoButton info = new CmsInfoButton(infoMap);
        VerticalLayout prog = new VerticalLayout();
        Label label = new Label();
        label.setContentMode(ContentMode.HTML);
        label.setValue("<p>" + CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_MEMORY_BLOCK_0", new Object[0]) + "</p>");
        prog.addComponent((Component)label);
        prog.addComponent((Component)CmsCacheViewApp.getProgressBar((float)entryLruCache.getObjectCosts() / (float)entryLruCache.getMaxCacheCosts()));
        info.addAdditionalElement((Component)prog, 0);
        info.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEX_0", new Object[0]));
        info.setDescription(CmsVaadinUtils.getMessageText("GUI_CACHE_FLEX_0", new Object[0]));
        return info;
    }

    protected static CmsInfoButton getImageStatisticButton() {
        long size = 0L;
        if (new File(CmsImageLoader.getImageRepositoryPath()).exists()) {
            size = FileUtils.sizeOfDirectory((File)new File(CmsImageLoader.getImageRepositoryPath()));
        }
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        infoMap.put(CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LABEL_MEMORY_BLOCK_0", new Object[0]), CmsFileUtil.formatFilesize(size, A_CmsUI.getCmsObject().getRequestContext().getLocale()));
        CmsInfoButton info = new CmsInfoButton(infoMap);
        info.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGE_0", new Object[0]));
        info.setDescription(CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGE_0", new Object[0]));
        return info;
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            if (Mode.FlexCache.equals((Object)this.m_mode)) {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_CACHE_VIEW_FLEX_0", new Object[0]));
            } else {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_CACHE_VIEW_IMAGE_0", new Object[0]));
            }
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (this.m_siteTableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_siteTableFilter);
            this.m_siteTableFilter = null;
        }
        if (Mode.FlexCache.equals((Object)this.m_mode)) {
            this.m_rootLayout.setMainHeightFull(true);
            return this.getFlexViewComponent();
        }
        if (Mode.ImageCache.equals((Object)this.m_mode)) {
            this.m_rootLayout.setMainHeightFull(true);
            return this.getImageViewComponent();
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private Component getFlexViewComponent() {
        final CmsFlexCacheTable table = new CmsFlexCacheTable();
        this.m_siteTableFilter = new TextField();
        this.m_siteTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_siteTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_siteTableFilter.addStyleName("inline-icon");
        this.m_siteTableFilter.setWidth("200px");
        this.m_siteTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                table.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_siteTableFilter);
        this.m_uiContext.addToolbarButton((Component)CmsCacheViewApp.getFlexStatisticButton());
        this.m_uiContext.addToolbarButton((Component)CmsFlushCache.getFlushToolButton());
        table.setSizeFull();
        return table;
    }

    private Component getImageViewComponent() {
        this.m_siteTableFilter = new TextField();
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setSizeFull();
        VerticalLayout intro = CmsVaadinUtils.getInfoLayout("GUI_CACHE_IMAGE_INTRODUCTION_0");
        VerticalLayout nullResult = CmsVaadinUtils.getInfoLayout("GUI_CACHE_IMAGE_NO_RESULTS_0");
        final CmsImageCacheTable table = new CmsImageCacheTable(intro, nullResult, this.m_siteTableFilter);
        sp.setFirstComponent((Component)new CmsImageCacheInput(table));
        VerticalLayout secC = new VerticalLayout();
        secC.setSizeFull();
        secC.addComponent((Component)intro);
        secC.addComponent((Component)nullResult);
        secC.addComponent((Component)table);
        this.m_siteTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_siteTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_siteTableFilter.addStyleName("inline-icon");
        this.m_siteTableFilter.setWidth("200px");
        this.m_siteTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                table.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_siteTableFilter);
        this.m_uiContext.addToolbarButton((Component)CmsCacheViewApp.getImageStatisticButton());
        this.m_uiContext.addToolbarButton((Component)CmsFlushCache.getFlushToolButton());
        table.setSizeFull();
        sp.setSecondComponent((Component)secC);
        sp.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        table.setVisible(false);
        nullResult.setVisible(false);
        this.m_siteTableFilter.setVisible(false);
        return sp;
    }

    public static enum Mode {
        FlexCache,
        ImageCache;

    }
}

