/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.cacheadmin.CmsConfirmSimpleFlushDialog;
import org.opencms.ui.apps.cacheadmin.CmsFlexCacheCleanDialog;
import org.opencms.ui.apps.cacheadmin.CmsFlushButtonHolderDialog;
import org.opencms.ui.apps.cacheadmin.CmsImageCacheCleanDialog;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsFlushCache
extends Panel {
    static Log LOG = CmsLog.getLog(CmsFlushCache.class.getName());
    private static final String BUTTON_WIDTH = "250px";
    private static final long serialVersionUID = -8868998646787654217L;
    private VerticalLayout m_flushes;

    public CmsFlushCache() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_flushes.setSpacing(true);
        this.m_flushes.setMargin(true);
        this.setWidthUndefined();
        VerticalLayout c = CmsFlushCache.getButtonLayout(3, new Runnable(){

            @Override
            public void run() {
            }
        });
        this.m_flushes.addComponent((Component)c);
    }

    protected static VerticalLayout getButtonLayout(int size, final Runnable clickedRunnable) {
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setMargin(true);
        layout.addStyleName("wrapping");
        Button clean_flex = CmsFlushCache.getFlushButton("GUI_CACHE_FLEXCACHE_CLEAN_ADMIN_TOOL_NAME_0", "GUI_CACHE_FLEXCACHE_CLEAN_ADMIN_TOOL_HELP_0", new CmsFlexCacheCleanDialog(), clickedRunnable);
        Button clean_image = CmsFlushCache.getFlushButton("GUI_CACHE_IMAGECACHE_CLEAN_ADMIN_TOOL_NAME_0", "GUI_CACHE_IMAGECACHE_CLEAN_ADMIN_TOOL_HELP_0", new CmsImageCacheCleanDialog(), clickedRunnable);
        Button clean_core = CmsFlushCache.getFlushButton("GUI_CACHE_CORECACHE_CLEAN_ADMIN_TOOL_NAME_0", "GUI_CACHE_CORECACHE_CLEAN_ADMIN_TOOL_HELP_0", new CmsConfirmSimpleFlushDialog(CmsVaadinUtils.getMessageText("GUI_CACHE_CORECACHE_CLEAN_ADMIN_TOOL_CONF_0", new Object[0])), new Runnable(){

            @Override
            public void run() {
                OpenCms.fireCmsEvent(new CmsEvent(5, null));
                clickedRunnable.run();
            }
        });
        Button clean_repo = CmsFlushCache.getFlushButton("GUI_CACHE_JSP_REPOSITORY_ADMIN_TOOL_NAME_0", "GUI_CACHE_JSP_REPOSITORY_ADMIN_TOOL_HELP_0", new CmsConfirmSimpleFlushDialog(CmsVaadinUtils.getMessageText("GUI_CACHE_JSP_REPOSITORY_ADMIN_TOOL_CONF_0", new Object[0])), new Runnable(){

            @Override
            public void run() {
                OpenCms.fireCmsEvent(new CmsEvent(8, Collections.emptyMap()));
                OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(1))));
                clickedRunnable.run();
            }
        });
        Button reini = CmsFlushCache.getFlushButton("GUI_CACHE_REINI_TOOL_NAME_0", "GUI_CACHE_REINI_TOOL_NAME_HELP_0", new CmsConfirmSimpleFlushDialog(CmsVaadinUtils.getMessageText("GUI_CACHE_REINI_TOOL_CONF_0", new Object[0])), new Runnable(){

            @Override
            public void run() {
                try {
                    OpenCms.getWorkplaceManager().initialize(A_CmsUI.getCmsObject());
                    OpenCms.fireCmsEvent(5, new HashMap<String, Object>());
                    clickedRunnable.run();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to reinitialize workspace", (Throwable)e);
                }
            }
        });
        ArrayList<Button> elements = new ArrayList<Button>();
        elements.add(clean_core);
        elements.add(clean_flex);
        elements.add(clean_image);
        elements.add(reini);
        elements.add(clean_repo);
        HorizontalLayout row = new HorizontalLayout();
        row.setSpacing(true);
        for (int i = 0; i < elements.size(); ++i) {
            if (size > 0) {
                row.addComponent((Component)elements.get(i));
                if (!(i % (size - 1) == 0 & i > 0)) continue;
                layout.addComponent((Component)row);
                row = new HorizontalLayout();
                row.setSpacing(true);
                continue;
            }
            layout.addComponent((Component)elements.get(i));
        }
        return layout;
    }

    protected static Button getFlushToolButton() {
        Button res = new Button((Resource)FontOpenCms.CACHE);
        res.addStyleName("borderless");
        res.addStyleName("o-toolbar-button");
        res.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 7110311791006484514L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.content);
                window.setContent((Component)new CmsFlushButtonHolderDialog(window));
                A_CmsUI.get().addWindow(window);
            }
        });
        return res;
    }

    private static Button getFlushButton(String captionMessage, String descriptionMessage, final I_CloseableDialog dialog, final Runnable okRun) {
        Button ret = new Button();
        ret.setWidth(BUTTON_WIDTH);
        ret.addStyleName("v-button");
        ret.addStyleName("o-button-blue");
        ret.setCaption(CmsVaadinUtils.getMessageText(captionMessage, new Object[0]));
        ret.setDescription(CmsVaadinUtils.getMessageText(descriptionMessage, new Object[0]));
        ret.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -4513263981209222571L;

            public void buttonClick(Button.ClickEvent event) {
                final Window window = CmsBasicDialog.prepareWindow();
                dialog.setCloseRunnable(new Runnable(){

                    @Override
                    public void run() {
                        window.close();
                    }
                });
                dialog.setOkRunnable(okRun);
                window.setContent((Component)dialog);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_CLEAN_CONFIRM_0", new Object[0]));
                UI.getCurrent().addWindow(window);
            }
        });
        return ret;
    }

    public static interface I_CloseableDialog {
        public void setCloseRunnable(Runnable var1);

        public void setOkRunnable(Runnable var1);
    }
}

