/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsDbSynchronizationApp;
import org.opencms.ui.components.CmsRemovableFormRow;
import org.opencms.ui.components.fileselect.CmsPathSelectField;

public class CmsDbSynchronizationView
extends VerticalLayout {
    private static final long serialVersionUID = -794938118093564562L;
    static Log LOG = CmsLog.getLog(CmsDbSynchronizationView.class.getName());
    CmsSynchronizeSettings m_synchronizeSettings;
    private Button m_addResource;
    private Button m_ok;
    private FormLayout m_resources;
    protected CmsObject m_cms;
    private TextField m_target;
    private CheckBox m_enabled;
    private CmsDbSynchronizationApp m_app;
    private Set<AbstractField<String>> m_componentsToValidate = new HashSet<AbstractField<String>>();

    public CmsDbSynchronizationView(CmsDbSynchronizationApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_app = app;
        this.m_componentsToValidate.add((AbstractField<String>)this.m_target);
        this.m_cms = this.initCms(A_CmsUI.getCmsObject());
        CmsUserSettings userSettings = new CmsUserSettings(this.m_cms);
        this.m_synchronizeSettings = userSettings.getSynchronizeSettings();
        if (this.m_synchronizeSettings == null) {
            this.m_synchronizeSettings = new CmsSynchronizeSettings();
            this.m_synchronizeSettings.setEnabled(false);
        }
        this.m_app.setRefreshButton(this.m_synchronizeSettings.isEnabled());
        this.initUI();
        this.m_target.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 5508413459469395463L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDbSynchronizationView.this.setOkButtonEnabled(true);
            }
        });
        this.m_enabled.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -5921001488632416603L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDbSynchronizationView.this.setOkButtonEnabled(true);
            }
        });
        this.m_addResource.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 2169629308804189534L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDbSynchronizationView.this.addResource("");
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -5083450266085163340L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDbSynchronizationView.this.removeEmptyResourceFields();
                CmsDbSynchronizationView.this.addValidators();
                if (CmsDbSynchronizationView.this.isValid()) {
                    CmsDbSynchronizationView.this.submit();
                    CmsDbSynchronizationView.this.setOkButtonEnabled(false);
                }
            }
        });
    }

    protected void addResource(String path) {
        CmsPathSelectField field = new CmsPathSelectField();
        field.setCmsObject(this.m_cms);
        field.setUseRootPaths(true);
        field.setValue(path);
        field.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 8646438704383992571L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDbSynchronizationView.this.setOkButtonEnabled(true);
            }
        });
        this.m_componentsToValidate.add((AbstractField<String>)field);
        CmsRemovableFormRow<CmsPathSelectField> row = new CmsRemovableFormRow<CmsPathSelectField>(field, CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_REMOVE_RESOURCE_0", new Object[0]));
        row.setCaption(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_RESOURCE_0", new Object[0]));
        row.setRemoveRunnable(new Runnable(){

            @Override
            public void run() {
                CmsDbSynchronizationView.this.setOkButtonEnabled(true);
            }
        });
        this.m_resources.addComponent(row);
    }

    protected void addValidators() {
        this.m_target.removeAllValidators();
        this.m_target.addValidator((Validator)new TargetValidator());
        for (Component component : this.m_componentsToValidate) {
            if (!(component instanceof CmsPathSelectField)) continue;
            ((CmsPathSelectField)component).removeAllValidators();
            ((CmsPathSelectField)component).addValidator(new ResourceValidator());
        }
    }

    protected boolean isEnabledSych() {
        return this.m_synchronizeSettings.isEnabled();
    }

    protected boolean isValid() {
        for (AbstractField<String> component : this.m_componentsToValidate) {
            if (component.isValid()) continue;
            return false;
        }
        return true;
    }

    protected void removeEmptyResourceFields() {
        HashSet<Component> componentsToRemove = new HashSet<Component>();
        int count = 0;
        Component lastElement = null;
        for (Component c : this.m_resources) {
            if (!(c instanceof CmsRemovableFormRow)) continue;
            ++count;
            AbstractField field = (AbstractField)((CmsRemovableFormRow)c).getInput();
            String value = (String)field.getValue();
            if (!value.isEmpty()) continue;
            componentsToRemove.add(c);
            lastElement = c;
        }
        if (componentsToRemove.size() == count) {
            componentsToRemove.remove(lastElement);
        }
        if (count == 0) {
            this.addResource("");
        }
        for (Component c : componentsToRemove) {
            this.m_resources.removeComponent(c);
            this.m_componentsToValidate.remove(c);
        }
    }

    protected void setOkButtonEnabled(boolean enable) {
        this.m_ok.setEnabled(enable);
    }

    protected void submit() {
        CmsUserSettings userSettings;
        this.m_synchronizeSettings.setEnabled((Boolean)this.m_enabled.getValue());
        this.m_synchronizeSettings.setSourceListInVfs(this.getResourcePaths());
        try {
            userSettings = new CmsUserSettings(A_CmsUI.getCmsObject());
            userSettings.setSynchronizeSettings(this.m_synchronizeSettings);
            userSettings.save(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to set synchro settings", (Throwable)e);
        }
        userSettings = new CmsUserSettings(A_CmsUI.getCmsObject());
        this.m_synchronizeSettings = userSettings.getSynchronizeSettings();
        this.m_app.setRefreshButton(this.m_synchronizeSettings.isEnabled());
    }

    protected boolean synchroEnabled() {
        return (Boolean)this.m_enabled.getValue();
    }

    private List<String> getResourcePaths() {
        ArrayList<String> res = new ArrayList<String>();
        for (Component c : this.m_resources) {
            if (!(c instanceof CmsRemovableFormRow)) continue;
            AbstractField field = (AbstractField)((CmsRemovableFormRow)c).getInput();
            res.add((String)field.getValue());
        }
        return res;
    }

    private CmsObject initCms(CmsObject cms) {
        try {
            cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to init CmsObject");
        }
        cms.getRequestContext().setSiteRoot("");
        return cms;
    }

    private void initUI() {
        this.m_enabled.setValue((Object)new Boolean(this.m_synchronizeSettings.isEnabled()));
        if (this.m_synchronizeSettings.getDestinationPathInRfs() != null) {
            this.m_target.setValue(this.m_synchronizeSettings.getDestinationPathInRfs());
        }
        List<String> resources = this.m_synchronizeSettings.getSourceListInVfs();
        for (String resource : resources) {
            this.addResource(resource);
        }
        this.setOkButtonEnabled(false);
    }

    class TargetValidator
    implements Validator {
        private static final long serialVersionUID = 4404089964412111711L;

        TargetValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String val = (String)value;
            if (CmsDbSynchronizationView.this.synchroEnabled() & val.isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_VALIDATION_EMPTY_TARGET_0", new Object[0]));
            }
            if (CmsDbSynchronizationView.this.synchroEnabled()) {
                try {
                    CmsDbSynchronizationView.this.m_synchronizeSettings.setDestinationPathInRfs(val);
                }
                catch (Throwable t) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_VALIDATION_EMPTY_TARGET_0", new Object[0]));
                }
            }
        }
    }

    class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = -1513193444185009615L;

        ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String resourceName = (String)value;
            if (CmsDbSynchronizationView.this.synchroEnabled() & resourceName == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_VALIDATION_EMPTY_RESOURCES_0", new Object[0]));
            }
            try {
                CmsDbSynchronizationView.this.m_cms.readResource(resourceName);
            }
            catch (CmsException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_SYNC_VALIDATION_RESOURCE_NOT_FOUND_1", resourceName));
            }
        }
    }
}

