/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.main.CmsException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.dbmanager.CmsPropertyDeleteDialog;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchApp;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;

public class CmsPropertyTable
extends Table {
    private static final long serialVersionUID = 8004865379309420561L;
    private IndexedContainer m_container;
    CmsContextMenu m_menu = new CmsContextMenu();
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;

    public CmsPropertyTable() {
        this.m_menu.setAsTableContextMenu(this);
        this.init();
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.setMultiSelect(false);
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableColumn.Name, search, true, false)}));
        }
    }

    public void init() {
        try {
            List<CmsPropertyDefinition> properties = A_CmsUI.getCmsObject().readAllPropertyDefinitions();
            this.m_container = new IndexedContainer();
            for (TableColumn col : TableColumn.values()) {
                this.m_container.addContainerProperty((Object)col, col.getType(), col.getDefaultValue());
            }
            this.setContainerDataSource((Container)this.m_container);
            this.setItemIconPropertyId((Object)TableColumn.Icon);
            this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
            this.setVisibleColumns(new Object[]{TableColumn.Name});
            for (CmsPropertyDefinition prop : properties) {
                Item item = this.m_container.addItem((Object)prop);
                item.getItemProperty((Object)TableColumn.Name).setValue((Object)prop.getName());
            }
            this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = 4807195510202231174L;

                public void itemClick(ItemClickEvent event) {
                    CmsPropertyTable.this.setValue(null);
                    CmsPropertyTable.this.select(event.getItemId());
                    if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                        CmsPropertyTable.this.m_menu.setEntries(CmsPropertyTable.this.getMenuEntries(), Collections.singleton(((CmsPropertyDefinition)CmsPropertyTable.this.getValue()).getName()));
                        CmsPropertyTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsPropertyTable.this);
                    } else if (TableColumn.Name.equals(event.getPropertyId())) {
                        CmsPropertyTable.this.showResources(((CmsPropertyDefinition)CmsPropertyTable.this.getValue()).getName());
                    }
                }
            });
            this.setCellStyleGenerator(new Table.CellStyleGenerator(){
                private static final long serialVersionUID = 1L;

                public String getStyle(Table source, Object itemId, Object propertyId) {
                    if (TableColumn.Name.equals(propertyId)) {
                        return " o-hover-column";
                    }
                    return null;
                }
            });
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected void showResources(String propertyName) {
        CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
        settings.setPaths(Collections.singletonList("/"));
        settings.setSiteRoot("");
        settings.setSearchpattern(".*");
        settings.setType(CmsSourceSearchForm.SearchType.properties);
        try {
            settings.setProperty(A_CmsUI.getCmsObject().readPropertyDefinition(propertyName));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        CmsAppWorkplaceUi.get().showApp("source-search", CmsSourceSearchApp.generateState(settings));
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryResources());
            this.m_menuEntries.add(new EntryDelete());
        }
        return this.m_menuEntries;
    }

    class EntryResources
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryResources() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsPropertyTable.this.showResources(data.iterator().next());
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PQUEUE_RESOURCES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryDelete
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryDelete() {
        }

        @Override
        public void executeAction(Set<String> data) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_DELETE_0", new Object[0]));
            window.setContent((Component)new CmsPropertyDeleteDialog(data.iterator().next(), window, new Runnable(){

                @Override
                public void run() {
                    CmsPropertyTable.this.init();
                }
            }));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    protected static enum TableColumn {
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-database")),
        Name("GUI_MESSAGES_BROADCAST_COLS_USER_0", String.class, "");

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableColumn(String headerMessage, Class<?> type, Object defaultValue) {
            this.m_headerMessage = headerMessage;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        static List<TableColumn> withHeader() {
            ArrayList<TableColumn> props = new ArrayList<TableColumn>();
            for (TableColumn prop : TableColumn.values()) {
                if (prop.m_headerMessage == null) continue;
                props.add(prop);
            }
            return props;
        }

        Object getDefaultValue() {
            return this.m_defaultValue;
        }

        String getLocalizedMessage() {
            if (this.m_headerMessage == null) {
                return "";
            }
            return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }
    }
}

