/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsResourceTypeStatResult;
import org.opencms.ui.apps.dbmanager.CmsResourceTypeStatResultList;

public class CmsResourceTypeStatsView
extends VerticalLayout {
    static Log LOG = CmsLog.getLog(CmsResourceTypeStatsView.class.getName());
    static CmsResourceTypeStatResultList results;
    private static final long serialVersionUID = -5884776533727327584L;
    CmsObject m_cms;
    Button m_ok;
    VerticalLayout m_resLayout;
    ComboBox m_resType;
    Panel m_results;
    ComboBox m_siteSelect;

    public CmsResourceTypeStatsView() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        results = CmsResourceTypeStatResultList.init(results);
        results.setVerticalLayout(this.m_resLayout, true);
        if (results.isEmpty()) {
            this.m_results.setVisible(false);
        }
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.setClickListener();
            this.setupResourceType();
            IndexedContainer availableSites = CmsVaadinUtils.getAvailableSitesContainer(this.m_cms, "caption");
            this.m_siteSelect.setContainerDataSource((Container)availableSites);
            if (availableSites.getItem((Object)this.m_cms.getRequestContext().getSiteRoot()) != null) {
                this.m_siteSelect.setValue((Object)this.m_cms.getRequestContext().getSiteRoot());
            }
            this.m_siteSelect.setNullSelectionAllowed(false);
            this.m_siteSelect.setItemCaptionPropertyId((Object)"caption");
        }
        catch (CmsException e1) {
            LOG.error((Object)"Unable to get CmsObject", (Throwable)e1);
        }
    }

    protected CmsObject getCmsObject() {
        this.m_cms.getRequestContext().setSiteRoot((String)this.m_siteSelect.getValue());
        return this.m_cms;
    }

    protected I_CmsResourceType getType() {
        return (I_CmsResourceType)this.m_resType.getValue();
    }

    private void setClickListener() {
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6621475980210242125L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    CmsResourceFilter filter = CmsResourceTypeStatsView.this.getType() == null ? CmsResourceFilter.ALL : CmsResourceFilter.requireType(CmsResourceTypeStatsView.this.getType());
                    results.addResult(new CmsResourceTypeStatResult(CmsResourceTypeStatsView.this.getType(), (String)CmsResourceTypeStatsView.this.m_siteSelect.getValue(), CmsResourceTypeStatsView.this.getCmsObject().readResources("/", filter, true).size()));
                    CmsResourceTypeStatsView.this.m_results.setVisible(true);
                    results.setVerticalLayout(CmsResourceTypeStatsView.this.m_resLayout, false);
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to read resource tree", (Throwable)e);
                }
            }
        });
    }

    private void setupResourceType() {
        IndexedContainer resTypes = CmsVaadinUtils.getResourceTypesContainer();
        resTypes.addContainerFilter(CmsVaadinUtils.FILTER_NO_FOLDERS);
        this.m_resType.setContainerDataSource((Container)resTypes);
        this.m_resType.setItemCaptionPropertyId((Object)CmsVaadinUtils.PropertyId.caption);
        this.m_resType.setItemIconPropertyId((Object)CmsVaadinUtils.PropertyId.icon);
    }
}

