/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsInternalLinksValidator;
import org.opencms.relations.CmsRelation;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.linkvalidation.A_CmsLinkValidator;
import org.opencms.ui.apps.linkvalidation.CmsInternalResources;
import org.opencms.ui.apps.linkvalidation.CmsLinkValidationInternalTable;
import org.opencms.ui.apps.linkvalidation.CmsResourceListDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsLinkValidationApp
extends A_CmsWorkplaceApp {
    static final Log LOG = CmsLog.getLog(CmsLinkValidationApp.class);

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LINKVALIDATION_ADMIN_TOOL_NAME_SHORT_0", new Object[0]));
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (state.isEmpty()) {
            this.m_rootLayout.setMainHeightFull(true);
            return this.getInternalComponent();
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private HorizontalSplitPanel getInternalComponent() {
        this.m_rootLayout.setMainHeightFull(true);
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setSizeFull();
        VerticalLayout result = new VerticalLayout();
        result.setSizeFull();
        VerticalLayout intro = CmsVaadinUtils.getInfoLayout("GUI_LINKVALIDATION_INTRODUCTION_0");
        VerticalLayout nullResult = CmsVaadinUtils.getInfoLayout("GUI_LINKVALIDATION_NO_BROKEN_LINKS_0");
        nullResult.setVisible(false);
        CmsLinkValidationInternalTable table = new CmsLinkValidationInternalTable((Component)intro, (Component)nullResult, new InternalValidator());
        table.setVisible(false);
        table.setSizeFull();
        table.setWidth("100%");
        result.addComponent((Component)table);
        result.addComponent((Component)intro);
        result.addComponent((Component)nullResult);
        VerticalLayout leftCol = new VerticalLayout();
        leftCol.setSizeFull();
        CmsInternalResources resources = new CmsInternalResources(table);
        leftCol.addComponent((Component)resources);
        leftCol.setExpandRatio((Component)resources, 1.0f);
        sp.setFirstComponent((Component)leftCol);
        sp.setSecondComponent((Component)result);
        sp.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        return sp;
    }

    public class InternalValidator
    extends A_CmsLinkValidator {
        CmsInternalLinksValidator validator;

        @Override
        public List<CmsResource> failedResources(List<String> resources) {
            this.validator = new CmsInternalLinksValidator(A_CmsUI.getCmsObject(), resources);
            return this.validator.getResourcesWithBrokenLinks();
        }

        @Override
        public String failMessage(CmsResource resource) {
            String res = "";
            List<CmsRelation> brokenLinks = this.validator.getBrokenLinksForResource(resource.getRootPath());
            if (brokenLinks != null) {
                Iterator<CmsRelation> j = brokenLinks.iterator();
                while (j.hasNext()) {
                    res = res + j.next().getTargetPath() + ", ";
                }
            }
            return res.substring(0, res.length() - 2);
        }

        @Override
        public ItemClickEvent.ItemClickListener getClickListener() {
            return new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = -7729459896374968941L;

                public void itemClick(ItemClickEvent event) {
                    if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT)) {
                        return;
                    }
                    if (!InternalValidator.this.property.equals(event.getPropertyId())) {
                        return;
                    }
                    try {
                        CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                        cms.getRequestContext().setSiteRoot("");
                        CmsResource resource = cms.readResource(new CmsUUID((String)event.getItemId()));
                        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                        window.setCaption(CmsVaadinUtils.getMessageText(InternalValidator.this.getCaptionKey(), new Object[0]));
                        window.setContent((Component)CmsResourceListDialog.forNonExistingPaths(InternalValidator.this.getBrokenLinkedResources(resource)));
                        A_CmsUI.get().addWindow(window);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Unable to show detail resources", (Throwable)e);
                    }
                }
            };
        }

        @Override
        public String getPropertyName() {
            return "BrokenLinks";
        }

        @Override
        public Map<CmsResourceTableProperty, Integer> getTableProperties() {
            this.property = new CmsResourceTableProperty(this.getPropertyName(), String.class, "", "GUI_LINKVALIDATION_BROKENLINKS_DETAIL_LINKS_NAME_0", true, 0.0f, 200);
            LinkedHashMap<CmsResourceTableProperty, Integer> res = new LinkedHashMap<CmsResourceTableProperty, Integer>(CmsFileTable.DEFAULT_TABLE_PROPERTIES);
            res.put(this.property, 0);
            return res;
        }

        String getCaptionKey() {
            return "GUI_LINKVALIDATION_BROKENLINKS_DETAIL_LINKS_NAME_0";
        }

        private List<String> getBrokenLinkedResources(CmsResource resource) {
            ArrayList<String> res = new ArrayList<String>();
            List<CmsRelation> brokenLinks = this.validator.getBrokenLinksForResource(resource.getRootPath());
            if (brokenLinks != null) {
                Iterator<CmsRelation> j = brokenLinks.iterator();
                while (j.hasNext()) {
                    res.add(j.next().getTargetPath());
                }
            }
            return res;
        }

        private String getBrokenLinkString(String rootPath) {
            String ret = "";
            try {
                String siteRoot;
                CmsObject rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                rootCms.getRequestContext().setSiteRoot("");
                String siteName = siteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath);
                if (siteRoot != null) {
                    try {
                        siteName = rootCms.readPropertyObject(siteRoot, "Title", false).getValue(siteRoot);
                    }
                    catch (CmsException e) {
                        siteName = siteRoot;
                    }
                    ret = rootPath.substring(siteRoot.length());
                } else {
                    siteName = "/";
                }
                if (!A_CmsUI.getCmsObject().getRequestContext().getSiteRoot().equals(siteRoot)) {
                    ret = CmsVaadinUtils.getMessageText("GUI_DELETE_SITE_RELATION_2", siteName, rootPath);
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            return ret;
        }
    }
}

