/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.lists;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.shared.CmsDialogOptions;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsResourceStatusTabId;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.search.config.CmsSearchConfiguration;
import org.opencms.jsp.search.config.CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.parser.CmsSimpleSearchConfigurationParser;
import org.opencms.jsp.search.controller.CmsSearchController;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetRange;
import org.opencms.jsp.search.result.CmsSearchResultWrapper;
import org.opencms.jsp.search.state.I_CmsSearchStateFacet;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsLink;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.CmsContextMenuActionItem;
import org.opencms.ui.actions.CmsDeleteDialogAction;
import org.opencms.ui.actions.CmsEditDialogAction;
import org.opencms.ui.actions.CmsResourceInfoAction;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppView;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.apps.CmsFileExplorerSettings;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.lists.CmsOptionDialog;
import org.opencms.ui.apps.lists.CmsResultFacets;
import org.opencms.ui.apps.lists.CmsResultTable;
import org.opencms.ui.apps.lists.daterestrictions.CmsDateRestrictionParser;
import org.opencms.ui.apps.lists.daterestrictions.I_CmsListDateRestriction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.components.CmsResourceTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.ui.contextmenu.I_CmsContextMenuItemProvider;
import org.opencms.util.CmsGeoUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.directedit.I_CmsEditHandler;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsListManager
extends A_CmsWorkplaceApp
implements CmsResourceTable.I_ResourcePropertyProvider,
I_CmsContextProvider,
ViewChangeListener,
I_CmsWindowCloseListener,
I_CmsCachableApp {
    public static final String FIELD_CATEGORIES = "category_exact";
    public static final String FIELD_DATE = "instancedate_%s_dt";
    public static final String FIELD_DATE_RANGE = "instancedaterange_%s_dr";
    public static final String FIELD_DATE_FACET_NAME = "instancedate";
    public static final String FIELD_PARENT_FOLDERS = "parent-folders";
    public static final String N_BLACKLIST = "Blacklist";
    public static final String N_CATEGORY = "Category";
    private static final String N_CATEGORY_FOLDER_RESTRICTION = "CategoryFolderFilter";
    private static final String N_COORDINATES = "Coordinates";
    private static final String N_FOLDER = "Folder";
    public static final String N_CATEGORY_MODE = "CategoryMode";
    public static final String N_DATE_RESTRICTION = "DateRestriction";
    public static final String N_DISPLAY_TYPE = "TypesToCollect";
    public static final String N_FILTER_MULTI_DAY = "FilterMultiDay";
    public static final String N_FILTER_QUERY = "FilterQuery";
    public static final String N_GEO_FILTER = "GeoFilter";
    public static final String N_KEY = "Key";
    public static final String N_PARAMETER = "Parameter";
    public static final String N_RADIUS = "Radius";
    public static final String N_SEARCH_FOLDER = "SearchFolder";
    public static final String N_SHOW_EXPIRED = "ShowExpired";
    public static final String N_SORT_ORDER = "SortOrder";
    public static final String N_TITLE = "Title";
    public static final String N_VALUE = "Value";
    public static final String PARAM_LOCALE = "locale";
    public static final String N_MAX_RESULTS = "MaxResults";
    public static final String[] PARAMETER_FIELDS = new String[]{"Title", "Category", "FilterMultiDay", "FilterQuery", "SortOrder", "ShowExpired", "MaxResults"};
    public static final String PATH_NAME_VIEW = "view";
    public static final String RES_TYPE_LIST_CONFIG = "listconfig";
    protected static final CmsResourceTableProperty BLACKLISTED_PROPERTY = new CmsResourceTableProperty("BLACKLISTED", Boolean.class, Boolean.FALSE, "GUI_LISTMANAGER_COLUMN_BLACKLISTED_0", true, 0.0f, 110);
    protected static final CmsResourceTableProperty INFO_PROPERTY = new CmsResourceTableProperty("INFO_PROPERTY", String.class, null, null, true, 1.0f, 0);
    protected static final CmsResourceTableProperty INFO_PROPERTY_LABEL = new CmsResourceTableProperty("INFO_PROPERTY_LABEL", String.class, null, "GUI_LISTMANAGER_COLUMN_INFO_0", true, 0.0f, 110);
    protected static final CmsResourceTableProperty INSTANCEDATE_PROPERTY = new CmsResourceTableProperty("INSTANCEDATE_PROPERTY", Date.class, null, "GUI_LISTMANAGER_COLUMN_INSTANCEDATE_0", true, 0.0f, 145);
    protected static final String[][] SORT_OPTIONS = new String[][]{{CmsSimpleSearchConfigurationParser.SortOption.DATE_ASC.toString(), CmsSimpleSearchConfigurationParser.SortOption.DATE_DESC.toString(), CmsSimpleSearchConfigurationParser.SortOption.TITLE_ASC.toString(), CmsSimpleSearchConfigurationParser.SortOption.TITLE_DESC.toString(), CmsSimpleSearchConfigurationParser.SortOption.ORDER_ASC.toString(), CmsSimpleSearchConfigurationParser.SortOption.ORDER_DESC.toString()}, {"GUI_LISTMANAGER_SORT_DATE_ASC_0", "GUI_LISTMANAGER_SORT_DATE_DESC_0", "GUI_LISTMANAGER_SORT_TITLE_ASC_0", "GUI_LISTMANAGER_SORT_TITLE_DESC_0", "GUI_LISTMANAGER_SORT_ORDER_ASC_0", "GUI_LISTMANAGER_SORT_ORDER_DESC_0"}};
    static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    static final Log LOG = CmsLog.getLog(CmsListManager.class.getName());
    private static final I_CmsSearchConfigurationPagination PAGINATION = new CmsSearchConfigurationPagination(null, 10000, (Integer)1);
    private static final long serialVersionUID = -25954374225590319L;
    ListConfigurationBean m_currentConfig;
    CmsResource m_currentResource;
    CmsResultTable m_resultTable;
    private Button m_createNewButton;
    private CmsSimpleSearchConfigurationParser m_currentConfigParser;
    private String m_currentState;
    private Window m_dialogWindow;
    private Button m_editCurrentButton;
    private boolean m_hasSeriesInstances;
    private boolean m_hasSeriesType;
    private boolean m_hideSeriesInstances;
    private Button m_infoButton;
    private boolean m_isOverView;
    private ComboBox m_localeSelect;
    private CmsLockActionRecord m_lockAction;
    private CmsFileTable m_overviewTable;
    private Button m_publishButton;
    private boolean m_resetting;
    private CmsResultFacets m_resultFacets;
    private HorizontalSplitPanel m_resultLayout;
    private ComboBox m_resultSorter;
    private TextField m_tableFilter;
    private TextField m_textSearch;
    private Button m_toggleSeriesButton;

    public static ListConfigurationBean parseListConfiguration(CmsObject cms, CmsResource res) {
        ListConfigurationBean result = new ListConfigurationBean();
        try {
            List<I_CmsXmlContentValue> categoryFolderRestrictions;
            I_CmsXmlContentValue geoFilterValue;
            CmsFile configFile = cms.readFile(res);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, configFile);
            Locale locale = CmsLocaleManager.MASTER_LOCALE;
            if (!content.hasLocale(locale)) {
                locale = content.getLocales().get(0);
            }
            for (String field : PARAMETER_FIELDS) {
                String val = content.getStringValue(cms, field, locale);
                if (N_CATEGORY.equals(field)) {
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(val)) {
                        result.setCategories(Arrays.asList(val.split(",")));
                        continue;
                    }
                    result.setCategories(Collections.emptyList());
                    continue;
                }
                result.setParameterValue(field, val);
            }
            I_CmsXmlContentValue restrictValue = content.getValue(N_DATE_RESTRICTION, locale);
            if (restrictValue != null) {
                CmsDateRestrictionParser parser = new CmsDateRestrictionParser(cms);
                I_CmsListDateRestriction restriction = parser.parse(new CmsXmlContentValueLocation(restrictValue));
                if (restriction == null) {
                    LOG.warn((Object)("Improper date restriction configuration in content " + content.getFile().getRootPath() + ", online=" + cms.getRequestContext().getCurrentProject().isOnlineProject()));
                }
                result.setDateRestriction(restriction);
            }
            if ((geoFilterValue = content.getValue(N_GEO_FILTER, locale)) != null) {
                String coordinatesPath = geoFilterValue.getPath() + "/" + N_COORDINATES;
                String radiusPath = geoFilterValue.getPath() + "/" + N_RADIUS;
                I_CmsXmlContentValue coordinatesValue = content.getValue(coordinatesPath, locale);
                I_CmsXmlContentValue radiusValue = content.getValue(radiusPath, locale);
                String coordinates = CmsGeoUtil.parseCoordinates(coordinatesValue.getStringValue(cms));
                String radius = radiusValue.getStringValue(cms);
                boolean radiusValid = false;
                try {
                    Float.parseFloat(radius);
                    radiusValid = true;
                }
                catch (NumberFormatException e) {
                    radiusValid = false;
                }
                if (coordinates != null && radiusValid) {
                    ListConfigurationBean.ListGeoFilterBean listGeoFilterBean = new ListConfigurationBean.ListGeoFilterBean(coordinates, radius);
                    result.setGeoFilter(listGeoFilterBean);
                } else {
                    LOG.warn((Object)("Improper Geo filter in content " + content.getFile().getRootPath() + ", online=" + cms.getRequestContext().getCurrentProject().isOnlineProject()));
                }
            }
            I_CmsXmlContentValue categoryModeVal = content.getValue(N_CATEGORY_MODE, locale);
            CategoryMode categoryMode = CategoryMode.OR;
            if (categoryModeVal != null) {
                try {
                    categoryMode = CategoryMode.valueOf(categoryModeVal.getStringValue(cms));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            result.setCategoryMode(categoryMode);
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            for (I_CmsXmlContentValue parameter : content.getValues(N_PARAMETER, locale)) {
                I_CmsXmlContentValue keyVal = content.getValue(parameter.getPath() + "/" + N_KEY, locale);
                I_CmsXmlContentValue valueVal = content.getValue(parameter.getPath() + "/" + N_VALUE, locale);
                if (keyVal == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(keyVal.getStringValue(cms)) || valueVal == null) continue;
                parameters.put(keyVal.getStringValue(cms), valueVal.getStringValue(cms));
            }
            result.setAdditionalParameters(parameters);
            ArrayList<String> displayTypes = new ArrayList<String>();
            List<I_CmsXmlContentValue> typeValues = content.getValues(N_DISPLAY_TYPE, locale);
            if (!typeValues.isEmpty()) {
                for (I_CmsXmlContentValue value : typeValues) {
                    displayTypes.add(value.getStringValue(cms));
                }
            }
            result.setDisplayTypes(displayTypes);
            ArrayList<String> folders = new ArrayList<String>();
            List<I_CmsXmlContentValue> folderValues = content.getValues(N_SEARCH_FOLDER, locale);
            if (!folderValues.isEmpty()) {
                for (I_CmsXmlContentValue value : folderValues) {
                    CmsLink val = ((CmsXmlVfsFileValue)value).getLink(cms);
                    if (val == null) continue;
                    folders.add(cms.getRequestContext().addSiteRoot(val.getSitePath(cms)));
                }
            }
            result.setFolders(folders);
            ArrayList<CmsUUID> blackList = new ArrayList<CmsUUID>();
            List<I_CmsXmlContentValue> blacklistValues = content.getValues(N_BLACKLIST, locale);
            if (!blacklistValues.isEmpty()) {
                for (I_CmsXmlContentValue value : blacklistValues) {
                    CmsLink link = ((CmsXmlVfsFileValue)value).getLink(cms);
                    if (link == null) continue;
                    blackList.add(link.getStructureId());
                }
            }
            if (!(categoryFolderRestrictions = content.getValues(N_CATEGORY_FOLDER_RESTRICTION, locale)).isEmpty()) {
                for (I_CmsXmlContentValue restriction : categoryFolderRestrictions) {
                    ArrayList<String> restrictionFolders = new ArrayList<String>();
                    List<I_CmsXmlContentValue> folderVals = content.getValues(CmsXmlUtils.concatXpath(restriction.getPath(), N_FOLDER), locale);
                    for (I_CmsXmlContentValue folderVal : folderVals) {
                        CmsLink val = ((CmsXmlVfsFileValue)folderVal).getLink(cms);
                        if (val == null) continue;
                        restrictionFolders.add(cms.getRequestContext().addSiteRoot(val.getSitePath(cms)));
                    }
                    I_CmsXmlContentValue categoryVal = content.getValue(CmsXmlUtils.concatXpath(restriction.getPath(), N_CATEGORY), locale);
                    String categoryString = null != categoryVal ? categoryVal.getStringValue(cms) : "";
                    List<Object> restrictionCategorySitePaths = CmsStringUtil.isNotEmptyOrWhitespaceOnly(categoryString) ? Arrays.asList(categoryString.split(",")) : Collections.emptyList();
                    ArrayList<String> restrictionCategories = new ArrayList<String>(restrictionCategorySitePaths.size());
                    for (String string : restrictionCategorySitePaths) {
                        try {
                            String path = CmsCategoryService.getInstance().getCategory(cms, cms.getRequestContext().addSiteRoot(string)).getPath();
                            restrictionCategories.add(path);
                        }
                        catch (CmsException e) {
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    String restrictionCategoryMode = content.getValue(CmsXmlUtils.concatXpath(restriction.getPath(), N_CATEGORY_MODE), locale).getStringValue(cms);
                    result.addCategoryFolderFilter(new ListConfigurationBean.ListCategoryFolderRestrictionBean(restrictionCategories, restrictionFolders, null == restrictionCategoryMode ? null : CategoryMode.valueOf(restrictionCategoryMode)));
                }
            }
            result.setBlacklist(blackList);
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void addItemProperties(Item resourceItem, CmsObject cms, CmsResource resource, Locale locale) {
        CmsResourceUtil resUtil;
        String title;
        if (this.m_currentConfig != null && resourceItem.getItemProperty((Object)BLACKLISTED_PROPERTY) != null) {
            resourceItem.getItemProperty((Object)BLACKLISTED_PROPERTY).setValue((Object)this.m_currentConfig.getBlacklist().contains(resource.getStructureId()));
        }
        if (this.m_currentConfig != null && resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE) != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(title = (resUtil = new CmsResourceUtil(cms, resource)).getGalleryTitle((Locale)this.m_localeSelect.getValue()))) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE).setValue((Object)title);
        }
        if (resource instanceof CmsSearchResource && resourceItem.getItemProperty((Object)INFO_PROPERTY_LABEL) != null) {
            String seriesType = ((CmsSearchResource)resource).getField("seriesdatestype_s");
            resourceItem.getItemProperty((Object)INFO_PROPERTY_LABEL).setValue((Object)CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_SERIES_TYPE_" + (seriesType == null ? "DEFAULT" : seriesType) + "_0", new Object[0]));
            resourceItem.getItemProperty((Object)INFO_PROPERTY).setValue((Object)seriesType);
        }
        if (resource instanceof CmsSearchResource && resourceItem.getItemProperty((Object)INSTANCEDATE_PROPERTY) != null) {
            Date date = ((CmsSearchResource)resource).getDateField(this.m_resultTable.getDateFieldKey());
            resourceItem.getItemProperty((Object)INSTANCEDATE_PROPERTY).setValue((Object)date);
        }
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.unlockCurrent();
        return true;
    }

    @Override
    public I_CmsDialogContext getDialogContext() {
        CmsFileTable table = this.isOverView() ? this.m_overviewTable : this.m_resultTable;
        List<CmsResource> resources = table.getSelectedResources();
        DialogContext context = new DialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, table, resources);
        if (!this.isOverView()) {
            context.setSelectedItems(this.m_resultTable.getSelectedItems());
        }
        return context;
    }

    @Override
    public void initUI(I_CmsAppUIContext uiContext) {
        super.initUI(uiContext);
        this.m_publishButton = CmsToolBar.createButton((Resource)FontOpenCms.PUBLISH, CmsVaadinUtils.getMessageText("GUI_PUBLISH_BUTTON_TITLE_0", new Object[0]));
        if (CmsAppWorkplaceUi.isOnlineProject()) {
            this.m_publishButton.setEnabled(false);
            this.m_publishButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
        }
        this.m_publishButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsListManager.this.publish();
            }
        });
        uiContext.addToolbarButton((Component)this.m_publishButton);
        this.m_editCurrentButton = CmsToolBar.createButton((Resource)FontOpenCms.PEN, CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_EDIT_CONFIG_0", new Object[0]));
        this.m_editCurrentButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsListManager.this.editListConfiguration(CmsListManager.this.m_currentResource);
            }
        });
        uiContext.addToolbarButton((Component)this.m_editCurrentButton);
        this.m_infoButton = CmsToolBar.createButton((Resource)FontOpenCms.INFO, CmsVaadinUtils.getMessageText("GUI_RESOURCE_INFO_0", new Object[0]));
        this.m_infoButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                DialogContext context = new DialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, CmsListManager.this.m_resultTable, Collections.singletonList(CmsListManager.this.m_currentResource));
                CmsResourceInfoAction action = new CmsResourceInfoAction();
                action.openDialog(context, CmsResourceStatusTabId.tabRelationsTo.name());
            }
        });
        uiContext.addToolbarButton((Component)this.m_infoButton);
        this.m_toggleSeriesButton = CmsToolBar.createButton((Resource)FontOpenCms.LIST, CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_TOGGLE_SERIES_BUTTON_0", new Object[0]));
        this.m_toggleSeriesButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsListManager.this.toggleDateSeries();
            }
        });
        uiContext.addToolbarButton((Component)this.m_toggleSeriesButton);
        this.m_createNewButton = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_CREATE_NEW_0", new Object[0]));
        this.m_createNewButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsListManager.this.createNew();
            }
        });
        uiContext.addToolbarButton((Component)this.m_createNewButton);
        this.m_rootLayout.setMainHeightFull(true);
        this.m_resultLayout = new HorizontalSplitPanel();
        this.m_resultLayout.setSizeFull();
        this.m_resultFacets = new CmsResultFacets(this);
        this.m_resultFacets.setWidth("100%");
        this.m_resultLayout.setFirstComponent((Component)this.m_resultFacets);
        LinkedHashMap<CmsResourceTableProperty, Integer> tableColumns = new LinkedHashMap<CmsResourceTableProperty, Integer>();
        for (Map.Entry<CmsResourceTableProperty, Integer> columnsEntry : CmsFileTable.DEFAULT_TABLE_PROPERTIES.entrySet()) {
            if (columnsEntry.getKey().equals(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME)) {
                tableColumns.put(INFO_PROPERTY_LABEL, 0);
            } else if (columnsEntry.getKey().equals(CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE)) {
                tableColumns.put(INSTANCEDATE_PROPERTY, 0);
            }
            tableColumns.put(columnsEntry.getKey(), columnsEntry.getValue());
        }
        tableColumns.put(BLACKLISTED_PROPERTY, 2);
        tableColumns.put(INFO_PROPERTY, 2);
        this.m_resultTable = new CmsResultTable(null, tableColumns);
        this.m_resultTable.applyWorkplaceAppSettings();
        CmsResourceContextMenuBuilder menuBuilderOverView = new CmsResourceContextMenuBuilder();
        menuBuilderOverView.addMenuItemProvider(OpenCms.getWorkplaceAppManager().getMenuItemProvider());
        menuBuilderOverView.addMenuItemProvider(new I_CmsContextMenuItemProvider(){

            @Override
            public List<I_CmsContextMenuItem> getMenuItems() {
                return Arrays.asList(new CmsContextMenuActionItem(new CmsEditDialogAction(){

                    @Override
                    public void executeAction(I_CmsDialogContext context) {
                        CmsListManager.this.editListConfiguration(context.getResources().get(0));
                    }
                }, null, 10.0f, 1000));
            }
        });
        CmsResourceContextMenuBuilder menuBuilder = new CmsResourceContextMenuBuilder();
        menuBuilder.addMenuItemProvider(OpenCms.getWorkplaceAppManager().getMenuItemProvider());
        menuBuilder.addMenuItemProvider(new I_CmsContextMenuItemProvider(){

            @Override
            public List<I_CmsContextMenuItem> getMenuItems() {
                return Arrays.asList(new CmsContextMenuActionItem(new A_CmsWorkplaceAction(){

                    @Override
                    public void executeAction(I_CmsDialogContext context) {
                        CmsUUID structureId = context.getResources().get(0).getStructureId();
                        CmsListManager.this.m_currentConfig.getBlacklist().add(structureId);
                        CmsListManager.this.saveBlacklist(CmsListManager.this.m_currentConfig);
                        context.finish(Collections.singletonList(structureId));
                    }

                    @Override
                    public String getId() {
                        return "hideresource";
                    }

                    @Override
                    public String getTitleKey() {
                        return "GUI_LISTMANAGER_BLACKLIST_MENU_ENTRY_0";
                    }

                    @Override
                    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
                        if (CmsListManager.this.m_currentConfig != null && resources != null && resources.size() == 1 && !CmsListManager.this.m_currentConfig.getBlacklist().contains(resources.get(0).getStructureId())) {
                            return CmsEditDialogAction.VISIBILITY.getVisibility(cms, Collections.singletonList(CmsListManager.this.m_currentResource));
                        }
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }, null, 10.0f, 0), new CmsContextMenuActionItem(new A_CmsWorkplaceAction(){

                    @Override
                    public void executeAction(I_CmsDialogContext context) {
                        CmsUUID structureId = context.getResources().get(0).getStructureId();
                        CmsListManager.this.m_currentConfig.getBlacklist().remove(structureId);
                        CmsListManager.this.saveBlacklist(CmsListManager.this.m_currentConfig);
                        context.finish(Collections.singletonList(structureId));
                    }

                    @Override
                    public String getId() {
                        return "showresource";
                    }

                    @Override
                    public String getTitleKey() {
                        return "GUI_LISTMANAGER_REMOVE_FROM_BLACKLIST_MENU_ENTRY_0";
                    }

                    @Override
                    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
                        if (CmsListManager.this.m_currentConfig != null && resources != null && resources.size() == 1 && CmsListManager.this.m_currentConfig.getBlacklist().contains(resources.get(0).getStructureId())) {
                            return CmsEditDialogAction.VISIBILITY.getVisibility(cms, Collections.singletonList(CmsListManager.this.m_currentResource));
                        }
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }, null, 10.0f, 0), new CmsContextMenuActionItem(new EditAction(), null, 10.0f, 1000), new CmsContextMenuActionItem(new DeleteAction(), null, 10.0f, 1000));
            }
        });
        this.m_resultTable.setMenuBuilder(menuBuilder);
        this.m_resultTable.addAdditionalStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                String style = "";
                Item item = source.getItem(itemId);
                Boolean blacklisted = (Boolean)item.getItemProperty((Object)BLACKLISTED_PROPERTY).getValue();
                if (blacklisted.booleanValue()) {
                    style = style + "o-project-other ";
                } else if (CmsResourceTableProperty.PROPERTY_TITLE.equals(propertyId) && (item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED) == null || ((Boolean)item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).getValue()).booleanValue())) {
                    style = style + "o-in-navigation ";
                }
                if (INFO_PROPERTY_LABEL.equals(propertyId)) {
                    if (blacklisted.booleanValue()) {
                        style = style + " o-box-black";
                    } else {
                        Object value = item.getItemProperty((Object)INFO_PROPERTY).getValue();
                        if (value == null) {
                            style = style + " o-box-gray";
                        } else {
                            I_CmsSerialDateValue.DateType type = I_CmsSerialDateValue.DateType.valueOf((String)value);
                            switch (type) {
                                case SERIES: {
                                    style = style + " o-box-blue-light";
                                    break;
                                }
                                case SINGLE: {
                                    style = style + " o-box-gray";
                                    break;
                                }
                                case EXTRACTED: {
                                    style = style + " o-box-orange";
                                    break;
                                }
                            }
                        }
                    }
                }
                return style;
            }
        });
        final CmsResourceTable.DefaultItemDescriptionGenerator defaultDescriptionGenerator = new CmsResourceTable.DefaultItemDescriptionGenerator();
        this.m_resultTable.setsetItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){
            private static final long serialVersionUID = 1L;

            public String generateDescription(Component source, Object itemId, Object propertyId) {
                Item item = ((Table)source).getItem(itemId);
                if (INFO_PROPERTY_LABEL.equals(propertyId) && ((Boolean)item.getItemProperty((Object)BLACKLISTED_PROPERTY).getValue()).booleanValue()) {
                    return CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_COLUMN_BLACKLISTED_0", new Object[0]);
                }
                return defaultDescriptionGenerator.generateDescription(source, itemId, propertyId);
            }
        });
        this.m_resultTable.setContextProvider(this);
        this.m_resultTable.addPropertyProvider(this);
        this.m_resultTable.setSizeFull();
        this.m_resultLayout.setSecondComponent((Component)this.m_resultTable);
        this.m_overviewTable = new CmsFileTable(this);
        this.m_overviewTable.applyWorkplaceAppSettings();
        this.m_overviewTable.setMenuBuilder(menuBuilderOverView);
        this.m_overviewTable.setSizeFull();
        this.m_tableFilter = new TextField();
        this.m_tableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_tableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_tableFilter.addStyleName("inline-icon");
        this.m_tableFilter.setWidth("200px");
        this.m_tableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsListManager.this.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_tableFilter);
        this.m_localeSelect = new ComboBox();
        this.m_localeSelect.setNullSelectionAllowed(false);
        this.m_localeSelect.setWidth("100px");
        this.m_localeSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsListManager.this.changeContentLocale((Locale)event.getProperty().getValue());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_localeSelect);
        this.m_resultSorter = new ComboBox();
        this.m_resultSorter.setNullSelectionAllowed(false);
        this.m_resultSorter.setWidth("200px");
        for (int i = 0; i < SORT_OPTIONS[0].length; ++i) {
            this.m_resultSorter.addItem((Object)SORT_OPTIONS[0][i]);
            this.m_resultSorter.setItemCaption((Object)SORT_OPTIONS[0][i], CmsVaadinUtils.getMessageText(SORT_OPTIONS[1][i], new Object[0]));
        }
        this.m_resultSorter.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsListManager.this.sortResult();
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_resultSorter);
        this.m_textSearch = new TextField();
        this.m_textSearch.setIcon((Resource)FontOpenCms.SEARCH);
        this.m_textSearch.setInputPrompt(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_SEARCH_0", new Object[0]));
        this.m_textSearch.addStyleName("inline-icon");
        this.m_textSearch.setWidth("200px");
        this.m_textSearch.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsListManager.this.search((String)event.getProperty().getValue());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_textSearch);
        this.m_resultLayout.setSecondComponent((Component)this.m_resultTable);
        this.m_resultLayout.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public void onRestoreFromCache() {
        if (this.isOverView()) {
            CmsFileExplorerSettings state = this.m_overviewTable.getTableSettings();
            this.displayListConfigs();
            this.m_overviewTable.setTableState(state);
            this.m_overviewTable.updateSorting();
        } else {
            this.refreshResult();
        }
    }

    @Override
    public void onStateChange(String state) {
        if (this.m_currentState == null || !this.m_currentState.equals(state)) {
            this.m_currentState = state;
            super.onStateChange(state);
        }
    }

    @Override
    public void onWindowClose() {
        this.unlockCurrent();
    }

    public void saveBlacklist(ListConfigurationBean configBean) {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
            this.m_dialogWindow = null;
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            this.m_lockAction = CmsLockUtil.ensureLock(cms, this.m_currentResource);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            return;
        }
        try {
            CmsFile configFile = cms.readFile(this.m_currentResource);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, configFile);
            Locale locale = CmsLocaleManager.MASTER_LOCALE;
            int count = 0;
            while (content.hasValue(N_BLACKLIST, locale)) {
                content.removeValue(N_BLACKLIST, locale, 0);
            }
            for (CmsUUID hiddenId : configBean.getBlacklist()) {
                CmsXmlVfsFileValue contentVal = (CmsXmlVfsFileValue)content.addValue(cms, N_BLACKLIST, locale, count);
                contentVal.setIdValue(cms, hiddenId);
                ++count;
            }
            configFile.setContents(content.marshal());
            cms.writeFile(configFile);
            if (this.m_lockAction.getChange().equals((Object)CmsLockActionRecord.LockChange.locked)) {
                CmsLockUtil.tryUnlock(cms, configFile);
            }
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
        this.m_currentConfig = configBean;
    }

    public void search(CmsSimpleSearchConfigurationParser configParser, CmsResource resource) {
        this.m_currentResource = resource;
        this.m_currentConfigParser = configParser;
        this.resetContentLocale(configParser.getSearchLocale());
        this.m_resetting = true;
        this.m_resultSorter.setValue((Object)this.m_currentConfig.getParameterValue(N_SORT_ORDER));
        this.m_resetting = false;
        this.search(null, null, null);
    }

    public void search(Map<String, List<String>> fieldFacets, Map<String, List<String>> rangeFacets) {
        this.search(fieldFacets, rangeFacets, null);
    }

    public void search(Map<String, List<String>> fieldFacets, Map<String, List<String>> rangeFacets, String additionalQuery) {
        I_CmsSearchStateFacet state;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_resultSorter.getValue())) {
            this.m_currentConfigParser.setSortOption((String)this.m_resultSorter.getValue());
        }
        CmsSolrQuery query = this.m_currentConfigParser.getInitialQuery();
        CmsSearchController controller = new CmsSearchController(new CmsSearchConfiguration(this.m_currentConfigParser, A_CmsUI.getCmsObject()));
        controller.getPagination().getState().setCurrentPage(1);
        if (fieldFacets != null) {
            Map<String, I_CmsSearchControllerFacetField> fieldFacetControllers = controller.getFieldFacets().getFieldFacetController();
            for (Map.Entry<String, List<String>> facetEntry : fieldFacets.entrySet()) {
                state = fieldFacetControllers.get(facetEntry.getKey()).getState();
                state.clearChecked();
                for (String check : facetEntry.getValue()) {
                    state.addChecked(check);
                }
            }
        }
        if (rangeFacets != null) {
            Map<String, I_CmsSearchControllerFacetRange> rangeFacetControllers = controller.getRangeFacets().getRangeFacetController();
            for (Map.Entry<String, List<String>> facetEntry : rangeFacets.entrySet()) {
                state = rangeFacetControllers.get(facetEntry.getKey()).getState();
                state.clearChecked();
                for (String check : facetEntry.getValue()) {
                    state.addChecked(check);
                }
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(additionalQuery)) {
            controller.getCommon().getState().setQuery(additionalQuery);
        } else {
            this.resetTextSearch();
        }
        controller.addQueryParts(query, A_CmsUI.getCmsObject());
        this.executeSearch(controller, query);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_TITLE_0", new Object[0]));
        } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(A_CmsWorkplaceApp.getParamFromState(state, "resourceId"))) {
            crumbs.put("list-management", CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_TITLE_0", new Object[0]));
            String title = "";
            try {
                title = A_CmsUI.getCmsObject().readPropertyObject(this.m_currentResource, N_TITLE, false).getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_currentResource != null && CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
                title = this.m_currentResource.getName();
            }
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_VIEW_1", title));
        }
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        CmsObject cms = A_CmsUI.getCmsObject();
        boolean showOverview = true;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(A_CmsWorkplaceApp.getParamFromState(state, "resourceId"))) {
            try {
                CmsUUID id = new CmsUUID(A_CmsWorkplaceApp.getParamFromState(state, "resourceId"));
                CmsResource res = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                this.m_currentConfig = CmsListManager.parseListConfiguration(A_CmsUI.getCmsObject(), res);
                String localeString = A_CmsWorkplaceApp.getParamFromState(state, PARAM_LOCALE);
                Locale locale = CmsStringUtil.isNotEmptyOrWhitespaceOnly(localeString) ? CmsLocaleManager.getLocale(localeString) : this.getContentLocale(this.m_currentConfig);
                CmsSimpleSearchConfigurationParser configParser = new CmsSimpleSearchConfigurationParser(cms, this.m_currentConfig, null);
                this.setBackendSpecificOptions(configParser, locale);
                this.search(configParser, res);
                showOverview = false;
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (showOverview) {
            this.unlockCurrent();
            this.m_lockAction = null;
            this.displayListConfigs();
        }
        this.enableOverviewMode(showOverview);
        return showOverview ? this.m_overviewTable : this.m_resultLayout;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    void changeContentLocale(Locale contentLocale) {
        if (!this.m_resetting) {
            this.m_currentConfigParser.setSearchLocale(contentLocale);
        }
        this.m_resultTable.setContentLocale(contentLocale);
        this.search(null, null, null);
    }

    void closeEditDialog() {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
            this.m_dialogWindow = null;
        }
        if (this.m_isOverView) {
            this.unlockCurrent();
            this.m_currentResource = null;
        }
    }

    void createNew() {
        if (this.m_isOverView) {
            this.editListConfiguration(null);
        }
    }

    void displayResult(CmsSolrResultList resultList) {
        ArrayList<CmsResource> resources;
        this.evalSeries(resultList);
        if (this.m_hideSeriesInstances) {
            HashSet<CmsUUID> instanceIds = new HashSet<CmsUUID>();
            resources = new ArrayList();
            for (CmsSearchResource res : resultList) {
                if (instanceIds.contains(res.getStructureId())) continue;
                instanceIds.add(res.getStructureId());
                resources.add(res);
            }
        } else {
            resources = new ArrayList<CmsSearchResource>(resultList);
        }
        this.m_resultTable.fillTable(A_CmsUI.getCmsObject(), resources, true, false);
        String state = A_CmsWorkplaceApp.addParamToState("", "resourceId", this.m_currentResource.getStructureId().toString());
        this.m_currentState = state = A_CmsWorkplaceApp.addParamToState(state, PARAM_LOCALE, this.m_currentConfigParser.getSearchLocale().toString());
        CmsAppWorkplaceUi.get().changeCurrentAppState(state);
        if (this.m_isOverView) {
            this.enableOverviewMode(false);
            this.updateBreadCrumb(this.getBreadCrumbForState(state));
        }
    }

    void editListConfiguration(CmsResource resource) {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            String editState = resource == null ? CmsEditor.getEditStateForNew(cms, OpenCms.getResourceManager().getResourceType(RES_TYPE_LIST_CONFIG), "/", null, false, UI.getCurrent().getPage().getLocation().toString()) : CmsEditor.getEditState(resource.getStructureId(), false, UI.getCurrent().getPage().getLocation().toString());
            View view = CmsAppWorkplaceUi.get().getCurrentView();
            if (view instanceof CmsAppView) {
                ((CmsAppView)view).setCacheStatus(CmsAppView.CacheStatus.cacheOnce);
            }
            CmsAppWorkplaceUi.get().showApp(OpenCms.getWorkplaceAppManager().getAppConfiguration("editor"), editState);
        }
        catch (CmsLoaderException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    void enableOverviewMode(boolean enabled) {
        boolean isOffline = !A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject();
        this.m_publishButton.setVisible(!enabled);
        this.m_publishButton.setEnabled(isOffline);
        this.m_infoButton.setVisible(!enabled);
        this.m_tableFilter.setVisible(enabled);
        this.m_textSearch.setVisible(!enabled);
        this.m_editCurrentButton.setVisible(!enabled);
        this.m_editCurrentButton.setEnabled(isOffline);
        this.m_toggleSeriesButton.setVisible(this.m_hasSeriesType && !enabled);
        this.m_resultSorter.setVisible(!enabled);
        this.m_localeSelect.setVisible(!enabled);
        this.m_isOverView = enabled;
        this.m_rootLayout.setMainContent((Component)(enabled ? this.m_overviewTable : this.m_resultLayout));
        this.m_createNewButton.setVisible(enabled);
        if (enabled) {
            if (!isOffline) {
                this.m_createNewButton.setEnabled(false);
                this.m_createNewButton.setDescription(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_NOT_CREATABLE_ONLINE_0", new Object[0]));
            } else {
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsADEConfigData data = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getSiteRoot());
                CmsResourceTypeConfig typeConfig = data.getResourceType(RES_TYPE_LIST_CONFIG);
                try {
                    if (typeConfig == null || !typeConfig.checkCreatable(cms, cms.getRequestContext().getSiteRoot())) {
                        this.m_createNewButton.setEnabled(false);
                        this.m_createNewButton.setDescription(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_NOT_CREATABLE_TYPE_0", new Object[0]));
                    } else {
                        this.m_createNewButton.setEnabled(true);
                        this.m_createNewButton.setDescription(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_CREATE_NEW_0", new Object[0]));
                    }
                }
                catch (CmsException e) {
                    this.m_createNewButton.setEnabled(false);
                    this.m_createNewButton.setDescription(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_NOT_CREATABLE_TYPE_0", new Object[0]));
                }
            }
        }
    }

    void evalSeries(CmsSolrResultList resultList) {
        this.m_hasSeriesType = false;
        this.m_hasSeriesInstances = false;
        HashSet<CmsUUID> instanceIds = new HashSet<CmsUUID>();
        for (CmsSearchResource res : resultList) {
            String seriesType = res.getField("seriesdatestype_s");
            boolean bl = this.m_hasSeriesType = this.m_hasSeriesType || CmsStringUtil.isNotEmptyOrWhitespaceOnly(seriesType);
            if (!this.m_hasSeriesType || !I_CmsSerialDateValue.DateType.SERIES.name().equals(seriesType)) continue;
            if (instanceIds.contains(res.getStructureId())) {
                this.m_hasSeriesInstances = true;
                break;
            }
            instanceIds.add(res.getStructureId());
        }
        if (!this.m_hasSeriesInstances) {
            this.setsDateSeriesHiddenFlag(false);
        }
        this.m_toggleSeriesButton.setEnabled(this.m_hasSeriesInstances);
        this.m_toggleSeriesButton.setVisible(this.m_hasSeriesType);
    }

    void filterTable(String filter) {
        if (!this.m_resetting) {
            this.m_overviewTable.filterTable(filter);
        }
    }

    CmsContainerElementBean getElementForEditHandler(DialogContext context) {
        List<Item> selected = context.getSelectedItems();
        if (selected.size() == 1) {
            Item item = selected.get(0);
            Date instanceDate = (Date)item.getItemProperty((Object)INSTANCEDATE_PROPERTY).getValue();
            CmsResource resource = context.getResources().get(0);
            return new CmsContainerElementBean(resource.getStructureId(), null, Collections.singletonMap(FIELD_DATE_FACET_NAME, String.valueOf(instanceDate.getTime())), false);
        }
        return null;
    }

    List<CmsResource> getPublishResources() {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        if (this.m_currentResource != null) {
            result.add(this.m_currentResource);
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsSolrQuery query = this.m_currentConfigParser.getInitialQuery();
            CmsSearchController controller = new CmsSearchController(new CmsSearchConfiguration(this.m_currentConfigParser, A_CmsUI.getCmsObject()));
            controller.getPagination().getState().setCurrentPage(1);
            controller.addQueryParts(query, A_CmsUI.getCmsObject());
            I_CmsSearchConfigurationCommon commonConfig = controller.getCommon().getConfig();
            CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(commonConfig.getSolrIndex());
            try {
                CmsSolrResultList solrResultList = index.search(cms, query, true, null, false, CmsResourceFilter.IGNORE_EXPIRATION, commonConfig.getMaxReturnedResults());
                result.addAll(solrResultList);
            }
            catch (CmsSearchException e) {
                LOG.error((Object)"Error reading resources for publish.", (Throwable)e);
            }
        }
        return result;
    }

    boolean isOverView() {
        return this.m_isOverView;
    }

    void publish() {
        I_CmsUpdateListener<String> updateListener = new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
                CmsListManager.this.updateItems(updatedItems);
            }
        };
        CmsAppWorkplaceUi.get().disableGlobalShortcuts();
        CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), updateListener);
        extension.openPublishDialog(this.getPublishResources());
    }

    void refreshResult() {
        String itemId = this.m_resultTable.getCurrentPageFirstItemId();
        CmsFileExplorerSettings state = this.m_resultTable.getTableSettings();
        this.search(this.m_resultFacets.getSelectedFieldFacets(), this.m_resultFacets.getSelectedRangeFactes(), (String)this.m_textSearch.getValue());
        this.m_resultTable.setTableState(state);
        this.m_resultTable.updateSorting();
        this.m_resultTable.setCurrentPageFirstItemId(itemId);
    }

    void search(String query) {
        if (!this.m_resetting) {
            this.search(null, null, query);
        }
    }

    void setsDateSeriesHiddenFlag(boolean hide) {
        this.m_hideSeriesInstances = hide;
        if (this.m_hideSeriesInstances) {
            this.m_toggleSeriesButton.addStyleName("o-button-pressed");
        } else {
            this.m_toggleSeriesButton.removeStyleName("o-button-pressed");
        }
    }

    void sortResult() {
        if (!this.m_resetting) {
            this.search(this.m_resultFacets.getSelectedFieldFacets(), this.m_resultFacets.getSelectedRangeFactes(), (String)this.m_textSearch.getValue());
        }
    }

    void toggleDateSeries() {
        this.setsDateSeriesHiddenFlag(!this.m_hideSeriesInstances);
        this.refreshResult();
    }

    void tryUnlockCurrent() {
        if (this.m_lockAction != null && this.m_lockAction.getChange().equals((Object)CmsLockActionRecord.LockChange.locked)) {
            try {
                A_CmsUI.getCmsObject().unlockResource(this.m_currentResource);
            }
            catch (CmsException e) {
                e.printStackTrace();
            }
        }
    }

    void unlockCurrent() {
        if (this.m_currentResource != null && this.m_lockAction != null && this.m_lockAction.getChange().equals((Object)CmsLockActionRecord.LockChange.locked)) {
            CmsLockUtil.tryUnlock(A_CmsUI.getCmsObject(), this.m_currentResource);
        }
        this.m_lockAction = null;
    }

    void updateItems(List<String> updatedItems) {
        HashSet<CmsUUID> ids = new HashSet<CmsUUID>();
        for (String id : updatedItems) {
            ids.add(new CmsUUID(id));
        }
        this.m_resultTable.update(ids, false);
    }

    private void displayListConfigs() {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.resetTableFilter();
        try {
            List<CmsResource> resources = cms.readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(OpenCms.getResourceManager().getResourceType(RES_TYPE_LIST_CONFIG)));
            this.m_overviewTable.fillTable(cms, resources);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void executeSearch(CmsSearchController controller, CmsSolrQuery query) {
        CmsObject cms = A_CmsUI.getCmsObject();
        I_CmsSearchConfigurationCommon commonConfig = controller.getCommon().getConfig();
        CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(commonConfig.getSolrIndex());
        try {
            CmsSolrResultList solrResultList = index.search(cms, query, true, null, false, CmsResourceFilter.IGNORE_EXPIRATION, commonConfig.getMaxReturnedResults());
            this.displayResult(solrResultList);
            this.m_resultFacets.displayFacetResult(solrResultList, new CmsSearchResultWrapper(controller, solrResultList, query, cms, null));
        }
        catch (CmsSearchException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)"Error executing search.", (Throwable)e);
        }
    }

    private Locale getContentLocale(ListConfigurationBean bean) {
        CmsObject cms = A_CmsUI.getCmsObject();
        if (bean.getFolders().isEmpty()) {
            return OpenCms.getLocaleManager().getDefaultLocale(cms, "/");
        }
        return OpenCms.getLocaleManager().getDefaultLocale(cms, cms.getRequestContext().removeSiteRoot(this.m_currentConfig.getFolders().get(0)));
    }

    private void resetContentLocale(Locale defaultLocale) {
        this.m_resetting = true;
        this.m_localeSelect.removeAllItems();
        if (this.m_currentConfig.getFolders().isEmpty()) {
            this.m_localeSelect.addItem((Object)defaultLocale);
            this.m_localeSelect.setItemCaption((Object)defaultLocale, defaultLocale.getDisplayLanguage(UI.getCurrent().getLocale()));
        } else {
            for (String folder : this.m_currentConfig.getFolders()) {
                for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales(A_CmsUI.getCmsObject(), folder)) {
                    if (this.m_localeSelect.containsId((Object)locale)) continue;
                    this.m_localeSelect.addItem((Object)locale);
                    this.m_localeSelect.setItemCaption((Object)locale, locale.getDisplayLanguage(UI.getCurrent().getLocale()));
                }
            }
        }
        this.m_localeSelect.setValue((Object)defaultLocale);
        this.m_localeSelect.setEnabled(this.m_localeSelect.getItemIds().size() > 1);
        this.m_resetting = false;
    }

    private void resetTableFilter() {
        this.m_resetting = true;
        this.m_tableFilter.clear();
        this.m_resetting = false;
    }

    private void resetTextSearch() {
        this.m_resetting = true;
        this.m_textSearch.clear();
        this.m_resetting = false;
    }

    private void setBackendSpecificOptions(CmsSimpleSearchConfigurationParser configParser, Locale locale) {
        configParser.setSearchLocale(locale);
        configParser.setIgnoreBlacklist(true);
        configParser.setPagination(PAGINATION);
    }

    class EditAction
    extends CmsEditDialogAction {
        EditAction() {
        }

        @Override
        public void executeAction(final I_CmsDialogContext context) {
            final CmsResource resource = context.getResources().get(0);
            I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource);
            if (resourceType instanceof CmsResourceTypeXmlContent && ((CmsResourceTypeXmlContent)resourceType).getEditHandler(context.getCms()) != null) {
                final I_CmsEditHandler handler = ((CmsResourceTypeXmlContent)resourceType).getEditHandler(context.getCms());
                final CmsContainerElementBean elementBean = CmsListManager.this.getElementForEditHandler((DialogContext)context);
                CmsDialogOptions options = handler.getEditOptions(context.getCms(), elementBean, null, Collections.emptyMap(), true);
                if (options == null) {
                    super.executeAction(context);
                } else if (options.getOptions().size() == 1) {
                    this.editForOption(resource, elementBean, options.getOptions().get(0).getValue(), handler, context);
                } else {
                    Window window = CmsBasicDialog.prepareWindow();
                    window.setCaption(options.getTitle());
                    CmsOptionDialog dialog = new CmsOptionDialog(resource, options, new CmsOptionDialog.I_OptionHandler(){

                        @Override
                        public void handleOption(String option) {
                            EditAction.this.editForOption(resource, elementBean, option, handler, context);
                        }
                    }, null, window);
                    window.setContent((Component)dialog);
                    CmsAppWorkplaceUi.get().addWindow(window);
                    dialog.initActionHandler(window);
                }
            } else {
                super.executeAction(context);
            }
        }

        void editForOption(CmsResource resource, CmsContainerElementBean elementBean, String editOption, I_CmsEditHandler editHandler, I_CmsDialogContext context) {
            try {
                CmsUUID id = editHandler.prepareForEdit(context.getCms(), elementBean, editOption, null, Collections.emptyMap());
                if (resource.getStructureId().equals(id)) {
                    super.executeAction(context);
                } else if (id != null) {
                    CmsFileTableDialogContext changedContext = new CmsFileTableDialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, CmsListManager.this.m_resultTable, Collections.singletonList(context.getCms().readResource(id)));
                    super.executeAction(changedContext);
                }
            }
            catch (CmsException e) {
                CmsErrorDialog.showErrorDialog(e);
            }
        }
    }

    class DeleteAction
    extends CmsDeleteDialogAction {
        DeleteAction() {
        }

        @Override
        public void executeAction(final I_CmsDialogContext context) {
            final CmsResource resource = context.getResources().get(0);
            I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource);
            if (resourceType instanceof CmsResourceTypeXmlContent && ((CmsResourceTypeXmlContent)resourceType).getEditHandler(context.getCms()) != null) {
                final I_CmsEditHandler handler = ((CmsResourceTypeXmlContent)resourceType).getEditHandler(context.getCms());
                final CmsContainerElementBean elementBean = CmsListManager.this.getElementForEditHandler((DialogContext)context);
                CmsDialogOptions options = handler.getDeleteOptions(context.getCms(), elementBean, null, Collections.emptyMap());
                if (options == null) {
                    super.executeAction(context);
                } else if (options.getOptions().size() == 1) {
                    this.deleteForOption(resource, elementBean, options.getOptions().get(0).getValue(), handler, context);
                } else {
                    Window window = CmsBasicDialog.prepareWindow();
                    window.setCaption(options.getTitle());
                    CmsOptionDialog dialog = new CmsOptionDialog(resource, options, new CmsOptionDialog.I_OptionHandler(){

                        @Override
                        public void handleOption(String option) {
                            DeleteAction.this.deleteForOption(resource, elementBean, option, handler, context);
                        }
                    }, null, window);
                    window.setContent((Component)dialog);
                    CmsAppWorkplaceUi.get().addWindow(window);
                    dialog.initActionHandler(window);
                }
            } else {
                super.executeAction(context);
            }
        }

        void deleteForOption(CmsResource resource, CmsContainerElementBean elementBean, String deleteOption, I_CmsEditHandler editHandler, I_CmsDialogContext context) {
            try {
                editHandler.handleDelete(context.getCms(), elementBean, deleteOption, null, null);
            }
            catch (CmsException e) {
                CmsErrorDialog.showErrorDialog(e);
            }
        }
    }

    protected class DialogContext
    extends CmsFileTableDialogContext {
        private List<Item> m_selectedItems;

        public DialogContext(String appId, I_CmsDialogContext.ContextType contextType, CmsFileTable fileTable, List<CmsResource> resources) {
            super(appId, contextType, fileTable, resources);
        }

        @Override
        public void finish(Collection<CmsUUID> ids) {
            if (this.m_selectedItems == null) {
                super.finish(ids);
            } else {
                CmsListManager.this.refreshResult();
                this.closeWindow();
            }
        }

        public List<Item> getSelectedItems() {
            return this.m_selectedItems;
        }

        public void setSelectedItems(List<Item> items) {
            this.m_selectedItems = items;
        }
    }

    public static class ListConfigurationBean {
        private static final String ADDITIONAL_PARAM_MAX_RETURNED_RESULTS = "maxresults";
        private Map<String, String> m_additionalParameters;
        private List<CmsUUID> m_blacklist;
        private List<String> m_categories;
        private CategoryMode m_categoryMode;
        private I_CmsListDateRestriction m_dateRestriction;
        private List<String> m_dislayTypes;
        private ListGeoFilterBean m_geoFilter;
        private List<String> m_folders;
        private Map<String, String> m_parameterFields;
        private List<ListCategoryFolderRestrictionBean> m_categoryFolderRestrictions = new ArrayList<ListCategoryFolderRestrictionBean>();

        public ListConfigurationBean() {
            this.m_parameterFields = new HashMap<String, String>();
        }

        public void addCategoryFolderFilter(ListCategoryFolderRestrictionBean listCategoryFolderRestrictionBean) {
            this.m_categoryFolderRestrictions.add(listCategoryFolderRestrictionBean);
        }

        public Map<String, String> getAdditionalParameters() {
            return this.m_additionalParameters;
        }

        public List<CmsUUID> getBlacklist() {
            return this.m_blacklist;
        }

        public List<String> getCategories() {
            return this.m_categories;
        }

        public List<ListCategoryFolderRestrictionBean> getCategoryFolderRestrictions() {
            return this.m_categoryFolderRestrictions;
        }

        public CategoryMode getCategoryMode() {
            return this.m_categoryMode;
        }

        public I_CmsListDateRestriction getDateRestriction() {
            return this.m_dateRestriction;
        }

        public List<String> getDisplayTypes() {
            return this.m_dislayTypes;
        }

        public String getFilterQuery() {
            return this.m_parameterFields.get(CmsListManager.N_FILTER_QUERY);
        }

        public List<String> getFolders() {
            return this.m_folders;
        }

        public ListGeoFilterBean getGeoFilter() {
            return this.m_geoFilter;
        }

        public Integer getMaximallyReturnedResults() {
            block4: {
                String resString = this.m_parameterFields.get(CmsListManager.N_MAX_RESULTS);
                if (null == resString) {
                    this.m_additionalParameters.get(ADDITIONAL_PARAM_MAX_RETURNED_RESULTS);
                }
                if (null != resString) {
                    try {
                        return Integer.valueOf(resString);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error((Object)("Ignoring invalid maxresults param " + resString + " in list-config."));
                    }
                }
            }
            return null;
        }

        public Map<String, String> getParameters() {
            return this.m_parameterFields;
        }

        public String getParameterValue(String key) {
            return this.m_parameterFields.get(key);
        }

        public String getSortOrder() {
            return this.getParameterValue(CmsListManager.N_SORT_ORDER);
        }

        public List<String> getTypes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.m_dislayTypes != null) {
                for (String displayType : this.m_dislayTypes) {
                    String type = displayType;
                    if (type.contains(":")) {
                        type = type.substring(0, type.indexOf(":"));
                    }
                    if (result.contains(type)) continue;
                    result.add(type);
                }
            }
            return result;
        }

        public boolean isShowExpired() {
            return Boolean.parseBoolean(this.m_parameterFields.get(CmsListManager.N_SHOW_EXPIRED));
        }

        public void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.m_additionalParameters = additionalParameters;
        }

        public void setBlacklist(List<CmsUUID> blacklist) {
            this.m_blacklist = blacklist;
        }

        public void setCategories(List<String> categories) {
            this.m_categories = categories;
        }

        public void setCategoryMode(CategoryMode categoryMode) {
            this.m_categoryMode = categoryMode;
        }

        public void setDateRestriction(I_CmsListDateRestriction restriction) {
            this.m_dateRestriction = restriction;
        }

        public void setDisplayTypes(List<String> displayTypes) {
            this.m_dislayTypes = displayTypes;
        }

        public void setFolders(List<String> folders) {
            this.m_folders = folders;
        }

        public void setGeoFilter(ListGeoFilterBean geoFilter) {
            this.m_geoFilter = geoFilter;
        }

        public void setParameterValue(String name, String value) {
            this.m_parameterFields.put(name, value);
        }

        public static class ListGeoFilterBean {
            private String m_coordinates;
            private String m_radius;

            public ListGeoFilterBean(String coordinates, String radius) {
                this.m_coordinates = coordinates;
                this.m_radius = radius;
            }

            public String getCoordinates() {
                return this.m_coordinates;
            }

            public String getRadius() {
                return this.m_radius;
            }
        }

        public static class ListCategoryFolderRestrictionBean {
            private List<String> m_categories;
            private List<String> m_folders;
            private CategoryMode m_categoryMode;

            public ListCategoryFolderRestrictionBean(List<String> categories, List<String> folders, CategoryMode categoryMode) {
                this.m_categories = categories == null ? Collections.emptyList() : categories;
                this.m_folders = folders == null ? Collections.emptyList() : folders;
                this.m_categoryMode = categoryMode == null ? CategoryMode.OR : categoryMode;
            }

            public String toString() {
                if (this.m_categories.isEmpty() && this.m_folders.isEmpty()) {
                    return "";
                }
                String result = "(";
                if (!this.m_categories.isEmpty()) {
                    result = result + "category_exact:(";
                    result = this.m_categories.size() > 1 ? result + (String)this.m_categories.stream().reduce((cat1, cat2) -> "\"" + cat1 + "\" " + (Object)((Object)this.m_categoryMode) + " \"" + cat2 + "\"").get() : result + "\"" + this.m_categories.get(0) + "\"";
                    result = result + ")";
                }
                if (!this.m_folders.isEmpty()) {
                    if (!this.m_categories.isEmpty()) {
                        result = result + " AND ";
                    }
                    result = result + "parent-folders:(";
                    result = this.m_folders.size() > 1 ? result + (String)this.m_folders.stream().reduce((f1, f2) -> "\"" + f1 + "\" OR \"" + f2 + "\"").get() : result + "\"" + this.m_folders.get(0) + "\"";
                    result = result + ")";
                }
                result = result + ")";
                return result;
            }
        }
    }

    public static enum CategoryMode {
        AND,
        OR;

    }
}

