/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.lists;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetRange;
import org.opencms.jsp.search.result.CmsSearchResultWrapper;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.lists.CmsListManager;
import org.opencms.util.CmsStringUtil;

public class CmsResultFacets
extends VerticalLayout {
    private static final Log LOG = CmsLog.getLog(CmsResultFacets.class.getName());
    private static final String SELECTED_STYLE = "bold";
    private static final long serialVersionUID = 7190928063356086124L;
    private CmsListManager m_manager;
    private Map<String, List<String>> m_selectedFieldFacets;
    private List<String> m_selectedFolders;
    private Map<String, List<String>> m_selectedRangeFacets;
    private boolean m_useFullPathCategories;

    public CmsResultFacets(CmsListManager manager) {
        this.m_manager = manager;
        this.m_selectedFieldFacets = new HashMap<String, List<String>>();
        this.m_selectedRangeFacets = new HashMap<String, List<String>>();
        this.m_selectedFolders = new ArrayList<String>();
        this.m_useFullPathCategories = true;
        this.addStyleName("v-scrollable");
        this.setMargin(true);
        this.setSpacing(true);
    }

    public void displayFacetResult(CmsSolrResultList solrResultList, CmsSearchResultWrapper resultWrapper) {
        Component dates;
        Component folders;
        this.removeAllComponents();
        Component categories = this.prepareCategoryFacets(solrResultList, resultWrapper);
        if (categories != null) {
            this.addComponent(categories);
        }
        if ((folders = this.prepareFolderFacets(solrResultList, resultWrapper)) != null) {
            this.addComponent(folders);
        }
        if ((dates = this.prepareDateFacets(solrResultList, resultWrapper)) != null) {
            this.addComponent(dates);
        }
    }

    public void resetFacets() {
        this.m_selectedFieldFacets.clear();
        this.m_selectedRangeFacets.clear();
    }

    protected Map<String, List<String>> getSelectedFieldFacets() {
        return this.m_selectedFieldFacets;
    }

    protected Map<String, List<String>> getSelectedRangeFactes() {
        return this.m_selectedRangeFacets;
    }

    boolean isSelected(Component component) {
        return component.getStyleName().contains(SELECTED_STYLE);
    }

    void resetFacetsAndSearch() {
        this.resetFacets();
        this.m_manager.search(this.m_selectedFieldFacets, this.m_selectedRangeFacets);
    }

    void selectFieldFacet(String field, String value) {
        this.m_selectedFieldFacets.clear();
        this.m_selectedRangeFacets.clear();
        this.m_selectedFieldFacets.put(field, Collections.singletonList(value));
        this.m_manager.search(this.m_selectedFieldFacets, this.m_selectedRangeFacets);
    }

    void selectRangeFacet(String field, String value) {
        this.m_selectedFieldFacets.clear();
        this.m_selectedRangeFacets.clear();
        this.m_selectedRangeFacets.put(field, Collections.singletonList(value));
        this.m_manager.search(this.m_selectedFieldFacets, this.m_selectedRangeFacets);
    }

    private Collection<FacetField.Count> filterFolderFacets(Collection<FacetField.Count> folderFacets) {
        String siteRoot = A_CmsUI.getCmsObject().getRequestContext().getSiteRoot();
        if (!siteRoot.endsWith("/")) {
            siteRoot = siteRoot + "/";
        }
        ArrayList<FacetField.Count> result = new ArrayList<FacetField.Count>();
        block0: for (FacetField.Count value : folderFacets) {
            if (!value.getName().startsWith(siteRoot) || value.getName().length() <= siteRoot.length()) continue;
            if (this.m_selectedFolders.isEmpty()) {
                result.add(value);
                continue;
            }
            for (String folder : this.m_selectedFolders) {
                if (!value.getName().startsWith(folder)) continue;
                result.add(value);
                continue block0;
            }
        }
        return result;
    }

    private String getCategoryLabel(String categoryPath) {
        CmsObject cms = A_CmsUI.getCmsObject();
        String result = "";
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(categoryPath)) {
            return result;
        }
        Locale locale = UI.getCurrent().getLocale();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            if (this.m_useFullPathCategories) {
                categoryPath = categoryPath.substring(0, categoryPath.length() - 1);
                String currentPath = "";
                boolean isFirst = true;
                for (String part : categoryPath.split("/")) {
                    currentPath = currentPath + part + "/";
                    CmsCategory cat = catService.localizeCategory(cms, catService.readCategory(cms, currentPath, "/"), locale);
                    if (!isFirst) {
                        result = result + "  /  ";
                    } else {
                        isFirst = false;
                    }
                    result = result + cat.getTitle();
                }
            } else {
                CmsCategory cat = catService.localizeCategory(cms, catService.readCategory(cms, categoryPath, "/"), locale);
                result = cat.getTitle();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error reading category " + categoryPath + "."), (Throwable)e);
        }
        return result;
    }

    private String getFolderLabel(String path) {
        CmsObject cms = A_CmsUI.getCmsObject();
        return cms.getRequestContext().removeSiteRoot(path);
    }

    private Component prepareCategoryFacets(CmsSolrResultList solrResultList, CmsSearchResultWrapper resultWrapper) {
        FacetField categoryFacets = solrResultList.getFacetField("category_exact");
        I_CmsSearchControllerFacetField facetController = resultWrapper.getController().getFieldFacets().getFieldFacetController().get("category_exact");
        if (categoryFacets != null && categoryFacets.getValueCount() > 0) {
            VerticalLayout catLayout = new VerticalLayout();
            for (final FacetField.Count value : categoryFacets.getValues()) {
                Button cat = new Button(this.getCategoryLabel(value.getName()) + " (" + value.getCount() + ")");
                cat.addStyleName("tiny");
                cat.addStyleName("borderless");
                Boolean selected = facetController.getState().getIsChecked().get(value.getName());
                if (selected != null && selected.booleanValue()) {
                    cat.addStyleName(SELECTED_STYLE);
                }
                cat.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        if (CmsResultFacets.this.isSelected(event.getComponent())) {
                            CmsResultFacets.this.resetFacetsAndSearch();
                        } else {
                            CmsResultFacets.this.selectFieldFacet("category_exact", value.getName());
                        }
                    }
                });
                catLayout.addComponent((Component)cat);
            }
            Panel catPanel = new Panel(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_FACET_CATEGORIES_0", new Object[0]));
            catPanel.setContent((Component)catLayout);
            return catPanel;
        }
        return null;
    }

    private Component prepareDateFacets(CmsSolrResultList solrResultList, CmsSearchResultWrapper resultWrapper) {
        RangeFacet dateFacets = resultWrapper.getRangeFacet().get("instancedate");
        I_CmsSearchControllerFacetRange facetController = resultWrapper.getController().getRangeFacets().getRangeFacetController().get("instancedate");
        DateTimeFormatter isoFormat = ISODateTimeFormat.dateTimeNoMillis();
        if (dateFacets != null && dateFacets.getCounts().size() > 0) {
            GridLayout dateLayout = new GridLayout();
            dateLayout.setWidth("100%");
            dateLayout.setColumns(6);
            String currentYear = null;
            int row = -2;
            for (final RangeFacet.Count value : dateFacets.getCounts()) {
                int targetRow;
                int targetColumn;
                DateTime parsedDateTime = isoFormat.parseDateTime(value.getValue());
                DateTime serverDateTime = parsedDateTime.withZone(DateTimeZone.getDefault());
                String serverYear = "" + serverDateTime.getYear();
                if (!serverYear.equals(currentYear)) {
                    dateLayout.setRows((row += 2) + 2);
                    currentYear = serverYear;
                    Label year = new Label(currentYear);
                    year.addStyleName("o-padding-horizontal");
                    dateLayout.addComponent((Component)year, 0, row, 5, row);
                    ++row;
                }
                int month = serverDateTime.getMonthOfYear() - 1;
                Button date = new Button(CmsListManager.MONTHS[month] + " (" + value.getCount() + ")");
                date.addStyleName("tiny");
                date.addStyleName("borderless");
                Boolean selected = facetController.getState().getIsChecked().get(value.getValue());
                if (selected != null && selected.booleanValue()) {
                    date.addStyleName(SELECTED_STYLE);
                }
                date.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        if (CmsResultFacets.this.isSelected(event.getComponent())) {
                            CmsResultFacets.this.resetFacetsAndSearch();
                        } else {
                            CmsResultFacets.this.selectRangeFacet("instancedate", value.getValue());
                        }
                    }
                });
                if (month < 6) {
                    targetColumn = month;
                    targetRow = row;
                } else {
                    targetColumn = month - 6;
                    targetRow = row + 1;
                    dateLayout.setRows(row + 2);
                }
                dateLayout.addComponent((Component)date, targetColumn, targetRow);
            }
            Panel datePanel = new Panel(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_FACET_DATE_0", new Object[0]));
            datePanel.setContent((Component)dateLayout);
            return datePanel;
        }
        return null;
    }

    private Component prepareFolderFacets(CmsSolrResultList solrResultList, CmsSearchResultWrapper resultWrapper) {
        FacetField folderFacets = solrResultList.getFacetField("parent-folders");
        I_CmsSearchControllerFacetField facetController = resultWrapper.getController().getFieldFacets().getFieldFacetController().get("parent-folders");
        if (folderFacets != null && folderFacets.getValueCount() > 0) {
            VerticalLayout folderLayout = new VerticalLayout();
            for (final FacetField.Count value : this.filterFolderFacets(folderFacets.getValues())) {
                Button folder = new Button(this.getFolderLabel(value.getName()) + " (" + value.getCount() + ")");
                folder.addStyleName("tiny");
                folder.addStyleName("borderless");
                Boolean selected = facetController.getState().getIsChecked().get(value.getName());
                if (selected != null && selected.booleanValue()) {
                    folder.addStyleName(SELECTED_STYLE);
                }
                folder.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        if (CmsResultFacets.this.isSelected(event.getComponent())) {
                            CmsResultFacets.this.resetFacetsAndSearch();
                        } else {
                            CmsResultFacets.this.selectFieldFacet("parent-folders", value.getName());
                        }
                    }
                });
                folderLayout.addComponent((Component)folder);
            }
            Panel folderPanel = new Panel(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_FACET_FOLDERS_0", new Object[0]));
            folderPanel.setContent((Component)folderLayout);
            return folderPanel;
        }
        return null;
    }
}

