/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.lists.daterestrictions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.opencms.ui.apps.lists.daterestrictions.I_CmsListDateRestriction;

public class CmsListDateRangeRestriction
implements I_CmsListDateRestriction {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Date m_from;
    private Date m_to;

    public CmsListDateRangeRestriction(Date fromDate, Date toDate) {
        this.m_from = fromDate;
        this.m_to = toDate;
    }

    @Override
    public String getRange() {
        return "[" + this.formatDate(this.m_from) + " TO " + this.formatDate(this.m_to) + "]";
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "*";
        }
        return DATE_FORMAT.format(date);
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

