/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.navigator.View;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.gwt.CmsCoreService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsAttributeAwareApp;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppView;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.modules.CmsImportTabForm;
import org.opencms.ui.apps.modules.CmsModuleExportDialog;
import org.opencms.ui.apps.modules.CmsModuleInfoDialog;
import org.opencms.ui.apps.modules.CmsModuleRow;
import org.opencms.ui.apps.modules.CmsModuleTable;
import org.opencms.ui.apps.modules.CmsSiteSelectDialog;
import org.opencms.ui.apps.modules.edit.CmsEditModuleForm;
import org.opencms.ui.components.CmsAppViewLayout;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsBasicReportPage;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;

public class CmsModuleApp
extends A_CmsAttributeAwareApp
implements I_CmsCachableApp {
    public static final String PARAM_MODULE = "module";
    private static final Log LOG = CmsLog.getLog(CmsModuleApp.class);
    private static final long serialVersionUID = 1L;
    private IdentityHashMap<A_CmsReportThread, String> m_labels = new IdentityHashMap();
    private Map<String, A_CmsReportThread> m_reports = Maps.newHashMap();

    public static void editModule(CmsModule module, boolean isNew, String caption, Runnable callback) {
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsEditModuleForm form = new CmsEditModuleForm(module, isNew, callback);
        window.setContent((Component)form);
        window.setCaption(caption);
        A_CmsUI.get().addWindow(window);
        window.center();
    }

    public static CmsMenuItemVisibilityMode visibilityCheckHasModule(String name) {
        if (OpenCms.getModuleManager().hasModule(name)) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    public void editModule(String moduleName) {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        CmsModuleApp.editModule(module, false, CmsVaadinUtils.getMessageText("GUI_MODULES_TITLE_EDIT_MODULE_1", module.getName()), this::reload);
    }

    public void editNewModule(Runnable callback) {
        CmsModule module = new CmsModule();
        module.setSite("/");
        CmsModuleApp.editModule(module, true, CmsVaadinUtils.getMessageText("GUI_MODULES_TITLE_NEW_MODULE_0", new Object[0]), callback);
    }

    public List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        ArrayList result = Lists.newArrayList();
        result.add(new ModuleInfoEntry());
        result.add(new EditModuleEntry());
        result.add(new DeleteModuleEntry());
        result.add(new ExportModuleEntry());
        result.add(new ExplorerEntry());
        return result;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(updatedItems -> {});
        super.initUI(context);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public void onRestoreFromCache() {
    }

    @Override
    public void onStateChange(String state) {
        View view = CmsAppWorkplaceUi.get().getCurrentView();
        ((CmsAppView)view).setCacheStatus(CmsAppView.CacheStatus.cache);
        super.onStateChange(state);
    }

    public void openModuleInfo(Set<String> name) {
        new ModuleInfoEntry().executeAction(name);
    }

    public void openReport(String newState, A_CmsReportThread thread, String label) {
        this.setReport(newState, thread);
        this.m_labels.put(thread, label);
        this.openSubView(newState, true);
    }

    public void setReport(String key, A_CmsReportThread report) {
        this.m_reports.put(key, report);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        String noParamState = state.replaceFirst("!!.*$", "");
        ArrayList tokens = Lists.newArrayList();
        String appId = "modules";
        tokens.add(appId);
        tokens.addAll(Arrays.asList(noParamState.split("/")));
        LinkedHashMap<String, String> breadcrumbs = new LinkedHashMap<String, String>();
        ArrayList currentPath = Lists.newArrayList();
        breadcrumbs.put(appId, appId);
        String lastKey = appId;
        for (int i = 0; i < tokens.size(); ++i) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)tokens.get(i))) continue;
            currentPath.add((String)tokens.get(i));
            String key = CmsStringUtil.listAsString(currentPath, "/");
            String text = null;
            text = ((String)tokens.get(i)).equals(appId) ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_MAIN_0", new Object[0]) : (((String)tokens.get(i)).equals("delete") ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_DELETE_MODULE_0", new Object[0]) : (((String)tokens.get(i)).equals("export") ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_EXPORT_MODULE_0", new Object[0]) : (((String)tokens.get(i)).equals("import") ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_IMPORT_HTTP_0", new Object[0]) : (((String)tokens.get(i)).equals("server-import") ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_IMPORT_SERVER_0", new Object[0]) : (((String)tokens.get(i)).equals("report") ? CmsVaadinUtils.getMessageText("GUI_MODULES_NAV_REPORT_0", new Object[0]) : (String)tokens.get(i))))));
            breadcrumbs.put(key, text);
            lastKey = key;
        }
        String lastLabel = (String)breadcrumbs.remove(lastKey);
        breadcrumbs.put("", lastLabel);
        return breadcrumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        if (state.equals("import")) {
            return new CmsImportTabForm(this, this::reload);
        }
        if (state.equals("import/report") || state.equals("delete") || state.equals("export")) {
            String label = this.getReportLabel(state);
            CmsBasicReportPage reportForm = new CmsBasicReportPage(label, this.m_reports.get(state), new Runnable(){

                @Override
                public void run() {
                    CmsModuleApp.this.openSubView("", true);
                }
            });
            reportForm.setHeight("100%");
            return reportForm;
        }
        return this.getModuleTable();
    }

    protected Component getModuleTable() {
        ArrayList rows = Lists.newArrayList();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            CmsModuleRow row = new CmsModuleRow(module);
            rows.add(row);
        }
        CmsModuleTable<CmsModuleRow> table = new CmsModuleTable<CmsModuleRow>(this, CmsModuleRow.class, rows);
        return table;
    }

    protected String getReportLabel(String state) {
        return this.m_labels.get(this.m_reports.get(state));
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected void reload() {
        A_CmsUI.get().reload();
    }

    @Override
    protected void updateAppAttributes(Map<String, Object> attributes) {
        super.updateAppAttributes(attributes);
        this.m_uiContext.clearToolbarButtons();
        List buttons = (List)attributes.get("buttons");
        if (buttons != null) {
            buttons.add(0, CmsAppViewLayout.createPublishButton(changes -> {}));
            for (Component button : buttons) {
                this.m_uiContext.addToolbarButton(button);
            }
        }
    }

    class ModuleInfoEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        ModuleInfoEntry() {
        }

        @Override
        public void executeAction(Set<String> module) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            CmsModuleInfoDialog typeList = new CmsModuleInfoDialog(module.iterator().next(), CmsModuleApp.this::editModule);
            window.setContent((Component)typeList);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_MODULES_TYPES_FOR_MODULE_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
            window.center();
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MODULES_CONTEXTMENU_LIST_TYPES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsModuleApp.visibilityCheckHasModule(context.iterator().next());
        }
    }

    class ExportModuleEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExportModuleEntry() {
        }

        @Override
        public void executeAction(final Set<String> context) {
            final CmsObject cms = A_CmsUI.getCmsObject();
            String moduleName = context.iterator().next();
            String handlerDesc = CmsVaadinUtils.getMessageText("GUI_MODULES_REPORT_EXPORT_1", moduleName);
            final CmsModuleImportExportHandler handler = CmsModuleImportExportHandler.getExportHandler(cms, OpenCms.getModuleManager().getModule(moduleName), handlerDesc);
            final A_CmsReportThread thread = new A_CmsReportThread(cms, "Export module " + moduleName){

                @Override
                public String getReportUpdate() {
                    return this.getReport().getReportUpdate();
                }

                @Override
                public void run() {
                    this.initHtmlReport(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                    try {
                        OpenCms.getImportExportManager().exportData(cms, handler, this.getReport());
                    }
                    catch (Exception e) {
                        this.getReport().println(e);
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            };
            CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
            if (module.hasModuleResourcesWithUndefinedSite()) {
                CmsSiteSelectDialog.openDialogInWindow(new CmsSiteSelectDialog.I_Callback(){

                    @Override
                    public void onCancel() {
                    }

                    @Override
                    public void onSiteSelect(String site) {
                        cms.getRequestContext().setSiteRoot(site);
                        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                        window.setCaption(CmsVaadinUtils.getMessageText("GUI_MODULES_REPORT_EXPORT_1", context));
                        CmsModuleExportDialog dialog = new CmsModuleExportDialog(handler, thread, window);
                        window.setContent((Component)dialog);
                        A_CmsUI.get().addWindow(window);
                    }
                }, CmsVaadinUtils.getMessageText("GUI_MODULES_TITLE_SITE_SELECT_0", new Object[0]));
            } else {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                window.setHeight("500px");
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_MODULES_REPORT_EXPORT_1", context));
                CmsModuleExportDialog dialog = new CmsModuleExportDialog(handler, thread, window);
                window.setContent((Component)dialog);
                A_CmsUI.get().addWindow(window);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MODULES_CONTEXTMENU_EXPORT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsModuleApp.visibilityCheckHasModule(context.iterator().next());
        }
    }

    static class ExplorerEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExplorerEntry() {
        }

        @Override
        public void executeAction(Set<String> context) {
            String path = this.getModuleFolder(context.iterator().next());
            if (path != null) {
                String link = CmsCoreService.getVaadinWorkplaceLink(A_CmsUI.getCmsObject(), path);
                A_CmsUI.get().getPage().setLocation(link);
                A_CmsUI.get().getPage().reload();
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MODULES_CONTEXTMENU_EXPLORER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            String moduleName = context.iterator().next();
            if (this.getModuleFolder(moduleName) != null) {
                return CmsModuleApp.visibilityCheckHasModule(moduleName);
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }

        private String getModuleFolder(String moduleName) {
            CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
            if (module != null) {
                for (String resource : module.getResources()) {
                    if (!CmsStringUtil.comparePaths("/system/modules/" + moduleName, resource)) continue;
                    return resource;
                }
            }
            return null;
        }
    }

    class EditModuleEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EditModuleEntry() {
        }

        @Override
        public void executeAction(Set<String> context) {
            CmsModuleApp.this.editModule(context.iterator().next());
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MODULES_CONTEXTMENU_EDIT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsModuleApp.visibilityCheckHasModule(context.iterator().next());
        }
    }

    class DeleteModuleEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        DeleteModuleEntry() {
        }

        @Override
        public void executeAction(final Set<String> context) {
            try {
                final String moduleName = context.iterator().next();
                final CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                final CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
                Runnable okAction = new Runnable(){

                    @Override
                    public void run() {
                        final A_CmsReportThread thread = new A_CmsReportThread(cms, "Delete module " + context){

                            @Override
                            public String getReportUpdate() {
                                return this.getReport().getReportUpdate();
                            }

                            @Override
                            public void run() {
                                this.initHtmlReport(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                                try {
                                    OpenCms.getModuleManager().deleteModule(cms, moduleName, false, this.getReport());
                                }
                                catch (Exception e) {
                                    this.getReport().println(e);
                                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        };
                        if (module.hasModuleResourcesWithUndefinedSite()) {
                            CmsSiteSelectDialog.openDialogInWindow(new CmsSiteSelectDialog.I_Callback(){

                                @Override
                                public void onCancel() {
                                }

                                @Override
                                public void onSiteSelect(String site) {
                                    cms.getRequestContext().setSiteRoot(site);
                                    CmsModuleApp.this.openReport("delete", thread, CmsVaadinUtils.getMessageText("GUI_MODULES_REPORT_DELETE_MODULE_1", context));
                                }
                            }, CmsVaadinUtils.getMessageText("GUI_MODULES_TITLE_SITE_SELECT_0", new Object[0]));
                        } else {
                            CmsModuleApp.this.openReport("delete", thread, CmsVaadinUtils.getMessageText("GUI_MODULES_REPORT_DELETE_MODULE_1", context));
                        }
                    }
                };
                CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_MODULES_CONFIRM_DELETE_TITLE_1", context), CmsVaadinUtils.getMessageText("GUI_MODULES_DELETE_CONFIRMATION_0", new Object[0]), okAction);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MODULES_CONTEXTMENU_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsModuleApp.visibilityCheckHasModule(context.iterator().next());
        }
    }

    public static class States {
        public static final String DELETE_REPORT = "delete";
        public static final String EXPORT_REPORT = "export";
        public static final String IMPORT = "import";
        public static final String IMPORT_REPORT = "import/report";
        public static final String MAIN = "";
    }

    public static class Icons {
        public static Resource APP = new CmsCssIcon("oc-icon-32-module");
        public static Resource IMPORT = FontOpenCms.UPLOAD;
        public static final Resource LIST_ICON = new CmsCssIcon("oc-icon-24-module");
        public static Resource RESINFO_ICON = new CmsCssIcon("oc-icon-24-module");
    }

    public static class Attributes {
        public static final String BUTTONS = "buttons";
    }
}

