/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.modules.CmsModuleApp;

public class CmsModuleAppConfiguration
extends A_CmsWorkplaceAppConfiguration {
    public static final String APP_ID = "modules";

    @Override
    public String getAppCategory() {
        return "Administration";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        return new CmsModuleApp();
    }

    @Override
    public String getButtonStyle() {
        return null;
    }

    @Override
    public Resource getIcon() {
        return CmsModuleApp.Icons.APP;
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_MODULES_APP_NAME_0");
    }

    @Override
    public CmsRole getRequiredRole() {
        return CmsRole.DATABASE_MANAGER;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        if (!OpenCms.getRoleManager().hasRole(cms, this.getRequiredRole())) {
            return CmsAppVisibilityStatus.INVISIBLE;
        }
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return new CmsAppVisibilityStatus(true, false, Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_MODULES_ONLINE_DISABLED_0"));
        }
        return CmsAppVisibilityStatus.ACTIVE;
    }
}

