/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptAll;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.server.StreamVariable;
import com.vaadin.ui.Button;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.Html5File;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Upload;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.modules.A_CmsModuleImportForm;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.modules.CmsModuleImportFile;
import org.opencms.ui.components.CmsAutoItemCreatingComboBox;
import org.opencms.util.CmsStringUtil;

public class CmsModuleImportForm
extends A_CmsModuleImportForm {
    private static final Log LOG = CmsLog.getLog(CmsModuleImportForm.class);
    private static final long serialVersionUID = 1L;
    private DragAndDropWrapper m_dnd;
    protected Button m_cancel;
    protected Button m_ok;
    protected CmsAutoItemCreatingComboBox m_siteSelect;
    protected Upload m_upload;
    protected Label m_uploadLabel;

    public CmsModuleImportForm(CmsModuleApp app, VerticalLayout start, VerticalLayout report, Runnable run) {
        super(app, start, report, run);
        this.m_upload.setImmediate(true);
        this.m_dnd.setDropHandler(new DropHandler(){
            private static final long serialVersionUID = 1L;

            public void drop(DragAndDropEvent event) {
                DragAndDropWrapper.WrapperTransferable transfer = (DragAndDropWrapper.WrapperTransferable)event.getTransferable();
                Html5File[] files = transfer.getFiles();
                if (files.length == 1) {
                    final Html5File file = files[0];
                    CmsModuleImportForm.this.m_uploadLabel.setValue(file.getFileName());
                    file.setStreamVariable(new StreamVariable(){
                        private static final long serialVersionUID = 1L;

                        public OutputStream getOutputStream() {
                            String path = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getWebInfRfsPath(), "packages/modules", CmsModuleImportForm.this.processFileName(file.getFileName()));
                            CmsModuleImportForm.this.m_importFile = new CmsModuleImportFile(path);
                            try {
                                return new FileOutputStream(CmsModuleImportForm.this.m_importFile.getPath());
                            }
                            catch (FileNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public boolean isInterrupted() {
                            return false;
                        }

                        public boolean listenProgress() {
                            return false;
                        }

                        public void onProgress(StreamVariable.StreamingProgressEvent evt) {
                        }

                        public void streamingFailed(StreamVariable.StreamingErrorEvent evt) {
                            LOG.info((Object)("Upload streaming failed: " + evt.getFileName()), (Throwable)evt.getException());
                        }

                        public void streamingFinished(StreamVariable.StreamingEndEvent evt) {
                            CmsModuleImportForm.this.validateModuleFile();
                        }

                        public void streamingStarted(StreamVariable.StreamingStartEvent evt) {
                            CmsModuleImportForm.this.m_ok.setEnabled(false);
                            CmsModuleImportForm.this.m_siteSelect.setEnabled(true);
                        }
                    });
                }
            }

            public AcceptCriterion getAcceptCriterion() {
                return AcceptAll.get();
            }
        });
        this.m_upload.addStartedListener(new Upload.StartedListener(){
            private static final long serialVersionUID = 1L;

            public void uploadStarted(Upload.StartedEvent event) {
                CmsModuleImportForm.this.m_ok.setEnabled(false);
                CmsModuleImportForm.this.m_siteSelect.setEnabled(true);
                String name = event.getFilename();
                name = CmsModuleImportForm.this.processFileName(name);
                CmsModuleImportForm.this.m_uploadLabel.setValue(name);
            }
        });
        this.m_upload.addChangeListener(new Upload.ChangeListener(){
            private static final long serialVersionUID = 1L;

            public void filenameChanged(Upload.ChangeEvent event) {
                CmsModuleImportForm.this.m_ok.setEnabled(false);
                CmsModuleImportForm.this.m_siteSelect.setEnabled(true);
                String name = CmsModuleImportForm.this.processFileName(event.getFilename());
                CmsModuleImportForm.this.m_uploadLabel.setValue(name);
            }
        });
        this.m_upload.setReceiver(new Upload.Receiver(){
            private static final long serialVersionUID = 1L;

            public OutputStream receiveUpload(String filename, String mimeType) {
                String path = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getWebInfRfsPath(), "packages/modules", CmsModuleImportForm.this.processFileName(filename));
                File rfsFile = new File(path);
                rfsFile.getParentFile().mkdirs();
                CmsModuleImportForm.this.m_importFile = new CmsModuleImportFile(path);
                try {
                    return new FileOutputStream(CmsModuleImportForm.this.m_importFile.getPath());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.m_upload.addSucceededListener(new Upload.SucceededListener(){
            private static final long serialVersionUID = 1L;

            public void uploadSucceeded(Upload.SucceededEvent event) {
                CmsModuleImportForm.this.validateModuleFile();
            }
        });
    }

    @Override
    protected Button getCancelButton() {
        return this.m_cancel;
    }

    @Override
    protected Button getOkButton() {
        return this.m_ok;
    }

    @Override
    protected CmsAutoItemCreatingComboBox getSiteSelector() {
        return this.m_siteSelect;
    }
}

