/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.modules.CmsImportTabForm;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.modules.CmsModuleRow;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.util.table.CmsBeanTableBuilder;

public class CmsModuleTable<T>
extends Table {
    private static final long serialVersionUID = 1L;
    protected CmsModuleApp m_app;
    protected CmsBeanTableBuilder<T> m_tableBuilder;
    private CmsInfoButton m_counter;
    protected CmsContextMenu m_menu = new CmsContextMenu();
    private TextField m_searchBox = new TextField();

    public CmsModuleTable(CmsModuleApp app, Class<T> rowType, List<T> rows) {
        this.m_menu.setAsTableContextMenu(this);
        this.m_app = app;
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsModuleTable.this.onItemClick(event);
            }
        });
        this.m_searchBox.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                String filterString = event.getText();
                Container.Filterable container = (Container.Filterable)CmsModuleTable.this.getContainerDataSource();
                container.removeAllContainerFilters();
                container.addContainerFilter(CmsModuleTable.this.m_tableBuilder.getDefaultFilter(filterString));
                if (CmsModuleTable.this.getValue() != null) {
                    CmsModuleTable.this.setCurrentPageFirstItemId(CmsModuleTable.this.getValue());
                }
            }
        });
        this.m_searchBox.setIcon((Resource)FontOpenCms.FILTER);
        this.m_searchBox.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_searchBox.addStyleName("inline-icon");
        this.m_searchBox.setWidth("200px");
        HashMap attributes = Maps.newHashMap();
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSpacing(true);
        hl.addComponent((Component)this.m_searchBox);
        attributes.put("ATTR_INFO_COMPONENT", hl);
        attributes.put("ATTR_MAIN_HEIGHT_FULL", Boolean.TRUE);
        ArrayList buttons = Lists.newArrayList();
        Button addModule = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_MODULES_BUTTON_NEW_MODULE_0", new Object[0]));
        addModule.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsModuleTable.this.m_app.editNewModule(CmsModuleTable.this::reload);
            }
        });
        buttons.add(addModule);
        Button importButton = CmsToolBar.createButton(CmsModuleApp.Icons.IMPORT, CmsVaadinUtils.getMessageText("GUI_MODULES_BUTTON_IMPORT_0", new Object[0]));
        importButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsModuleTable.this.importModule();
            }
        });
        buttons.add(importButton);
        this.m_counter = new CmsInfoButton();
        this.m_counter.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_MODULES_STATISTICS_0", new Object[0]));
        this.m_counter.setDescription(CmsVaadinUtils.getMessageText("GUI_MODULES_STATISTICS_0", new Object[0]));
        buttons.add(this.m_counter);
        attributes.put("buttons", buttons);
        this.setData(attributes);
        CmsBeanTableBuilder<T> builder = CmsBeanTableBuilder.newInstance(rowType);
        this.m_tableBuilder = builder;
        builder.buildTable(this, rows);
        this.setCellStyleGenerator(builder.getDefaultCellStyleGenerator());
        this.setItemIconPropertyId("icon");
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setSelectable(true);
        this.setMultiSelect(false);
        this.sort(new Object[]{"name"}, new boolean[]{true});
        this.updateCounter();
    }

    public void importModule() {
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsImportTabForm form = new CmsImportTabForm(this.m_app, this::reload);
        window.setContent((Component)form);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_MODULES_IMPORT_TITLE_0", new Object[0]));
        A_CmsUI.get().addWindow(window);
        window.center();
    }

    public void reload() {
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        BeanItemContainer container = (BeanItemContainer)this.getContainerDataSource();
        container.removeAllItems();
        ArrayList newRows = Lists.newArrayList();
        for (CmsModule module : modules) {
            CmsModuleRow row = new CmsModuleRow(module);
            newRows.add(row);
        }
        container.addAll((Collection)newRows);
        this.sort();
        this.updateCounter();
    }

    protected void onItemClick(ItemClickEvent event) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
            CmsModuleRow moduleRow = (CmsModuleRow)event.getItemId();
            this.select(moduleRow);
            nameSet.add(moduleRow.getModule().getName());
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                this.select(moduleRow);
                this.m_menu.setEntries(this.m_app.getMenuEntries(), nameSet);
                this.m_menu.openForTable(event, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && "name".equals(event.getPropertyId())) {
                this.m_app.openModuleInfo(nameSet);
            }
        }
    }

    private void updateCounter() {
        this.m_counter.replaceData(Collections.singletonMap(CmsVaadinUtils.getMessageText("GUI_MODULES_STATISTICS_ROW_COUNT_0", new Object[0]), String.valueOf(this.getContainerDataSource().size())));
    }
}

