/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.TextField;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.projects.CmsProjectsTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsRemovableFormRow;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsEditProjectForm
extends CmsBasicDialog {
    private static Log LOG = CmsLog.getLog(CmsEditProjectForm.class.getName());
    private static final long serialVersionUID = 2345799706922671537L;
    TextField m_fieldOU;
    private Button m_addResource;
    private Button m_cancel;
    private CheckBox m_fieldDeleteAfterPublish;
    private TextField m_fieldDescription;
    private CmsPrincipalSelect m_fieldManager;
    private TextField m_fieldName;
    private Field<?>[] m_fields;
    private CmsPrincipalSelect m_fieldUser;
    private CmsProjectsTable m_table;
    private Button m_ok;
    private CmsProject m_project;
    private FormLayout m_resources;
    private ResourceValidator m_resourceValidator;
    private Window m_window;

    public CmsEditProjectForm(CmsProjectsTable table, CmsUUID projectId, Window window) {
        this(table, window);
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            this.m_project = cms.readProject(projectId);
            this.displayResourceInfoDirectly(Collections.singletonList(new CmsResourceInfo(this.m_project.getName(), this.m_project.getDescription(), (Resource)new CmsCssIcon("oc-icon-24-project"))));
            this.m_fieldName.setValue(this.m_project.getName());
            this.m_fieldName.setEnabled(false);
            this.m_fieldDescription.setValue(this.m_project.getDescription());
            this.m_fieldUser.setValue(cms.readGroup(this.m_project.getGroupId()).getName());
            this.m_fieldManager.setValue(cms.readGroup(this.m_project.getManagerGroupId()).getName());
            try {
                CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, this.m_project.getOuFqn());
                this.m_fieldOU.setValue(ou.getDisplayName(UI.getCurrent().getLocale()));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_fieldOU.setValue(null);
            }
            this.m_fieldOU.setEnabled(false);
            for (String resName : cms.readProjectResources(this.m_project)) {
                this.addResourceField(resName);
            }
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    public CmsEditProjectForm(CmsProjectsTable table, Window window) {
        this.m_window = window;
        this.m_table = table;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_resourceValidator = new ResourceValidator();
        this.m_fieldManager.setWidgetType(CmsPrincipalSelect.WidgetType.groupwidget);
        this.m_fieldManager.setRealPrincipalsOnly(true);
        this.m_fieldUser.setWidgetType(CmsPrincipalSelect.WidgetType.groupwidget);
        this.m_fieldUser.setRealPrincipalsOnly(true);
        try {
            CmsOrganizationalUnit ou = OpenCms.getRoleManager().getOrgUnitsForRole(A_CmsUI.getCmsObject(), CmsRole.PROJECT_MANAGER, true).get(0);
            this.m_fieldOU.setValue(ou.getName());
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_fieldOU.setValue(null);
        }
        this.m_fieldOU.setImmediate(true);
        this.m_fieldOU.addValidator((Validator)new OUValidator());
        this.m_fieldOU.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditProjectForm.this.validateResourceFields();
            }
        });
        this.m_addResource.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditProjectForm.this.addResourceField(null);
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditProjectForm.this.submit();
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditProjectForm.this.cancel();
            }
        });
        this.m_fields = new Field[]{this.m_fieldName, this.m_fieldDescription, this.m_fieldManager, this.m_fieldUser, this.m_fieldOU};
    }

    void addResourceField(String value) {
        CmsPathSelectField field = new CmsPathSelectField();
        field.setUseRootPaths(true);
        if (value != null) {
            field.setValue(value);
        }
        field.addValidator(this.m_resourceValidator);
        CmsRemovableFormRow<CmsPathSelectField> row = new CmsRemovableFormRow<CmsPathSelectField>(field, CmsVaadinUtils.getMessageText("GUI_PROJECTS_REMOVE_RESOURCE_0", new Object[0]));
        row.setCaption(CmsVaadinUtils.getMessageText("GUI_PROJECTS_RESOURCE_0", new Object[0]));
        row.setDescription(CmsVaadinUtils.getMessageText("GUI_PROJECTS_RESOURCE_HELP_0", new Object[0]));
        this.m_resources.addComponent(row);
    }

    void cancel() {
        this.m_window.close();
    }

    void submit() {
        if (this.isValid()) {
            if (this.m_project == null) {
                this.createProject();
            } else {
                this.saveProject();
            }
            this.m_table.loadProjects();
            this.m_window.close();
        }
    }

    void validateResourceFields() {
        for (Component c : this.m_resources) {
            if (!(c instanceof CmsRemovableFormRow)) continue;
            ((CmsPathSelectField)((CmsRemovableFormRow)c).getInput()).validate();
        }
    }

    private void createProject() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            String name = "/";
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_fieldOU.getValue())) {
                name = CmsStringUtil.joinPaths(name, (String)this.m_fieldOU.getValue());
            }
            name = CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_fieldName.getValue()) ? CmsStringUtil.joinPaths(name, (String)this.m_fieldName.getValue()) : CmsStringUtil.joinPaths(name, "/");
            this.m_project = cms.createProject(name, (String)this.m_fieldDescription.getValue(), this.m_fieldUser.getValue(), this.m_fieldManager.getValue(), (Boolean)this.m_fieldDeleteAfterPublish.getValue() != false ? CmsProject.PROJECT_TYPE_TEMPORARY : CmsProject.PROJECT_TYPE_NORMAL);
            this.updateProjectResources();
        }
        catch (Throwable t) {
            CmsErrorDialog.showErrorDialog(t);
        }
    }

    private Set<String> getResourcePaths() {
        HashSet<String> resources = new HashSet<String>();
        for (Component c : this.m_resources) {
            String value;
            if (!(c instanceof CmsRemovableFormRow) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(value = ((CmsPathSelectField)((CmsRemovableFormRow)c).getInput()).getValue())) continue;
            resources.add(value);
        }
        return resources;
    }

    private boolean isValid() {
        for (Field<?> field : this.m_fields) {
            if (field.isValid()) continue;
            field.focus();
            return false;
        }
        for (Component c : this.m_resources) {
            if (!(c instanceof CmsRemovableFormRow) || ((CmsPathSelectField)((CmsRemovableFormRow)c).getInput()).isValid()) continue;
            ((CmsPathSelectField)((CmsRemovableFormRow)c).getInput()).focus();
            return false;
        }
        return true;
    }

    private void saveProject() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            this.m_project.setDescription((String)this.m_fieldDescription.getValue());
            this.m_project.setGroupId(cms.readGroup(this.m_fieldUser.getValue()).getId());
            this.m_project.setManagerGroupId(cms.readGroup(this.m_fieldManager.getValue()).getId());
            this.m_project.setDeleteAfterPublishing((Boolean)this.m_fieldDeleteAfterPublish.getValue());
            cms.writeProject(this.m_project);
            this.updateProjectResources();
        }
        catch (Throwable t) {
            CmsErrorDialog.showErrorDialog(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectResources() throws CmsException {
        CmsObject cms = A_CmsUI.getCmsObject();
        Set<String> resourceRootPaths = this.getResourcePaths();
        CmsProject currentProject = cms.getRequestContext().getCurrentProject();
        cms.getRequestContext().setCurrentProject(this.m_project);
        String currentSite = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("");
            for (String resName : cms.readProjectResources(this.m_project)) {
                if (resourceRootPaths.contains(resName)) continue;
                cms.removeResourceFromProject(resName);
            }
            List<String> currentResNames = cms.readProjectResources(this.m_project);
            for (String resName : resourceRootPaths) {
                if (currentResNames.contains(resName)) continue;
                cms.copyResourceToProject(resName);
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(currentSite);
            cms.getRequestContext().setCurrentProject(currentProject);
        }
    }

    protected class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        protected ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value) && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)CmsEditProjectForm.this.m_fieldOU.getValue())) {
                try {
                    List<CmsResource> ouRes = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(A_CmsUI.getCmsObject(), (String)CmsEditProjectForm.this.m_fieldOU.getValue());
                    String resPath = (String)value;
                    for (CmsResource res : ouRes) {
                        if (!resPath.startsWith(res.getRootPath())) continue;
                        return;
                    }
                    throw new Validator.InvalidValueException("The resource path " + value + " is not part of the project OU '" + (String)CmsEditProjectForm.this.m_fieldOU.getValue() + "'.");
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
        }
    }

    protected class OUValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        protected OUValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (CmsEditProjectForm.this.m_fieldOU.isEnabled() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value)) {
                try {
                    OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), (String)value);
                }
                catch (CmsException e) {
                    throw new Validator.InvalidValueException(e.getLocalizedMessage(UI.getCurrent().getLocale()));
                }
            }
        }
    }
}

