/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.projects.CmsEditProjectForm;
import org.opencms.ui.apps.projects.CmsProjectManager;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsProjectsTable
extends Table {
    public static final String PROP_DATE_CREATED = "dateCreated";
    public static final String PROP_DESCRIPTION = "descrition";
    public static final String PROP_ICON = "icon";
    public static final String PROP_ID = "id";
    public static final String PROP_MANAGER = "manager";
    public static final String PROP_NAME = "name";
    public static final String PROP_ORG_UNIT = "orgUnit";
    public static final String PROP_OWNER = "owner";
    public static final String PROP_RESOURCES = "resources";
    public static final String PROP_USER = "user";
    protected static Log LOG = CmsLog.getLog(CmsProjectsTable.class.getName());
    private static final long serialVersionUID = 1540265836332964510L;
    IndexedContainer m_container;
    CmsProjectManager m_manager;
    CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<CmsUUID>>> m_menuEntries;

    public CmsProjectsTable(CmsProjectManager manager) {
        this.m_manager = manager;
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)PROP_ID, CmsUUID.class, null);
        this.m_container.addContainerProperty((Object)PROP_ICON, Resource.class, (Object)new CmsCssIcon("oc-icon-24-project"));
        this.m_container.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_DESCRIPTION, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_ORG_UNIT, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_OWNER, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_MANAGER, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_USER, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_DATE_CREATED, Date.class, null);
        this.m_container.addContainerProperty((Object)PROP_RESOURCES, ProjectResources.class, null);
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnHeader(PROP_NAME, CmsVaadinUtils.getMessageText("GUI_PROJECTS_NAME_0", new Object[0]));
        this.setColumnHeader(PROP_DESCRIPTION, CmsVaadinUtils.getMessageText("GUI_PROJECTS_DESCRIPTION_0", new Object[0]));
        this.setColumnHeader(PROP_ORG_UNIT, CmsVaadinUtils.getMessageText("GUI_PROJECTS_ORG_UNIT_0", new Object[0]));
        this.setColumnHeader(PROP_OWNER, CmsVaadinUtils.getMessageText("GUI_PROJECTS_OWNER_0", new Object[0]));
        this.setColumnHeader(PROP_MANAGER, CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_GROUP_0", new Object[0]));
        this.setColumnHeader(PROP_USER, CmsVaadinUtils.getMessageText("GUI_PROJECTS_USER_GROUP_0", new Object[0]));
        this.setColumnHeader(PROP_DATE_CREATED, CmsVaadinUtils.getMessageText("GUI_PROJECTS_DATE_CREATED_0", new Object[0]));
        this.setColumnHeader(PROP_RESOURCES, CmsVaadinUtils.getMessageText("GUI_PROJECTS_RESOURCES_0", new Object[0]));
        this.setColumnWidth(null, 40);
        this.setColumnExpandRatio(PROP_NAME, 2.0f);
        this.setColumnExpandRatio(PROP_DESCRIPTION, 2.0f);
        this.setColumnExpandRatio(PROP_RESOURCES, 2.0f);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsProjectsTable.this.onItemClick(event);
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (CmsProjectsTable.PROP_NAME.equals(propertyId)) {
                    return "o-hover-column";
                }
                return null;
            }
        });
    }

    public static void showProjectResources(Item item) {
        VerticalLayout layout = new VerticalLayout();
        ProjectResources pr = (ProjectResources)item.getItemProperty((Object)PROP_RESOURCES).getValue();
        for (String path : pr) {
            layout.addComponent((Component)new Label(path));
        }
        layout.setSpacing(false);
        CmsBasicDialog dialog = new CmsBasicDialog();
        dialog.setContent((Component)layout);
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        String ou = "" + item.getItemProperty((Object)PROP_ORG_UNIT).getValue();
        String project = "" + item.getItemProperty((Object)PROP_NAME).getValue();
        String caption = CmsVaadinUtils.getMessageText("GUI_PROJECTS_RESOURCES_POPUP_CAPTION_2", project, ou);
        window.setCaption(caption);
        window.setContent((Component)dialog);
        CmsAppWorkplaceUi.get().addWindow(window);
    }

    public void filterTable(String filter) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_NAME, filter, true, false), new SimpleStringFilter((Object)PROP_DESCRIPTION, filter, true, false)}));
        }
        if (this.getValue() != null & !((Set)this.getValue()).isEmpty()) {
            this.setCurrentPageFirstItemId(((Set)this.getValue()).iterator().next());
        }
    }

    public void loadProjects() {
        CmsObject cms = A_CmsUI.getCmsObject();
        Locale locale = UI.getCurrent().getLocale();
        this.m_container.removeAllItems();
        boolean isMultiOU = false;
        try {
            isMultiOU = !OpenCms.getOrgUnitManager().getOrganizationalUnits(cms, "", true).isEmpty();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (isMultiOU) {
            this.setVisibleColumns(new Object[]{PROP_NAME, PROP_DESCRIPTION, PROP_ORG_UNIT, PROP_OWNER, PROP_MANAGER, PROP_USER, PROP_DATE_CREATED, PROP_RESOURCES});
        } else {
            this.setVisibleColumns(new Object[]{PROP_NAME, PROP_DESCRIPTION, PROP_OWNER, PROP_MANAGER, PROP_USER, PROP_DATE_CREATED, PROP_RESOURCES});
        }
        try {
            List<CmsProject> projects = OpenCms.getOrgUnitManager().getAllManageableProjects(cms, "", true);
            for (CmsProject project : projects) {
                Item item = this.m_container.addItem((Object)project.getUuid());
                item.getItemProperty((Object)PROP_ID).setValue((Object)project.getUuid());
                item.getItemProperty((Object)PROP_NAME).setValue((Object)project.getSimpleName());
                item.getItemProperty((Object)PROP_DESCRIPTION).setValue((Object)project.getDescription());
                try {
                    item.getItemProperty((Object)PROP_ORG_UNIT).setValue((Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale));
                    item.getItemProperty((Object)PROP_OWNER).setValue((Object)cms.readUser(project.getOwnerId()).getName());
                    item.getItemProperty((Object)PROP_MANAGER).setValue((Object)cms.readGroup(project.getManagerGroupId()).getSimpleName());
                    item.getItemProperty((Object)PROP_USER).setValue((Object)cms.readGroup(project.getGroupId()).getSimpleName());
                }
                catch (CmsException e) {
                    LOG.warn((Object)("Error reading project properties for " + project + ". " + e.getLocalizedMessage()), (Throwable)e);
                }
                item.getItemProperty((Object)PROP_DATE_CREATED).setValue((Object)new Date(project.getDateCreated()));
                StringBuffer html = new StringBuffer(512);
                try {
                    item.getItemProperty((Object)PROP_RESOURCES).setValue((Object)new ProjectResources(cms.readProjectResources(project)));
                }
                catch (CmsException e) {
                    LOG.error((Object)("Error reading project resources for " + project.getSimpleName()));
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error reading manageable projects", (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    protected void displayException(Throwable e) {
        CmsErrorDialog.showErrorDialog(e, new Runnable(){

            @Override
            public void run() {
                CmsAppWorkplaceUi.get().reload();
            }
        });
    }

    List<I_CmsSimpleContextMenuEntry<Set<CmsUUID>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<CmsUUID>>>();
            this.m_menuEntries.add(new ShowFilesEntry());
            this.m_menuEntries.add(new UnlockEntry());
            this.m_menuEntries.add(new PublishEntry());
            this.m_menuEntries.add(new EditEntry());
            this.m_menuEntries.add(new DeleteEntry());
        }
        return this.m_menuEntries;
    }

    void onItemClick(ItemClickEvent event) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                CmsUUID itemId = (CmsUUID)event.getItemId();
                Set value = (Set)this.getValue();
                if (value == null) {
                    this.select(itemId);
                } else if (!value.contains(itemId)) {
                    this.setValue(null);
                    this.select(itemId);
                }
                this.m_menu.setEntries(this.getMenuEntries(), (Set)this.getValue());
                this.m_menu.openForTable(event, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && PROP_NAME.equals(event.getPropertyId())) {
                Item item = event.getItem();
                CmsUUID id = (CmsUUID)item.getItemProperty((Object)PROP_ID).getValue();
                this.m_manager.openSubView(A_CmsWorkplaceApp.addParamToState("files", "projectId", id.toString()), true);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && PROP_RESOURCES.equals(event.getPropertyId())) {
                Item item = event.getItem();
                CmsProjectsTable.showProjectResources(item);
            }
        }
    }

    class UnlockEntry
    implements I_CmsSimpleContextMenuEntry<Set<CmsUUID>> {
        UnlockEntry() {
        }

        @Override
        public void executeAction(Set<CmsUUID> data) {
            for (CmsUUID projectId : data) {
                try {
                    A_CmsUI.getCmsObject().unlockProject(projectId);
                }
                catch (CmsException e) {
                    LOG.error((Object)("Error unlocking project " + projectId), (Throwable)e);
                    CmsProjectsTable.this.displayException(e);
                }
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_UNLOCK_FILES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<CmsUUID> data) {
            if (A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            if (data.size() == 1) {
                CmsUUID projectId = data.iterator().next();
                try {
                    if (A_CmsUI.getCmsObject().countLockedResources(projectId) == 0) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)("Error reading locked resources on project " + projectId), (Throwable)e);
                }
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class ShowFilesEntry
    implements I_CmsSimpleContextMenuEntry<Set<CmsUUID>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        ShowFilesEntry() {
        }

        @Override
        public void executeAction(Set<CmsUUID> data) {
            CmsUUID id = data.iterator().next();
            CmsProjectsTable.this.m_manager.openSubView(A_CmsWorkplaceApp.addParamToState("files", "projectId", id.toString()), true);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_SHOW_FILES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<CmsUUID> data) {
            if (data == null || data.size() != 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class PublishEntry
    implements I_CmsSimpleContextMenuEntry<Set<CmsUUID>> {
        PublishEntry() {
        }

        @Override
        public void executeAction(Set<CmsUUID> data) {
            CmsUUID projectId = data.iterator().next();
            CmsAppWorkplaceUi.get().disableGlobalShortcuts();
            CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), null);
            try {
                extension.openPublishDialog(A_CmsUI.getCmsObject().readProject(projectId));
            }
            catch (CmsException e) {
                LOG.error((Object)("Error reading project " + projectId), (Throwable)e);
                CmsProjectsTable.this.displayException(e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_PUBLISH_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<CmsUUID> data) {
            if (data != null && data.size() == 1) {
                if (A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
                }
                CmsUUID projectId = data.iterator().next();
                try {
                    return A_CmsUI.getCmsObject().countLockedResources(projectId) == 0 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
                }
                catch (CmsException e) {
                    LOG.error((Object)("Error reading locked resources on project " + projectId), (Throwable)e);
                }
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EditEntry
    implements I_CmsSimpleContextMenuEntry<Set<CmsUUID>> {
        EditEntry() {
        }

        @Override
        public void executeAction(Set<CmsUUID> data) {
            CmsUUID id = data.iterator().next();
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            CmsEditProjectForm form = new CmsEditProjectForm(CmsProjectsTable.this, id, window);
            window.setContent((Component)form);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_PROJECTS_EDIT_1", CmsProjectsTable.this.m_container.getItem((Object)id).getItemProperty((Object)CmsProjectsTable.PROP_NAME).getValue()));
            A_CmsUI.get().addWindow(window);
            window.center();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_EDIT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<CmsUUID> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class DeleteEntry
    implements I_CmsSimpleContextMenuEntry<Set<CmsUUID>> {
        DeleteEntry() {
        }

        @Override
        public void executeAction(final Set<CmsUUID> data) {
            String message;
            ArrayList<CmsResourceInfo> projectInfos = new ArrayList<CmsResourceInfo>();
            CmsCssIcon projectIcon = new CmsCssIcon("oc-icon-24-project");
            if (data.size() == 1) {
                Item item = CmsProjectsTable.this.m_container.getItem((Object)data.iterator().next());
                message = CmsVaadinUtils.getMessageText("GUI_PROJECTS_CONFIRM_DELETE_PROJECT_1", item.getItemProperty((Object)CmsProjectsTable.PROP_NAME).getValue());
                projectInfos.add(new CmsResourceInfo((String)item.getItemProperty((Object)CmsProjectsTable.PROP_NAME).getValue(), (String)item.getItemProperty((Object)CmsProjectsTable.PROP_DESCRIPTION).getValue(), (Resource)projectIcon));
            } else {
                message = "";
                for (CmsUUID id : data) {
                    if (message.length() > 0) {
                        message = message + ", ";
                    }
                    Item item = CmsProjectsTable.this.m_container.getItem((Object)id);
                    message = message + item.getItemProperty((Object)CmsProjectsTable.PROP_NAME).getValue();
                    projectInfos.add(new CmsResourceInfo((String)item.getItemProperty((Object)CmsProjectsTable.PROP_NAME).getValue(), (String)item.getItemProperty((Object)CmsProjectsTable.PROP_DESCRIPTION).getValue(), (Resource)projectIcon));
                }
                message = CmsVaadinUtils.getMessageText("GUI_PROJECTS_CONFIRM_DELETE_PROJECTS_1", message);
            }
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_PROJECTS_DELETE_0", new Object[0]), message, new Runnable(){

                @Override
                public void run() {
                    for (CmsUUID projectId : data) {
                        try {
                            A_CmsUI.getCmsObject().deleteProject(projectId);
                            CmsAppWorkplaceUi.get().reload();
                        }
                        catch (CmsException e) {
                            LOG.error((Object)("Error deleting project " + projectId), (Throwable)e);
                            CmsProjectsTable.this.displayException(e);
                        }
                    }
                }
            }).displayResourceInfoDirectly(projectInfos);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<CmsUUID> data) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    public static class ProjectResources
    extends ArrayList<String> {
        public ProjectResources(List<String> origin) {
            super(origin);
        }

        @Override
        public String toString() {
            return CmsStringUtil.listAsString(this, ", ");
        }
    }
}

