/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.resourcetypes;

import com.google.common.collect.Lists;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.resourcetypes.CmsResourceTypeApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsEditResourceTypeDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -5966214615311043554L;
    private static final String ICON_MODE_CSS = "css";
    private static final String ICON_MODE_FILE = "file";
    private static final Log LOG = CmsLog.getLog(CmsEditResourceTypeDialog.class);
    private OptionGroup m_iconMode;
    private TextField m_smallIconCSS;
    private TextField m_bigIconCSS;
    private TextField m_smallIconFile;
    private TextField m_bigIconFile;
    protected I_CmsResourceType m_type;
    private Label m_warningIcon;
    private Button m_ok;
    private CheckBox m_confirm;
    private Button m_cancel;
    private TextField m_typeShortName;
    private TextField m_typeName;
    private TextField m_typeDescription;
    private TextField m_typeTitle;
    private TextField m_typeID;
    private CmsPathSelectField m_schema;
    private CmsObject m_cms;

    public CmsEditResourceTypeDialog(Window window, CmsResourceTypeApp app, I_CmsResourceType resourceType) {
        this.m_type = resourceType;
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e1) {
            this.m_cms = A_CmsUI.getCmsObject();
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_warningIcon.setContentMode(ContentMode.HTML);
        this.m_warningIcon.setValue(FontOpenCms.WARNING.getHtml());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type.getModuleName())) {
            CmsModule module = OpenCms.getModuleManager().getModule(this.m_type.getModuleName());
            CmsExplorerTypeSettings dummy = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_type.getTypeName());
            for (CmsExplorerTypeSettings settings : module.getExplorerTypes()) {
                if (!dummy.equals(settings)) continue;
                CmsResourceInfo resInfo = new CmsResourceInfo(CmsVaadinUtils.getMessageText(settings.getKey(), new Object[0]), this.m_type.getTypeName(), CmsResourceUtil.getBigIconResource(settings, null));
                this.displayResourceInfoDirectly(Arrays.asList(resInfo));
            }
        } else {
            this.m_confirm.setEnabled(false);
        }
        this.m_ok.addClickListener((Button.ClickListener & Serializable)e -> this.submit(window, app));
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> window.close());
        this.setFields();
        this.setVisibilityOfIconFields();
        this.m_typeShortName.addValidator((Validator)new NameValidator());
        this.m_typeID.addValidator((Validator)new IDValidator());
        this.m_ok.setEnabled(false);
        this.m_confirm.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.m_ok.setEnabled(((Boolean)this.m_confirm.getValue()).booleanValue()));
        this.m_typeShortName.setValue(this.m_type.getTypeName());
        this.m_typeID.setValue(String.valueOf(this.m_type.getTypeId()));
        if (this.m_type instanceof CmsResourceTypeXmlContent) {
            CmsResourceTypeXmlContent typeXML = (CmsResourceTypeXmlContent)this.m_type;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(typeXML.getSchema())) {
                this.m_schema.setVisible(false);
            } else {
                this.m_schema.setValue(typeXML.getSchema());
                this.m_schema.addValidator(new ResourceValidator());
            }
        } else {
            this.m_schema.setVisible(false);
        }
        this.m_iconMode.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -4165180367864561412L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditResourceTypeDialog.this.setVisibilityOfIconFields();
            }
        });
    }

    protected void setVisibilityOfIconFields() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type.getModuleName())) {
            this.m_iconMode.setVisible(false);
            this.m_smallIconCSS.setVisible(false);
            this.m_smallIconFile.setVisible(false);
            this.m_bigIconCSS.setVisible(false);
            this.m_bigIconFile.setVisible(false);
            return;
        }
        if (ICON_MODE_CSS.equals(this.m_iconMode.getValue())) {
            this.m_smallIconCSS.setVisible(true);
            this.m_bigIconCSS.setVisible(true);
            this.m_smallIconFile.setVisible(false);
            this.m_bigIconFile.setVisible(false);
            return;
        }
        if (ICON_MODE_FILE.equals(this.m_iconMode.getValue())) {
            this.m_smallIconCSS.setVisible(false);
            this.m_bigIconCSS.setVisible(false);
            this.m_smallIconFile.setVisible(true);
            this.m_bigIconFile.setVisible(true);
            return;
        }
        this.m_smallIconCSS.setVisible(false);
        this.m_bigIconCSS.setVisible(false);
        this.m_smallIconFile.setVisible(false);
        this.m_bigIconFile.setVisible(false);
    }

    protected void submit(Window window, CmsResourceTypeApp app) {
        if (this.isValid()) {
            CmsModule module = OpenCms.getModuleManager().getModule(this.m_type.getModuleName()).clone();
            if (this.isKeepTypeCase()) {
                this.saveResourceType(module);
            } else {
                try {
                    this.changeIdNameOrSchema(module);
                }
                catch (CmsConfigurationException e) {
                    LOG.error((Object)"Unable to change resource type.", (Throwable)e);
                }
            }
            try {
                OpenCms.getModuleManager().updateModule(this.m_cms, module);
                OpenCms.getResourceManager().initialize(this.m_cms);
                OpenCms.getWorkplaceManager().addExplorerTypeSettings(module);
                OpenCms.getWorkplaceManager().initialize(this.m_cms);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to save resource type", (Throwable)e);
            }
            window.close();
            app.reload();
        }
    }

    private void changeIdNameOrSchema(CmsModule module) throws CmsConfigurationException {
        ArrayList typeSettings = Lists.newArrayList(module.getExplorerTypes());
        ArrayList<CmsExplorerTypeSettings> newTypeSettings = new ArrayList<CmsExplorerTypeSettings>();
        for (CmsExplorerTypeSettings setting : typeSettings) {
            if (setting.getName().equals(this.m_type.getTypeName())) continue;
            newTypeSettings.add(setting);
        }
        OpenCms.getWorkplaceManager().removeExplorerTypeSettings(module);
        ArrayList<I_CmsResourceType> types = new ArrayList<I_CmsResourceType>(module.getResourceTypes());
        types.remove(this.m_type);
        CmsResourceTypeXmlContent type = new CmsResourceTypeXmlContent();
        type.addConfigurationParameter("schema", this.m_schema.getValue());
        type.setAdditionalModuleResourceType(true);
        type.setModuleName(module.getName());
        type.initConfiguration((String)this.m_typeShortName.getValue(), (String)this.m_typeID.getValue(), CmsResourceTypeXmlContent.class.getName());
        types.add(type);
        module.setResourceTypes(types);
        CmsExplorerTypeSettings setting = new CmsExplorerTypeSettings();
        setting.setTypeAttributes((String)this.m_typeShortName.getValue(), (String)this.m_typeName.getValue(), null, null, "oc-icon-16-default", "oc-icon-24-default", CmsResourceTypeXmlContent.getStaticTypeName(), null, "false", null, null);
        setting.setAutoSetNavigation("false");
        setting.setAutoSetTitle("false");
        setting.setNewResourceOrder("10");
        setting.setAddititionalModuleExplorerType(true);
        setting.setBigIcon(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? null : (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_bigIconFile.getValue()) ? null : (String)this.m_bigIconFile.getValue()));
        setting.setIcon(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? null : (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_smallIconFile.getValue()) ? null : (String)this.m_smallIconFile.getValue()));
        setting.setBigIconStyle(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_bigIconCSS.getValue()) ? null : (String)this.m_bigIconCSS.getValue()) : null);
        setting.setSmallIconStyle(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_smallIconCSS.getValue()) ? null : (String)this.m_smallIconCSS.getValue()) : null);
        setting.setKey((String)this.m_typeName.getValue());
        setting.setTitleKey((String)this.m_typeTitle.getValue());
        setting.setInfo((String)this.m_typeDescription.getValue());
        newTypeSettings.add(setting);
        module.setExplorerTypes(newTypeSettings);
        OpenCms.getWorkplaceManager().addExplorerTypeSettings(module);
    }

    private boolean isKeepTypeCase() {
        boolean res = Integer.parseInt((String)this.m_typeID.getValue()) == this.m_type.getTypeId();
        boolean bl = res = res && ((String)this.m_typeShortName.getValue()).equals(this.m_type.getTypeName());
        if (this.m_type instanceof CmsResourceTypeXmlContent) {
            res = res && ((CmsResourceTypeXmlContent)this.m_type).getSchema().equals(this.m_schema.getValue());
        }
        return res;
    }

    private boolean isValid() {
        return this.m_schema.isValid() && this.m_typeID.isValid() && this.m_typeShortName.isValid();
    }

    private void saveResourceType(CmsModule module) {
        ArrayList typeSettings = Lists.newArrayList(OpenCms.getModuleManager().getModule(this.m_type.getModuleName()).getExplorerTypes());
        for (CmsExplorerTypeSettings setting : typeSettings) {
            if (!setting.getName().equals(this.m_type.getTypeName())) continue;
            setting.setBigIcon(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? null : (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_bigIconFile.getValue()) ? null : (String)this.m_bigIconFile.getValue()));
            setting.setIcon(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? null : (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_smallIconFile.getValue()) ? null : (String)this.m_smallIconFile.getValue()));
            setting.setBigIconStyle(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_bigIconCSS.getValue()) ? null : (String)this.m_bigIconCSS.getValue()) : null);
            setting.setSmallIconStyle(ICON_MODE_CSS.equals(this.m_iconMode.getValue()) ? (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_smallIconCSS.getValue()) ? null : (String)this.m_smallIconCSS.getValue()) : null);
            setting.setKey((String)this.m_typeName.getValue());
            setting.setTitleKey((String)this.m_typeTitle.getValue());
            setting.setInfo((String)this.m_typeDescription.getValue());
            break;
        }
        module.setExplorerTypes(typeSettings);
        OpenCms.getWorkplaceManager().addExplorerTypeSettings(module);
    }

    private void setFields() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type.getModuleName())) {
            return;
        }
        ArrayList typeSettings = Lists.newArrayList(OpenCms.getModuleManager().getModule(this.m_type.getModuleName()).getExplorerTypes());
        for (CmsExplorerTypeSettings setting : typeSettings) {
            boolean cssIconStyle;
            if (!setting.getName().equals(this.m_type.getTypeName())) continue;
            boolean bl = cssIconStyle = setting.getBigIcon() == null;
            if (cssIconStyle) {
                this.m_iconMode.setValue((Object)ICON_MODE_CSS);
                if (setting.getBigIconStyle() == null) {
                    this.m_smallIconCSS.setValue("");
                    this.m_bigIconCSS.setValue("");
                } else {
                    this.m_smallIconCSS.setValue(setting.getSmallIconStyle());
                    this.m_bigIconCSS.setValue(setting.getBigIconStyle());
                }
            } else {
                this.m_iconMode.setValue((Object)ICON_MODE_FILE);
                this.m_smallIconFile.setValue(setting.getIcon());
                this.m_bigIconFile.setValue(setting.getBigIcon());
            }
            this.m_typeName.setValue(setting.getKey());
            this.m_typeTitle.setValue(setting.getTitleKey());
            this.m_typeDescription.setValue(setting.getInfo());
            break;
        }
    }

    class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null || ((String)value).isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
            }
            String resource = (String)value;
            if (!CmsEditResourceTypeDialog.this.m_cms.existsResource(resource)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
            }
        }
    }

    class NameValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        NameValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (((String)value).isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_NAME_0", new Object[0]));
            }
            if (CmsEditResourceTypeDialog.this.m_type.getTypeName().equals(value)) {
                return;
            }
            if (!CmsResourceTypeApp.isResourceTypeNameFree((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_NAME_0", new Object[0]));
            }
        }
    }

    class IDValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        IDValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (((String)value).isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_ID_0", new Object[0]));
            }
            try {
                int id = Integer.parseInt((String)value);
                if (id == CmsEditResourceTypeDialog.this.m_type.getTypeId()) {
                    return;
                }
                if (!CmsResourceTypeApp.isResourceTypeIdFree(id)) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_ID_0", new Object[0]));
                }
            }
            catch (NumberFormatException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_ID_0", new Object[0]));
            }
        }
    }
}

