/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.resourcetypes;

import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.modules.CmsModuleRow;
import org.opencms.ui.apps.resourcetypes.CmsNewResourceTypeDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.util.table.CmsBeanTableBuilder;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsMoveResourceTypeDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsMoveResourceTypeDialog.class);
    private Button m_ok;
    private Button m_cancel;
    private Table m_table;
    private CheckBox m_moveAnyway;
    private Label m_warningIcon;
    private TextField m_filter;
    private boolean m_schemaOK = true;
    private VerticalLayout m_missingSchemaLayout;
    private I_CmsResourceType m_type;
    private CmsResourceTypeXmlContent m_typeXML;

    public CmsMoveResourceTypeDialog(CmsNewResourceTypeDialog dialog) {
        this.init(null);
        this.m_missingSchemaLayout.setVisible(false);
        this.m_ok.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.getModuleName() != null) {
                dialog.setModule(this.getModuleName(), this);
            }
        });
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> CmsVaadinUtils.getWindow((Component)this).close());
    }

    public CmsMoveResourceTypeDialog(Window window, I_CmsResourceType type) {
        this.init(window);
        this.m_type = type;
        this.m_table.select((Object)new CmsModuleRow(OpenCms.getModuleManager().getModule(type.getModuleName())));
        this.m_table.setCurrentPageFirstItemId((Object)new CmsModuleRow(OpenCms.getModuleManager().getModule(type.getModuleName())));
        if (this.m_type instanceof CmsResourceTypeXmlContent) {
            this.m_typeXML = (CmsResourceTypeXmlContent)this.m_type;
            if (!OpenCms.getModuleManager().getModule(this.m_type.getModuleName()).getResources().contains(this.m_typeXML.getSchema())) {
                this.m_schemaOK = false;
                this.m_ok.setEnabled(false);
                this.m_moveAnyway.addValueChangeListener(new Property.ValueChangeListener(){

                    public void valueChange(Property.ValueChangeEvent event) {
                        CmsMoveResourceTypeDialog.this.setOkButton();
                    }
                });
            }
        }
        CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
        this.displayResourceInfoDirectly(Collections.singletonList(new CmsResourceInfo(CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]), type.getModuleName(), CmsResourceUtil.getBigIconResource(typeSetting, null))));
        this.m_ok.addClickListener((Button.ClickListener & Serializable)e -> this.updateResourceType(window));
    }

    protected void filterTable(String text) {
        Container.Filterable container = (Container.Filterable)this.m_table.getContainerDataSource();
        container.removeAllContainerFilters();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(text)) {
            container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)"name", text, true, false), new SimpleStringFilter((Object)"title", text, true, false)}));
        }
    }

    protected String getModuleName() {
        if (this.m_table.getValue() == null) {
            return null;
        }
        return ((CmsModuleRow)this.m_table.getValue()).getName();
    }

    protected void setOkButton() {
        this.m_ok.setEnabled(((Boolean)this.m_moveAnyway.getValue()).booleanValue());
    }

    protected void updateResourceType(Window window) {
        if (!((CmsModuleRow)this.m_table.getValue()).equals(new CmsModuleRow(OpenCms.getModuleManager().getModule(this.m_type.getModuleName())))) {
            CmsModule newModule = ((CmsModuleRow)this.m_table.getValue()).getModule().clone();
            CmsModule oldModule = OpenCms.getModuleManager().getModule(this.m_type.getModuleName()).clone();
            this.m_type.setModuleName(newModule.getName());
            ArrayList newTypes = Lists.newArrayList(newModule.getResourceTypes());
            newTypes.add(this.m_type);
            newModule.setResourceTypes(newTypes);
            ArrayList<CmsExplorerTypeSettings> oldSettings = new ArrayList<CmsExplorerTypeSettings>(oldModule.getExplorerTypes());
            CmsExplorerTypeSettings settings = new CmsExplorerTypeSettings();
            settings.setName(this.m_type.getTypeName());
            settings = (CmsExplorerTypeSettings)oldSettings.get(oldSettings.indexOf(settings));
            oldSettings.remove(settings);
            ArrayList<CmsExplorerTypeSettings> newSettings = new ArrayList<CmsExplorerTypeSettings>(newModule.getExplorerTypes());
            newSettings.add(settings);
            oldModule.setExplorerTypes(oldSettings);
            newModule.setExplorerTypes(newSettings);
            ArrayList oldTypes = Lists.newArrayList(oldModule.getResourceTypes());
            oldTypes.remove(this.m_type);
            oldModule.setResourceTypes(oldTypes);
            if (this.m_schemaOK) {
                ArrayList oldResources = Lists.newArrayList(oldModule.getResources());
                oldResources.remove(this.m_typeXML.getSchema());
                oldModule.setResources(oldResources);
                ArrayList newResources = Lists.newArrayList(newModule.getResources());
                newResources.add(this.m_typeXML.getSchema());
                newModule.setResources(newResources);
            }
            try {
                OpenCms.getModuleManager().updateModule(A_CmsUI.getCmsObject(), oldModule);
                OpenCms.getModuleManager().updateModule(A_CmsUI.getCmsObject(), newModule);
                OpenCms.getResourceManager().initialize(A_CmsUI.getCmsObject());
                OpenCms.getWorkplaceManager().removeExplorerTypeSettings(oldModule);
                OpenCms.getWorkplaceManager().addExplorerTypeSettings(newModule);
                OpenCms.getWorkplaceManager().initialize(A_CmsUI.getCmsObject());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to move resource type", (Throwable)e);
            }
        }
        window.close();
        A_CmsUI.get().reload();
    }

    private void init(Window window) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_warningIcon.setContentMode(ContentMode.HTML);
        this.m_warningIcon.setValue(FontOpenCms.WARNING.getHtml());
        if (window != null) {
            this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> window.close());
        }
        this.m_table.setWidth("100%");
        this.m_table.setHeight("100%");
        ArrayList<CmsModuleRow> rows = new ArrayList<CmsModuleRow>();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            CmsModuleRow row = new CmsModuleRow(module);
            rows.add(row);
        }
        CmsBeanTableBuilder<CmsModuleRow> builder = CmsBeanTableBuilder.newInstance(CmsModuleRow.class);
        builder.buildTable(this.m_table, rows);
        this.m_table.setCellStyleGenerator(builder.getDefaultCellStyleGenerator());
        this.m_table.setItemIconPropertyId((Object)"icon");
        this.m_table.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.m_table.setSelectable(true);
        this.m_table.setVisibleColumns(new Object[]{"name", "title"});
        this.m_table.setSortContainerPropertyId((Object)"name");
        this.m_table.sort();
        this.m_filter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_filter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_filter.addStyleName("inline-icon");
        this.m_filter.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsMoveResourceTypeDialog.this.filterTable(event.getText());
            }
        });
    }
}

