/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.resourcetypes;

import com.google.common.collect.Lists;
import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeFolderBase;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.apps.resourcetypes.CmsEditResourceTypeDialog;
import org.opencms.ui.apps.resourcetypes.CmsMoveResourceTypeDialog;
import org.opencms.ui.apps.resourcetypes.CmsResourceTypeApp;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchApp;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceTypesTable
extends Table {
    private static final long serialVersionUID = 1L;
    static final Log LOG = CmsLog.getLog(CmsResourceTypesTable.class);
    CmsObject m_cms;
    private CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private IndexedContainer m_container;
    CmsResourceTypeApp m_app;

    public CmsResourceTypesTable(CmsResourceTypeApp app) {
        this.m_app = app;
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.setSizeFull();
        this.init();
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 7957778390938304845L;

            public void itemClick(ItemClickEvent event) {
                CmsResourceTypesTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
    }

    public void filterTable(String text) {
        this.m_container.removeAllContainerFilters();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(text)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.Name, text, true, false), new SimpleStringFilter((Object)TableProperty.ShortName, text, true, false), new SimpleStringFilter((Object)TableProperty.Module, text, true, false)}));
        }
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EditEntry());
            this.m_menuEntries.add(new SchemaEditorEntry());
            this.m_menuEntries.add(new SearchEntry());
            this.m_menuEntries.add(new MoveEntry());
            this.m_menuEntries.add(new DeleteEntry());
        }
        return this.m_menuEntries;
    }

    void init() {
        if (this.m_container == null) {
            this.m_container = new IndexedContainer();
            this.setContainerDataSource((Container)this.m_container);
        } else {
            this.m_container.removeAllContainerFilters();
            this.m_container.removeAllItems();
        }
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefaultValue());
            this.setColumnHeader((Object)prop, prop.getLocalizedMessage());
        }
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.setMultiSelect(true);
        for (I_CmsResourceType type : CmsVaadinUtils.getResourceTypes()) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            Item item = this.m_container.addItem((Object)type.getTypeName());
            item.getItemProperty((Object)TableProperty.ID).setValue((Object)type.getTypeId());
            item.getItemProperty((Object)TableProperty.Icon).setValue((Object)CmsResourceUtil.getBigIconResource(typeSetting, null));
            item.getItemProperty((Object)TableProperty.Name).setValue((Object)CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]));
            item.getItemProperty((Object)TableProperty.ShortName).setValue((Object)type.getTypeName());
            item.getItemProperty((Object)TableProperty.Module).setValue((Object)type.getModuleName());
        }
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.ShortName, TableProperty.ID, TableProperty.Module});
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == null) {
                this.m_menu.setEntries(this.getMenuEntries(), (Set)this.getValue());
                this.m_menu.openForTable(event, itemId, propertyId, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.Name.equals(propertyId)) {
                String typeName = (String)itemId;
                this.openEditDialog(typeName);
            }
        }
    }

    void openEditDialog(String typeName) {
        try {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            window.setContent((Component)new CmsEditResourceTypeDialog(window, this.m_app, OpenCms.getResourceManager().getResourceType(typeName)));
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_WINDOW_CAPTION_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
        }
        catch (CmsLoaderException e) {
            LOG.error((Object)"Unable to read resource type by name", (Throwable)e);
        }
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    static enum TableProperty {
        Icon(null, Resource.class, null, false),
        Name("GUI_RESOURCETYPE_EDIT_DISPLAY_NAME_0", String.class, "", false),
        ShortName("GUI_RESOURCETYPE_EDIT_SHORT_NAME_0", String.class, "", false),
        ID("GUI_RESOURCETYPE_ID_0", Integer.class, null, false),
        Module("GUI_RESOURCETYPE_MODULE_0", String.class, "", false);

        private boolean m_collapsable;
        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String headerMessage, Class<?> type, Object defaultValue, boolean collapsable) {
            this.m_headerMessage = headerMessage;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
            this.m_collapsable = collapsable;
        }

        static List<TableProperty> withHeader() {
            ArrayList<TableProperty> props = new ArrayList<TableProperty>();
            for (TableProperty prop : TableProperty.values()) {
                if (prop.m_headerMessage == null) continue;
                props.add(prop);
            }
            return props;
        }

        Object getDefaultValue() {
            return this.m_defaultValue;
        }

        String getLocalizedMessage() {
            if (this.m_headerMessage == null) {
                return "";
            }
            return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }

        boolean isCollapsable() {
            return this.m_collapsable;
        }
    }

    class SearchEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        SearchEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
            settings.setPaths(Collections.singletonList("/"));
            settings.setSiteRoot(CmsResourceTypesTable.this.m_cms.getRequestContext().getSiteRoot());
            settings.setSearchpattern(".*");
            settings.setTypes(data.iterator().next());
            settings.setType(CmsSourceSearchForm.SearchType.fullText);
            CmsAppWorkplaceUi.get().showApp("source-search", CmsSourceSearchApp.generateState(settings));
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_SEARCH_RESOURCES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NO_AVAILABLE_MULTIPLE_0");
            }
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(data.iterator().next());
                return type instanceof A_CmsResourceTypeFolderBase ? CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE : CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            catch (CmsLoaderException e) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
    }

    class SchemaEditorEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        SchemaEditorEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(data.iterator().next());
                if (type instanceof CmsResourceTypeXmlContent) {
                    CmsResourceTypeXmlContent typeXML = (CmsResourceTypeXmlContent)type;
                    CmsResource resource = CmsResourceTypesTable.this.m_cms.readResource(typeXML.getSchema());
                    String editState = CmsEditor.getEditState(resource.getStructureId(), false, UI.getCurrent().getPage().getLocation().toString());
                    CmsAppWorkplaceUi.get().showApp(OpenCms.getWorkplaceAppManager().getAppConfiguration("editor"), editState);
                }
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)"Unable to read resource type", (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read schema file", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_SCHEMA_DEFINITION_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            block5: {
                if (data.size() > 1) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NO_AVAILABLE_MULTIPLE_0");
                }
                try {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(data.iterator().next());
                    if (!(type instanceof CmsResourceTypeXmlContent)) break block5;
                    CmsResourceTypeXmlContent typeXML = (CmsResourceTypeXmlContent)type;
                    try {
                        CmsResourceTypesTable.this.m_cms.readResource(typeXML.getSchema());
                    }
                    catch (CmsException e) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                    return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                }
                catch (CmsLoaderException e) {
                    LOG.error((Object)"Unable to read resource type", (Throwable)e);
                }
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class MoveEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        MoveEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(data.iterator().next());
                window.setContent((Component)new CmsMoveResourceTypeDialog(window, type));
                String moduleName = type.getModuleName();
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_MOVE_WINDOW_CAPTION_1", moduleName));
                A_CmsUI.get().addWindow(window);
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)"Unable to read resource type by name", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_MOVE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NO_AVAILABLE_MULTIPLE_0");
            }
            try {
                Iterator<String> it = data.iterator();
                while (it.hasNext()) {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(it.next());
                    if (!CmsStringUtil.isEmptyOrWhitespaceOnly(type.getModuleName())) continue;
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NOT_AVAILABLE_CORE_0");
                }
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read resourcetype", (Throwable)e);
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
        }
    }

    class EditEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EditEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsResourceTypesTable.this.openEditDialog(data.iterator().next());
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NO_AVAILABLE_MULTIPLE_0");
            }
            String typeName = data.iterator().next();
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(typeName);
                return CmsStringUtil.isEmptyOrWhitespaceOnly(type.getModuleName()) ? CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NOT_AVAILABLE_CORE_0") : CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)"Unable to read resource type by name", (Throwable)e);
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
        }
    }

    class DeleteEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        DeleteEntry() {
        }

        @Override
        public void executeAction(final Set<String> data) {
            try {
                final Window window = CmsBasicDialog.prepareWindow();
                Iterator<String> it = data.iterator();
                boolean existResources = false;
                while (it.hasNext()) {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(it.next());
                    if (CmsResourceTypesTable.this.m_cms.readResources("", CmsResourceFilter.requireType(type), true).size() <= 0) continue;
                    existResources = true;
                }
                if (existResources) {
                    CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_DELETE_NOT_POSSIBLE_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_DELETE_NOT_POSSIBLE_LONG_0", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            window.close();
                        }
                    }, null, true);
                } else {
                    CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_DELETE_CONFIRM_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_DELETE_CONFIRM_LONG_0", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Iterator it = data.iterator();
                                HashMap<String, CmsModule> modulesToBeUpdated = new HashMap<String, CmsModule>();
                                while (it.hasNext()) {
                                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType((String)it.next());
                                    if (!modulesToBeUpdated.containsKey(type.getModuleName())) {
                                        modulesToBeUpdated.put(type.getModuleName(), OpenCms.getModuleManager().getModule(type.getModuleName()).clone());
                                    }
                                    CmsModule module = (CmsModule)modulesToBeUpdated.get(type.getModuleName());
                                    ArrayList typeSettings = Lists.newArrayList(module.getExplorerTypes());
                                    ArrayList<CmsExplorerTypeSettings> newTypeSettings = new ArrayList<CmsExplorerTypeSettings>();
                                    for (CmsExplorerTypeSettings setting : typeSettings) {
                                        if (setting.getName().equals(type.getTypeName())) continue;
                                        newTypeSettings.add(setting);
                                    }
                                    OpenCms.getWorkplaceManager().removeExplorerTypeSettings(module);
                                    ArrayList<I_CmsResourceType> types = new ArrayList<I_CmsResourceType>(module.getResourceTypes());
                                    types.remove(type);
                                    module.setResourceTypes(types);
                                    module.setExplorerTypes(newTypeSettings);
                                }
                                for (String moduleName : modulesToBeUpdated.keySet()) {
                                    OpenCms.getModuleManager().updateModule(CmsResourceTypesTable.this.m_cms, (CmsModule)modulesToBeUpdated.get(moduleName));
                                    OpenCms.getResourceManager().initialize(CmsResourceTypesTable.this.m_cms);
                                    OpenCms.getWorkplaceManager().addExplorerTypeSettings((CmsModule)modulesToBeUpdated.get(moduleName));
                                }
                                OpenCms.getWorkplaceManager().initialize(CmsResourceTypesTable.this.m_cms);
                            }
                            catch (CmsException e) {
                                LOG.error((Object)"Unable to delete resource type", (Throwable)e);
                            }
                            window.close();
                            CmsResourceTypesTable.this.m_app.reload();
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            window.close();
                        }
                    });
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to delete resource type", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            try {
                Iterator<String> it = data.iterator();
                while (it.hasNext()) {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(it.next());
                    if (!CmsStringUtil.isEmptyOrWhitespaceOnly(type.getModuleName())) continue;
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_RESOURCETYPE_APP_TABLE_NOT_AVAILABLE_CORE_0");
                }
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read resourcetype", (Throwable)e);
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
        }
    }
}

