/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.LinkedHashMap;
import java.util.List;
import org.opencms.configuration.CmsSchedulerConfiguration;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.scheduler.CmsSchedulerException;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsCRUDApp;
import org.opencms.ui.apps.scheduler.CmsJobEditView;
import org.opencms.ui.apps.scheduler.CmsJobTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsStringUtil;

public class CmsJobManagerApp
extends A_CmsWorkplaceApp
implements I_CmsCRUDApp<CmsScheduledJobInfo> {
    public static final String PARAM_COPY = "copy";
    public static final String PARAM_JOB_ID = "jobId";
    public static final String PATH_NAME_EDIT = "edit";
    protected CmsJobTable m_jobTable;
    protected Window m_dialogWindow;

    public void closeDialogWindow(boolean updateTable) {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
            this.m_dialogWindow = null;
        }
        if (updateTable) {
            this.m_jobTable.reloadJobs();
        }
    }

    @Override
    public void createElement(CmsScheduledJobInfo element) {
        this.writeElement(element);
    }

    @Override
    public void defaultAction(String elelemntId) {
        this.openEditDialog(elelemntId, false);
    }

    @Override
    public void deleteElements(List<String> jobIds) {
        try {
            for (String jobId : jobIds) {
                OpenCms.getScheduleManager().unscheduleJob(A_CmsUI.getCmsObject(), jobId);
            }
            OpenCms.writeConfiguration(CmsSchedulerConfiguration.class);
        }
        catch (CmsRoleViolationException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public List<CmsScheduledJobInfo> getAllElements() {
        return OpenCms.getScheduleManager().getJobs();
    }

    @Override
    public CmsScheduledJobInfo getElement(String elementId) {
        return OpenCms.getScheduleManager().getJob(elementId);
    }

    public CmsJobEditView openEditDialog(String jobId, boolean copy) {
        CmsScheduledJobInfo jobCopy;
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
        }
        this.m_dialogWindow = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsScheduledJobInfo job = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(jobId)) {
            job = this.getElement(jobId);
        }
        if (job == null) {
            jobCopy = new CmsScheduledJobInfo();
            jobCopy.setContextInfo(new CmsContextInfo());
            this.m_dialogWindow.setCaption(CmsVaadinUtils.getMessageText("GUI_NEWJOB_ADMIN_TOOL_NAME_0", new Object[0]));
        } else {
            jobCopy = job.clone();
            jobCopy.setActive(job.isActive());
            if (copy) {
                jobCopy.clearId();
                this.m_dialogWindow.setCaption(CmsVaadinUtils.getMessageText("GUI_SCHEDULER_TITLE_COPY_1", job.getJobName()));
            } else {
                this.m_dialogWindow.setCaption(CmsVaadinUtils.getMessageText("GUI_JOBS_LIST_ACTION_EDIT_NAME_0", new Object[0]));
            }
        }
        CmsJobEditView editPanel = new CmsJobEditView(this, jobCopy);
        editPanel.loadFromBean(jobCopy);
        this.m_dialogWindow.setContent((Component)editPanel);
        A_CmsUI.get().addWindow(this.m_dialogWindow);
        this.m_dialogWindow.center();
        return editPanel;
    }

    public void restoreMainView() {
        this.openSubView("", true);
    }

    public void runJob(CmsScheduledJobInfo job) {
        CmsScheduleManager scheduler = OpenCms.getScheduleManager();
        scheduler.executeDirectly(job.getId());
    }

    @Override
    public void writeElement(CmsScheduledJobInfo jobInfo) {
        try {
            OpenCms.getScheduleManager().scheduleJob(A_CmsUI.getCmsObject(), jobInfo);
        }
        catch (CmsSchedulerException | CmsRoleViolationException cmsException) {
            // empty catch block
        }
        OpenCms.writeConfiguration(CmsSchedulerConfiguration.class);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        crumbs.put("", CmsVaadinUtils.getMessageText("GUI_JOBS_ADMIN_TOOL_NAME_0", new Object[0]));
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        Button addJob = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_NEWJOB_ADMIN_TOOL_NAME_0", new Object[0]));
        addJob.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsJobManagerApp.this.openEditDialog(null, false);
            }
        });
        this.m_uiContext.addToolbarButton((Component)addJob);
        this.m_rootLayout.setMainHeightFull(true);
        CmsJobTable table = this.getJobTable();
        table.reloadJobs();
        return table;
    }

    protected CmsJobTable getJobTable() {
        if (this.m_jobTable == null) {
            this.m_jobTable = new CmsJobTable(this);
            this.m_jobTable.setWidth("100%");
        }
        return this.m_jobTable;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }
}

