/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.searchindex;

import java.util.HashMap;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.apps.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsIndexingReportThread
extends A_CmsReportThread {
    private Throwable m_error;
    private List<String> m_indexNames;

    public CmsIndexingReportThread(CmsObject cms, List<String> indexNames) {
        super(cms, Messages.get().getBundle().key("GUI_INDEXING_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_indexNames = indexNames;
    }

    @Override
    public Throwable getError() {
        return this.m_error;
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        this.getReport().println(Messages.get().container("RPT_REBUILD_SEARCH_INDEXES_BEGIN_0"), 2);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("report", this.getReport());
            if (this.m_indexNames != null) {
                params.put("indexNames", CmsStringUtil.collectionAsString(this.m_indexNames, ","));
            }
            OpenCms.fireCmsEvent(32, params);
            this.getReport().println(Messages.get().container("RPT_REBUILD_SEARCH_INDEXES_END_0"), 2);
        }
        catch (Throwable exc) {
            this.getReport().println(org.opencms.search.Messages.get().container("RPT_SEARCH_INDEXING_FAILED_0"), 1);
            this.getReport().println(exc);
            this.m_error = exc;
        }
    }
}

