/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.shell;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsShell;
import org.opencms.module.Messages;
import org.opencms.report.A_CmsReportThread;

public class CmsShellScriptThread
extends A_CmsReportThread {
    private String m_script;

    public CmsShellScriptThread(CmsObject cms, String script) {
        super(cms, "shellscript");
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_script = script;
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        String script = "echo on\n" + this.m_script;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buffer);
        CmsShell shell = new CmsShell(this.getCms(), "${user}@${project}:${siteroot}|${uri}>", null, out, out);
        String[] subscripts = script.split("\n");
        int stringPos = 0;
        for (String subscript : subscripts) {
            shell.execute(subscript);
            out.flush();
            String res = buffer.toString();
            this.getReport().println(Messages.get().container("RPT_IMPORT_SCRIPT_OUTPUT_1", res.substring(stringPos)));
            stringPos = res.length();
        }
    }
}

