/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;

public class CmsDeleteSiteDialog
extends CmsBasicDialog {
    static Log LOG = CmsLog.getLog(CmsDeleteSiteDialog.class.getName());
    private static final long serialVersionUID = 4861877088383896218L;
    protected CmsSiteManager m_manager;
    private Button m_cancelButton;
    private CheckBox m_deleteResources;
    private Button m_okButton;
    protected final List<CmsSite> m_sitesToDelete = new ArrayList<CmsSite>();

    public CmsDeleteSiteDialog(CmsSiteManager manager, Set<String> data) {
        this.m_manager = manager;
        for (String site : data) {
            this.m_sitesToDelete.add(manager.getElement(site));
        }
        this.displayResourceInfoDirectly(this.getResourceInfos());
        this.setContent((Component)this.getContent());
        this.m_okButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        this.m_cancelButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        this.addButton((Component)this.m_okButton);
        this.addButton((Component)this.m_cancelButton);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -5769891739879269176L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteSiteDialog.this.m_manager.closeDialogWindow(false);
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6932464669055039855L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteSiteDialog.this.submit();
                CmsDeleteSiteDialog.this.m_manager.closeDialogWindow(true);
            }
        });
    }

    protected VerticalLayout getContent() {
        String message;
        if (this.m_sitesToDelete.size() == 1) {
            message = CmsVaadinUtils.getMessageText("GUI_SITE_CONFIRM_DELETE_SITE_1", this.m_sitesToDelete.get(0).getTitle());
        } else {
            message = "";
            for (CmsSite site : this.m_sitesToDelete) {
                if (message.length() > 0) {
                    message = message + ", ";
                }
                message = message + site.getTitle();
            }
            message = CmsVaadinUtils.getMessageText("GUI_SITE_CONFIRM_DELETE_SITES_1", message);
        }
        VerticalLayout layout = new VerticalLayout();
        this.m_deleteResources = new CheckBox();
        this.m_deleteResources.setCaption(CmsVaadinUtils.getMessageText("GUI_SITE_DELETE_RESOURCES_0", new Object[0]));
        this.m_deleteResources.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_DELETE_RESOURCES_HELP_0", new Object[0]));
        layout.addComponent((Component)this.m_deleteResources);
        Label label = new Label();
        label.setContentMode(ContentMode.HTML);
        label.setValue(message);
        layout.addComponent((Component)label);
        return layout;
    }

    protected void submit() {
        ArrayList<String> siteRootsToDelete = new ArrayList<String>();
        for (CmsSite site : this.m_sitesToDelete) {
            String currentSite = A_CmsUI.getCmsObject().getRequestContext().getSiteRoot();
            if (currentSite.equals(site.getSiteRoot())) {
                A_CmsUI.getCmsObject().getRequestContext().setSiteRoot("");
            }
            siteRootsToDelete.add(site.getSiteRoot());
        }
        this.m_manager.deleteElements(siteRootsToDelete);
        if (((Boolean)this.m_deleteResources.getValue()).booleanValue()) {
            for (CmsSite site : this.m_sitesToDelete) {
                try {
                    this.m_manager.getRootCmsObject().lockResource(site.getSiteRoot());
                }
                catch (CmsException e) {
                    LOG.error((Object)"unable to lock resource");
                }
                try {
                    this.m_manager.getRootCmsObject().deleteResource(site.getSiteRoot(), CmsResource.DELETE_PRESERVE_SIBLINGS);
                    try {
                        this.m_manager.getRootCmsObject().unlockResource(site.getSiteRoot());
                    }
                    catch (CmsLockException e) {
                        LOG.info((Object)"Unlock failed.", (Throwable)e);
                    }
                }
                catch (CmsException cmsException) {}
            }
        }
    }

    private List<CmsResourceInfo> getResourceInfos() {
        ArrayList<CmsResourceInfo> infos = new ArrayList<CmsResourceInfo>();
        for (CmsSite site : this.m_sitesToDelete) {
            infos.add(new CmsResourceInfo(site.getTitle(), site.getSiteRoot(), this.m_manager.getFavIcon(site.getSiteRoot())));
        }
        return infos;
    }
}

