/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.FontIcon;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsDefaultPasswordGenerator;
import org.opencms.security.I_CmsPasswordGenerator;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.I_CmsPasswordFetcher;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsButtonFormRow;

public class CmsGeneratePasswordDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -7522845215366141986L;

    public CmsGeneratePasswordDialog(final I_CmsPasswordFetcher passwordFetcher, final Runnable close) {
        this.setWidth("500px");
        FormLayout layout = new FormLayout();
        layout.setWidth("100%");
        layout.addStyleName("o-formlayout-workplace-main");
        layout.setMargin(true);
        layout.setSpacing(true);
        final TextField passwordField = new TextField();
        passwordField.setValue(CmsGeneratePasswordDialog.getRandomPassword());
        CmsButtonFormRow<TextField> row = new CmsButtonFormRow<TextField>(passwordField, (FontIcon)VaadinIcons.REFRESH, new Runnable(){

            @Override
            public void run() {
                passwordField.setValue(CmsGeneratePasswordDialog.getRandomPassword());
            }
        }, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GEN_PASSWORD_REFRESH_0", new Object[0]));
        Label label = new Label(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GEN_PASSWORD_TEXT_0", new Object[0]));
        label.setWidth("100%");
        layout.addComponent((Component)label);
        row.setWidth("100%");
        layout.addComponent(row);
        this.setContent((Component)layout);
        Button closeButton = new Button(CmsVaadinUtils.messageCancel());
        closeButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -8994698147835117427L;

            public void buttonClick(Button.ClickEvent event) {
                close.run();
            }
        });
        Button okButton = new Button(CmsVaadinUtils.messageOk());
        okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -1375411076842792728L;

            public void buttonClick(Button.ClickEvent event) {
                passwordFetcher.fetchPassword((String)passwordField.getValue());
                close.run();
            }
        });
        this.addButton((Component)okButton);
        this.addButton((Component)closeButton);
    }

    public static String getRandomPassword() {
        if (OpenCms.getPasswordHandler() instanceof I_CmsPasswordGenerator) {
            return ((I_CmsPasswordGenerator)((Object)OpenCms.getPasswordHandler())).getRandomPassword();
        }
        return CmsDefaultPasswordGenerator.getRandomPWD();
    }
}

