/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.user.CmsShowResourcesDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsShowResourceTable
extends Table {
    private static final long serialVersionUID = -7843045876535036146L;
    private static final Log LOG = CmsLog.getLog(CmsShowResourceTable.class);
    private static final String PROP_ICON = "icon";
    private static final String PROP_NAME = "name";
    private static final String PROP_PERMISSION = "permission";
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    CmsContextMenu m_menu = new CmsContextMenu();
    private IndexedContainer m_container;
    private CmsPrincipal m_principal;
    private CmsObject m_cms;

    public CmsShowResourceTable(CmsObject cms, CmsUUID principalID, CmsShowResourcesDialog.DialogType type) {
        this.m_menu.setAsTableContextMenu(this);
        this.setSelectable(true);
        try {
            this.m_cms = cms;
            this.m_principal = this.getPrincipal(cms, type, principalID);
            this.setSizeFull();
            this.m_container = new IndexedContainer();
            this.m_container.addContainerProperty((Object)PROP_ICON, Resource.class, null);
            this.m_container.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
            this.m_container.addContainerProperty((Object)PROP_PERMISSION, String.class, (Object)"");
            for (CmsResource res : this.getResourcesFromPrincipal(cms, principalID)) {
                CmsResourceUtil resUtil = new CmsResourceUtil(cms, res);
                Item item = this.m_container.addItem((Object)res);
                item.getItemProperty((Object)PROP_ICON).setValue((Object)resUtil.getSmallIconResource());
                item.getItemProperty((Object)PROP_NAME).setValue((Object)res.getRootPath());
                item.getItemProperty((Object)PROP_PERMISSION).setValue((Object)this.getPermissionString(cms, res, type));
            }
            this.setContainerDataSource((Container)this.m_container);
            this.setItemIconPropertyId(PROP_ICON);
            this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
            this.setColumnWidth(null, 40);
            this.setVisibleColumns(new Object[]{PROP_NAME, PROP_PERMISSION});
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read user information.", (Throwable)e);
        }
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -4738296706762013443L;

            public void itemClick(ItemClickEvent event) {
                CmsShowResourceTable.this.setValue(null);
                CmsShowResourceTable.this.select(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    CmsShowResourceTable.this.m_menu.setEntries(CmsShowResourceTable.this.getMenuEntries(), Collections.singleton(((CmsResource)CmsShowResourceTable.this.getValue()).getRootPath()));
                    CmsShowResourceTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsShowResourceTable.this);
                }
            }
        });
    }

    public boolean hasNoEntries() {
        return this.m_container.size() == 0;
    }

    protected CmsObject getCms() {
        return this.m_cms;
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new ExplorerEntry());
        }
        return this.m_menuEntries;
    }

    void openExplorerForParent(String rootPath, String uuid) {
        String parentPath = CmsResource.getParentFolder(rootPath);
        if (!rootPath.startsWith(this.m_cms.getRequestContext().getSiteRoot())) {
            this.m_cms.getRequestContext().setSiteRoot("");
        }
        CmsAppWorkplaceUi.get().showApp("explorer", this.m_cms.getRequestContext().getCurrentProject().getUuid() + "!!" + this.m_cms.getRequestContext().getSiteRoot() + "!!" + parentPath.substring(this.m_cms.getRequestContext().getSiteRoot().length()) + "!!" + uuid + "!!");
    }

    private String getPermissionString(CmsObject cms, CmsResource res, CmsShowResourcesDialog.DialogType type) throws CmsException {
        if (type.equals((Object)CmsShowResourcesDialog.DialogType.User)) {
            cms.getPermissions(res.getRootPath(), this.m_principal.getName()).getPermissionString();
        } else if (type.equals((Object)CmsShowResourcesDialog.DialogType.Group)) {
            for (CmsAccessControlEntry ace : cms.getAccessControlEntries(res.getRootPath(), false)) {
                if (!ace.getPrincipal().equals(this.m_principal.getId())) continue;
                return ace.getPermissions().getPermissionString();
            }
        }
        return "";
    }

    private CmsPrincipal getPrincipal(CmsObject cms, CmsShowResourcesDialog.DialogType type, CmsUUID id) throws CmsException {
        if (type.equals((Object)CmsShowResourcesDialog.DialogType.Group)) {
            return cms.readGroup(id);
        }
        if (type.equals((Object)CmsShowResourcesDialog.DialogType.User)) {
            return cms.readUser(id);
        }
        return null;
    }

    private Set<CmsResource> getResourcesFromPrincipal(CmsObject cms, CmsUUID id) throws CmsException {
        return cms.getResourcesForPrincipal(id, null, false);
    }

    class ExplorerEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExplorerEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                CmsResource res = CmsShowResourceTable.this.getCms().readResource(data.iterator().next());
                CmsShowResourceTable.this.openExplorerForParent(res.getRootPath(), res.getStructureId().getStringValue());
            }
            catch (CmsException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return Messages.get().getBundle(locale).key("GUI_EXPLORER_TITLE_0");
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }
}

