/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.A_CmsEditUserGroupRoleDialog;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.util.CmsUUID;

public class CmsUserEditGroupsDialog
extends A_CmsEditUserGroupRoleDialog {
    private static final long serialVersionUID = 7548706839526481814L;
    private static final Log LOG = CmsLog.getLog(CmsUserEditGroupsDialog.class);
    public static final String ID_OU = "ou";
    Button m_close;
    VerticalLayout m_leftTableHolder;
    VerticalLayout m_rightTableHolder;
    VerticalLayout m_vlayout;
    HorizontalLayout m_hlayout;

    public CmsUserEditGroupsDialog(CmsObject cms, CmsUUID userId, Window window, CmsAccountsApp app) {
        super(cms, userId, window, app);
    }

    @Override
    public void addItem(Set<String> data) {
        if (this.m_app.checkAddGroup((CmsUser)this.m_principal, data)) {
            for (String groupName : data) {
                try {
                    this.m_cms.addUserToGroup(this.m_principal.getName(), groupName);
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to add user to group", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getAddActionCaption() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_ADD_GROUP_0", new Object[0]);
    }

    @Override
    public String getAddCaptionText() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_CHOOSE_GROUP_0", new Object[0]);
    }

    @Override
    public IndexedContainer getAvailableItemsIndexedContainer(String caption, String propIcon) {
        try {
            return this.m_app.getAvailableGroupsContainerWithout(this.m_cms, this.m_principal.getOuFqn(), caption, propIcon, ID_OU, this.m_cms.getGroupsOfUser(this.m_principal.getName(), true), this.m_app::getGroupIcon);
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read groups of user", (Throwable)e);
            return null;
        }
    }

    @Override
    public Button getCloseButton() {
        return this.m_close;
    }

    @Override
    public String getCurrentTableCaption() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_CURRENTLY_SET_GROUPS_0", new Object[0]);
    }

    @Override
    public String getDescriptionForItemId(Object itemId) {
        return null;
    }

    @Override
    public String getEmptyMessage() {
        return "GUI_USERMANAGEMENT_EDIT_EMPTY_GROUPS_0";
    }

    @Override
    public String getFurtherColumnId() {
        return ID_OU;
    }

    @Override
    public HorizontalLayout getHLayout() {
        return this.m_hlayout;
    }

    @Override
    public String getItemName() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_NAME_0", new Object[0]);
    }

    @Override
    public IndexedContainer getItemsOfUserIndexedContainer(String propName, String propIcon, String propStatus) {
        CmsUser user = (CmsUser)this.m_principal;
        IndexedContainer container = this.m_app.getUserGroupsEditorContainer(user, propName, propIcon, propStatus);
        return container;
    }

    @Override
    public VerticalLayout getLeftTableLayout() {
        return this.m_leftTableHolder;
    }

    @Override
    public VerticalLayout getParentLayout() {
        return this.m_vlayout;
    }

    @Override
    public VerticalLayout getRightTableLayout() {
        return this.m_rightTableHolder;
    }

    @Override
    public Set<String> getStringSetValue(Set<Object> value) {
        HashSet<String> res = new HashSet<String>();
        for (Object o : value) {
            res.add(((CmsGroup)o).getName());
        }
        return res;
    }

    @Override
    public String getWindowCaptionMessageKey() {
        return "GUI_USERMANAGEMENT_EDIT_USERGROUP_1";
    }

    @Override
    public void removeItem(Set<String> items) {
        if (this.m_app.checkRemoveGroups((CmsUser)this.m_principal, items)) {
            Iterator<String> iterator = items.iterator();
            while (iterator.hasNext()) {
                try {
                    this.m_cms.removeUserFromGroup(this.m_principal.getName(), iterator.next());
                }
                catch (CmsException | CmsIllegalArgumentException exception) {}
            }
        }
    }
}

