/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.ItemCaptionGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.site.CmsSite;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPath;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsExtendedSiteSelector
extends ComboBox<SiteSelectorOption> {
    private static final Log LOG = CmsLog.getLog(CmsExtendedSiteSelector.class);
    private static final long serialVersionUID = 1L;
    public static final int LONG_PAGE_LENGTH = 20;
    private boolean m_initialized;
    private List<SiteSelectorOption> m_options = new ArrayList<SiteSelectorOption>();

    public CmsExtendedSiteSelector() {
        this.setDataProvider(new ListDataProvider(this.m_options));
        this.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> item.getLabel());
        this.setTextInputAllowed(true);
        this.setEmptySelectionAllowed(false);
        this.addAttachListener((ClientConnector.AttachListener & Serializable)evt -> {
            if (!this.m_initialized) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " must be initialized with initOptions");
            }
        });
    }

    public static List<SiteSelectorOption> getExplorerSiteSelectorOptions(CmsObject cms, boolean addSubsites) {
        LinkedHashMap<String, String> siteOptions = CmsVaadinUtils.getAvailableSitesMap(cms);
        ArrayList<String> subsites = new ArrayList<String>(OpenCms.getADEManager().getSubsitesForSiteSelector(cms.getRequestContext().getCurrentProject().isOnlineProject()));
        Collections.sort(subsites);
        ArrayListMultimap subsitesForSite = ArrayListMultimap.create();
        if (addSubsites) {
            try {
                CmsObject titleCms = OpenCms.initCmsObject(cms);
                titleCms.getRequestContext().setSiteRoot("");
                for (String subsite : subsites) {
                    Optional<String> remainingPath;
                    CmsPath siteRootPath;
                    CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(subsite);
                    if (site == null || !site.isSubsiteSelectionEnabled() || (siteRootPath = new CmsPath(site.getSiteRoot())).equals(new CmsPath(subsite)) || !(remainingPath = CmsStringUtil.removePrefixPath(site.getSiteRoot(), subsite)).isPresent()) continue;
                    try {
                        CmsResource subsiteRes = titleCms.readResource(subsite, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        CmsResourceUtil resUtil = new CmsResourceUtil(titleCms, subsiteRes);
                        String title = resUtil.getTitle();
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
                            title = subsiteRes.getName();
                        }
                        SiteSelectorOption option = new SiteSelectorOption(site.getSiteRoot(), remainingPath.get(), "\u2013 " + title);
                        subsitesForSite.put((Object)siteRootPath, (Object)option);
                    }
                    catch (CmsVfsResourceNotFoundException | CmsPermissionViolationException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<SiteSelectorOption> result = new ArrayList<SiteSelectorOption>();
        for (Map.Entry<String, String> entry : siteOptions.entrySet()) {
            result.add(new SiteSelectorOption(entry.getKey(), null, entry.getValue()));
            result.addAll(subsitesForSite.get((Object)new CmsPath(entry.getKey())));
        }
        return result;
    }

    public void initOptions(CmsObject cms, boolean addSubsites) {
        List<SiteSelectorOption> options = CmsExtendedSiteSelector.getExplorerSiteSelectorOptions(cms, addSubsites);
        this.m_options.clear();
        this.m_options.addAll(options);
        this.m_initialized = true;
    }

    public void selectSite(String siteRoot) {
        this.setValue(new SiteSelectorOption(siteRoot, null, null));
    }

    public static class SiteSelectorOption {
        private String m_label;
        private String m_path;
        private String m_site;

        public SiteSelectorOption(String site, String path, String label) {
            this.m_site = this.normalizePath(site);
            this.m_path = this.normalizePath(path);
            this.m_label = label;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SiteSelectorOption other = (SiteSelectorOption)obj;
            return Objects.equal((Object)this.m_site, (Object)other.m_site) && Objects.equal((Object)this.m_path, (Object)other.m_path);
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getSite() {
            return this.m_site;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_path == null ? 0 : this.m_path.hashCode());
            result = 31 * result + (this.m_site == null ? 0 : this.m_site.hashCode());
            return result;
        }

        private String normalizePath(String path) {
            if (path == null) {
                return null;
            }
            return CmsFileUtil.removeTrailingSeparator(path);
        }
    }
}

