/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsInfoButton
extends Button {
    private static final long serialVersionUID = 5718515094289838271L;
    private static final FontOpenCms ICON = FontOpenCms.INFO;
    protected String m_windowCaption;
    Button m_addButton;
    private List<String> m_htmlLines;
    private List<InfoElementBean> m_additionalElements = new ArrayList<InfoElementBean>();
    private Button.ClickListener m_clickListener;

    public CmsInfoButton() {
        super((Resource)ICON);
        this.ini(new ArrayList<String>());
    }

    public CmsInfoButton(List<String> htmlLines) {
        super((Resource)ICON);
        this.m_htmlLines = htmlLines;
        this.ini(htmlLines);
    }

    public CmsInfoButton(Map<String, String> infos) {
        super((Resource)ICON);
        this.ini(this.getHtmlLines(infos));
    }

    public void addAdditionalElement(Component component) {
        this.m_additionalElements.add(new InfoElementBean(this.m_additionalElements.size() + 1, component));
        this.removeClickListener(this.m_clickListener);
        this.m_clickListener = this.getClickListener(this.m_htmlLines, this.m_additionalElements);
        this.addClickListener(this.m_clickListener);
    }

    public void addAdditionalElement(Component component, int pos) {
        this.m_additionalElements.add(new InfoElementBean(pos, component));
        this.removeClickListener(this.m_clickListener);
        this.m_clickListener = this.getClickListener(this.m_htmlLines, this.m_additionalElements);
        this.addClickListener(this.m_clickListener);
    }

    public VerticalLayout getInfoLayout() {
        return this.getLayout(this.m_htmlLines, this.m_additionalElements);
    }

    public void replaceData(Map<String, String> data) {
        this.removeClickListener(this.m_clickListener);
        this.m_clickListener = this.getClickListener(this.getHtmlLines(data), this.m_additionalElements);
        this.addClickListener(this.m_clickListener);
    }

    public void setAdditionalButton(Button button) {
        this.m_addButton = button;
    }

    public void setWindowCaption(String caption) {
        this.m_windowCaption = caption;
    }

    protected VerticalLayout getLayout(List<String> htmlLines, List<InfoElementBean> additionalElements) {
        VerticalLayout layout = new VerticalLayout();
        Label label = new Label();
        label.setWidthUndefined();
        layout.setMargin(true);
        label.setContentMode(ContentMode.HTML);
        layout.addStyleName("o-info-dialog");
        String htmlContent = "";
        for (String line : htmlLines) {
            htmlContent = htmlContent + line;
        }
        label.setValue(htmlContent);
        layout.addComponent((Component)label);
        for (InfoElementBean infoElement : additionalElements) {
            layout.addComponent(infoElement.getComponent(), infoElement.getPos());
        }
        layout.setWidthUndefined();
        return layout;
    }

    private Button.ClickListener getClickListener(final List<String> htmlLines, final List<InfoElementBean> additionalElements) {
        return new Button.ClickListener(){
            private static final long serialVersionUID = -553128629431329217L;

            public void buttonClick(Button.ClickEvent event) {
                final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.content);
                window.setCaption(CmsInfoButton.this.m_windowCaption == null ? CmsVaadinUtils.getMessageText("GUI_INFO_BUTTON_CAPTION_0", new Object[0]) : CmsInfoButton.this.m_windowCaption);
                window.setResizable(false);
                CmsBasicDialog dialog = new CmsBasicDialog();
                if (CmsInfoButton.this.m_addButton != null) {
                    dialog.addButton((Component)CmsInfoButton.this.m_addButton, false);
                }
                VerticalLayout layout = CmsInfoButton.this.getLayout(htmlLines, additionalElements);
                dialog.setContent((Component)layout);
                Button button = new Button(CmsVaadinUtils.messageClose());
                button.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 5789436407764072884L;

                    public void buttonClick(Button.ClickEvent event1) {
                        window.close();
                    }
                });
                dialog.addButton((Component)button);
                window.setContent((Component)dialog);
                UI.getCurrent().addWindow(window);
            }
        };
    }

    private List<String> getHtmlLines(Map<String, String> infos) {
        ArrayList<String> htmlLines = new ArrayList<String>();
        for (String key : infos.keySet()) {
            htmlLines.add("<div style=\"display:flex;align-items:flex-end;\"><div class=\"o-info-dialog-name\">" + key + " :</div><div style=\"width:140px;\" class=\"" + "o-info-dialog-value" + "\">" + infos.get(key) + "</div></div>");
        }
        this.m_htmlLines = htmlLines;
        return htmlLines;
    }

    private void ini(List<String> htmlLines) {
        this.addStyleName("borderless");
        this.addStyleName("o-toolbar-button");
        this.m_clickListener = this.getClickListener(htmlLines, this.m_additionalElements);
        this.addClickListener(this.m_clickListener);
    }

    class InfoElementBean {
        private int m_pos;
        private Component m_component;

        InfoElementBean(int pos, Component comp) {
            this.m_pos = pos;
            this.m_component = comp;
        }

        protected Component getComponent() {
            return this.m_component;
        }

        protected int getPos() {
            return this.m_pos;
        }
    }
}

