/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.TextField;
import com.vaadin.v7.ui.Label;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceInfo
extends CustomLayout {
    private static final String BUTTON_CONTAINER = "buttonContainer";
    private static final Log LOG = CmsLog.getLog(CmsResourceInfo.class);
    private static final long serialVersionUID = -1715926038770100307L;
    private Label m_bottomText = new Label();
    private Label m_buttonLabel = new Label();
    private CmsResourceIcon m_icon = new CmsResourceIcon();
    private Label m_topText = new Label();
    private TextField m_topInput = new TextField();

    public CmsResourceInfo() {
        try {
            this.initTemplateContentsFromInputStream(CmsVaadinUtils.readCustomLayout(CmsResourceInfo.class, "resourceinfo.html"));
            this.addComponent((Component)this.m_topText, "topLabel");
            this.addComponent((Component)this.m_bottomText, "bottomLabel");
            this.addComponent((Component)this.m_icon, "icon");
            this.addComponent((Component)this.m_buttonLabel, BUTTON_CONTAINER);
            this.addComponent((Component)this.m_topInput, "topInput");
            this.m_topInput.setVisible(false);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsResourceInfo(CmsResource resource) {
        this(resource, true);
    }

    public CmsResourceInfo(CmsResource resource, boolean useState) {
        this();
        Locale locale = A_CmsUI.get().getLocale();
        CmsResourceUtil resourceUtil = new CmsResourceUtil(A_CmsUI.getCmsObject(), resource);
        resourceUtil.setAbbrevLength(100);
        String galleryTitle = resourceUtil.getGalleryTitle(locale);
        this.m_topText.setValue(galleryTitle);
        this.m_topInput.setValue(galleryTitle);
        this.m_bottomText.setValue(resourceUtil.getPath());
        this.m_icon.initContent(resourceUtil, useState ? resource.getState() : null, true, true);
    }

    public CmsResourceInfo(String top, String bottom, Resource iconResource) {
        this();
        this.m_topText.setValue(top);
        this.m_topInput.setValue(top);
        this.m_bottomText.setValue(bottom);
        this.m_icon.initContent(null, iconResource, null, false, true);
    }

    public CmsResourceInfo(String top, String bottom, String iconPath) {
        this();
        this.m_topText.setValue(top);
        this.m_topInput.setValue(top);
        this.m_bottomText.setValue(bottom);
        this.m_icon.initContent(null, (Resource)new ExternalResource(iconPath), null, false, true);
    }

    public static CmsResourceInfo createSitemapResourceInfo(CmsResource resource, CmsSite baseSite) {
        String siteRoot;
        String title = resource.getName();
        String path = resource.getRootPath();
        CmsResourceInfo info = new CmsResourceInfo();
        CmsResourceUtil resUtil = new CmsResourceUtil(A_CmsUI.getCmsObject(), resource);
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            Map<String, CmsProperty> props = CmsProperty.toObjectMap(cms.readPropertyObjects(resource, false));
            CmsProperty navtextProp = props.get("NavText");
            CmsProperty titleProp = props.get("Title");
            if (navtextProp != null && navtextProp.getValue() != null) {
                title = navtextProp.getValue();
            } else if (titleProp != null && titleProp.getValue() != null) {
                title = titleProp.getValue();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        info.getTopLine().setValue(title);
        if (baseSite != null && path.startsWith(siteRoot = baseSite.getSiteRoot())) {
            path = path.substring(siteRoot.length());
            path = CmsStringUtil.joinPaths("/", path);
        }
        info.getBottomLine().setValue(path);
        Resource icon = CmsResourceIcon.getSitemapResourceIcon(A_CmsUI.getCmsObject(), resUtil.getResource(), CmsResourceIcon.IconMode.localeCompare);
        info.getResourceIcon().initContent(resUtil, icon, null, true, false);
        return info;
    }

    public void decorateTopInput() {
        this.m_topText.setVisible(false);
        this.m_topInput.setVisible(true);
    }

    public void decorateTopLabel() {
        this.m_topText.setVisible(true);
        this.m_topInput.setVisible(false);
    }

    public Label getBottomLine() {
        return this.m_bottomText;
    }

    public Component getButtonWidget() {
        return this.getComponent(BUTTON_CONTAINER);
    }

    public CmsResourceIcon getResourceIcon() {
        return this.m_icon;
    }

    public TextField getTopInput() {
        return this.m_topInput;
    }

    public Label getTopLine() {
        return this.m_topText;
    }

    public void setButtonWidget(Component button) {
        this.addComponent(button, BUTTON_CONTAINER);
    }

    public void setTopLineText(String text) {
        this.m_topText.setValue(text);
        this.m_topInput.setValue(text);
    }
}

