/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.editablegroup;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.v7.ui.Label;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ui.components.editablegroup.CmsEditableGroupRow;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;

public class CmsEditableGroup {
    private AbstractOrderedLayout m_container;
    private boolean m_editEnabled;
    private I_EmptyHandler m_emptyHandler;
    private Label m_errorLabel = new Label();
    private Component.Listener m_errorListener;
    private String m_errorMessage;
    private boolean m_hideAdd = false;
    private Supplier<Component> m_newComponentFactory;
    private I_RowBuilder m_rowBuilder = new DefaultRowBuilder();
    private String m_rowCaption;

    public CmsEditableGroup(AbstractOrderedLayout container, Supplier<Component> componentFactory, I_EmptyHandler emptyHandler) {
        this.m_emptyHandler = emptyHandler;
        this.m_container = container;
        this.m_newComponentFactory = componentFactory;
        this.m_emptyHandler = emptyHandler;
        this.m_emptyHandler.init(this);
        this.m_errorListener = new Component.Listener(){
            private static final long serialVersionUID = 1L;

            public void componentEvent(Component.Event event) {
                if (event instanceof Component.ErrorEvent) {
                    CmsEditableGroup.this.updateGroupValidation();
                }
            }
        };
        this.m_errorLabel.setValue(this.m_errorMessage);
        this.m_errorLabel.addStyleName("o-editablegroup-errorlabel");
        this.setErrorVisible(false);
    }

    public CmsEditableGroup(AbstractOrderedLayout container, Supplier<Component> componentFactory, String addButtonCaption) {
        this(container, componentFactory, new AddButtonEmptyHandler(addButtonCaption));
    }

    public void addRow(Component component) {
        Component actualComponent = component == null ? (Component)this.m_newComponentFactory.get() : component;
        I_CmsEditableGroupRow row = this.m_rowBuilder.buildRow(this, actualComponent);
        this.m_container.addComponent((Component)row);
        this.updatePlaceholder();
        this.updateButtonBars();
        this.updateGroupValidation();
    }

    public void addRowAfter(I_CmsEditableGroupRow row) {
        int index = this.m_container.getComponentIndex((Component)row);
        if (index >= 0) {
            Component component = (Component)this.m_newComponentFactory.get();
            I_CmsEditableGroupRow newRow = this.m_rowBuilder.buildRow(this, component);
            this.m_container.addComponent((Component)newRow, index + 1);
        }
        this.updatePlaceholder();
        this.updateButtonBars();
        this.updateGroupValidation();
    }

    public AbstractOrderedLayout getContainer() {
        return this.m_container;
    }

    public Component.Listener getErrorListener() {
        return this.m_errorListener;
    }

    public Supplier<Component> getNewComponentFactory() {
        return this.m_newComponentFactory;
    }

    public String getRowCaption() {
        return this.m_rowCaption;
    }

    public List<I_CmsEditableGroupRow> getRows() {
        ArrayList result = Lists.newArrayList();
        for (Component component : this.m_container) {
            if (!(component instanceof I_CmsEditableGroupRow)) continue;
            result.add((I_CmsEditableGroupRow)component);
        }
        return result;
    }

    public void init() {
        this.m_container.removeAllComponents();
        this.m_container.addComponent((Component)this.m_errorLabel);
        this.updatePlaceholder();
    }

    public void moveDown(I_CmsEditableGroupRow row) {
        int index = this.m_container.getComponentIndex((Component)row);
        if (index >= 0 && index < this.m_container.getComponentCount() - 1) {
            this.m_container.removeComponent((Component)row);
            this.m_container.addComponent((Component)row, index + 1);
        }
        this.updateButtonBars();
    }

    public void moveUp(I_CmsEditableGroupRow row) {
        int index = this.m_container.getComponentIndex((Component)row);
        if (index > 0) {
            this.m_container.removeComponent((Component)row);
            this.m_container.addComponent((Component)row, index - 1);
        }
        this.updateButtonBars();
    }

    public void onEdit(I_CmsEditableGroupRow row) {
    }

    public void remove(I_CmsEditableGroupRow row) {
        int index = this.m_container.getComponentIndex((Component)row);
        if (index >= 0) {
            this.m_container.removeComponent((Component)row);
        }
        this.updatePlaceholder();
        this.updateButtonBars();
        this.updateGroupValidation();
    }

    public void removeAll() {
        this.m_container.removeAllComponents();
        this.updatePlaceholder();
        this.updateButtonBars();
        this.updateGroupValidation();
    }

    public void setAddButtonVisible(boolean visible) {
        this.m_hideAdd = !visible;
    }

    public void setEditEnabled(boolean enabled) {
        this.m_editEnabled = enabled;
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
        this.m_errorLabel.setValue(errorMessage != null ? errorMessage : "");
    }

    public void setRowBuilder(I_RowBuilder rowBuilder) {
        this.m_rowBuilder = rowBuilder;
    }

    public void setRowCaption(String rowCaption) {
        this.m_rowCaption = rowCaption;
    }

    protected boolean hasError(Component component) {
        if (component instanceof AbstractComponent && ((AbstractComponent)component).getComponentError() != null) {
            return true;
        }
        return component instanceof I_HasError && ((I_HasError)component).hasEditableGroupError();
    }

    private void setErrorVisible(boolean hasError) {
        this.m_errorLabel.setVisible(hasError && this.m_errorMessage != null);
    }

    private void updateButtonBars() {
        List<I_CmsEditableGroupRow> rows = this.getRows();
        int i = 0;
        for (I_CmsEditableGroupRow row : rows) {
            boolean first = i == 0;
            boolean last = i == rows.size() - 1;
            row.getButtonBar().setFirstLast(first, last, this.m_hideAdd);
            row.getButtonBar().getState().setEditEnabled(this.m_editEnabled);
            ++i;
        }
    }

    private void updateGroupValidation() {
        boolean hasError = false;
        for (I_CmsEditableGroupRow row : this.getRows()) {
            if (!this.hasError(row.getComponent())) continue;
            hasError = true;
            break;
        }
        this.setErrorVisible(hasError);
    }

    private void updatePlaceholder() {
        boolean empty = this.getRows().size() == 0;
        this.m_emptyHandler.setEmpty(empty);
    }

    public static interface I_RowBuilder {
        public I_CmsEditableGroupRow buildRow(CmsEditableGroup var1, Component var2);
    }

    public static interface I_HasError {
        public boolean hasEditableGroupError();
    }

    public static interface I_EmptyHandler {
        public void init(CmsEditableGroup var1);

        public void setEmpty(boolean var1);
    }

    public static class DefaultRowBuilder
    implements I_RowBuilder {
        @Override
        public I_CmsEditableGroupRow buildRow(CmsEditableGroup group, Component component) {
            if (component instanceof Layout.MarginHandler) {
                Layout.MarginHandler marginHandler = (Layout.MarginHandler)component;
                marginHandler.setMargin(false);
            }
            if (component instanceof AbstractComponent) {
                component.addListener(group.getErrorListener());
            }
            CmsEditableGroupRow row = new CmsEditableGroupRow(group, component);
            if (group.getRowCaption() != null) {
                row.setCaption(group.getRowCaption());
            }
            return row;
        }
    }

    public static class AddButtonEmptyHandler
    implements I_EmptyHandler {
        private Button m_addButton;
        private CmsEditableGroup m_group;

        public AddButtonEmptyHandler(String addButtonText) {
            this.m_addButton = new Button(addButtonText);
            this.m_addButton.addClickListener((Button.ClickListener & Serializable)evt -> {
                Component component = (Component)this.m_group.getNewComponentFactory().get();
                this.m_group.addRow(component);
            });
        }

        @Override
        public void init(CmsEditableGroup group) {
            this.m_group = group;
        }

        @Override
        public void setEmpty(boolean empty) {
            if (empty) {
                this.m_group.getContainer().addComponent((Component)this.m_addButton);
            } else {
                this.m_group.getContainer().removeComponent((Component)this.m_addButton);
            }
        }
    }
}

