/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialog;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsFileSelectField<T>
extends CustomField<T>
implements CmsEditableGroup.I_HasError {
    private static final Log LOG = CmsLog.getLog(A_CmsFileSelectField.class);
    private static final long serialVersionUID = 1L;
    protected String m_fileSelectCaption;
    protected CmsResourceFilter m_filter;
    protected boolean m_startWithSitemapView;
    protected TextField m_textField = new TextField();
    Button m_fileSelectButton;
    private boolean m_fileselectVisible = true;
    protected CmsObject m_cms;
    protected boolean m_diableSiteSwitch;
    private String m_defaultPath = "";
    private boolean m_requireFolder;
    private boolean m_requireFile;
    private String m_basePath = "/";

    public A_CmsFileSelectField() {
        this.m_textField.setWidth("100%");
        this.m_filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
    }

    public void disableSiteSwitch() {
        this.m_diableSiteSwitch = true;
    }

    @Override
    public boolean hasEditableGroupError() {
        return this.m_textField.getComponentError() != null;
    }

    public void requireFile() {
        this.m_requireFile = true;
        this.m_requireFolder = false;
    }

    public void requireFolder() {
        this.m_requireFile = false;
        this.m_requireFolder = true;
    }

    public void resetRequireType() {
        this.m_requireFile = false;
        this.m_requireFolder = false;
    }

    public void setBasePath(String path) {
        this.m_basePath = path;
    }

    public void setCmsObject(CmsObject cms) {
        this.m_cms = cms;
    }

    public void setDefaultPath(String path) {
        this.m_defaultPath = path;
        if (!this.m_defaultPath.endsWith("/")) {
            this.m_defaultPath = this.m_defaultPath + "/";
        }
        this.m_defaultPath = this.m_defaultPath + "aa";
    }

    public void setFileSelectButtonVisible(boolean visible) {
        this.m_fileselectVisible = visible;
        if (this.m_fileSelectButton != null) {
            this.m_fileSelectButton.setVisible(visible);
        }
    }

    public void setFileSelectCaption(String caption) {
        this.m_fileSelectCaption = caption;
    }

    public void setResourceFilter(CmsResourceFilter filter) {
        this.m_filter = filter;
    }

    public void setStartWithSitempaView(boolean startWithSitemapView) {
        this.m_startWithSitemapView = startWithSitemapView;
    }

    protected CmsResourceSelectDialog.Options getOptions() {
        CmsResourceSelectDialog.Options options = new CmsResourceSelectDialog.Options();
        return options;
    }

    protected CssLayout initContent() {
        CssLayout layout = new CssLayout();
        if (this.m_fileselectVisible) {
            layout.addStyleName("o-fileselect");
        }
        layout.setWidth("100%");
        layout.addComponent((Component)this.m_textField);
        if (this.m_fileselectVisible) {
            Label spacer = new Label("");
            spacer.addStyleName("o-fileselect-spacer");
            spacer.setContentMode(ContentMode.HTML);
            spacer.setValue("<div></div>");
            layout.addComponent((Component)spacer);
        }
        this.m_fileSelectButton = new Button("");
        this.m_fileSelectButton.addStyleName("o-button-icon");
        this.m_fileSelectButton.setIcon((Resource)FontOpenCms.GALLERY);
        this.m_fileSelectButton.addStyleName("o-fileselect-button");
        this.m_fileSelectButton.setEnabled(this.m_fileselectVisible);
        if (this.m_fileselectVisible) {
            layout.addComponent((Component)this.m_fileSelectButton);
        }
        this.m_fileSelectButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsFileSelectField.this.openFileSelector();
            }
        });
        return layout;
    }

    protected void openFileSelector() {
        try {
            final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            window.setCaption(this.m_fileSelectCaption != null ? this.m_fileSelectCaption : this.getWindowCaption());
            A_CmsUI.get().addWindow(window);
            CmsResourceSelectDialog fileSelect = this.m_cms == null ? new CmsResourceSelectDialog(this.m_filter, A_CmsUI.getCmsObject(), this.getOptions()) : new CmsResourceSelectDialog(this.m_filter, this.m_cms, this.getOptions());
            if (this.m_diableSiteSwitch) {
                fileSelect.disableSiteSwitch();
            }
            fileSelect.showSitemapView(this.m_startWithSitemapView);
            Object value = this.getValue();
            if (value instanceof CmsResource) {
                fileSelect.showStartResource((CmsResource)value);
            } else if (value instanceof String) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                    fileSelect.openPath(this.m_defaultPath);
                } else {
                    fileSelect.openPath((String)value);
                }
            }
            window.setContent((Component)fileSelect);
            fileSelect.addSelectionHandler(new I_CmsSelectionHandler<CmsResource>(){

                @Override
                public void onSelection(CmsResource selected) {
                    if (!A_CmsFileSelectField.this.resourceIsValid(selected)) {
                        return;
                    }
                    A_CmsFileSelectField.this.setResourceValue(selected);
                    window.close();
                }
            });
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    protected boolean resourceIsValid(CmsResource resource) {
        if (!resource.getRootPath().startsWith(this.m_basePath)) {
            return false;
        }
        if (this.m_requireFile & resource.isFolder()) {
            return false;
        }
        return !(this.m_requireFolder & resource.isFile());
    }

    protected abstract void setResourceValue(CmsResource var1);

    private String getWindowCaption() {
        if (this.m_requireFolder) {
            return CmsVaadinUtils.getMessageText("GUI_FOLDER_SELECT_CAPTION_0", new Object[0]);
        }
        return CmsVaadinUtils.getMessageText("GUI_FILE_SELECT_CAPTION_0", new Object[0]);
    }
}

