/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialogContents;
import org.opencms.ui.components.fileselect.CmsResourceTreeContainer;
import org.opencms.ui.components.fileselect.CmsResourceTreeTable;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResourceSelectDialog
extends CustomComponent {
    public static final String PROPERTY_SITE_CAPTION = "caption";
    private static final Log LOG = CmsLog.getLog(CmsResourceSelectDialog.class);
    private static final long serialVersionUID = 1L;
    protected CmsObject m_currentCms;
    protected CmsResourceFilter m_filter;
    protected CmsResource m_root;
    private CmsResourceTreeTable m_fileTree;
    private boolean m_isSitemapView = true;
    private String m_siteRoot;
    private CmsResourceTreeContainer m_treeData;

    public CmsResourceSelectDialog(CmsResourceFilter filter) throws CmsException {
        this(filter, A_CmsUI.getCmsObject());
    }

    public CmsResourceSelectDialog(CmsResourceFilter filter, CmsObject cms) throws CmsException {
        this(filter, cms, new Options());
    }

    public CmsResourceSelectDialog(CmsResourceFilter filter, CmsObject cms, Options options) throws CmsException {
        this.m_filter = filter;
        this.setCompositionRoot((Component)new CmsResourceSelectDialogContents());
        IndexedContainer container = options.getSiteSelectionContainer() != null ? options.getSiteSelectionContainer() : CmsVaadinUtils.getAvailableSitesContainer(cms, PROPERTY_SITE_CAPTION);
        this.getSiteSelector().setContainerDataSource((Container)container);
        if (!cms.existsResource("/", CmsResourceFilter.IGNORE_EXPIRATION)) {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setSiteRoot("/system/");
        }
        this.m_siteRoot = cms.getRequestContext().getSiteRoot();
        this.getSiteSelector().setValue((Object)CmsVaadinUtils.getPathItemId(this.getSiteSelector().getContainerDataSource(), this.m_siteRoot));
        this.getSiteSelector().setNullSelectionAllowed(false);
        this.getSiteSelector().setItemCaptionPropertyId((Object)PROPERTY_SITE_CAPTION);
        this.getSiteSelector().setFilteringMode(FilteringMode.CONTAINS);
        this.getSiteSelector().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String site = (String)event.getProperty().getValue();
                CmsResourceSelectDialog.this.onSiteChange(site);
            }
        });
        CmsResource root = cms.readResource("/");
        this.m_fileTree = this.createTree(cms, root);
        this.m_fileTree.setColumnExpandRatio("CAPTION_FOLDERS", 5.0f);
        this.m_fileTree.setColumnExpandRatio(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, 1.0f);
        this.m_treeData = this.m_fileTree.getTreeContainer();
        this.updateRoot(cms, root);
        this.getContents().getTreeContainer().addComponent((Component)this.m_fileTree);
        this.m_fileTree.setSizeFull();
        this.updateView();
    }

    public void addSelectionHandler(I_CmsSelectionHandler<CmsResource> handler) {
        this.m_fileTree.addResourceSelectionHandler(handler);
    }

    public void disableSiteSwitch() {
        this.getSiteSelector().setEnabled(false);
    }

    public void openPath(String path) {
        if (!CmsStringUtil.isPrefixPath(this.m_root.getRootPath(), path)) {
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(path);
            if (site != null) {
                this.getSiteSelector().setValue((Object)site.getSiteRoot());
                path = this.m_currentCms.getRequestContext().removeSiteRoot(path);
            } else if (OpenCms.getSiteManager().startsWithShared(path)) {
                this.getSiteSelector().setValue((Object)OpenCms.getSiteManager().getSharedFolder());
            } else if (path.startsWith("/system/")) {
                Container container = this.getSiteSelector().getContainerDataSource();
                String newSiteRoot = null;
                for (String possibleSiteRoot : Arrays.asList("", "/", "/system", "/system/")) {
                    if (!container.containsId((Object)possibleSiteRoot)) continue;
                    newSiteRoot = possibleSiteRoot;
                    break;
                }
                if (newSiteRoot == null) {
                    LOG.warn((Object)("Couldn't open path in site selector because neither root site nor system folder are in the site selector. path=" + path));
                    return;
                }
                this.getSiteSelector().setValue(newSiteRoot);
            }
        }
        if (!"/".equals(path)) {
            ArrayList idsToOpen = Lists.newArrayList();
            try {
                CmsResource currentFolder = this.m_currentCms.readResource(CmsResource.getParentFolder(path));
                if (!this.m_root.getStructureId().equals(currentFolder.getStructureId())) {
                    idsToOpen.add(currentFolder.getStructureId());
                    CmsResource parentFolder = null;
                    do {
                        try {
                            parentFolder = this.m_currentCms.readParentFolder(currentFolder.getStructureId());
                            idsToOpen.add(parentFolder.getStructureId());
                            currentFolder = parentFolder;
                        }
                        catch (NullPointerException | CmsException e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            break;
                        }
                    } while (!parentFolder.getStructureId().equals(this.m_root.getStructureId()));
                    Collections.reverse(idsToOpen);
                    for (CmsUUID id : idsToOpen) {
                        this.m_fileTree.expandItem(id);
                    }
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)"Can not read parent folder of current path.", (Throwable)e);
            }
        }
    }

    public void showSitemapView(boolean showSitemapView) {
        if (this.m_isSitemapView != showSitemapView) {
            this.m_isSitemapView = showSitemapView;
            this.updateView();
        }
    }

    public void showStartResource(CmsResource startResource) {
        this.openPath(startResource.getRootPath());
    }

    protected CmsResourceTreeTable createTree(CmsObject cms, CmsResource root) {
        return new CmsResourceTreeTable(cms, root, this.m_filter);
    }

    protected CmsResourceSelectDialogContents getContents() {
        return (CmsResourceSelectDialogContents)this.getCompositionRoot();
    }

    protected CmsResourceTreeTable getFileTree() {
        return this.m_fileTree;
    }

    protected void onSiteChange(String site) {
        try {
            this.m_treeData.removeAllItems();
            CmsObject rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            rootCms.getRequestContext().setSiteRoot("");
            CmsResource siteRootResource = rootCms.readResource(site);
            this.m_treeData.initRoot(rootCms, siteRootResource);
            this.m_fileTree.expandItem(siteRootResource.getStructureId());
            this.m_siteRoot = site;
            this.updateRoot(rootCms, siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void updateRoot(CmsObject rootCms, CmsResource siteRootResource) {
        this.m_root = siteRootResource;
        this.m_currentCms = rootCms;
        this.updateView();
    }

    protected void updateView() {
        this.m_fileTree.showSitemapView(this.m_isSitemapView);
    }

    private ComboBox getSiteSelector() {
        return this.getContents().getSiteSelector();
    }

    class PathSelectionAdapter
    implements I_CmsSelectionHandler<CmsResource> {
        private I_CmsSelectionHandler<String> m_pathHandler;
        private boolean m_useSitePaths;

        public PathSelectionAdapter(I_CmsSelectionHandler<String> pathHandler, boolean useSitePaths) {
            this.m_pathHandler = pathHandler;
            this.m_useSitePaths = useSitePaths;
        }

        @Override
        public void onSelection(CmsResource selected) {
            String path = selected.getRootPath();
            if (this.m_useSitePaths) {
                try {
                    CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    cms.getRequestContext().setSiteRoot(CmsResourceSelectDialog.this.m_siteRoot);
                    path = cms.getRequestContext().removeSiteRoot(path);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_pathHandler.onSelection(path);
        }
    }

    public static class Options {
        private IndexedContainer m_siteSelectionContainer;

        public IndexedContainer getSiteSelectionContainer() {
            return this.m_siteSelectionContainer;
        }

        public void setSiteSelectionContainer(IndexedContainer siteSelectionContainer) {
            this.m_siteSelectionContainer = siteSelectionContainer;
        }
    }
}

