/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.annotations.Theme;
import com.vaadin.server.VaadinRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

@Theme(value="opencms")
public class CmsEmbeddedDialogsUI
extends A_CmsUI {
    public static final String DIALOGS_PATH = "dialogs/";
    private static final Log LOG = CmsLog.getLog(CmsEmbeddedDialogsUI.class);
    private static final long serialVersionUID = 1201184887611215370L;
    CmsEmbeddedDialogContext m_currentContext;

    public static String getEmbeddedDialogsContextPath() {
        return CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getWorkplaceContext(), DIALOGS_PATH);
    }

    public Locale getLocale() {
        CmsObject cms = CmsEmbeddedDialogsUI.getCmsObject();
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
    }

    @Override
    public void reload() {
        if (this.m_currentContext != null) {
            this.m_currentContext.reload();
        }
    }

    @Override
    protected void init(VaadinRequest request) {
        String errorMessage;
        Throwable t;
        block17: {
            super.init(request);
            t = null;
            errorMessage = null;
            try {
                OpenCms.getRoleManager().checkRole(CmsEmbeddedDialogsUI.getCmsObject(), CmsRole.ELEMENT_AUTHOR);
                if ("principalselect".equals(this.getDialogId(request))) {
                    this.m_currentContext = new CmsEmbeddedDialogContext("principalselect", null, null);
                    CmsPrincipalSelectDialog.openEmbeddedDialog(this.m_currentContext, request.getParameterMap());
                    break block17;
                }
                try {
                    I_CmsDialogContext.ContextType type;
                    List<CmsResource> resourceList;
                    String resources = request.getParameter("resources");
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resources)) {
                        resourceList = new ArrayList();
                        String[] resIds = resources.split(";");
                        for (int i = 0; i < resIds.length; ++i) {
                            if (!CmsUUID.isValidUUID(resIds[i])) continue;
                            resourceList.add(CmsEmbeddedDialogsUI.getCmsObject().readResource(new CmsUUID(resIds[i]), CmsResourceFilter.ALL));
                        }
                    } else {
                        resourceList = Collections.emptyList();
                    }
                    String typeParam = request.getParameter("contextType");
                    boolean isEditor = Boolean.parseBoolean(request.getParameter("editor"));
                    String appId = "";
                    try {
                        type = I_CmsDialogContext.ContextType.valueOf(typeParam);
                        if (I_CmsDialogContext.ContextType.containerpageToolbar.equals((Object)type)) {
                            appId = "pageeditor";
                        } else if (I_CmsDialogContext.ContextType.sitemapToolbar.equals((Object)type)) {
                            appId = "sitemapeditor";
                        } else if (isEditor) {
                            appId = "editor";
                        }
                    }
                    catch (Exception e) {
                        type = I_CmsDialogContext.ContextType.appToolbar;
                        LOG.error((Object)("Could not parse context type parameter " + typeParam));
                    }
                    this.m_currentContext = new CmsEmbeddedDialogContext(appId, type, resourceList);
                    I_CmsWorkplaceAction action = this.getAction(request);
                    if (action.isActive(this.m_currentContext)) {
                        action.executeAction(this.m_currentContext);
                        break block17;
                    }
                    errorMessage = CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_TITLE_0", new Object[0]);
                }
                catch (Throwable e) {
                    t = e;
                    errorMessage = CmsVaadinUtils.getMessageText("ERR_DAILOG_INSTANTIATION_FAILED_1", request.getPathInfo());
                }
            }
            catch (CmsRoleViolationException ex) {
                t = ex;
                errorMessage = CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_TITLE_0", new Object[0]);
            }
        }
        if (errorMessage != null) {
            CmsErrorDialog.showErrorDialog(errorMessage, t, new Runnable(){

                @Override
                public void run() {
                    CmsEmbeddedDialogsUI.this.m_currentContext = new CmsEmbeddedDialogContext("", null, Collections.emptyList());
                    CmsEmbeddedDialogsUI.this.m_currentContext.finish((Collection<CmsUUID>)null);
                }
            });
        }
    }

    private I_CmsWorkplaceAction getAction(VaadinRequest request) throws Exception {
        String dialogId = this.getDialogId(request);
        Class<?> actionClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(dialogId);
        return (I_CmsWorkplaceAction)actionClass.newInstance();
    }

    private String getDialogId(VaadinRequest request) {
        String path = request.getPathInfo();
        return path != null ? path.substring(1) : null;
    }
}

