/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSchedulerConfiguration;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.Messages;

public class CmsPublishScheduledDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 7488454443783670970L;
    private static final Log LOG = CmsLog.getLog(CmsPublishScheduledDialog.class);
    private static CmsObject m_adminCms;
    private I_CmsDialogContext m_context;
    private CmsDateField m_dateField;
    private Button m_okButton;
    private Button m_cancelButton;
    private CheckBox m_includeSubResources;

    public CmsPublishScheduledDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.displayResourceInfo(context.getResources());
        FormLayout form = this.initForm();
        this.setContent((Component)form);
        this.m_okButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPublishScheduledDialog.this.submit();
            }
        });
        this.addButton((Component)this.m_okButton);
        this.m_cancelButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPublishScheduledDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsPublishScheduledDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsPublishScheduledDialog.this.submit();
            }
        });
        this.m_dateField.setRangeStart(LocalDateTime.now());
    }

    public static void setAdminCms(CmsObject cms) {
        m_adminCms = cms;
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    void submit() {
        Date dateValue;
        long publishTime;
        long current = System.currentTimeMillis();
        if (current > (publishTime = (dateValue = this.m_dateField.getDate()).getTime())) {
            this.m_context.error(new CmsException(Messages.get().container("ERR_PUBLISH_SCHEDULED_DATE_IN_PAST_1", dateValue)));
        } else {
            try {
                CmsObject cms = OpenCms.initCmsObject(this.m_context.getCms());
                CmsObject adminCms = this.getAdminCms();
                adminCms.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
                CmsProject tmpProject = this.createTempProject(adminCms, this.m_context.getResources(), dateValue);
                adminCms.getRequestContext().setCurrentProject(tmpProject);
                cms.getRequestContext().setCurrentProject(tmpProject);
                HashSet<CmsUUID> changeIds = new HashSet<CmsUUID>();
                HashSet<CmsResource> needToUnlockLater = new HashSet<CmsResource>();
                for (CmsResource resource : this.m_context.getResources()) {
                    this.addToTempProject(adminCms, cms, resource, tmpProject, needToUnlockLater);
                    if (resource.isFolder() && this.m_includeSubResources.getValue().booleanValue()) {
                        List<CmsResource> subResources = cms.readResources(resource, CmsResourceFilter.ONLY_VISIBLE.addExcludeState(CmsResourceState.STATE_UNCHANGED), true);
                        for (CmsResource sub : subResources) {
                            if (!cms.hasPermissions(sub, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL)) continue;
                            this.addToTempProject(adminCms, cms, sub, tmpProject, needToUnlockLater);
                        }
                    }
                    changeIds.add(resource.getStructureId());
                }
                CmsScheduledJobInfo job = new CmsScheduledJobInfo();
                String jobName = tmpProject.getName();
                jobName = jobName.replace("&#47;", "/");
                job.setJobName(jobName);
                job.setClassName("org.opencms.scheduler.jobs.CmsPublishScheduledJob");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateValue);
                String cronExpr = "" + calendar.get(13) + " " + calendar.get(12) + " " + calendar.get(11) + " " + calendar.get(5) + " " + (calendar.get(2) + 1) + " ? " + calendar.get(1);
                job.setCronExpression(cronExpr);
                job.setActive(true);
                CmsContextInfo contextInfo = new CmsContextInfo();
                contextInfo.setProjectName(tmpProject.getName());
                contextInfo.setUserName(adminCms.getRequestContext().getCurrentUser().getName());
                TreeMap<String, String> params = new TreeMap<String, String>();
                String userName = this.m_context.getCms().getRequestContext().getCurrentUser().getName();
                params.put("mail-to-user", userName);
                params.put("jobname", jobName);
                params.put("linkcheck", "true");
                String unlockIdList = needToUnlockLater.stream().map(res -> res.getStructureId().toString()).collect(Collectors.joining(","));
                params.put("unlock-list", unlockIdList);
                job.setParameters(params);
                job.setContextInfo(contextInfo);
                OpenCms.getScheduleManager().scheduleJob(adminCms, job);
                OpenCms.writeConfiguration(CmsSchedulerConfiguration.class);
                this.m_context.finish(changeIds);
            }
            catch (CmsException ex) {
                LOG.error((Object)"Error performing publish scheduled dialog operation.", (Throwable)ex);
                this.m_context.error(ex);
            }
        }
    }

    private void addToTempProject(CmsObject adminCms, CmsObject userCms, CmsResource resource, CmsProject tmpProject, Set<CmsResource> needToUnlockLater) throws CmsException {
        adminCms.copyResourceToProject(resource);
        CmsLock lock = userCms.getLock(resource);
        if (lock != null && lock.isOwnedBy(userCms.getRequestContext().getCurrentUser()) && !lock.isOwnedInProjectBy(userCms.getRequestContext().getCurrentUser(), userCms.getRequestContext().getCurrentProject())) {
            userCms.changeLock(resource);
        }
        userCms.lockResource(resource);
        if (resource.getState().isUnchanged()) {
            needToUnlockLater.add(resource);
        }
        lock = userCms.getLock(resource);
    }

    private String computeProjectName(String rootPath, Date date) {
        String dateTime = CmsDateUtil.getDateTime(date, 3, this.getLocale());
        String projectName = CmsVaadinUtils.getMessageText("GUI_PUBLISH_SCHEDULED_PROJECT_NAME_2", rootPath, dateTime);
        projectName = projectName.replace("/", "&#47;");
        while (projectName.length() > 190) {
            rootPath = "..." + rootPath.substring(5, rootPath.length());
            projectName = this.computeProjectName(rootPath, date);
        }
        return projectName;
    }

    private CmsProject createTempProject(CmsObject adminCms, List<CmsResource> resources, Date date) throws CmsException {
        CmsProject tmpProject;
        String rootPath = resources.get(0).getRootPath();
        if (resources.size() > 1) {
            rootPath = CmsResource.getParentFolder(rootPath);
        }
        String projectName = this.computeProjectName(rootPath, date);
        try {
            tmpProject = adminCms.createProject(projectName, "", CmsRole.WORKPLACE_USER.getGroupName(), CmsRole.PROJECT_MANAGER.getGroupName(), CmsProject.PROJECT_TYPE_TEMPORARY);
        }
        catch (CmsException e) {
            String resName = CmsResource.getName(rootPath);
            if (resName.length() > 64) {
                resName = resName.substring(0, 64) + "...";
            }
            projectName = this.computeProjectName(resName, date) + " [" + new CmsUUID() + "]";
            tmpProject = adminCms.createProject(projectName, "", CmsRole.WORKPLACE_USER.getGroupName(), CmsRole.PROJECT_MANAGER.getGroupName(), CmsProject.PROJECT_TYPE_TEMPORARY);
        }
        tmpProject.setHidden(true);
        adminCms.writeProject(tmpProject);
        return tmpProject;
    }

    private CmsObject getAdminCms() throws CmsException {
        return OpenCms.initCmsObject(m_adminCms);
    }

    private boolean hasFolders() {
        for (CmsResource resource : this.m_context.getResources()) {
            if (!resource.isFolder()) continue;
            return true;
        }
        return false;
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        this.m_dateField = new CmsDateField();
        this.m_dateField.setCaption(CmsVaadinUtils.getMessageText("GUI_LABEL_DATE_PUBLISH_SCHEDULED_0", new Object[0]));
        form.addComponent((Component)this.m_dateField);
        this.m_includeSubResources = new CheckBox(CmsVaadinUtils.getMessageText("GUI_PUBLISH_MULTI_SUBRESOURCES_0", new Object[0]));
        if (this.hasFolders()) {
            form.addComponent((Component)this.m_includeSubResources);
        }
        return form;
    }
}

