/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.HasValue;
import com.vaadin.server.Page;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Property;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.gwt.CmsCoreService;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.util.CmsStringUtil;

public class CmsSiteSelectDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsSiteSelectDialog.class);
    private static final long serialVersionUID = 4455901453008760434L;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private CmsExtendedSiteSelector m_siteComboBox;

    public CmsSiteSelectDialog(CmsEmbeddedDialogContext context) {
        this.m_context = context;
        this.setContent((Component)this.initForm());
        this.m_cancelButton = this.createButtonCancel();
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteSelectDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsSiteSelectDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsSiteSelectDialog.this.submit();
            }
        });
    }

    public static void changeSite(CmsEmbeddedDialogContext context, CmsExtendedSiteSelector.SiteSelectorOption option) {
        if (option.getPath() != null || !CmsStringUtil.comparePaths(context.getCms().getRequestContext().getSiteRoot(), option.getSite())) {
            String siteRoot = option.getSite();
            A_CmsUI.get().changeSite(option.getSite());
            if (CmsStringUtil.comparePaths(siteRoot, "/") || OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
                Page.getCurrent().open(CmsCoreService.getFileExplorerLink(A_CmsUI.getCmsObject(), siteRoot), "_top");
                return;
            }
            context.finish(option);
        } else {
            context.finish(null, null);
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    void submit() {
        CmsExtendedSiteSelector.SiteSelectorOption option = (CmsExtendedSiteSelector.SiteSelectorOption)this.m_siteComboBox.getValue();
        I_CmsDialogContext context = this.m_context;
        CmsSiteSelectDialog.changeSite((CmsEmbeddedDialogContext)context, option);
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        this.m_siteComboBox = this.prepareSiteSelector("GUI_LABEL_SITE_0");
        this.m_siteComboBox.setValue(new CmsExtendedSiteSelector.SiteSelectorOption(A_CmsUI.getCmsObject().getRequestContext().getSiteRoot(), null, null));
        form.addComponent((Component)this.m_siteComboBox);
        Property.ValueChangeListener changeListener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSiteSelectDialog.this.submit();
            }
        };
        this.m_siteComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> this.submit());
        return form;
    }

    private CmsExtendedSiteSelector prepareSiteSelector(String captionKey) {
        CmsExtendedSiteSelector result = new CmsExtendedSiteSelector();
        String caption = CmsVaadinUtils.getWpMessagesForCurrentLocale().key(captionKey);
        result.setCaption(caption);
        result.initOptions(this.m_context.getCms(), true);
        result.setPageLength(20);
        result.setWidth("100%");
        result.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        return result;
    }
}

