/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors.messagebundle;

import com.vaadin.ui.UI;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.DefaultItemSorter;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.ItemSorter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessageException;
import org.opencms.i18n.CmsMessages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.ui.A_CmsDialogContext;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsDirectPublishDialogAction;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorTypes;
import org.opencms.ui.editors.messagebundle.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsMessageBundleEditorModel {
    private static final Log LOG = CmsLog.getLog(CmsMessageBundleEditorModel.class);
    public static final String PROPERTY_BUNDLE_DESCRIPTOR_LOCALIZATION = "bundle.descriptor.messages";
    private CmsObject m_cms;
    private Map<Locale, CmsLockUtil.LockedFile> m_lockedBundleFiles;
    private Map<Locale, CmsResource> m_bundleFiles;
    private CmsResource m_resource;
    private CmsResource m_desc;
    private CmsXmlContent m_descContent;
    private CmsXmlContent m_xmlBundle;
    private Map<Locale, SortedProperties> m_localizations;
    private String m_basename;
    private String m_sitepath;
    private Locale m_locale;
    private CmsMessageBundleEditorTypes.BundleType m_bundleType;
    CmsMessageBundleEditorTypes.KeySet m_keyset;
    private IndexedContainer m_container;
    private Collection<Locale> m_locales;
    private Map<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.EditorState> m_editorState;
    private boolean m_hasMasterMode;
    private CmsMessageBundleEditorTypes.EditMode m_editMode;
    private CmsLockUtil.LockedFile m_descFile;
    private String m_configuredBundle;
    private boolean m_switchedLocaleOnOpening;
    private boolean m_hasDefault;
    private boolean m_hasDescription;
    private boolean m_removeDescriptorOnCancel;
    Set<Locale> m_changedTranslations;
    boolean m_descriptorHasChanges;
    private boolean m_alreadyLoadedAllLocalizations;

    public CmsMessageBundleEditorModel(CmsObject cms, CmsResource resource) throws CmsException, IOException {
        if (cms == null) {
            throw new CmsException(Messages.get().container("ERR_LOADING_BUNDLE_CMS_OBJECT_NULL_0"));
        }
        if (resource == null) {
            throw new CmsException(Messages.get().container("ERR_LOADING_BUNDLE_FILENAME_NULL_0"));
        }
        this.m_cms = cms;
        this.m_resource = resource;
        this.m_editMode = CmsMessageBundleEditorTypes.EditMode.DEFAULT;
        this.m_bundleFiles = new HashMap<Locale, CmsResource>();
        this.m_lockedBundleFiles = new HashMap<Locale, CmsLockUtil.LockedFile>();
        this.m_changedTranslations = new HashSet<Locale>();
        this.m_localizations = new HashMap<Locale, SortedProperties>();
        this.m_keyset = new CmsMessageBundleEditorTypes.KeySet();
        this.m_bundleType = this.initBundleType();
        this.m_locales = this.initLocales();
        if (this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.XML)) {
            this.initXmlBundle();
        }
        this.setResourceInformation();
        this.initDescriptor();
        if (this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.PROPERTY)) {
            this.initPropertyBundle();
        }
        this.initHasMasterMode();
        this.initEditorStates();
    }

    public boolean addDescriptor() {
        this.saveLocalization();
        IndexedContainer oldContainer = this.m_container;
        try {
            this.createAndLockDescriptorFile();
            this.unmarshalDescriptor();
            this.updateBundleDescriptorContent();
            this.m_hasMasterMode = true;
            this.m_container = this.createContainer();
            this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, this.getDefaultState());
            this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.MASTER, this.getMasterState());
        }
        catch (IOException | CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            if (this.m_descContent != null) {
                this.m_descContent = null;
            }
            if (this.m_descFile != null) {
                this.m_descFile = null;
            }
            if (this.m_desc != null) {
                try {
                    this.m_cms.deleteResource(this.m_desc, CmsResource.CmsResourceDeleteMode.valueOf(1));
                }
                catch (CmsException ex) {
                    LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
                this.m_desc = null;
            }
            this.m_hasMasterMode = false;
            this.m_container = oldContainer;
            return false;
        }
        this.m_removeDescriptorOnCancel = true;
        return true;
    }

    public boolean canAddKeys() {
        return !this.hasDescriptor() || this.getEditMode().equals((Object)CmsMessageBundleEditorTypes.EditMode.MASTER);
    }

    public void deleteDescriptorIfNecessary() throws CmsException {
        if (this.m_removeDescriptorOnCancel && this.m_desc != null) {
            this.m_cms.deleteResource(this.m_desc, CmsResource.CmsResourceDeleteMode.valueOf(2));
        }
    }

    public Set<Object> getAllUsedKeys() {
        return this.m_keyset.getKeySet();
    }

    public CmsMessageBundleEditorTypes.BundleType getBundleType() {
        return this.m_bundleType;
    }

    public ConfigurableMessages getConfigurableMessages(CmsMessages defaultMessages, Locale locale) {
        return new ConfigurableMessages(defaultMessages, locale, this.m_configuredBundle);
    }

    public IndexedContainer getContainerForCurrentLocale() throws IOException, CmsException {
        if (null == this.m_container) {
            this.m_container = this.createContainer();
        }
        return this.m_container;
    }

    public CmsContextMenu getContextMenuForItem(Object itemId) {
        CmsContextMenu result = null;
        try {
            final Item item = this.m_container.getItem(itemId);
            Property keyProp = item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY);
            String key = (String)keyProp.getValue();
            if (null != key && !key.isEmpty()) {
                this.loadAllRemainingLocalizations();
                final HashMap<Locale, String> localesWithEntries = new HashMap<Locale, String>();
                for (Locale l : this.m_localizations.keySet()) {
                    String value;
                    if (l == this.m_locale || null == (value = this.m_localizations.get(l).getProperty(key)) || value.isEmpty()) continue;
                    localesWithEntries.put(l, value);
                }
                if (!localesWithEntries.isEmpty()) {
                    result = new CmsContextMenu();
                    CmsContextMenu.ContextMenuItem mainItem = result.addItem(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_BUNDLE_EDITOR_CONTEXT_COPY_LOCALE_0"));
                    for (final Locale l : localesWithEntries.keySet()) {
                        CmsContextMenu.ContextMenuItem menuItem = mainItem.addItem(l.getDisplayName(UI.getCurrent().getLocale()));
                        menuItem.addItemClickListener(new CmsContextMenu.ContextMenuItemClickListener(){

                            @Override
                            public void contextMenuItemClicked(CmsContextMenu.ContextMenuItemClickEvent event) {
                                item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).setValue(localesWithEntries.get(l));
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public List<CmsMessageBundleEditorTypes.TableProperty> getEditableColumns() {
        return this.m_editorState.get((Object)this.m_editMode).getEditableColumns();
    }

    public List<CmsMessageBundleEditorTypes.TableProperty> getEditableColumns(CmsMessageBundleEditorTypes.EditMode mode) {
        return this.m_editorState.get((Object)mode).getEditableColumns();
    }

    public String getEditedFilePath() {
        switch (this.getBundleType()) {
            case DESCRIPTOR: {
                return this.m_cms.getSitePath(this.m_desc);
            }
            case PROPERTY: {
                return null != this.m_lockedBundleFiles.get(this.getLocale()) ? this.m_cms.getSitePath(this.m_lockedBundleFiles.get(this.getLocale()).getFile()) : this.m_cms.getSitePath(this.m_resource);
            }
            case XML: {
                return this.m_cms.getSitePath(this.m_resource);
            }
        }
        throw new IllegalArgumentException();
    }

    public CmsMessageBundleEditorTypes.EditMode getEditMode() {
        return this.m_editMode;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Collection<Locale> getLocales() {
        return this.m_locales;
    }

    public boolean getSwitchedLocaleOnOpening() {
        return this.m_switchedLocaleOnOpening;
    }

    public void handleChange(Object propertyId) {
        try {
            this.lockOnChange(propertyId);
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.isDescriptorProperty(propertyId)) {
            this.m_descriptorHasChanges = true;
        }
        if (this.isBundleProperty(propertyId)) {
            this.m_changedTranslations.add(this.getLocale());
        }
    }

    public KeyChangeResult handleKeyChange(CmsMessageBundleEditorTypes.EntryChangeEvent event, boolean allLanguages) {
        if (this.m_keyset.getKeySet().contains(event.getNewValue())) {
            this.m_container.getItem(event.getItemId()).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue((Object)event.getOldValue());
            return KeyChangeResult.FAILED_DUPLICATED_KEY;
        }
        if (allLanguages && !this.renameKeyForAllLanguages(event.getOldValue(), event.getNewValue())) {
            this.m_container.getItem(event.getItemId()).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue((Object)event.getOldValue());
            return KeyChangeResult.FAILED_FOR_OTHER_LANGUAGE;
        }
        return KeyChangeResult.SUCCESS;
    }

    public boolean handleKeyDeletion(String key) {
        if (this.m_keyset.getKeySet().contains(key)) {
            if (this.removeKeyForAllLanguages(key)) {
                this.m_keyset.removeKey(key);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasChanges() {
        return !this.m_changedTranslations.isEmpty() || this.m_descriptorHasChanges;
    }

    public boolean hasDefaultValues() {
        return this.m_hasDefault;
    }

    public boolean hasDescriptionValues() {
        return this.m_hasDescription;
    }

    public boolean hasDescriptor() {
        return !this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR) && this.m_descContent != null;
    }

    public boolean hasMasterMode() {
        return this.m_hasMasterMode;
    }

    public boolean isShowOptionsColumn(CmsMessageBundleEditorTypes.EditMode mode) {
        return this.m_editorState.get((Object)mode).isShowOptions();
    }

    public void publish() {
        CmsDirectPublishDialogAction action = new CmsDirectPublishDialogAction();
        List<CmsResource> resources = this.getBundleResources();
        A_CmsDialogContext context = new A_CmsDialogContext("", I_CmsDialogContext.ContextType.appToolbar, resources){

            @Override
            public void focus(CmsUUID structureId) {
            }

            @Override
            public List<CmsUUID> getAllStructureIdsInView() {
                return null;
            }

            @Override
            public void updateUserInfo() {
            }
        };
        action.executeAction(context);
        this.updateLockInformation();
    }

    public void save() throws CmsException {
        if (this.hasChanges()) {
            switch (this.m_bundleType) {
                case PROPERTY: {
                    this.saveLocalization();
                    this.saveToPropertyVfsBundle();
                    break;
                }
                case XML: {
                    this.saveLocalization();
                    this.saveToXmlVfsBundle();
                    break;
                }
                case DESCRIPTOR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (null != this.m_descFile) {
                this.saveToBundleDescriptor();
            }
            this.resetChanges();
        }
    }

    public void saveAsPropertyBundle() throws UnsupportedEncodingException, CmsException, IOException {
        switch (this.m_bundleType) {
            case XML: {
                this.saveLocalization();
                this.loadAllRemainingLocalizations();
                this.createPropertyVfsBundleFiles();
                this.saveToPropertyVfsBundle();
                this.m_bundleType = CmsMessageBundleEditorTypes.BundleType.PROPERTY;
                this.removeXmlBundleFile();
                break;
            }
            default: {
                throw new IllegalArgumentException("The method should only be called when editing an XMLResourceBundle.");
            }
        }
    }

    public boolean setEditMode(CmsMessageBundleEditorTypes.EditMode mode) {
        try {
            if (mode == CmsMessageBundleEditorTypes.EditMode.MASTER && null == this.m_descFile) {
                this.m_descFile = CmsLockUtil.LockedFile.lockResource(this.m_cms, this.m_desc);
            }
            this.m_editMode = mode;
        }
        catch (CmsException e) {
            return false;
        }
        return true;
    }

    public boolean setLocale(Locale locale) {
        if (this.adjustExistingContainer(locale)) {
            this.m_locale = locale;
            return true;
        }
        return false;
    }

    public void unlock() {
        for (Locale l : this.m_lockedBundleFiles.keySet()) {
            CmsLockUtil.LockedFile f = this.m_lockedBundleFiles.get(l);
            f.tryUnlock();
        }
        if (null != this.m_descFile) {
            this.m_descFile.tryUnlock();
        }
    }

    List<CmsResource> getBundleResources() {
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>(this.m_bundleFiles.values());
        if (this.m_desc != null) {
            resources.add(this.m_desc);
        }
        return resources;
    }

    private boolean adjustExistingContainer(Locale locale) {
        this.saveLocalization();
        return this.replaceValues(locale);
    }

    private void createAndLockDescriptorFile() throws CmsException {
        String sitePath = this.m_sitepath + this.m_basename + "_desc";
        this.m_desc = this.m_cms.createResource(sitePath, OpenCms.getResourceManager().getResourceType(CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR.toString()));
        this.m_descFile = CmsLockUtil.LockedFile.lockResource(this.m_cms, this.m_desc);
        this.m_descFile.setCreated(true);
    }

    private IndexedContainer createContainer() throws IOException, CmsException {
        IndexedContainer container = null;
        container = this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR) ? this.createContainerForDescriptorEditing() : (this.hasDescriptor() ? this.createContainerForBundleWithDescriptor() : this.createContainerForBundleWithoutDescriptor());
        container.setItemSorter((ItemSorter)new DefaultItemSorter((Comparator)CmsCaseInsensitiveStringComparator.getInstance()));
        return container;
    }

    private IndexedContainer createContainerForBundleWithDescriptor() throws IOException, CmsException {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, String.class, (Object)"");
        SortedProperties localization = this.getLocalization(this.m_locale);
        CmsXmlContentValueSequence messages = this.m_descContent.getValueSequence("Message", CmsMessageBundleEditorTypes.Descriptor.LOCALE);
        boolean hasDescription = false;
        boolean hasDefault = false;
        for (int i = 0; i < messages.getElementCount(); ++i) {
            String prefix = messages.getValue(i).getPath() + "/";
            Object itemId = container.addItem();
            Item item = container.getItem(itemId);
            String key = this.m_descContent.getValue(prefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue((Object)key);
            String translation = localization.getProperty(key);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).setValue((Object)(null == translation ? "" : translation));
            String descValue = this.m_descContent.getValue(prefix + "Description", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION).setValue((Object)descValue);
            hasDescription = hasDescription || !descValue.isEmpty();
            String defaultValue = this.m_descContent.getValue(prefix + "Default", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT).setValue((Object)defaultValue);
            hasDefault = hasDefault || !defaultValue.isEmpty();
        }
        this.m_hasDefault = hasDefault;
        this.m_hasDescription = hasDescription;
        return container;
    }

    private IndexedContainer createContainerForBundleWithoutDescriptor() throws IOException, CmsException {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION, String.class, (Object)"");
        SortedProperties localization = this.getLocalization(this.m_locale);
        Set<Object> keySet = this.m_keyset.getKeySet();
        for (Object key : keySet) {
            Object itemId = container.addItem();
            Item item = container.getItem(itemId);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue(key);
            Object translation = localization.get(key);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).setValue(null == translation ? "" : translation);
        }
        return container;
    }

    private IndexedContainer createContainerForDescriptorEditing() {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION, String.class, (Object)"");
        container.addContainerProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT, String.class, (Object)"");
        CmsXmlContentValueSequence messages = this.m_descContent.getValueSequence("/Message", CmsMessageBundleEditorTypes.Descriptor.LOCALE);
        for (int i = 0; i < messages.getElementCount(); ++i) {
            String prefix = messages.getValue(i).getPath() + "/";
            Object itemId = container.addItem();
            Item item = container.getItem(itemId);
            String key = this.m_descContent.getValue(prefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue((Object)key);
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION).setValue((Object)this.m_descContent.getValue(prefix + "Description", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms));
            item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT).setValue((Object)this.m_descContent.getValue(prefix + "Default", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms));
        }
        return container;
    }

    private void createPropertyVfsBundleFiles() throws CmsIllegalArgumentException, CmsLoaderException, CmsException {
        String bundleFileBasePath = this.m_sitepath + this.m_basename + "_";
        for (Locale l : this.m_localizations.keySet()) {
            CmsResource res = this.m_cms.createResource(bundleFileBasePath + l.toString(), OpenCms.getResourceManager().getResourceType(CmsMessageBundleEditorTypes.BundleType.PROPERTY.toString()));
            this.m_bundleFiles.put(l, res);
            CmsLockUtil.LockedFile file = CmsLockUtil.LockedFile.lockResource(this.m_cms, res);
            file.setCreated(true);
            this.m_lockedBundleFiles.put(l, file);
            this.m_changedTranslations.add(l);
        }
    }

    private CmsMessageBundleEditorTypes.EditorState getDefaultState() {
        ArrayList<CmsMessageBundleEditorTypes.TableProperty> cols = new ArrayList<CmsMessageBundleEditorTypes.TableProperty>(1);
        cols.add(CmsMessageBundleEditorTypes.TableProperty.TRANSLATION);
        return new CmsMessageBundleEditorTypes.EditorState(cols, false);
    }

    private Map<String, Item> getKeyItemMap() {
        HashMap<String, Item> ret = new HashMap<String, Item>();
        for (Object itemId : this.m_container.getItemIds()) {
            ret.put(this.m_container.getItem(itemId).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).getValue().toString(), this.m_container.getItem(itemId));
        }
        return ret;
    }

    private SortedProperties getLocalization(Locale locale) throws IOException, CmsException {
        if (null == this.m_localizations.get(locale)) {
            switch (this.m_bundleType) {
                case PROPERTY: {
                    this.loadLocalizationFromPropertyBundle(locale);
                    break;
                }
                case XML: {
                    this.loadLocalizationFromXmlBundle(locale);
                    break;
                }
                case DESCRIPTOR: {
                    return null;
                }
            }
        }
        return this.m_localizations.get(locale);
    }

    private CmsMessageBundleEditorTypes.EditorState getMasterState() {
        ArrayList<CmsMessageBundleEditorTypes.TableProperty> cols = new ArrayList<CmsMessageBundleEditorTypes.TableProperty>(4);
        cols.add(CmsMessageBundleEditorTypes.TableProperty.KEY);
        cols.add(CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION);
        cols.add(CmsMessageBundleEditorTypes.TableProperty.DEFAULT);
        cols.add(CmsMessageBundleEditorTypes.TableProperty.TRANSLATION);
        return new CmsMessageBundleEditorTypes.EditorState(cols, true);
    }

    private CmsMessageBundleEditorTypes.BundleType initBundleType() {
        String resourceTypeName = OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName();
        return CmsMessageBundleEditorTypes.BundleType.toBundleType(resourceTypeName);
    }

    private void initDescriptor() throws CmsXmlException, CmsException {
        if (this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR)) {
            this.m_desc = this.m_resource;
        } else {
            try {
                this.m_desc = this.m_cms.readResource(this.m_sitepath + this.m_basename + "_desc");
            }
            catch (CmsVfsResourceNotFoundException e) {
                this.m_desc = CmsMessageBundleEditorTypes.getDescriptor(this.m_cms, this.m_basename);
            }
        }
        this.unmarshalDescriptor();
    }

    private void initEditorStates() {
        this.m_editorState = new HashMap<CmsMessageBundleEditorTypes.EditMode, CmsMessageBundleEditorTypes.EditorState>();
        ArrayList<CmsMessageBundleEditorTypes.TableProperty> cols = null;
        switch (this.m_bundleType) {
            case PROPERTY: 
            case XML: {
                if (this.hasDescriptor()) {
                    this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, this.getDefaultState());
                    if (!this.hasMasterMode()) break;
                    this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.MASTER, this.getMasterState());
                    break;
                }
                cols = new ArrayList(1);
                cols.add(CmsMessageBundleEditorTypes.TableProperty.KEY);
                cols.add(CmsMessageBundleEditorTypes.TableProperty.TRANSLATION);
                this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, new CmsMessageBundleEditorTypes.EditorState(cols, true));
                break;
            }
            case DESCRIPTOR: {
                cols = new ArrayList<CmsMessageBundleEditorTypes.TableProperty>(3);
                cols.add(CmsMessageBundleEditorTypes.TableProperty.KEY);
                cols.add(CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION);
                cols.add(CmsMessageBundleEditorTypes.TableProperty.DEFAULT);
                this.m_editorState.put(CmsMessageBundleEditorTypes.EditMode.DEFAULT, new CmsMessageBundleEditorTypes.EditorState(cols, true));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void initHasMasterMode() throws CmsException {
        this.m_hasMasterMode = this.hasDescriptor() && this.m_cms.hasPermissions(this.m_desc, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
    }

    private void initKeySetForXmlBundle() {
        for (Locale l : this.m_locales) {
            if (!this.m_xmlBundle.hasLocale(l)) continue;
            HashSet<Object> keys = new HashSet<Object>();
            for (I_CmsXmlContentValue msg : this.m_xmlBundle.getValueSequence("Message", l).getValues()) {
                String msgpath = msg.getPath();
                keys.add(this.m_xmlBundle.getStringValue(this.m_cms, msgpath + "/Key", l));
            }
            this.m_keyset.updateKeySet(null, keys);
        }
    }

    private Collection<Locale> initLocales() {
        ArrayList<Locale> locales = null;
        switch (this.m_bundleType) {
            case DESCRIPTOR: {
                locales = new ArrayList<Locale>(1);
                locales.add(CmsMessageBundleEditorTypes.Descriptor.LOCALE);
                break;
            }
            case PROPERTY: 
            case XML: {
                locales = OpenCms.getLocaleManager().getAvailableLocales(this.m_cms, this.m_resource);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return locales;
    }

    private void initPropertyBundle() throws CmsLoaderException, CmsException, IOException {
        for (Locale l : this.m_locales) {
            String filePath = this.m_sitepath + this.m_basename + "_" + l.toString();
            CmsResource resource = null;
            if (!this.m_cms.existsResource(filePath, CmsResourceFilter.requireType(OpenCms.getResourceManager().getResourceType(CmsMessageBundleEditorTypes.BundleType.PROPERTY.toString())))) continue;
            resource = this.m_cms.readResource(filePath);
            SortedProperties props = new SortedProperties();
            CmsFile file = this.m_cms.readFile(resource);
            props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(file.getContents()), CmsFileUtil.getEncoding(this.m_cms, file)));
            this.m_keyset.updateKeySet(null, props.keySet());
            this.m_bundleFiles.put(l, resource);
        }
    }

    private void initXmlBundle() throws CmsException {
        CmsFile file = this.m_cms.readFile(this.m_resource);
        this.m_bundleFiles.put(null, this.m_resource);
        this.m_xmlBundle = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        this.initKeySetForXmlBundle();
    }

    private boolean isBundleProperty(Object property) {
        return property.equals((Object)CmsMessageBundleEditorTypes.TableProperty.KEY) || property.equals((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION);
    }

    private boolean isDescriptorProperty(Object property) {
        return this.getBundleType().equals((Object)CmsMessageBundleEditorTypes.BundleType.DESCRIPTOR) || this.hasDescriptor() && (property.equals((Object)CmsMessageBundleEditorTypes.TableProperty.KEY) || property.equals((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT) || property.equals((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION));
    }

    private void loadAllRemainingLocalizations() throws CmsException, UnsupportedEncodingException, IOException {
        if (!this.m_alreadyLoadedAllLocalizations) {
            if (this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.PROPERTY)) {
                for (Locale l : this.m_locales) {
                    CmsResource resource;
                    if (null != this.m_localizations.get(l) || (resource = this.m_bundleFiles.get(l)) == null) continue;
                    CmsFile file = this.m_cms.readFile(resource);
                    this.m_bundleFiles.put(l, file);
                    SortedProperties props = new SortedProperties();
                    props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(file.getContents()), CmsFileUtil.getEncoding(this.m_cms, file)));
                    this.m_localizations.put(l, props);
                }
            }
            if (this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.XML)) {
                for (Locale l : this.m_locales) {
                    if (null != this.m_localizations.get(l)) continue;
                    this.loadLocalizationFromXmlBundle(l);
                }
            }
            this.m_alreadyLoadedAllLocalizations = true;
        }
    }

    private void loadLocalizationFromPropertyBundle(Locale locale) throws IOException, CmsException {
        String sitePath = this.m_sitepath + this.m_basename + "_" + locale.toString();
        CmsResource resource = null;
        if (this.m_cms.existsResource(sitePath)) {
            resource = this.m_cms.readResource(sitePath);
            if (!OpenCms.getResourceManager().getResourceType(resource).getTypeName().equals(CmsMessageBundleEditorTypes.BundleType.PROPERTY.toString())) {
                throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_RESOURCE_HAS_WRONG_TYPE_2", locale.getDisplayName(), resource.getRootPath()));
            }
        } else {
            resource = this.m_cms.createResource(sitePath, OpenCms.getResourceManager().getResourceType(CmsMessageBundleEditorTypes.BundleType.PROPERTY.toString()));
            CmsLockUtil.LockedFile lf = CmsLockUtil.LockedFile.lockResource(this.m_cms, resource);
            lf.setCreated(true);
            this.m_lockedBundleFiles.put(locale, lf);
        }
        this.m_bundleFiles.put(locale, resource);
        SortedProperties props = new SortedProperties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(this.m_cms.readFile(resource).getContents()), CmsFileUtil.getEncoding(this.m_cms, resource)));
        this.m_localizations.put(locale, props);
    }

    private void loadLocalizationFromXmlBundle(Locale locale) {
        CmsXmlContentValueSequence messages = this.m_xmlBundle.getValueSequence("Message", locale);
        SortedProperties props = new SortedProperties();
        if (null != messages) {
            for (I_CmsXmlContentValue msg : messages.getValues()) {
                String msgpath = msg.getPath();
                props.put(this.m_xmlBundle.getStringValue(this.m_cms, msgpath + "/Key", locale), this.m_xmlBundle.getStringValue(this.m_cms, msgpath + "/Value", locale));
            }
        }
        this.m_localizations.put(locale, props);
    }

    private void lockAllLocalizations(String key) throws CmsException {
        for (Locale l : this.m_bundleFiles.keySet()) {
            if (null != l && !this.m_localizations.get(l).containsKey(key)) continue;
            this.lockLocalization(l);
        }
    }

    private void lockDescriptor() throws CmsException {
        if (null == this.m_descFile && null != this.m_desc) {
            this.m_descFile = CmsLockUtil.LockedFile.lockResource(this.m_cms, this.m_desc);
        }
    }

    private void lockLocalization(Locale l) throws CmsException {
        if (null == this.m_lockedBundleFiles.get(l)) {
            CmsLockUtil.LockedFile lf = CmsLockUtil.LockedFile.lockResource(this.m_cms, this.m_bundleFiles.get(l));
            this.m_lockedBundleFiles.put(l, lf);
        }
    }

    private void lockOnChange(Object propertyId) throws CmsException {
        if (this.isDescriptorProperty(propertyId)) {
            this.lockDescriptor();
        } else {
            Locale l = this.m_bundleType.equals((Object)CmsMessageBundleEditorTypes.BundleType.PROPERTY) ? this.m_locale : null;
            this.lockLocalization(l);
        }
    }

    private boolean removeKeyForAllLanguages(String key) {
        try {
            if (this.hasDescriptor()) {
                this.lockDescriptor();
            }
            this.loadAllRemainingLocalizations();
            this.lockAllLocalizations(key);
        }
        catch (IOException | CmsException e) {
            LOG.warn((Object)"Not able lock all localications for bundle.", (Throwable)e);
            return false;
        }
        if (!this.hasDescriptor()) {
            for (Map.Entry<Locale, SortedProperties> entry : this.m_localizations.entrySet()) {
                SortedProperties localization = entry.getValue();
                if (!localization.containsKey(key)) continue;
                localization.remove(key);
                this.m_changedTranslations.add(entry.getKey());
            }
        }
        return true;
    }

    private void removeXmlBundleFile() throws CmsException {
        this.lockLocalization(null);
        this.m_cms.deleteResource(this.m_resource, CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.m_resource = null;
    }

    private boolean renameKeyForAllLanguages(String oldKey, String newKey) {
        try {
            this.loadAllRemainingLocalizations();
            this.lockAllLocalizations(oldKey);
            if (this.hasDescriptor()) {
                this.lockDescriptor();
            }
        }
        catch (IOException | CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        for (Map.Entry<Locale, SortedProperties> entry : this.m_localizations.entrySet()) {
            SortedProperties localization = entry.getValue();
            if (!localization.containsKey(oldKey)) continue;
            String value = localization.getProperty(oldKey);
            localization.remove(oldKey);
            localization.put(newKey, value);
            this.m_changedTranslations.add(entry.getKey());
        }
        if (this.hasDescriptor()) {
            CmsXmlContentValueSequence messages = this.m_descContent.getValueSequence("Message", CmsMessageBundleEditorTypes.Descriptor.LOCALE);
            for (int i = 0; i < messages.getElementCount(); ++i) {
                String prefix = messages.getValue(i).getPath() + "/";
                String key = this.m_descContent.getValue(prefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(this.m_cms);
                if (key != oldKey) continue;
                this.m_descContent.getValue(prefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).setStringValue(this.m_cms, newKey);
                break;
            }
            this.m_descriptorHasChanges = true;
        }
        this.m_keyset.renameKey(oldKey, newKey);
        return true;
    }

    private boolean replaceValues(Locale locale) {
        try {
            SortedProperties localization = this.getLocalization(locale);
            if (this.hasDescriptor()) {
                for (Object itemId : this.m_container.getItemIds()) {
                    Item item = this.m_container.getItem(itemId);
                    String key = item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).getValue().toString();
                    Object value = localization.get(key);
                    item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).setValue(null == value ? "" : value);
                }
            } else {
                this.m_container.removeAllItems();
                Set<Object> keyset = this.m_keyset.getKeySet();
                for (Object key : keyset) {
                    Object itemId = this.m_container.addItem();
                    Item item = this.m_container.getItem(itemId);
                    item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).setValue(key);
                    Object value = localization.get(key);
                    item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).setValue(null == value ? "" : value);
                }
                if (this.m_container.getItemIds().isEmpty()) {
                    this.m_container.addItem();
                }
            }
            return true;
        }
        catch (IOException | CmsException e) {
            return false;
        }
    }

    private void resetChanges() {
        this.m_changedTranslations.clear();
        this.m_descriptorHasChanges = false;
    }

    private void saveLocalization() {
        SortedProperties localization = new SortedProperties();
        for (Object itemId : this.m_container.getItemIds()) {
            Item item = this.m_container.getItem(itemId);
            String key = item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.KEY).getValue().toString();
            String value = item.getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.TRANSLATION).getValue().toString();
            if (key.isEmpty() || value.isEmpty()) continue;
            localization.put(key, value);
        }
        this.m_keyset.updateKeySet(this.m_localizations.get(this.m_locale).keySet(), localization.keySet());
        this.m_localizations.put(this.m_locale, localization);
    }

    private void saveToBundleDescriptor() throws CmsException {
        if (null != this.m_descFile) {
            this.m_removeDescriptorOnCancel = false;
            this.updateBundleDescriptorContent();
            this.m_descFile.getFile().setContents(this.m_descContent.marshal());
            this.m_cms.writeFile(this.m_descFile.getFile());
        }
    }

    private void saveToPropertyVfsBundle() throws CmsException {
        for (Locale l : this.m_changedTranslations) {
            SortedProperties props = this.m_localizations.get(l);
            CmsLockUtil.LockedFile f = this.m_lockedBundleFiles.get(l);
            if (null == props || null == f) continue;
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, f.getEncoding());
                props.store(writer, null);
                byte[] contentBytes = outputStream.toByteArray();
                CmsFile file = f.getFile();
                file.setContents(contentBytes);
                String contentEncodingProperty = this.m_cms.readPropertyObject(file, "content-encoding", false).getValue();
                if (null == contentEncodingProperty || !contentEncodingProperty.equals(f.getEncoding())) {
                    this.m_cms.writePropertyObject(this.m_cms.getSitePath(file), new CmsProperty("content-encoding", f.getEncoding(), f.getEncoding()));
                }
                this.m_cms.writeFile(file);
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_FILE_UNSUPPORTED_ENCODING_2", f.getFile().getRootPath(), f.getEncoding()), (Throwable)e);
            }
        }
    }

    private void saveToXmlVfsBundle() throws CmsException {
        if (this.m_lockedBundleFiles.get(null) != null) {
            for (Locale l : this.m_locales) {
                SortedProperties props = this.m_localizations.get(l);
                if (null != props) {
                    if (this.m_xmlBundle.hasLocale(l)) {
                        this.m_xmlBundle.removeLocale(l);
                    }
                    this.m_xmlBundle.addLocale(this.m_cms, l);
                    int i = 0;
                    ArrayList<Object> keys = new ArrayList<Object>(props.keySet());
                    Collections.sort(keys, CmsCaseInsensitiveStringComparator.getInstance());
                    for (Object e : keys) {
                        String value;
                        if (null == e || e.toString().isEmpty() || (value = props.getProperty(e.toString())).isEmpty()) continue;
                        this.m_xmlBundle.addValue(this.m_cms, "Message", l, i);
                        this.m_xmlBundle.getValue("Message[" + ++i + "]/Key", l).setStringValue(this.m_cms, e.toString());
                        this.m_xmlBundle.getValue("Message[" + i + "]/Value", l).setStringValue(this.m_cms, value);
                    }
                }
                CmsFile bundleFile = this.m_lockedBundleFiles.get(null).getFile();
                bundleFile.setContents(this.m_xmlBundle.marshal());
                this.m_cms.writeFile(bundleFile);
            }
        }
    }

    private void setResourceInformation() {
        String sitePath = this.m_cms.getSitePath(this.m_resource);
        int pathEnd = sitePath.lastIndexOf(47) + 1;
        String baseName = sitePath.substring(pathEnd);
        this.m_sitepath = sitePath.substring(0, pathEnd);
        switch (CmsMessageBundleEditorTypes.BundleType.toBundleType(OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName())) {
            case PROPERTY: {
                String localeSuffix = CmsStringUtil.getLocaleSuffixForName(baseName);
                if (null != localeSuffix && !localeSuffix.isEmpty()) {
                    baseName = baseName.substring(0, baseName.lastIndexOf(localeSuffix) - 1);
                    this.m_locale = CmsLocaleManager.getLocale(localeSuffix);
                }
                if (null != this.m_locale && this.m_locales.contains(this.m_locale)) break;
                this.m_switchedLocaleOnOpening = true;
                this.m_locale = this.m_locales.iterator().next();
                break;
            }
            case XML: {
                this.m_locale = OpenCms.getLocaleManager().getBestAvailableLocaleForXmlContent(this.m_cms, this.m_resource, this.m_xmlBundle);
                break;
            }
            case DESCRIPTOR: {
                this.m_basename = baseName.substring(0, baseName.length() - "_desc".length());
                this.m_locale = new Locale("en");
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.get().container("ERR_UNSUPPORTED_BUNDLE_TYPE_1", (Object)CmsMessageBundleEditorTypes.BundleType.toBundleType(OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName())).toString());
            }
        }
        this.m_basename = baseName;
    }

    private void unmarshalDescriptor() throws CmsXmlException, CmsException {
        if (null != this.m_desc) {
            this.m_descContent = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(this.m_desc));
            CmsProperty bundleProp = this.m_cms.readPropertyObject(this.m_desc, PROPERTY_BUNDLE_DESCRIPTOR_LOCALIZATION, true);
            if (!bundleProp.isNullProperty() && !bundleProp.getValue().trim().isEmpty()) {
                this.m_configuredBundle = bundleProp.getValue();
            }
        }
    }

    private void updateBundleDescriptorContent() throws CmsXmlException {
        if (this.m_descContent.hasLocale(CmsMessageBundleEditorTypes.Descriptor.LOCALE)) {
            this.m_descContent.removeLocale(CmsMessageBundleEditorTypes.Descriptor.LOCALE);
        }
        this.m_descContent.addLocale(this.m_cms, CmsMessageBundleEditorTypes.Descriptor.LOCALE);
        int i = 0;
        Map<String, Item> keyItemMap = this.getKeyItemMap();
        ArrayList<String> keys = new ArrayList<String>(keyItemMap.keySet());
        Collections.sort(keys, CmsCaseInsensitiveStringComparator.getInstance());
        for (Object e : keys) {
            Property defaultValueProp;
            if (null == e || e.toString().isEmpty()) continue;
            this.m_descContent.addValue(this.m_cms, "Message", CmsMessageBundleEditorTypes.Descriptor.LOCALE, i);
            String messagePrefix = "Message[" + ++i + "]/";
            this.m_descContent.getValue(messagePrefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).setStringValue(this.m_cms, (String)e);
            Property descProp = keyItemMap.get(e).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DESCRIPTION);
            if (null != descProp && null != descProp.getValue()) {
                String desc = descProp.getValue().toString();
                this.m_descContent.getValue(messagePrefix + "Description", CmsMessageBundleEditorTypes.Descriptor.LOCALE).setStringValue(this.m_cms, desc);
            }
            if (null == (defaultValueProp = keyItemMap.get(e).getItemProperty((Object)CmsMessageBundleEditorTypes.TableProperty.DEFAULT)) || null == defaultValueProp.getValue()) continue;
            String defaultValue = defaultValueProp.getValue().toString();
            this.m_descContent.getValue(messagePrefix + "Default", CmsMessageBundleEditorTypes.Descriptor.LOCALE).setStringValue(this.m_cms, defaultValue);
        }
    }

    private void updateLockInformation() {
        this.m_lockedBundleFiles.clear();
        this.m_descFile = null;
    }

    static enum KeyChangeResult {
        SUCCESS,
        FAILED_DUPLICATED_KEY,
        FAILED_FOR_OTHER_LANGUAGE;

    }

    public static final class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 8814525892788043348L;
        private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private static char toHex(int nibble) {
            return HEX_DIGIT[nibble & 0xF];
        }

        @Override
        public void store(OutputStream out, String comments) throws IOException {
            this.store0(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), true);
        }

        @Override
        public void store(Writer writer, String comments) throws IOException {
            this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), false);
        }

        private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
            int len = theString.length();
            int bufLen = len * 2;
            if (bufLen < 0) {
                bufLen = Integer.MAX_VALUE;
            }
            StringBuffer outBuffer = new StringBuffer(bufLen);
            block8: for (int x = 0; x < len; ++x) {
                char aChar = theString.charAt(x);
                if (aChar > '=' && aChar < '\u007f') {
                    if (aChar == '\\') {
                        outBuffer.append('\\');
                        outBuffer.append('\\');
                        continue;
                    }
                    outBuffer.append(aChar);
                    continue;
                }
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        continue block8;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        continue block8;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        continue block8;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        continue block8;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        continue block8;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        continue block8;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(SortedProperties.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(SortedProperties.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(SortedProperties.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(SortedProperties.toHex(aChar & 0xF));
                            continue block8;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            return outBuffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store0(BufferedWriter bw, boolean escUnicode) throws IOException {
            SortedProperties sortedProperties = this;
            synchronized (sortedProperties) {
                ArrayList<Object> keys = new ArrayList<Object>(super.keySet());
                Collections.sort(keys, CmsCaseInsensitiveStringComparator.getInstance());
                for (Object e : keys) {
                    String key = (String)e;
                    String val = (String)this.get(key);
                    key = this.saveConvert(key, true, escUnicode);
                    val = this.saveConvert(val, false, escUnicode);
                    bw.write(key + "=" + val);
                    bw.newLine();
                }
            }
            bw.flush();
        }
    }

    public static final class ConfigurableMessages {
        CmsMessages m_defaultMessages;
        CmsMessages m_configuredMessages;

        public ConfigurableMessages(CmsMessages defaultMessages, Locale locale, String configuredBundle) {
            CmsMessages bundle;
            this.m_defaultMessages = defaultMessages;
            if (null != configuredBundle && null != (bundle = new CmsMessages(configuredBundle, locale)).getResourceBundle()) {
                this.m_configuredMessages = bundle;
            }
        }

        public String getColumnHeader(CmsMessageBundleEditorTypes.TableProperty column) {
            switch (column) {
                case DEFAULT: {
                    return this.getMessage("GUI_COLUMN_HEADER_DEFAULT_0");
                }
                case DESCRIPTION: {
                    return this.getMessage("GUI_COLUMN_HEADER_DESCRIPTION_0");
                }
                case KEY: {
                    return this.getMessage("GUI_COLUMN_HEADER_KEY_0");
                }
                case OPTIONS: {
                    return "";
                }
                case TRANSLATION: {
                    return this.getMessage("GUI_COLUMN_HEADER_TRANSLATION_0");
                }
            }
            throw new IllegalArgumentException();
        }

        private String getMessage(String key) {
            if (null != this.m_configuredMessages) {
                try {
                    return this.m_configuredMessages.getString(key);
                }
                catch (CmsMessageException cmsMessageException) {
                    // empty catch block
                }
            }
            try {
                return this.m_defaultMessages.getString(key);
            }
            catch (CmsMessageException e) {
                return "???" + key + "???";
            }
        }
    }

    public static final class CmsCaseInsensitiveStringComparator
    implements Comparator<Object> {
        private static CmsCaseInsensitiveStringComparator m_instance = new CmsCaseInsensitiveStringComparator();

        private CmsCaseInsensitiveStringComparator() {
        }

        public static CmsCaseInsensitiveStringComparator getInstance() {
            return m_instance;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int r = 0;
            if (o1 != null && o2 != null) {
                if (o1 instanceof String && o2 instanceof String) {
                    String string1 = (String)o1;
                    String string2 = (String)o2;
                    r = String.CASE_INSENSITIVE_ORDER.compare(string1, string2);
                    if (r == 0) {
                        r = string1.compareTo(string2);
                    }
                } else {
                    r = ((Comparable)o1).compareTo(o2);
                }
            } else {
                r = o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return r;
        }
    }
}

