/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.error;

import com.vaadin.annotations.Theme;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.WrappedSession;
import com.vaadin.shared.Version;
import com.vaadin.ui.JavaScript;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.main.I_CmsThrowable;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

@Theme(value="opencms")
public class CmsErrorUI
extends A_CmsUI {
    private static final long serialVersionUID = -7274300240145879438L;
    private static final Log LOG = CmsLog.getLog(CmsErrorUI.class);
    private static final String THROWABLE = "THROWABLE";
    private static final String PATH = "PATH";
    public static final String ERROR_PAGE_PATH_FRAQUMENT = "errorpage/";
    private String m_requestedPage;
    private Throwable m_throwable;

    public static String getBootstrapPage(CmsObject cms, Throwable throwable, HttpServletRequest request) {
        try {
            CmsErrorUI.setErrorAttributes(cms, throwable, request);
            byte[] pageBytes = CmsFileUtil.readFully(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/opencms/ui/error/error-page.html"));
            String page = new String(pageBytes, "UTF-8");
            CmsMacroResolver resolver = new CmsMacroResolver();
            String context = OpenCms.getSystemInfo().getContextPath();
            String vaadinDir = CmsStringUtil.joinPaths(context, "VAADIN/");
            String vaadinVersion = Version.getFullVersion();
            String vaadinServlet = CmsStringUtil.joinPaths(context, "workplace/", ERROR_PAGE_PATH_FRAQUMENT);
            String vaadinBootstrap = CmsStringUtil.joinPaths(context, "VAADIN/vaadinBootstrap.js");
            resolver.addMacro("loadingHtml", "<div class='o-loading-indicator opencms-font'><div class=\"oc-spin-center\">\n<span class=\"oc-spinner-bg\"></span>\n<span class=\"oc-spinner oc-spin-outer\"></span><br>\n<span class=\"oc-spinner-circle oc-spin-inner\"></span><br>\n<span class=\"oc-spinner-dots oc-spin-dots\"></span>\n</div></div>");
            resolver.addMacro("vaadinDir", vaadinDir);
            resolver.addMacro("vaadinVersion", vaadinVersion);
            resolver.addMacro("vaadinServlet", vaadinServlet);
            resolver.addMacro("vaadinBootstrap", vaadinBootstrap);
            resolver.addMacro("title", "Error page");
            page = resolver.resolveMacros(page);
            return page;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to display error page.", (Throwable)e);
            return "<!--Error-->";
        }
    }

    private static void setErrorAttributes(CmsObject cms, Throwable throwable, HttpServletRequest request) {
        Throwable cause;
        String errorUri = CmsFlexController.getThrowableResourceUri((ServletRequest)request);
        if (errorUri == null) {
            errorUri = cms.getRequestContext().getUri();
        }
        if ((cause = CmsFlexController.getThrowable((ServletRequest)request)) == null) {
            cause = throwable;
        }
        request.getSession().setAttribute(THROWABLE, (Object)cause);
        request.getSession().setAttribute(PATH, (Object)errorUri);
    }

    @Override
    protected void init(VaadinRequest request) {
        this.readErrorAttributes();
        CmsErrorDialog.showErrorDialog(this.getErrorMessage(this.m_throwable), this.m_throwable, new Runnable(){

            @Override
            public void run() {
                JavaScript.eval((String)"if (window.parent && window.parent.cmsIsLegacyApp) window.parent.location.reload();");
            }
        });
    }

    private String getErrorMessage(Throwable throwable) {
        StringBuffer result = new StringBuffer(512);
        result.append(CmsVaadinUtils.getMessageText("GUI_ERROR_DIALOG_MESSAGE_0", new Object[0])).append("<br />");
        result.append(this.getMessage(throwable));
        return result.toString();
    }

    private String getMessage(Throwable t) {
        if (t instanceof I_CmsThrowable && ((I_CmsThrowable)((Object)t)).getMessageContainer() != null) {
            CmsMultiException exc;
            String message;
            StringBuffer result = new StringBuffer(256);
            if (t instanceof CmsMultiException && CmsStringUtil.isNotEmpty(message = (exc = (CmsMultiException)t).getMessage(this.getLocale()))) {
                result.append(message);
                result.append("<br />");
            }
            I_CmsThrowable cmsThrowable = (I_CmsThrowable)((Object)t);
            result.append(cmsThrowable.getLocalizedMessage(this.getLocale()));
            return result.toString();
        }
        String message = t.getMessage();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(message)) {
            message = CmsVaadinUtils.getMessageText("GUI_ERROR_UNKNOWN_0", new Object[0]);
        }
        return message;
    }

    private void readErrorAttributes() {
        WrappedSession session = this.getSession().getSession();
        this.m_requestedPage = (String)session.getAttribute(PATH);
        this.m_throwable = (Throwable)session.getAttribute(THROWABLE);
        session.removeAttribute(THROWABLE);
        session.removeAttribute(PATH);
    }
}

